/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.CountAccumulator;
import org.apache.flink.table.functions.aggfunctions.CountAggFunction;
import org.apache.flink.table.runtime.batch.sql.AggregateITCase$;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.utils.NonMergableCount;
import org.apache.flink.table.utils.NonMergableCountAcc;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple7;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001E\u0011q\"Q4he\u0016<\u0017\r^3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\b+bE2,\u0007K]8he\u0006l7oQ8mY\u0016\u001cG/[8o)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0006d_:4\u0017nZ'pI\u0016\u0004\"aG\u0017\u000f\u0005qYcBA\u000f+\u001d\tq\u0012F\u0004\u0002 Q9\u0011\u0001e\n\b\u0003C\u0019r!AI\u0013\u000e\u0003\rR!\u0001\n\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003+\u0019I!\u0001\f\u000b\u0002+Q\u000b'\r\\3Qe><'/Y7t)\u0016\u001cHOQ1tK&\u0011af\f\u0002\u0010)\u0006\u0014G.Z\"p]\u001aLw-T8eK*\u0011A\u0006\u0006\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M*\u0004C\u0001\u001b\u0001\u001b\u0005\u0011\u0001\"B\r1\u0001\u0004Q\u0002\"B\u001c\u0001\t\u0003A\u0014\u0001\u0006;fgR\fum\u001a:fO\u0006$\u0018n\u001c8UsB,7\u000fF\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0011)f.\u001b;)\u0005Y\u0002\u0005CA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0015QWO\\5u\u0013\t)%I\u0001\u0003UKN$\b\"B$\u0001\t\u0003A\u0014\u0001\u0006;fgR$\u0016M\u00197f\u0003\u001e<'/Z4bi&|g\u000e\u000b\u0002G\u0001\")!\n\u0001C\u0001q\u00051B/Z:u\t\u0006$\u0018mU3u\u0003\u001e<'/Z4bi&|g\u000e\u000b\u0002J\u0001\")Q\n\u0001C\u0001q\u0005AB/Z:u\u0003\u001e<'/Z4bi&|g\u000eR1uCRK\b/Z:)\u00051\u0003\u0005\"\u0002)\u0001\t\u0003A\u0014a\u0005;fgR$\u0016M\u00197f!J|'.Z2uS>t\u0007FA(A\u0011\u0015\u0019\u0006\u0001\"\u00019\u0003\t\"Xm\u001d;UC\ndW-Q4he\u0016<\u0017\r^5p]^KG\u000f[!sSRDW.\u001a;jG\"\u0012!\u000b\u0011\u0005\u0006-\u0002!\t\u0001O\u0001\u001ci\u0016\u001cH/Q4he\u0016<\u0017\r^5p]^KG\u000f\u001b+x_\u000e{WO\u001c;)\u0005U\u0003\u0005\"B-\u0001\t\u0003A\u0014A\b;fgR\fum\u001a:fO\u0006$\u0018n\u001c8BMR,'\u000f\u0015:pU\u0016\u001cG/[8oQ\tA\u0006\tC\u0003]\u0001\u0011\u0005\u0001(A\u000buKN$H)[:uS:\u001cG/Q4he\u0016<\u0017\r^3)\u0005m\u0003\u0005\"B0\u0001\t\u0003A\u0014\u0001\b;fgR<%o\\;qK\u0012$\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003=\u0002CQA\u0019\u0001\u0005\u0002a\n\u0001\u0004^3ti\u001e\u0013x.\u001e9j]\u001e\u001cV\r^!hOJ,w-\u0019;fQ\t\t\u0007\tC\u0003f\u0001\u0011\u0005\u0001(\u0001\u000euKN$\u0018iZ4sK\u001e\fG/Z#naRLH)\u0019;b'\u0016$8\u000f\u000b\u0002e\u0001\")\u0001\u000e\u0001C\u0001q\u0005IB/Z:u)Vl'\r\\3XS:$wn^!hOJ,w-\u0019;fQ\t9\u0007\tC\u0003l\u0001\u0011\u0005\u0001(\u0001\u0013uKN$H+^7cY\u0016<\u0016N\u001c3po\u0006;wM]3hCR,w+\u001b;i\u0007>dG.Z2uQ\tQ\u0007\tC\u0003o\u0001\u0011\u0005\u0001(\u0001\u0016uKN$H+^7cY\u0016<\u0016N\u001c3po\u0006;wM]3hCR,w+\u001b;i\u0007>dG.Z2u+:tWm\u001d;)\u00055\u0004\u0005\"B9\u0001\t\u0003A\u0014A\b;fgR$V/\u001c2mK^Kg\u000eZ8x/&$\b\u000e\u0015:pa\u0016\u0014H/[3tQ\t\u0001\b\tC\u0003u\u0001\u0011\u0005\u0001(\u0001\fuKN$\bj\u001c9XS:$wn^!hOJ,w-\u0019;fQ\t\u0019\b\tC\u0003x\u0001\u0011\u0005\u0001(A\u000euKN$\bj\u001c9XS:$wn^,ji\"\u0004&o\u001c9feRLWm\u001d\u0015\u0003m\u0002CQA\u001f\u0001\u0005\u0002a\n!\u0004^3tiN+7o]5p]^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016D#!\u001f!\t\u000bu\u0004A\u0011\u0001\u001d\u0002?Q,7\u000f^*fgNLwN\\,j]\u0012|woV5uQB\u0013x\u000e]3si&,7\u000f\u000b\u0002}\u0001\":\u0001!!\u0001\u0002\u000e\u0005=\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d!)\u0001\u0004sk:tWM]\u0005\u0005\u0003\u0017\t)AA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]!)A\u0004sk:tWM]:\n\t\u0005m\u0011Q\u0003\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3")
public class AggregateITCase
extends TableProgramsCollectionTestBase {
    @Test
    public void testAggregationTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT sum(_1), min(_1), max(_1), count(_1), avg(_1) FROM MyTable";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "231,1,21,21,11";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT sum(_1) FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "231";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDataSetAggregation() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT sum(_1) FROM MyTable";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "231";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationDataTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT avg(a), avg(b), avg(c), avg(d), avg(e), avg(f), count(g), min(g), min('Ciao'), max(g), max('Ciao'), sum(CAST(f AS DECIMAL)) FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), (TypeInformation)new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }

                    public CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializerInstance(Class<Tuple7<Object, Object, Object, Object, Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,1,1,1,1.5,1.5,2,Ciao,Ciao,Hello,Ciao,3.0";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableProjection() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT avg(a), sum(a), count(a), avg(b), sum(b) FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1)), new Tuple2((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2))}), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])));
                    }

                    public CaseClassSerializer<Tuple2<Object, Object>> createSerializerInstance(Class<Tuple2<Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,3,2,1,3";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTableAggregationWithArithmetic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT avg(a + 2) + 2, count(b) + 5 FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "5.5,7";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationWithTwoCount() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT count(_1), count(_2) FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "2,2";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationAfterProjection() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT avg(a), sum(b), count(c) FROM (SELECT _1 as a, _2 as b, _3 as c FROM MyTable)";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), (TypeInformation)new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }

                    public CaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializerInstance(Class<Tuple7<Object, Object, Object, Object, Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "1,3,2";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDistinctAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT sum(_1) as a, count(distinct _3) as b FROM MyTable";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "231,21";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedDistinctAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT _2, avg(distinct _1) as a, count(_3) as b FROM MyTable GROUP BY _2";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(CollectionDataSets$.MODULE$.get3TupleDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        String expected = "6,18,6\n5,13,5\n4,8,4\n3,5,3\n2,2,2\n1,1,1";
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupingSetAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT _2, _3, avg(_1) as a, GROUP_ID() as g FROM MyTable GROUP BY GROUPING SETS (_2, _3)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        tEnv.registerDataSet("MyTable", ds);
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = "6,null,18,1\n5,null,13,1\n4,null,8,1\n3,null,5,1\n2,null,2,1\n1,null,1,1\nnull,Luke Skywalker,6,2\nnull,I am fine.,5,2\nnull,Hi,1,2\nnull,Hello world, how are you?,4,2\nnull,Hello world,3,2\nnull,Hello,2,2\nnull,Comment#9,15,2\nnull,Comment#8,14,2\nnull,Comment#7,13,2\nnull,Comment#6,12,2\nnull,Comment#5,11,2\nnull,Comment#4,10,2\nnull,Comment#3,9,2\nnull,Comment#2,8,2\nnull,Comment#15,21,2\nnull,Comment#14,20,2\nnull,Comment#13,19,2\nnull,Comment#12,18,2\nnull,Comment#11,17,2\nnull,Comment#10,16,2\nnull,Comment#1,7,2";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testAggregateEmptyDataSets() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        NonMergableCount myAgg = new NonMergableCount();
        tEnv.registerFunction("myAgg", (AggregateFunction)myAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)new CaseClassTypeInfo<NonMergableCountAcc>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<NonMergableCountAcc> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<NonMergableCountAcc>(this, fieldSerializers){

                    public NonMergableCountAcc createInstance(Object[] fields) {
                        return new NonMergableCountAcc(BoxesRunTime.unboxToLong((Object)fields[0]));
                    }

                    public CaseClassSerializer<NonMergableCountAcc> createSerializerInstance(Class<NonMergableCountAcc> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT avg(a), sum(a), count(b) FROM MyTable where a = 4 group by a";
        String sqlQuery2 = "SELECT avg(a), sum(a), count(b) FROM MyTable where a = 4";
        String sqlQuery3 = "SELECT avg(a), sum(a), count(b) FROM MyTable";
        String sqlQuery4 = "SELECT avg(a), sum(a), count(b), myAgg(b)FROM MyTable where a = 4";
        Table ds = package$.MODULE$.dataSet2DataSetConversions(env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1)), new Tuple2((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2))}), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])));
                    }

                    public CaseClassSerializer<Tuple2<Object, Object>> createSerializerInstance(Class<Tuple2<Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        tEnv.registerTable("MyTable", ds);
        Table result = tEnv.sqlQuery(sqlQuery);
        Table result2 = tEnv.sqlQuery(sqlQuery2);
        Table result3 = tEnv.sqlQuery(sqlQuery3);
        Table result4 = tEnv.sqlQuery(sqlQuery4);
        Seq results = package$.MODULE$.table2TableConversions(result).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        Seq expected = (Seq)Seq$.MODULE$.empty();
        Seq results2 = package$.MODULE$.table2TableConversions(result2).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected2 = "null,null,0";
        Seq results3 = package$.MODULE$.table2TableConversions(result3).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected3 = "1,3,2";
        Seq results4 = package$.MODULE$.table2TableConversions(result4).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected4 = "null,null,0,0";
        Predef$.MODULE$.assert(results.equals((Object)expected), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Empty result is expected for grouped set, but actual: ").append(results).toString());
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results2).asJava()), (String)expected2);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results3).asJava()), (String)expected3);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results4).asJava()), (String)expected4);
    }

    @Test
    public void testTumbleWindowAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.TYPE), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        tEnv.registerFunction("countFun", (AggregateFunction)new CountAggFunction(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))));
        tEnv.registerFunction("wAvgWithMergeAndReset", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sqlQuery = "SELECT b, SUM(a), countFun(c), wAvgWithMergeAndReset(b, a), wAvgWithMergeAndReset(a, a)FROM T GROUP BY b, TUMBLE(ts, INTERVAL '3' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1,1,1", "2,2,1,2,2", "2,3,1,2,3", "3,9,2,3,4", "3,6,1,3,6", "4,15,2,4,7", "4,19,2,4,9", "5,11,1,5,11", "5,39,3,5,13", "5,15,1,5,15", "6,33,2,6,16", "6,57,3,6,19", "6,21,1,6,21"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testTumbleWindowAggregateWithCollect() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT b, COLLECT(b)FROM T GROUP BY b, TUMBLE(ts, INTERVAL '3' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$24 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,{1=1}", "2,{2=1}", "2,{2=1}", "3,{3=1}", "3,{3=2}", "4,{4=2}", "4,{4=2}", "5,{5=1}", "5,{5=1}", "5,{5=3}", "6,{6=1}", "6,{6=2}", "6,{6=3}"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testTumbleWindowAggregateWithCollectUnnest() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$25 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("t1", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Table t2 = tEnv.sqlQuery("SELECT b, COLLECT(b) as `set`FROM t1 GROUP BY b, TUMBLE(ts, INTERVAL '3' SECOND)");
        tEnv.registerTable("t2", t2);
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery("SELECT b, s FROM t2, UNNEST(t2.`set`) AS A(s) where b < 3")).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1", "2,2", "2,2"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testTumbleWindowWithProperties() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT b, COUNT(a), TUMBLE_START(ts, INTERVAL '5' SECOND), TUMBLE_END(ts, INTERVAL '5' SECOND), TUMBLE_ROWTIME(ts, INTERVAL '5' SECOND)FROM T GROUP BY b, TUMBLE(ts, INTERVAL '5' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$26 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1970-01-01 00:00:00.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "2,2,1970-01-01 00:00:00.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "3,1,1970-01-01 00:00:00.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "3,2,1970-01-01 00:00:05.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "4,3,1970-01-01 00:00:05.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "4,1,1970-01-01 00:00:10.0,1970-01-01 00:00:15.0,1970-01-01 00:00:14.999", "5,4,1970-01-01 00:00:10.0,1970-01-01 00:00:15.0,1970-01-01 00:00:14.999", "5,1,1970-01-01 00:00:15.0,1970-01-01 00:00:20.0,1970-01-01 00:00:19.999", "6,4,1970-01-01 00:00:15.0,1970-01-01 00:00:20.0,1970-01-01 00:00:19.999", "6,2,1970-01-01 00:00:20.0,1970-01-01 00:00:25.0,1970-01-01 00:00:24.999"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testHopWindowAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.TYPE), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        tEnv.registerFunction("countFun", (AggregateFunction)new CountAggFunction(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))));
        tEnv.registerFunction("wAvgWithMergeAndReset", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sqlQuery = "SELECT b, SUM(a), countFun(c), wAvgWithMergeAndReset(b, a), wAvgWithMergeAndReset(a, a)FROM T GROUP BY b, HOP(ts, INTERVAL '2' SECOND, INTERVAL '4' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$27 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1,1,1", "1,1,1,1,1", "2,5,2,2,2", "2,5,2,2,2", "3,9,2,3,4", "3,15,3,3,5", "3,6,1,3,6", "4,7,1,4,7", "4,24,3,4,8", "4,27,3,4,9", "4,10,1,4,10", "5,11,1,5,11", "5,36,3,5,12", "5,54,4,5,13", "5,29,2,5,14", "6,33,2,6,16", "6,70,4,6,17", "6,78,4,6,19", "6,41,2,6,20"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testHopWindowWithProperties() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT b, COUNT(a), HOP_START(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND), HOP_END(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND), HOP_ROWTIME(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND) FROM T GROUP BY b, HOP(ts, INTERVAL '5' SECOND, INTERVAL '10' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$28 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,1969-12-31 23:59:55.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "2,2,1969-12-31 23:59:55.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "3,1,1969-12-31 23:59:55.0,1970-01-01 00:00:05.0,1970-01-01 00:00:04.999", "1,1,1970-01-01 00:00:00.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "2,2,1970-01-01 00:00:00.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "3,3,1970-01-01 00:00:00.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "4,3,1970-01-01 00:00:00.0,1970-01-01 00:00:10.0,1970-01-01 00:00:09.999", "3,2,1970-01-01 00:00:05.0,1970-01-01 00:00:15.0,1970-01-01 00:00:14.999", "4,4,1970-01-01 00:00:05.0,1970-01-01 00:00:15.0,1970-01-01 00:00:14.999", "5,4,1970-01-01 00:00:05.0,1970-01-01 00:00:15.0,1970-01-01 00:00:14.999", "4,1,1970-01-01 00:00:10.0,1970-01-01 00:00:20.0,1970-01-01 00:00:19.999", "5,5,1970-01-01 00:00:10.0,1970-01-01 00:00:20.0,1970-01-01 00:00:19.999", "6,4,1970-01-01 00:00:10.0,1970-01-01 00:00:20.0,1970-01-01 00:00:19.999", "5,1,1970-01-01 00:00:15.0,1970-01-01 00:00:25.0,1970-01-01 00:00:24.999", "6,6,1970-01-01 00:00:15.0,1970-01-01 00:00:25.0,1970-01-01 00:00:24.999", "6,2,1970-01-01 00:00:20.0,1970-01-01 00:00:30.0,1970-01-01 00:00:29.999"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testSessionWindowAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.TYPE), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        tEnv.registerFunction("countFun", (AggregateFunction)new CountAggFunction(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))));
        tEnv.registerFunction("wAvgWithMergeAndReset", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sqlQuery = "SELECT MIN(a), MAX(a), SUM(a), countFun(c), wAvgWithMergeAndReset(b, a), wAvgWithMergeAndReset(a, a)FROM T GROUP BY SESSION(ts, INTERVAL '4' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AggregateITCase.$anonfun$testSessionWindowAggregate$1(x))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$29 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$14[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$14(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$29 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,10,39,6,3,7", "16,21,111,6,6,18"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testSessionWindowWithProperties() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env, this.config());
        String sqlQuery = "SELECT COUNT(a), SESSION_START(ts, INTERVAL '4' SECOND), SESSION_END(ts, INTERVAL '4' SECOND), SESSION_ROWTIME(ts, INTERVAL '4' SECOND) FROM T GROUP BY SESSION(ts, INTERVAL '4' SECOND)";
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AggregateITCase.$anonfun$testSessionWindowWithProperties$1(x))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4(x._1(), x._2(), x._3(), (Object)SqlFunctions.internalToTimestamp((long)(BoxesRunTime.unboxToInt((Object)x._1()) * 1000))), (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$30 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$15[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$15(org.apache.flink.table.runtime.batch.sql.AggregateITCase$$anon$30 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class));
        tEnv.registerDataSet("T", ds, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}));
        Seq result = package$.MODULE$.table2TableConversions(tEnv.sqlQuery(sqlQuery)).toDataSet(TypeExtractor.createTypeInfo(Row.class)).collect();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"6,1970-01-01 00:00:02.0,1970-01-01 00:00:14.0,1970-01-01 00:00:13.999", "6,1970-01-01 00:00:16.0,1970-01-01 00:00:25.0,1970-01-01 00:00:24.999"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionWindowAggregate$1(Tuple3 x) {
        return BoxesRunTime.unboxToLong((Object)x._2()) % 2L == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testSessionWindowWithProperties$1(Tuple3 x) {
        return BoxesRunTime.unboxToLong((Object)x._2()) % 2L == 0L;
    }

    public AggregateITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }
}

