/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.batch;

import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.runtime.utils.CommonTestData;
import org.apache.flink.table.runtime.utils.TableProgramsCollectionTestBase;
import org.apache.flink.table.runtime.utils.TableProgramsTestBase;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaTableSourceITCase
extends TableProgramsCollectionTestBase {
    public JavaTableSourceITCase(TableProgramsTestBase.TableConfigMode configMode) {
        super(configMode);
    }

    @Test
    public void testBatchTableSourceTableAPI() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        CsvTableSource csvTable = CommonTestData.getCsvTableSource();
        tableEnv.registerTableSource("persons", (TableSource)csvTable);
        Table result = tableEnv.scan(new String[]{"persons"}).select("id, first, last, score");
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "1,Mike,Smith,12.3\n2,Bob,Taylor,45.6\n3,Sam,Miller,7.89\n4,Peter,Smith,0.12\n5,Liz,Williams,34.5\n6,Sally,Miller,6.78\n7,Alice,Smith,90.1\n8,Kelly,Williams,2.34\n";
        JavaTableSourceITCase.compareResultAsText((List)results, (String)expected);
    }

    @Test
    public void testBatchTableSourceSQL() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env, (TableConfig)this.config());
        CsvTableSource csvTable = CommonTestData.getCsvTableSource();
        tableEnv.registerTableSource("persons", (TableSource)csvTable);
        Table result = tableEnv.sqlQuery("SELECT `last`, FLOOR(id), score * 2 FROM persons WHERE score < 20");
        DataSet resultSet = tableEnv.toDataSet(result, Row.class);
        List results = resultSet.collect();
        String expected = "Smith,1,24.6\nMiller,3,15.78\nSmith,4,0.24\nMiller,6,13.56\nWilliams,8,4.68\n";
        JavaTableSourceITCase.compareResultAsText((List)results, (String)expected);
    }
}

