/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.expressions.EqualTo;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.GreaterThan;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.Min;
import org.apache.flink.table.expressions.Sum;
import org.apache.flink.table.expressions.UnresolvedFieldReference;
import org.apache.flink.table.plan.RexProgramTestBase;
import org.apache.flink.table.plan.util.RexNodeToExpressionConverter;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.utils.InputTypeBuilder$;
import org.apache.flink.table.validate.FunctionCatalog;
import org.apache.flink.table.validate.FunctionCatalog$;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011qCU3y!J|wM]1n\u000bb$(/Y2u_J$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00029mC:T!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0013%\u0016D\bK]8he\u0006lG+Z:u\u0005\u0006\u001cX\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011q\u0002\u0001\u0005\b/\u0001\u0011\r\u0011\"\u0003\u0019\u0003=1WO\\2uS>t7)\u0019;bY><W#A\r\u0011\u0005iiR\"A\u000e\u000b\u0005q!\u0011\u0001\u0003<bY&$\u0017\r^3\n\u0005yY\"a\u0004$v]\u000e$\u0018n\u001c8DCR\fGn\\4\t\r\u0001\u0002\u0001\u0015!\u0003\u001a\u0003A1WO\\2uS>t7)\u0019;bY><\u0007\u0005C\u0003#\u0001\u0011\u00051%A\ruKN$X\t\u001f;sC\u000e$(+\u001a4J]B,HOR5fY\u0012\u001cH#\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\tUs\u0017\u000e\u001e\u0015\u0003C-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0006\u0002\u000b),h.\u001b;\n\u0005Aj#\u0001\u0002+fgRDQA\r\u0001\u0005\u0002\r\n!\u0004^3ti\u0016CHO]1diNKW\u000e\u001d7f\u0007>tG-\u001b;j_:D#!M\u0016\t\u000bU\u0002A\u0011A\u0012\u00025Q,7\u000f^#yiJ\f7\r^*j]\u001edWmQ8oI&$\u0018n\u001c8)\u0005QZ\u0003\"\u0002\u001d\u0001\t\u0003\u0019\u0013a\u0006;fgR,\u0005\u0010\u001e:bGR\u001ceNZ\"p]\u0012LG/[8oQ\t94\u0006C\u0003<\u0001\u0011\u00051%A\ruKN$X\t\u001f;sC\u000e$\u0018I\u0014#FqB\u0014Xm]:j_:\u001c\bF\u0001\u001e,\u0011\u0015q\u0004\u0001\"\u0001$\u0003Y!Xm\u001d;MSR,'/\u00197D_:4XM]:j_:\u001c\bFA\u001f,\u0011\u0015\t\u0005\u0001\"\u0001$\u0003}!Xm\u001d;FqR\u0014\u0018m\u0019;Be&$\b.\\3uS\u000e\u001cuN\u001c3ji&|gn\u001d\u0015\u0003\u0001.BQ\u0001\u0012\u0001\u0005\u0002\r\nA\u0004^3ti\u0016CHO]1diB{7\u000f\u001e4jq\u000e{g\u000eZ5uS>t7\u000f\u000b\u0002DW!)q\t\u0001C\u0001G\u0005)C/Z:u\u000bb$(/Y2u\u0007>tG-\u001b;j_:<\u0016\u000e\u001e5Gk:\u001cG/[8o\u0007\u0006dGn\u001d\u0015\u0003\r.BQA\u0013\u0001\u0005\u0002\r\nA\u0005^3ti\u0016CHO]1di^KG\u000f[+ogV\u0004\bo\u001c:uK\u0012\u001cuN\u001c3ji&|gn\u001d\u0015\u0003\u0013.BQ!\u0014\u0001\u0005\u0002\r\nq\u0004^3ti\u0016CHO]1diJ+gMT3ti\u0016$\u0017J\u001c9vi\u001aKW\r\u001c3tQ\ta5\u0006C\u0003Q\u0001\u0011\u00051%\u0001\u0017uKN$X\t\u001f;sC\u000e$(+\u001a4OKN$X\rZ%oaV$h)[3mIN<\u0016\u000e\u001e5O_:+7\u000f^5oO\"\u0012qj\u000b\u0005\u0006'\u0002!\taI\u0001$i\u0016\u001cH/\u0012=ue\u0006\u001cG\u000fR3faJ+gMT3ti\u0016$\u0017J\u001c9vi\u001aKW\r\u001c3tQ\t\u00116\u0006C\u0003W\u0001\u0011%q+\u0001\u0010ck&dGMU3y!J|wM]1n/&$\b\u000eR3fa:+7\u000f^5oOR\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006\u0019!/\u001a=\u000b\u0005uC\u0011aB2bY\u000eLG/Z\u0005\u0003?j\u0013!BU3y!J|wM]1n\u0011\u0015\t\u0007\u0001\"\u0003X\u0003i\u0011W/\u001b7e%\u0016D\bK]8he\u0006lw+\u001b;i\u001d\u0016\u001cH/\u001b8h\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003\u0005\"Xm\u001d;FqR\u0014\u0018m\u0019;TS:<G.\u001a)pgR4\u0017\u000e_\"p]\u0012LG/[8o)\u0011!Sm\\<\t\u000b\u0019\u0014\u0007\u0019A4\u0002\u0015\u0019LW\r\u001c3J]\u0012,\u0007\u0010\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\u000f%sG/Z4fe\")\u0001O\u0019a\u0001c\u0006\u0011q\u000e\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003ir\u000b1a]9m\u0013\t18O\u0001\nTc2\u0004vn\u001d;gSb|\u0005/\u001a:bi>\u0014\b\"\u0002=c\u0001\u0004I\u0018\u0001B3yaJ\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}M5\tQP\u0003\u0002\u007f\u0019\u00051AH]8pizJ1!!\u0001'\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0001\u0014\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\u0005Y\u0012m]:feR,\u0005\u0010\u001d:fgNLwN\\!se\u0006LX)];bYN$R\u0001JA\b\u0003KA\u0001\"!\u0005\u0002\n\u0001\u0007\u00111C\u0001\tKb\u0004Xm\u0019;fIB)Q%!\u0006\u0002\u001a%\u0019\u0011q\u0003\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005\r\u0012Q\u0004\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002CA\u0014\u0003\u0013\u0001\r!a\u0005\u0002\r\u0005\u001cG/^1m\u0001")
public class RexProgramExtractorTest
extends RexProgramTestBase {
    private final FunctionCatalog functionCatalog = FunctionCatalog$.MODULE$.withBuiltIns();

    private FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    @Test
    public void testExtractRefInputFields() {
        int[] usedFields = RexProgramExtractor$.MODULE$.extractRefInputFields(this.buildSimpleRexProgram());
        Assert.assertArrayEquals((int[])usedFields, (int[])new int[]{2, 3, 1});
    }

    @Test
    public void testExtractSimpleCondition() {
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        RexProgram program = this.buildSimpleRexProgram();
        Expression firstExp = ExpressionParser$.MODULE$.parseExpression("id > 6");
        Expression secondExp = ExpressionParser$.MODULE$.parseExpression("amount * price < 100");
        Expression[] expected = (Expression[])((Object[])new Expression[]{firstExp, secondExp});
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, builder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractSingleCondition() {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLocalRef a = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1}));
        builder.addCondition((RexNode)a);
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser$.MODULE$.parseExpression("amount >= id")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractCnfCondition() {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200L));
        RexLocalRef a = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3}));
        RexLocalRef b = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3}));
        RexLocalRef c = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3}));
        RexLocalRef d = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}));
        RexLocalRef e = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4}));
        RexLocalRef and = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).asJava()));
        RexLocalRef or = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)and, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)e, (List)Nil$.MODULE$)))).asJava()));
        RexLocalRef not = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)d, (List)Nil$.MODULE$)).asJava()));
        builder.addCondition((RexNode)builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)or, (List)new .colon.colon((Object)not, (List)Nil$.MODULE$))).asJava())));
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser$.MODULE$.parseExpression("amount < 100 || price == 100 || price === 200"), ExpressionParser$.MODULE$.parseExpression("id > 100 || price == 100 || price === 200"), ExpressionParser$.MODULE$.parseExpression("!(amount <= id)")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractANDExpressions() {
        ArrayBuffer arrayBuffer;
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLocalRef a = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3}));
        RexLocalRef b = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3}));
        RexLocalRef c = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3}));
        RexLocalRef d = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}));
        RexLocalRef and = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava()));
        builder.addCondition((RexNode)builder.addExpr((RexNode)and));
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        RexNode expanded = program.expandLocalRef(program.getCondition());
        ArrayBuffer convertedExpressions = new ArrayBuffer();
        ArrayBuffer unconvertedRexNodes = new ArrayBuffer();
        String[] inputNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(program.getInputRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(inputNames, this.functionCatalog());
        Option option = (Option)expanded.accept((RexVisitor)converter);
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression expression = (Expression)some.value();
            arrayBuffer = convertedExpressions.$plus$eq((Object)expression);
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = unconvertedRexNodes.$plus$eq((Object)expanded);
        } else {
            throw new MatchError((Object)option);
        }
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser$.MODULE$.parseExpression("amount < 100 && id > 100 && price === 100 && amount <= id")});
        this.assertExpressionArrayEquals(expected, (Expression[])convertedExpressions.toArray(ClassTag$.MODULE$.apply(Expression.class)));
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes.length());
    }

    @Test
    public void testLiteralConversions() {
        Expression[] converted;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"date_col", (List)new .colon.colon((Object)"time_col", (List)Nil$.MODULE$)))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.DATE, SqlTypeName.TIME}));
        RelDataType inputRowType = this.typeFactory().createStructType(fieldTypes, fieldNames);
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01.245");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 3);
        RexLiteral rexDate = this.rexBuilder().makeDateLiteral(new DateString("2017-09-12"));
        RexLiteral rexTime = this.rexBuilder().makeTimeLiteral(new TimeString("14:23:01"), 0);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexDate, (List)new .colon.colon((Object)rexTime, (List)Nil$.MODULE$)));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> builder.addExpr(x$1), Buffer$.MODULE$.canBuildFrom())).asJava();
        builder.addCondition((RexNode)builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition)));
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(builder.getProgram(), new RexBuilder((RelDataTypeFactory)this.typeFactory()), this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] expressionArray = converted = (Expression[])tuple2._1();
        Expression[] converted2 = expressionArray;
        Expression[] expected = (Expression[])((Object[])new Expression[]{new EqualTo((Expression)new UnresolvedFieldReference("timestamp_col"), (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-09-10 14:23:01.245"))), new EqualTo((Expression)new UnresolvedFieldReference("date_col"), (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2017-09-12"))), new EqualTo((Expression)new UnresolvedFieldReference("time_col"), (Expression)Literal$.MODULE$.apply((Object)Time.valueOf("14:23:01")))});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    @Test
    public void testExtractArithmeticConditions() {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexLocalRef[]{builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t0, t1}), t2})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{t0, t1}), t2})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{t0, t1}), t2})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, new RexNode[]{t0, t1}), t2})), builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, new RexNode[]{t0}), t2}))}))).asJava();
        builder.addCondition((RexNode)builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition)));
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser$.MODULE$.parseExpression("amount < id"), ExpressionParser$.MODULE$.parseExpression("amount <= id"), ExpressionParser$.MODULE$.parseExpression("amount <> id"), ExpressionParser$.MODULE$.parseExpression("amount == id"), ExpressionParser$.MODULE$.parseExpression("amount >= id"), ExpressionParser$.MODULE$.parseExpression("amount > id"), ExpressionParser$.MODULE$.parseExpression("amount + id == 100"), ExpressionParser$.MODULE$.parseExpression("amount - id == 100"), ExpressionParser$.MODULE$.parseExpression("amount * id == 100"), ExpressionParser$.MODULE$.parseExpression("amount / id == 100"), ExpressionParser$.MODULE$.parseExpression("-amount == 100")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractPostfixConditions() {
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NULL, "('flag).isNull");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_TRUE, "('flag).isTrue");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_TRUE, "('flag).isNotTrue");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_FALSE, "('flag).isFalse");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_FALSE, "('flag).isNotFalse");
    }

    @Test
    public void testExtractConditionWithFunctionCalls() {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLocalRef condition1 = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SUM, new RexNode[]{t0}), t2}));
        RexLocalRef condition2 = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MIN, new RexNode[]{t1}), t2}));
        builder.addCondition((RexNode)builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2})));
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{new GreaterThan((Expression)new Sum((Expression)new UnresolvedFieldReference("amount")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))), new EqualTo((Expression)new Min((Expression)new UnresolvedFieldReference("id")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractWithUnsupportedConditions() {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLocalRef cast = builder.addExpr(this.rexBuilder().makeCast(this.allFieldTypes().get(1), (RexNode)t0));
        RexLocalRef condition1 = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{cast, t2}));
        RexLocalRef condition2 = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}));
        RexLocalRef condition3 = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{condition1, condition2}));
        builder.addCondition(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2, condition3}));
        RexProgram program = builder.getProgram();
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser$.MODULE$.parseExpression("amount <= id")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)2L, (long)unconvertedRexNodes2.length);
        Assert.assertEquals((Object)">(CAST($2):BIGINT NOT NULL, 100)", (Object)unconvertedRexNodes2[0].toString());
        Assert.assertEquals((Object)"OR(>(CAST($2):BIGINT NOT NULL, 100), <=($2, $1))", (Object)unconvertedRexNodes2[1].toString());
    }

    @Test
    public void testExtractRefNestedInputFields() {
        RexProgram rexProgram = this.buildRexProgramWithNesting();
        int[] usedFields = RexProgramExtractor$.MODULE$.extractRefInputFields(rexProgram);
        String[][] usedNestedFields = RexProgramExtractor$.MODULE$.extractRefNestedInputFields(rexProgram, usedFields);
        String[][] expected = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"amount"}), (String[])((Object[])new String[]{"*"})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractRefNestedInputFieldsWithNoNesting() {
        RexProgram rexProgram = this.buildSimpleRexProgram();
        int[] usedFields = RexProgramExtractor$.MODULE$.extractRefInputFields(rexProgram);
        String[][] usedNestedFields = RexProgramExtractor$.MODULE$.extractRefNestedInputFields(rexProgram, usedFields);
        String[][] expected = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"*"}), (String[])((Object[])new String[]{"*"}), (String[])((Object[])new String[]{"*"})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractDeepRefNestedInputFields() {
        RexProgram rexProgram = this.buildRexProgramWithDeepNesting();
        int[] usedFields = RexProgramExtractor$.MODULE$.extractRefInputFields(rexProgram);
        String[][] usedNestedFields = RexProgramExtractor$.MODULE$.extractRefNestedInputFields(rexProgram, usedFields);
        String[][] expected = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"amount"}), (String[])((Object[])new String[]{"*"}), (String[])((Object[])new String[]{"with.deeper.entry", "with.deep.entry"})});
        Assert.assertThat((Object)usedFields, (Matcher)CoreMatchers.is((Object)new int[]{1, 0, 2}));
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    private RexProgram buildRexProgramWithDeepNesting() {
        RelDataType passportRow = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("id", SqlTypeName.VARCHAR).field("status", SqlTypeName.VARCHAR).build();
        RelDataType personRow = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("name", SqlTypeName.VARCHAR).field("age", SqlTypeName.INTEGER).nestedField("passport", passportRow).build();
        RelDataType paymentRow = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("id", SqlTypeName.BIGINT).field("amount", SqlTypeName.INTEGER).build();
        RelDataType deepRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("entry", SqlTypeName.VARCHAR).build();
        RelDataType entryRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).nestedField("inside", deepRowType).build();
        RelDataType deeperRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).nestedField("entry", entryRowType).build();
        RelDataType withRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).nestedField("deep", deepRowType).nestedField("deeper", deeperRowType).build();
        RelDataType fieldRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).nestedField("with", withRowType).build();
        RelDataType inputRowType = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).nestedField("persons", personRow).nestedField("payments", paymentRow).nestedField("field", fieldRowType).build();
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef(personRow, 0);
        RexInputRef t1 = this.rexBuilder().makeInputRef(paymentRow, 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(fieldRowType, 2);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(10L));
        RexNode person$pass = this.rexBuilder().makeFieldAccess((RexNode)t0, "passport", false);
        RexNode person$pass$stat = this.rexBuilder().makeFieldAccess(person$pass, "status", false);
        RexNode pay$amount = this.rexBuilder().makeFieldAccess((RexNode)t1, "amount", false);
        RexLocalRef multiplyAmount = builder.addExpr(this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{pay$amount, t3}));
        RexNode field$with = this.rexBuilder().makeFieldAccess((RexNode)t2, "with", false);
        RexNode field$with$deep = this.rexBuilder().makeFieldAccess(field$with, "deep", false);
        RexNode field$with$deeper = this.rexBuilder().makeFieldAccess(field$with, "deeper", false);
        RexNode field$with$deep$entry = this.rexBuilder().makeFieldAccess(field$with$deep, "entry", false);
        RexNode field$with$deeper$entry = this.rexBuilder().makeFieldAccess(field$with$deeper, "entry", false);
        RexNode field$with$deeper$entry$inside = this.rexBuilder().makeFieldAccess(field$with$deeper$entry, "inside", false);
        RexNode field$with$deeper$entry$inside$entry = this.rexBuilder().makeFieldAccess(field$with$deeper$entry$inside, "entry", false);
        builder.addProject((RexNode)multiplyAmount, "amount");
        builder.addProject(person$pass$stat, "status");
        builder.addProject(field$with$deep$entry, "entry");
        builder.addProject(field$with$deeper$entry$inside$entry, "entry");
        builder.addProject(field$with$deeper$entry, "entry2");
        builder.addProject((RexNode)t0, "person");
        return builder.getProgram();
    }

    private RexProgram buildRexProgramWithNesting() {
        RelDataType personRow = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("name", SqlTypeName.INTEGER).field("age", SqlTypeName.VARCHAR).build();
        RelDataType paymentRow = InputTypeBuilder$.MODULE$.inputOf(this.typeFactory()).field("id", SqlTypeName.BIGINT).field("amount", SqlTypeName.INTEGER).build();
        java.util.List types = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)personRow, (List)new .colon.colon((Object)paymentRow, (List)Nil$.MODULE$))).asJava();
        java.util.List names = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"persons", (List)new .colon.colon((Object)"payments", (List)Nil$.MODULE$))).asJava();
        RelDataType inputRowType = this.typeFactory().createStructType(types, names);
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        RexInputRef t0 = this.rexBuilder().makeInputRef((RelDataType)types.get(0), 0);
        RexInputRef t1 = this.rexBuilder().makeInputRef((RelDataType)types.get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode payment$amount = this.rexBuilder().makeFieldAccess((RexNode)t1, "amount", false);
        builder.addProject(payment$amount, "amount");
        builder.addProject((RexNode)t0, "persons");
        builder.addProject((RexNode)t2, "number");
        return builder.getProgram();
    }

    private void testExtractSinglePostfixCondition(Integer fieldIndex, SqlPostfixOperator op, String expr) {
        RelDataType inputRowType = this.typeFactory().createStructType(this.allFieldTypes(), this.allFieldNames());
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder());
        this.rexBuilder_$eq(new RexBuilder((RelDataTypeFactory)this.typeFactory()));
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(Predef$.MODULE$.Integer2int(fieldIndex)), Predef$.MODULE$.Integer2int(fieldIndex));
        builder.addCondition((RexNode)builder.addExpr(this.rexBuilder().makeCall((SqlOperator)op, new RexNode[]{t0})));
        RexProgram program = builder.getProgram(false);
        RexBuilder relBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2 tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, relBuilder, this.functionCatalog());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)1L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)expr, (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])convertedExpressions2)).head().toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    private void assertExpressionArrayEquals(Expression[] expected, Expression[] actual) {
        Expression[] sortedExpected = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Expression[] sortedActual = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((long)sortedExpected.length, (long)sortedActual.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedExpected)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sortedActual), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RexProgramExtractorTest.$anonfun$assertExpressionArrayEquals$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$assertExpressionArrayEquals$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression l = (Expression)tuple2._1();
        Expression r = (Expression)tuple2._2();
        Assert.assertEquals((Object)l.toString(), (Object)r.toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

