/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.QueryDecorrelationTest$;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u001b\t1\u0012+^3ss\u0012+7m\u001c:sK2\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!\u0001\u000f\\1o\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\"i\u0016\u001cHoQ8se\u0016d\u0017\r^5p]N\u001b\u0017\r\\1s\u0003\u001e<\u0017I\u001c3GS2$XM\u001d\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5uQ\tI2\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u0015\u0005)!.\u001e8ji&\u0011\u0001&\n\u0002\u0005)\u0016\u001cH\u000fC\u0003+\u0001\u0011\u00051$A\u0011uKN$H)Z2peJ,G.\u0019;f/&$\b.T;mi&\fum\u001a:fO\u0006$X\r\u000b\u0002*G\u0001")
public class QueryDecorrelationTest
extends TableTestBase {
    @Test
    public void testCorrelationScalarAggAndFilter() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "salary")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple5<Object, String, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple5<Object, String, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }

                    public CaseClassSerializer<Tuple5<Object, String, String, Object, Object>> createSerializerInstance(Class<Tuple5<Object, String, String, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.plan.QueryDecorrelationTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.plan.QueryDecorrelationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand e1.salary > (select avg(salary) from emp e2 where e1.empno = e2.empno)";
        String expectedQuery = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(deptno, 10)"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"deptno"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(deptno, 15)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(deptno, deptno0)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno", "deptno0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"IS NOT NULL(empno)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "AVG(salary) AS EXPR$0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(empno, empno0), >(salary, EXPR$0))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "empno0", "EXPR$0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno"}))}));
        util.verifySql(sql, expectedQuery);
    }

    @Test
    public void testDecorrelateWithMultiAggregate() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "salary")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple5<Object, String, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, String, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple5<Object, String, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Object, String, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }

                    public CaseClassSerializer<Tuple5<Object, String, String, Object, Object>> createSerializerInstance(Class<Tuple5<Object, String, String, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.plan.QueryDecorrelationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.plan.QueryDecorrelationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = "select sum(e1.empno) from emp e1, dept d1 where e1.deptno = d1.deptno and e1.salary > (    select avg(e2.salary) from emp e2 where e2.deptno = d1.deptno)";
        String expectedQuery = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"deptno"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(deptno, deptno0)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno", "deptno0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno0"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"salary", "deptno"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"IS NOT NULL(deptno)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"deptno"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"deptno", "AVG(salary) AS EXPR$0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(deptno0, deptno), >(salary, EXPR$0))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno", "salary", "deptno0", "deptno", "EXPR$0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"empno"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"SUM(empno) AS EXPR$0"}))}));
        util.verifySql(sql, expectedQuery);
    }
}

