/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.match;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.nodes.datastream.DataStreamMatch;
import org.apache.flink.table.plan.nodes.datastream.DataStreamScan;
import org.apache.flink.table.plan.nodes.datastream.PatternVisitor;
import org.apache.flink.types.Row;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005]d!B\u0001\u0003\u0003\u0003i!!\u0007)biR,'O\u001c+sC:\u001cH.\u0019;peR+7\u000f\u001e\"bg\u0016T!a\u0001\u0003\u0002\u000b5\fGo\u00195\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0019\tA!\u001e;jY&\u00111\u0003\u0005\u0002\u000b)\u0016\u001cH\u000fT8hO\u0016\u0014\b\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\nm\t\u0011#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8o+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015\u0011X\u000f\\3t\u0015\t\t#\"A\u0003kk:LG/\u0003\u0002$=\t\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\r\u0015\u0002\u0001\u0015!\u0003\u001d\u0003I)\u0007\u0010]3di\u0016$W\t_2faRLwN\u001c\u0011\t\u000b\u001d\u0002A\u0011A\u000e\u0002\rQD'o\\<oQ\t1\u0013\u0006\u0005\u0002+W5\t\u0001%\u0003\u0002-A\t!!+\u001e7f\u0011\u001dq\u0003A1A\u0005\n=\n\u0011\u0003^3tiR\u000b'\r\\3UsB,\u0017J\u001c4p+\u0005\u0001\u0004CA\u00199\u001b\u0005\u0011$BA\u001a5\u0003%!\u0018\u0010]3vi&d7O\u0003\u00026m\u0005!!.\u0019<b\u0015\t9d!A\u0002ba&L!!\u000f\u001a\u0003\u0017I{w\u000fV=qK&sgm\u001c\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0019\u0002%Q,7\u000f\u001e+bE2,G+\u001f9f\u0013:4w\u000e\t\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001@!\t\u0001E)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"A\u001b\n\u0005\u0015\u000b%AB*ue&tw\r\u0003\u0004H\u0001\u0001\u0006IaP\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003bB%\u0001\u0005\u0004%IAS\u0001\bG>tG/\u001a=u+\u0005Y\u0005#\u0002'P#f{V\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\rQ+\b\u000f\\34!\t\u0011v+D\u0001T\u0015\t!V+A\u0003u_>d7O\u0003\u0002W\u0011\u000591-\u00197dSR,\u0017B\u0001-T\u0005)\u0011V\r\u001c\"vS2$WM\u001d\t\u00035vk\u0011a\u0017\u0006\u0003\u001drS!a\u000e\u0003\n\u0005y[&AF*ue\u0016\fW\u000eV1cY\u0016,eN^5s_:lWM\u001c;\u0011\u0005\u0001,W\"A1\u000b\u00059\u0013'BA\u001cd\u0015\t!g!A\u0005tiJ,\u0017-\\5oO&\u0011a-\u0019\u0002\u001b'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\u0007Q\u0002\u0001\u000b\u0011B&\u0002\u0011\r|g\u000e^3yi\u0002BqA\u001b\u0001C\u0002\u0013%1.A\u0004qY\u0006tg.\u001a:\u0016\u00031\u0004\"!\\8\u000e\u00039T!A\u0016\u0003\n\u0005At'\u0001\u0005$mS:\\\u0007\u000b\\1o]\u0016\u0014\u0018*\u001c9m\u0011\u0019\u0011\b\u0001)A\u0005Y\u0006A\u0001\u000f\\1o]\u0016\u0014\b\u0005C\u0003u\u0001\u0011%Q/\u0001\bqe\u0016\u0004\u0018M]3D_:$X\r\u001f;\u0015\u0005-3\b\"B<t\u0001\u0004A\u0018\u0001\u0003;za\u0016LeNZ8\u0011\tet\u0018\u0011A\u0007\u0002u*\u00111\u0010`\u0001\tif\u0004X-\u001b8g_*\u0011QPN\u0001\u0007G>lWn\u001c8\n\u0005}T(a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u0007\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY!!\u0002\u0003\u0007I{w\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u001bY,'/\u001b4z!\u0006$H/\u001a:o)\u0019\t\u0019\"!\u0007\u00022A\u0019A*!\u0006\n\u0007\u0005]QJ\u0001\u0003V]&$\b\u0002CA\u000e\u0003\u001b\u0001\r!!\b\u0002\u001d5\fGo\u00195SK\u000e|wM\\5{KB!\u0011qDA\u0017\u001d\u0011\t\t#!\u000b\u0011\u0007\u0005\rR*\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\tY#T\u0001\u0007!J,G-\u001a4\n\u0007\u0015\u000byCC\u0002\u0002,5C\u0001\"a\r\u0002\u000e\u0001\u0007\u0011QG\u0001\tKb\u0004Xm\u0019;fIB\"\u0011qGA&!!\tI$a\u0011\u0002\u0002\u0005\u001dSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000fA\fG\u000f^3s]*\u0019\u0011\u0011\t\u0004\u0002\u0007\r,\u0007/\u0003\u0003\u0002F\u0005m\"a\u0002)biR,'O\u001c\t\u0005\u0003\u0013\nY\u0005\u0004\u0001\u0005\u0019\u00055\u0013\u0011GA\u0001\u0002\u0003\u0015\t!a\u0014\u0003\u0007}#\u0013'\u0005\u0003\u0002R\u0005\u0005\u0001c\u0001'\u0002T%\u0019\u0011QK'\u0003\u000f9{G\u000f[5oO\"9\u0011\u0011\f\u0001\u0005\n\u0005m\u0013aB2p[B\f'/\u001a\u000b\u0007\u0003'\ti&!\u001b\t\u0011\u0005M\u0012q\u000ba\u0001\u0003?\u0002D!!\u0019\u0002fAA\u0011\u0011HA\"\u0003\u0003\t\u0019\u0007\u0005\u0003\u0002J\u0005\u0015D\u0001DA4\u0003;\n\t\u0011!A\u0003\u0002\u0005=#aA0%e!A\u00111NA,\u0001\u0004\ti'\u0001\u0004bGR,\u0018\r\u001c\u0019\u0005\u0003_\n\u0019\b\u0005\u0005\u0002:\u0005\r\u0013\u0011AA9!\u0011\tI%a\u001d\u0005\u0019\u0005U\u0014\u0011NA\u0001\u0002\u0003\u0015\t!a\u0014\u0003\u0007}#3\u0007")
public abstract class PatternTranslatorTestBase
extends TestLogger {
    private final ExpectedException expectedException = ExpectedException.none();
    private final RowTypeInfo testTableTypeInfo = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO});
    private final String tableName;
    private final Tuple3<RelBuilder, StreamTableEnvironment, StreamExecutionEnvironment> context = this.prepareContext((TypeInformation<Row>)this.testTableTypeInfo());
    private final FlinkPlannerImpl planner = new FlinkPlannerImpl(((TableEnvironment)this.context()._2()).getFrameworkConfig(), ((TableEnvironment)this.context()._2()).getPlanner(), ((TableEnvironment)this.context()._2()).getTypeFactory());

    private ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private RowTypeInfo testTableTypeInfo() {
        return this.testTableTypeInfo;
    }

    private String tableName() {
        return this.tableName;
    }

    private Tuple3<RelBuilder, StreamTableEnvironment, StreamExecutionEnvironment> context() {
        return this.context;
    }

    private FlinkPlannerImpl planner() {
        return this.planner;
    }

    private Tuple3<RelBuilder, StreamTableEnvironment, StreamExecutionEnvironment> prepareContext(TypeInformation<Row> typeInfo) {
        org.apache.flink.streaming.api.scala.DataStream dataStreamMock = (org.apache.flink.streaming.api.scala.DataStream)Mockito.mock(org.apache.flink.streaming.api.scala.DataStream.class);
        DataStream jDataStreamMock = (DataStream)Mockito.mock(DataStream.class);
        Mockito.when((Object)dataStreamMock.javaStream()).thenReturn((Object)jDataStreamMock);
        Mockito.when((Object)jDataStreamMock.getType()).thenReturn(typeInfo);
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        tEnv.registerDataStream(this.tableName(), dataStreamMock, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}));
        FlinkRelBuilder relBuilder = tEnv.getRelBuilder();
        relBuilder.scan(new String[]{this.tableName()});
        return new Tuple3((Object)relBuilder, (Object)tEnv, (Object)env);
    }

    public void verifyPattern(String matchRecognize, Pattern<Row, ? extends Row> expected) {
        SqlNode parsed = this.planner().parse(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n         |SELECT *\n         |FROM ").append(this.tableName()).append("\n         |").append(matchRecognize).append("\n         |").toString())).stripMargin());
        SqlNode validated = this.planner().validate(parsed);
        RelNode converted = this.planner().rel((SqlNode)validated).rel;
        StreamTableEnvironment env = (StreamTableEnvironment)this.context()._2();
        RelNode optimized = env.optimize(converted, false);
        if (!(optimized.getInput(0) instanceof DataStreamScan)) {
            Assert.fail((String)"Expression is converted into more than a Match operation. Use a different test method.");
        }
        DataStreamMatch dataMatch = (DataStreamMatch)optimized;
        PatternVisitor pVisitor = new PatternVisitor(new TableConfig(), (TypeInformation)this.testTableTypeInfo(), dataMatch.getLogicalMatch());
        Pattern p = (Pattern)dataMatch.getLogicalMatch().pattern().accept((RexVisitor)pVisitor);
        this.compare(expected, (Pattern<Row, ? extends Row>)p);
    }

    private void compare(Pattern<Row, ? extends Row> expected, Pattern<Row, ? extends Row> actual) {
        Pattern currentLeft = expected;
        Pattern currentRight = actual;
        do {
            String string = currentLeft.getName();
            String string2 = currentRight.getName();
            boolean sameName = !(string != null ? !string.equals(string2) : string2 != null);
            Quantifier quantifier = currentLeft.getQuantifier();
            Quantifier quantifier2 = currentRight.getQuantifier();
            boolean sameQuantifier = !(quantifier != null ? !quantifier.equals(quantifier2) : quantifier2 != null);
            Quantifier.Times times = currentLeft.getTimes();
            Quantifier.Times times2 = currentRight.getTimes();
            boolean sameTimes = !(times != null ? !times.equals(times2) : times2 != null);
            AfterMatchSkipStrategy afterMatchSkipStrategy = currentLeft.getAfterMatchSkipStrategy();
            AfterMatchSkipStrategy afterMatchSkipStrategy2 = currentRight.getAfterMatchSkipStrategy();
            boolean sameSkipStrategy = !(afterMatchSkipStrategy != null ? !afterMatchSkipStrategy.equals(afterMatchSkipStrategy2) : afterMatchSkipStrategy2 != null);
            currentLeft = currentLeft.getPrevious();
            currentRight = currentRight.getPrevious();
            if (sameName && sameQuantifier && sameTimes && sameSkipStrategy) continue;
            throw new ComparisonFailure("Compiled different pattern.", expected.toString(), actual.toString());
        } while (currentLeft != null);
        if (currentRight != null) {
            throw new ComparisonFailure("Compiled different pattern.", expected.toString(), actual.toString());
        }
    }

    public PatternTranslatorTestBase() {
        this.tableName = "testTable";
    }
}

