/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.match;

import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.match.PatternTranslatorTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\t)\u0002+\u0019;uKJtGK]1og2\fGo\u001c:UKN$(BA\u0002\u0005\u0003\u0015i\u0017\r^2i\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!\u0007)biR,'O\u001c+sC:\u001cH.\u0019;peR+7\u000f\u001e\"bg\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005=\u0001\u0001\"B\f\u0001\t\u0003A\u0012!D:j[BdW\rU1ui\u0016\u0014h\u000eF\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0011)f.\u001b;)\u0005Y\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u000b\u0003\u0015QWO\\5u\u0013\t)#E\u0001\u0003UKN$\b\"B\u0014\u0001\t\u0003A\u0012A\u0004;fgR\fe\r^3s\u001b\u0006$8\r\u001b\u0015\u0003M\u0001BQA\u000b\u0001\u0005\u0002a\tq\u0002^3tiF+\u0018M\u001c;jM&,'o\u001d\u0015\u0003S\u0001BQ!\f\u0001\u0005\u0002a\tA\u0002^3ti>\u0003H/[8oC2D#\u0001\f\u0011\t\u000bA\u0002A\u0011\u0001\r\u0002\u001bQ,7\u000f\u001e*fYV\u001cG/\u00198uQ\ty\u0003\u0005C\u00034\u0001\u0011\u0005\u0001$A\u000fuKN$8i\u001c8ue>d7\t[1sg&s\u0007+\u0019;uKJtg*Y7fQ\t\u0011\u0004\u0005C\u00037\u0001\u0011\u0005\u0001$A\u0011uKN$(+\u001a7vGR\fg\u000e^(qi&|g.\u00197O_R\u001cV\u000f\u001d9peR,G\r\u000b\u00036AaJ\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002@y\tqA+\u00192mK\u0016C8-\u001a9uS>t\u0007\"B!\u0001\t\u0003A\u0012\u0001\t;fgR<%o\\;q!\u0006$H/\u001a:og\u0006\u0013XMT8u'V\u0004\bo\u001c:uK\u0012DC\u0001\u0011\u00119s!)A\t\u0001C\u00011\u0005yB/Z:u!\u0016\u0014X.\u001e;bi&|gn]!sK:{GoU;qa>\u0014H/\u001a3)\u0005\r\u0003\u0003\"B$\u0001\t\u0003A\u0012!\b;fgR,\u0005p\u00197vg&|gn]!sK:{GoU;qa>\u0014H/\u001a3)\u0005\u0019\u0003\u0003\"\u0002&\u0001\t\u0003A\u0012a\b;fgR\fE\u000e^3s]\u0006$\u0018n\u001c8t\u0003J,gj\u001c;TkB\u0004xN\u001d;fI\"\u0012\u0011\n\t\u0005\u0006\u001b\u0002!\t\u0001G\u0001#i\u0016\u001cH\u000f\u00155zg&\u001c\u0017\r\\(gMN,Go]!sK:{GoU;qa>\u0014H/\u001a3)\u00051\u0003\u0003\"\u0002)\u0001\t\u0003A\u0012\u0001\t;fgR\u0004\u0016\r\u001e;fe:4\u0016M]5bE2,7/T;ti\n+WK\\5rk\u0016D#a\u0014\u0011")
public class PatternTranslatorTest
extends PatternTranslatorTestBase {
    @Test
    public void simplePattern() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
    }

    @Test
    public void testAfterMatch() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO NEXT ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO LAST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP TO FIRST A\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"A").throwExceptionOnMiss()).next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   AFTER MATCH SKIP PAST LAST ROW\n        |   PATTERN (A B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).next("B"));
    }

    @Test
    public void testQuantifiers() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+ B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6} B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().greedy().next("B"));
    }

    @Test
    public void testOptional() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A* B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().greedy().optional().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("B"));
    }

    @Test
    public void testReluctant() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).timesOrMore(2).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A+? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A{2,6}? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).times(2, 6).consecutive().next("B"));
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A*? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).oneOrMore().consecutive().optional().next("B"));
    }

    @Test
    public void testControlCharsInPatternName() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    `A\"`.f0 AS aid\n        |  PATTERN (`A\"`? l C)\n        |  DEFINE\n        |    `A\"` as `A\"`.f0 = 1\n        |) AS T\n        |")).stripMargin(), (Pattern<Row, ? extends Row>)Pattern.begin((String)"A\"", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToNext()).optional().next("l").next("C"));
    }

    @Test(expected=TableException.class)
    public void testReluctantOptionalNotSupported() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN (A?? B)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test(expected=TableException.class)
    public void testGroupPatternsAreNotSupported() {
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 as aF0\n        |   PATTERN ((A B)+ C)\n        |   DEFINE\n        |     A as A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPermutationsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support PERMUTE patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (PERMUTE(A  C))\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testExclusionsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support '{-' '-}' patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A { - B - }  C)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testAlternationsAreNotSupported() {
        this.thrown().expectMessage("Currently, CEP doesn't support branching patterns.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (( A | B )  C)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPhysicalOffsetsAreNotSupported() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Flink does not support physical offsets within partition.");
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A)\n        |   DEFINE\n        |     A AS PREV(A.f0) = 1\n        |)")).stripMargin(), null);
    }

    @Test
    public void testPatternVariablesMustBeUnique() {
        this.thrown().expectMessage("Pattern variables must be unique. That might change in the future.");
        this.thrown().expect(TableException.class);
        this.verifyPattern(new StringOps(Predef$.MODULE$.augmentString("MATCH_RECOGNIZE (\n        |   ORDER BY proctime\n        |   MEASURES\n        |     A.f0 AS aF0\n        |   PATTERN (A B A)\n        |   DEFINE\n        |     A AS A.f0 = 1\n        |)")).stripMargin(), null);
    }
}

