/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.match;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.codegen.CodeGenException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.match.MatchOperatorValidationTest$;
import org.apache.flink.table.runtime.stream.sql.ToMillis;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u001b\tYR*\u0019;dQ>\u0003XM]1u_J4\u0016\r\\5eCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000b5\fGo\u00195\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011B\u000e\u0002\u0017M$(/Z1n+RLGn]\u000b\u00029A\u0011q\"H\u0005\u0003=A\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2Da\u0001\t\u0001!\u0002\u0013a\u0012\u0001D:ue\u0016\fW.\u0016;jYN\u0004\u0003\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0007;fgR\u001cvN\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3EKN\u001cG#\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\tUs\u0017\u000e\u001e\u0015\u0003C-\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0006\u0002\u000b),h.\u001b;\n\u0005Aj#\u0001\u0002+fgRDQA\r\u0001\u0005\u0002\r\nA\u0005^3tiN{'\u000f\u001e)s_\u000e,7o]5oORKW.Z*fG>tG-\u0019:z\r&,G\u000e\u001a\u0015\u0003c-BQ!\u000e\u0001\u0005\u0002\r\nq\u0002^3tiN{'\u000f\u001e(p\u001fJ$WM\u001d\u0015\u0003i-BQ\u0001\u000f\u0001\u0005\u0002\r\n\u0011\u0006^3tiV\u0003H-\u0019;fg&sW\u000b]:ue\u0016\fWn\u00149fe\u0006$xN\u001d(piN+\b\u000f]8si\u0016$\u0007FA\u001c,\u0011\u0015Y\u0004\u0001\"\u0001$\u0003M!Xm\u001d;BY2\u0014vn^:QKJl\u0015\r^2iQ\tQ4\u0006C\u0003?\u0001\u0011\u00051%\u0001\u0016uKN$xI]3fIf\fV/\u00198uS\u001aLWM]!u)\",WI\u001c3Jg:{GoU;qa>\u0014H/\u001a3)\u0005uZ\u0003\"B!\u0001\t\u0003\u0019\u0013\u0001\r;fgR\u0004\u0016\r\u001e;fe:\u001c\bK]8ek\u000eLgnZ#naRLX*\u0019;dQ\u0016\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002AW!)A\t\u0001C\u0001G\u0005\tC/Z:u+\u001235/\u0011:f\u001d>$8+\u001e9q_J$X\rZ%o\u001b\u0016\f7/\u001e:fg\"\u00121i\u000b\u0005\u0006\u000f\u0002!\taI\u0001 i\u0016\u001cH/\u0016#Gg\u0006\u0013XMT8u'V\u0004\bo\u001c:uK\u0012Le\u000eR3gS:,\u0007F\u0001$,\u0011\u0015Q\u0005\u0001\"\u0001$\u0003\u001d\"Xm\u001d;BO\u001e\u0014XmZ1uKN\f%/\u001a(piN+\b\u000f]8si\u0016$\u0017J\\'fCN,(/Z:)\u0005%[\u0003\"B'\u0001\t\u0003\u0019\u0013!\n;fgR\fum\u001a:fO\u0006$Xm]!sK:{GoU;qa>\u0014H/\u001a3J]\u0012+g-\u001b8fQ\ta5\u0006")
public class MatchOperatorValidationTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtils = this.streamTestUtil();

    private StreamTableTestUtil streamUtils() {
        return this.streamUtils;
    }

    @Test
    public void testSortProcessingTimeDesc() {
        this.thrown().expectMessage("Primary sort order of a streaming table must be ascending on time.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime DESC\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testSortProcessingTimeSecondaryField() {
        this.thrown().expectMessage("You must specify either rowtime or proctime for order by as the first one.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY price, proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testSortNoOrder() {
        this.thrown().expectMessage("You must specify either rowtime or proctime for order by.");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testUpdatesInUpstreamOperatorNotSupported() {
        this.thrown().expectMessage("Retraction on match recognize is not supported. Note: Match recognize should not follow a non-windowed GroupBy aggregation.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (SELECT DISTINCT * FROM Ticker)\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  ONE ROW PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testAllRowsPerMatch() {
        this.thrown().expectMessage("All rows per match mode is not supported yet.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  ALL ROWS PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testGreedyQuantifierAtTheEndIsNotSupported() {
        this.thrown().expectMessage("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B+)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testPatternsProducingEmptyMatchesAreNotSupported() {
        this.thrown().expectMessage("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A*)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testUDFsAreNotSupportedInMeasures() {
        this.thrown().expectMessage("Match recognize does not support UDFs, nor other functions that require open/close methods yet.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    ToMillis(A.proctime) AS aProctime\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS A.symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testUDFsAreNotSupportedInDefine() {
        this.thrown().expectMessage("Match recognize does not support UDFs, nor other functions that require open/close methods yet.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS ToMillis(A.proctime) = 2\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testAggregatesAreNotSupportedInMeasures() {
        this.thrown().expectMessage("Unsupported call: SUM \nIf you think this function should be supported, you can create an issue and start a discussion for it.");
        this.thrown().expect(CodeGenException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    SUM(A.price + A.tax) AS cost\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS A.symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testAggregatesAreNotSupportedInDefine() {
        this.thrown().expectMessage("Unsupported call: SUM \nIf you think this function should be supported, you can create an issue and start a discussion for it.");
        this.thrown().expect(CodeGenException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    B.price as bPrice\n         |  PATTERN (A+ B)\n         |  DEFINE\n         |    A AS SUM(A.price + A.tax) < 10\n         |) AS T\n         |")).stripMargin();
        package$.MODULE$.table2TableConversions(this.streamUtils().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    public MatchOperatorValidationTest() {
        this.streamUtils().addTable("Ticker", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }

                    public CaseClassSerializer<Tuple4<String, Object, Object, Object>> createSerializerInstance(Class<Tuple4<String, Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.match.MatchOperatorValidationTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtils().addFunction("ToMillis", new ToMillis());
    }
}

