/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ClassInstance$;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.descriptors.FunctionDescriptor$;
import org.apache.flink.table.functions.FunctionService$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u00111CR;oGRLwN\\*feZL7-\u001a+fgRT!a\u0001\u0003\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003u!Xm\u001d;Xe>tw-\u0011:hg\u001a+hn\u0019;j_:\u001c%/Z1uS>tG#\u0001\u000f\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0011)f.\u001b;)\te\u0001ce\n\t\u0003C\u0011j\u0011A\t\u0006\u0003G)\tQA[;oSRL!!\n\u0012\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\n\u0001\u0006\u0005\u0002*Y5\t!F\u0003\u0002,\t\u0005\u0019\u0011\r]5\n\u00055R#a\u0005,bY&$\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007\"B\u0018\u0001\t\u0003Y\u0012a\u0007;fgR\u0004&/\u001b<bi\u00164UO\\2uS>t7I]3bi&|g\u000e\u000b\u0003/A\u0019:\u0003\"\u0002\u001a\u0001\t\u0003Y\u0012\u0001\t;fgRLeN^1mS\u0012\u001cE.Y:t\rVt7\r^5p]\u000e\u0013X-\u0019;j_:DC!\r\u0011'O!)Q\u0007\u0001C\u00017\u0005!C/Z:u\u001d>$h)\u001e8di&|gn\u00117bgN4UO\\2uS>t7I]3bi&|g\u000e\u000b\u00035A\u0019:\u0003\"\u0002\u001d\u0001\t\u0003Y\u0012!\u0007;fgRtu.\u0011:h\rVt7\r^5p]\u000e\u0013X-\u0019;j_:D#a\u000e\u0011\t\u000bm\u0002A\u0011A\u000e\u00025Q,7\u000f^(oK\u0006\u0013xMR;oGRLwN\\\"sK\u0006$\u0018n\u001c8)\u0005i\u0002\u0003\"\u0002 \u0001\t\u0003Y\u0012\u0001\b;fgRlU\u000f\u001c;j\u0003J<g)\u001e8di&|gn\u0011:fCRLwN\u001c\u0015\u0003{\u0001:Q!\u0011\u0002\t\u0002\t\u000b1CR;oGRLwN\\*feZL7-\u001a+fgR\u0004\"\u0001G\"\u0007\u000b\u0005\u0011\u0001\u0012\u0001#\u0014\u0005\rs\u0001\"B\u000bD\t\u00031E#\u0001\"\u0007\t!\u001b\u0005!\u0013\u0002\u000b\u001d>\f%oZ\"mCN\u001c8CA$K!\tA2*\u0003\u0002M\u0005\tq1kY1mCJ4UO\\2uS>t\u0007\"B\u000bH\t\u0003qE#A(\u0011\u0005A;U\"A\"\u0007\tI\u001b\u0005a\u0015\u0002\f\u001f:,\u0017I]4DY\u0006\u001c8o\u0005\u0002R\u0015\"AQ+\u0015BC\u0002\u0013\u0005a+A\u0003gS\u0016dG-F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003mC:<'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005a#\n\u0005\t\u0015!\u0003X\u0003\u00191\u0017.\u001a7eA!)Q#\u0015C\u0001ER\u00111\r\u001a\t\u0003!FCQ!V1A\u0002]3AAZ\"\u0001O\niQ*\u001e7uS\u0006\u0013xm\u00117bgN\u001c\"!\u001a&\t\u0011%,'Q1A\u0005\u0002)\faAZ5fY\u0012\fT#A6\u0011\u00051|W\"A7\u000b\u00059\\\u0016\u0001B7bi\"L!\u0001]7\u0003\u0015\tKw\rR3dS6\fG\u000e\u0003\u0005sK\n\u0005\t\u0015!\u0003l\u0003\u001d1\u0017.\u001a7ec\u0001B\u0001\u0002^3\u0003\u0006\u0004%\t!^\u0001\u0007M&,G\u000e\u001a\u001a\u0016\u0003Y\u0004\"\u0001\\<\n\u0005al'A\u0003\"jO&sG/Z4fe\"A!0\u001aB\u0001B\u0003%a/A\u0004gS\u0016dGM\r\u0011\t\u000bU)G\u0011\u0001?\u0015\u0007utx\u0010\u0005\u0002QK\")\u0011n\u001fa\u0001W\")Ao\u001fa\u0001m\u001a1\u00111A\"\u0001\u0003\u000b\u0011A\u0002\u0015:jm\u0006$Xm\u00117bgN\u001c2!!\u0001K\u0011\u001d)\u0012\u0011\u0001C\u0005\u0003\u0013!\"!a\u0003\u0011\u0007A\u000b\t\u0001")
public class FunctionServiceTest {
    @Test(expected=ValidationException.class)
    public void testWrongArgsFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(NoArgClass.class.getName()).parameterString("12"));
        FunctionService$.MODULE$.createFunction(descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testPrivateFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(PrivateClass.class.getName()));
        FunctionService$.MODULE$.createFunction(descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidClassFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of("this.class.does.not.exist"));
        FunctionService$.MODULE$.createFunction(descriptor);
    }

    @Test(expected=ValidationException.class)
    public void testNotFunctionClassFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(String.class.getName()).parameterString("hello"));
        FunctionService$.MODULE$.createFunction(descriptor);
    }

    @Test
    public void testNoArgFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(NoArgClass.class.getName()));
        Assert.assertEquals(NoArgClass.class, (Object)FunctionService$.MODULE$.createFunction(descriptor).getClass());
    }

    @Test
    public void testOneArgFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(OneArgClass.class.getName()).parameterString("false"));
        UserDefinedFunction actualFunction = FunctionService$.MODULE$.createFunction(descriptor);
        Assert.assertEquals(OneArgClass.class, (Object)actualFunction.getClass());
        Assert.assertFalse((boolean)Predef$.MODULE$.Boolean2boolean(((OneArgClass)actualFunction).field()));
    }

    @Test
    public void testMultiArgFunctionCreation() {
        FunctionDescriptor descriptor = FunctionDescriptor$.MODULE$.apply().fromClass(ClassInstance$.MODULE$.apply().of(MultiArgClass.class.getName()).parameter(new BigDecimal("12.0003")).parameter(ClassInstance$.MODULE$.apply().of(BigInteger.class.getName()).parameter("111111111111111111111111111111111")));
        UserDefinedFunction actualFunction = FunctionService$.MODULE$.createFunction(descriptor);
        Assert.assertEquals(MultiArgClass.class, (Object)actualFunction.getClass());
        Assert.assertEquals((Object)new BigDecimal("12.0003"), (Object)((MultiArgClass)actualFunction).field1());
        Assert.assertEquals((Object)new BigInteger("111111111111111111111111111111111"), (Object)((MultiArgClass)actualFunction).field2());
    }

    public static class MultiArgClass
    extends ScalarFunction {
        private final BigDecimal field1;
        private final BigInteger field2;

        public BigDecimal field1() {
            return this.field1;
        }

        public BigInteger field2() {
            return this.field2;
        }

        public MultiArgClass(BigDecimal field1, BigInteger field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    public static class NoArgClass
    extends ScalarFunction {
    }

    public static class OneArgClass
    extends ScalarFunction {
        private final Boolean field;

        public Boolean field() {
            return this.field;
        }

        public OneArgClass(Boolean field) {
            this.field = field;
        }
    }

    public static class PrivateClass
    extends ScalarFunction {
        private PrivateClass() {
        }
    }
}

