/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.factories.utils.TestFixedFormatTableFactory;
import org.apache.flink.table.factories.utils.TestFixedFormatTableFactory$;
import org.apache.flink.table.factories.utils.TestWildcardFormatTableSourceFactory;
import org.apache.flink.table.factories.utils.TestWildcardFormatTableSourceFactory$;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u001b\tiB+\u00192mKN{WO]2f\r\u0006\u001cGo\u001c:z'\u0016\u0014h/[2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Ia-Y2u_JLWm\u001d\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t1\u0003^3tiZ\u000bG.\u001b3Qe>\u0004XM\u001d;jKN$\u0012\u0001\b\t\u0003\u001fuI!A\b\t\u0003\tUs\u0017\u000e\u001e\u0015\u00033\u0001\u0002\"!\t\u0013\u000e\u0003\tR!a\t\u0006\u0002\u000b),h.\u001b;\n\u0005\u0015\u0012#\u0001\u0002+fgRDQa\n\u0001\u0005\u0002m\t!\u0003^3ti&sg/\u00197jI\u000e{g\u000e^3yi\"\"a\u0005I\u0015+\u0003!)\u0007\u0010]3di\u0016$7%A\u0016\u0011\u00051zS\"A\u0017\u000b\u00059\"\u0011aA1qS&\u0011\u0001'\f\u0002 \u001d>l\u0015\r^2iS:<G+\u00192mK\u001a\u000b7\r^8ss\u0016C8-\u001a9uS>t\u0007\"\u0002\u001a\u0001\t\u0003Y\u0012a\u0007;fgR$\u0015N\u001a4fe\u0016tGoQ8oi\u0016DHOV3sg&|g\u000e\u000b\u00022A!)Q\u0007\u0001C\u00017\u00059B/Z:u+:\u001cX\u000f\u001d9peR,G\r\u0015:pa\u0016\u0014H/\u001f\u0015\u0005i\u0001J#\u0006C\u00039\u0001\u0011\u00051$\u0001\nuKN$x+\u001b7eG\u0006\u0014HMR8s[\u0006$\bFA\u001c!\u0011\u0015Y\u0004\u0001\"\u0003=\u0003)\u0001(o\u001c9feRLWm\u001d\u000b\u0002{A!ahQ#F\u001b\u0005y$B\u0001!B\u0003\u0011)H/\u001b7\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u0010\u0002\u0004\u001b\u0006\u0004\bC\u0001$N\u001d\t95\n\u0005\u0002I!5\t\u0011J\u0003\u0002K\u0019\u00051AH]8pizJ!\u0001\u0014\t\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019B\u0001")
public class TableSourceFactoryServiceTest {
    @Test
    public void testValidProperties() {
        Map<String, String> props = this.properties();
        props.put("connector.type", TestFixedFormatTableFactory$.MODULE$.CONNECTOR_TYPE_VALUE_FIXED());
        props.put("format.type", TestFixedFormatTableFactory$.MODULE$.FORMAT_TYPE_VALUE_TEST());
        Assert.assertTrue((boolean)(TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, props) instanceof TestFixedFormatTableFactory));
    }

    @Test(expected=NoMatchingTableFactoryException.class)
    public void testInvalidContext() {
        Map<String, String> props = this.properties();
        props.put("connector.type", "unknown-connector-type");
        props.put("format.type", TestFixedFormatTableFactory$.MODULE$.FORMAT_TYPE_VALUE_TEST());
        TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, props);
    }

    @Test
    public void testDifferentContextVersion() {
        Map<String, String> props = this.properties();
        props.put("connector.type", TestFixedFormatTableFactory$.MODULE$.CONNECTOR_TYPE_VALUE_FIXED());
        props.put("format.type", TestFixedFormatTableFactory$.MODULE$.FORMAT_TYPE_VALUE_TEST());
        props.put("connector.property-version", "2");
        Assert.assertTrue((boolean)(TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, props) instanceof TestFixedFormatTableFactory));
    }

    @Test(expected=NoMatchingTableFactoryException.class)
    public void testUnsupportedProperty() {
        Map<String, String> props = this.properties();
        props.put("connector.type", TestFixedFormatTableFactory$.MODULE$.CONNECTOR_TYPE_VALUE_FIXED());
        props.put("format.type", TestFixedFormatTableFactory$.MODULE$.FORMAT_TYPE_VALUE_TEST());
        props.put("format.unknown-format-type-property", "/new/path");
        TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, props);
    }

    @Test
    public void testWildcardFormat() {
        Map<String, String> props = this.properties();
        props.put("connector.type", TestWildcardFormatTableSourceFactory$.MODULE$.CONNECTOR_TYPE_VALUE_WILDCARD());
        props.put("format.unknown-format-type-property", "wildcard-property");
        StreamTableSourceFactory actualTableSource = (StreamTableSourceFactory)TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, props);
        Assert.assertTrue((boolean)(actualTableSource instanceof TestWildcardFormatTableSourceFactory));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> properties() {
        void var1_1;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.property-version", "1");
        properties.put("format.property-version", "1");
        properties.put("format.path", "/path/to/target");
        properties.put("schema.0.name", "a");
        properties.put("schema.1.name", "b");
        properties.put("schema.2.name", "c");
        properties.put("schema.0.field.0.name", "a");
        properties.put("schema.0.field.1.name", "b");
        properties.put("schema.0.field.2.name", "c");
        return var1_1;
    }
}

