/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.factories.utils.TestTableSinkFactory;
import org.apache.flink.table.factories.utils.TestTableSinkFactory$;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\tYB+\u00192mKNKgn\u001b$bGR|'/_*feZL7-\u001a+fgRT!a\u0001\u0003\u0002\u0013\u0019\f7\r^8sS\u0016\u001c(BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003M!Xm\u001d;WC2LG\r\u0015:pa\u0016\u0014H/[3t)\u0005a\u0002CA\b\u001e\u0013\tq\u0002C\u0001\u0003V]&$\bFA\r!!\t\tC%D\u0001#\u0015\t\u0019#\"A\u0003kk:LG/\u0003\u0002&E\t!A+Z:u\u0011\u00159\u0003\u0001\"\u0001\u001c\u0003I!Xm\u001d;J]Z\fG.\u001b3D_:$X\r\u001f;)\t\u0019\u0002\u0013FK\u0001\tKb\u0004Xm\u0019;fI\u000e\n1\u0006\u0005\u0002-_5\tQF\u0003\u0002/\t\u0005\u0019\u0011\r]5\n\u0005Aj#a\b(p\u001b\u0006$8\r[5oOR\u000b'\r\\3GC\u000e$xN]=Fq\u000e,\u0007\u000f^5p]\")!\u0007\u0001C\u00017\u0005YB/Z:u\t&4g-\u001a:f]R\u001cuN\u001c;fqR4VM]:j_:D#!\r\u0011\t\u000bU\u0002A\u0011A\u000e\u0002/Q,7\u000f^+ogV\u0004\bo\u001c:uK\u0012\u0004&o\u001c9feRL\b\u0006\u0002\u001b!S)BQ\u0001\u000f\u0001\u0005\ne\n!\u0002\u001d:pa\u0016\u0014H/[3t)\u0005Q\u0004\u0003B\u001eA\u0005\nk\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\ri\u0015\r\u001d\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015\u0003R\"\u0001$\u000b\u0005\u001dc\u0011A\u0002\u001fs_>$h(\u0003\u0002J!\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tI\u0005\u0003")
public class TableSinkFactoryServiceTest {
    @Test
    public void testValidProperties() {
        Map<String, String> props = this.properties();
        Assert.assertTrue((boolean)(TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, props) instanceof TestTableSinkFactory));
    }

    @Test(expected=NoMatchingTableFactoryException.class)
    public void testInvalidContext() {
        Map<String, String> props = this.properties();
        props.put("connector.type", "unknown-connector-type");
        TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, props);
    }

    @Test
    public void testDifferentContextVersion() {
        Map<String, String> props = this.properties();
        props.put("connector.property-version", "2");
        Assert.assertTrue((boolean)(TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, props) instanceof TestTableSinkFactory));
    }

    @Test(expected=NoMatchingTableFactoryException.class)
    public void testUnsupportedProperty() {
        Map<String, String> props = this.properties();
        props.put("format.path_new", "/new/path");
        TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, props);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> properties() {
        void var1_1;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", TestTableSinkFactory$.MODULE$.CONNECTOR_TYPE_VALUE_TEST());
        properties.put("format.type", TestTableSinkFactory$.MODULE$.FORMAT_TYPE_VALUE_TEST());
        properties.put("connector.property-version", "1");
        properties.put("format.property-version", "1");
        properties.put(TestTableSinkFactory$.MODULE$.FORMAT_PATH(), "/path/to/target");
        properties.put("schema.0.name", "a");
        properties.put("schema.1.name", "b");
        properties.put("schema.2.name", "c");
        properties.put("schema.0.field.0.name", "a");
        properties.put("schema.0.field.1.name", "b");
        properties.put("schema.0.field.2.name", "c");
        return var1_1;
    }
}

