/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.validation;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.scala.timestampDiff$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimePointUnit$;
import org.apache.flink.table.expressions.utils.ScalarTypesTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001=\u0011QdU2bY\u0006\u0014h)\u001e8di&|gn\u001d,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t!B^1mS\u0012\fG/[8o\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"aE*dC2\f'\u000fV=qKN$Vm\u001d;CCN,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003=!Xm\u001d;J]Z\fG.\u001b3M_\u001e\fD#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u00057\u0015ZC\u0006\u0005\u0002'S5\tqE\u0003\u0002)\u0019\u0005)!.\u001e8ji&\u0011!f\n\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\u0005i\u0003C\u0001\u00187\u001d\tyCG\u0004\u00021g5\t\u0011G\u0003\u00023\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003k\u0001\nq\u0001]1dW\u0006<W-\u0003\u00028q\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0005U\u0002\u0003\"\u0002\u001e\u0001\t\u0003i\u0012a\u0004;fgRLeN^1mS\u0012dun\u001a\u001a)\te*3\u0006\f\u0005\u0006{\u0001!\t!H\u0001\u0010i\u0016\u001cH/\u00138wC2LGMQ5oc!\"A(J\u0016@G\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\u0007\u0003\r\t\u0007/[\u0005\u0003\u000b\n\u00131CV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:DQa\u0012\u0001\u0005\u0002u\tq\u0002^3ti&sg/\u00197jI\nKgN\r\u0015\u0005\r\u0016Zs\bC\u0003K\u0001\u0011\u0005Q$A\buKN$\u0018J\u001c<bY&$')\u001b84Q\u0011IUeK \t\u000b5\u0003A\u0011A\u000f\u0002+Q,7\u000f^%om\u0006d\u0017\u000eZ*vEN$(/\u001b8hc!\"A*J\u0016@\u0011\u0015\u0001\u0006\u0001\"\u0001\u001e\u0003U!Xm\u001d;J]Z\fG.\u001b3Tk\n\u001cHO]5oOJBCaT\u0013,\u007f!)1\u000b\u0001C\u0001;\u0005QC/Z:u)&lWm\u001d;b[B\fE\rZ,ji\"<&o\u001c8h)&lWm\u001d;b[BLe\u000e^3sm\u0006d\u0007\u0006\u0002*&WU\u001b\u0013A\u0016\t\u0003\u0003^K!\u0001\u0017\"\u0003%M\u000bH\u000eU1sg\u0016\u0014X\t_2faRLwN\u001c\u0005\u00065\u0002!\t!H\u0001)i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BI\u0012<\u0016\u000e\u001e5Xe>tw\rV5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e\u0015\u00053\u0016ZS\u000bC\u0003^\u0001\u0011\u0005Q$A\u0011uKN$H+[7fgR\fW\u000e]!eI^KG\u000f[,s_:<\u0017+^1oi&$\u0018\u0010\u000b\u0003]K-z\u0004\"\u00021\u0001\t\u0003i\u0012A\b;fgR$\u0016.\\3ti\u0006l\u0007\u000fR5gM^KG\u000f[,s_:<G+[7fQ\u0011yVeK \t\u000b\r\u0004A\u0011A\u000f\u0002KQ,7\u000f\u001e+j[\u0016\u001cH/Y7q\t&4gmV5uQ^\u0013xN\\4US6,\u0017I\u001c3V]&$\b\u0006\u00022&W}BQA\u001a\u0001\u0005\u0002u\t\u0011\u0005^3ti\u0012{ukV5uQRKW.Z,iS\u000eD\u0017j]+ogV\u0004\bo\u001c:uK\u0012DC!Z\u0013,\u007f!)\u0011\u000e\u0001C\u0001;\u0005\tC/Z:u\t>Kv+\u001b;i)&lWm\u00165jG\"L5/\u00168tkB\u0004xN\u001d;fI\"\"\u0001.J\u0016@\u0011\u0015a\u0007\u0001\"\u0003n\u0003u!Xm\u001d;FqR\u0014\u0018m\u0019;Ge>lG+[7f5\u0016\u0014xNU3tk2$HC\u0001\u0010o\u0011\u0015y7\u000e1\u0001q\u0003\u0011)h.\u001b;\u0011\u0005EDX\"\u0001:\u000b\u0005M$\u0018\u0001B;uS2T!!\u001e<\u0002\u000f\u00054\u0018\r^5dC*\u0011qOC\u0001\bG\u0006d7-\u001b;f\u0013\tI(O\u0001\u0005US6,WK\\5u\u0011\u0015Y\b\u0001\"\u0001\u001e\u0003Y!Xm\u001d;NS2dWM\u001c8jk6<\u0016\u000e\u001e5US6,\u0007\u0006\u0002>&W}BQA \u0001\u0005\u0002u\t1\u0003^3ti\u000e+g\u000e^;ss^KG\u000f\u001b+j[\u0016DC!`\u0013,\u007f!1\u00111\u0001\u0001\u0005\u0002u\t\u0001\u0003^3tif+\u0017M],ji\"$\u0016.\\3)\u000b\u0005\u0005QeK \t\r\u0005%\u0001\u0001\"\u0001\u001e\u0003E!Xm\u001d;N_:$\bnV5uQRKW.\u001a\u0015\u0006\u0003\u000f)3f\u0010\u0005\u0007\u0003\u001f\u0001A\u0011A\u000f\u0002\u001fQ,7\u000f\u001e#bs^KG\u000f\u001b+j[\u0016DS!!\u0004&W}Ba!!\u0006\u0001\t\u0003i\u0012!\u000b;fgRLeNV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:luN]3UQ\u0006twJ\\3UsB,7\u000fK\u0003\u0002\u0014\u0015Zs\b\u0003\u0004\u0002\u001c\u0001!\t!H\u00010g\u000e\fG.Y%o-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198egR+7\u000f\u001e\u0015\u0006\u00033)3f\u0010\u0005\u0007\u0003C\u0001A\u0011A\u000f\u0002])\fg/Y%o-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198egR+7\u000f\u001e\u0015\u0006\u0003?)3f\u0010")
public class ScalarFunctionsValidationTest
extends ScalarTypesTestBase {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLog1() {
        this.testSqlApi("LOG(1, 100)", "FAIL");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLog2() {
        this.testSqlApi("LOG(-1)", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin1() {
        this.testSqlApi("BIN(f12)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin2() {
        this.testSqlApi("BIN(f15)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin3() {
        this.testSqlApi("BIN(f16)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring1() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring(package$.MODULE$.LiteralDoubleExpression(2.0).toExpr()), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring2() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring(package$.MODULE$.LiteralStringExpression("test").toExpr()), "FAIL", "FAIL");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampInterval() {
        this.testSqlApi("TIMESTAMPADD(XXX, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampFormat() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampAddWithWrongQuantity() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1.0, timestamp '2016-02-24 12:42:25')", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTime() {
        this.testTableApi(timestampDiff$.MODULE$.apply(TimePointUnit$.MODULE$.DAY(), package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTimeAndUnit() {
        this.testTableApi(timestampDiff$.MODULE$.apply(TimePointUnit$.MODULE$.MINUTE(), package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testDOWWithTimeWhichIsUnsupported() {
        this.testSqlApi("EXTRACT(DOW FROM TIME '12:42:25')", "0");
    }

    @Test(expected=ValidationException.class)
    public void testDOYWithTimeWhichIsUnsupported() {
        this.testSqlApi("EXTRACT(DOY FROM TIME '12:42:25')", "0");
    }

    private void testExtractFromTimeZeroResult(TimeUnit unit) {
        this.testSqlApi(new StringBuilder(30).append("EXTRACT(").append(unit).append(" FROM TIME '00:00:00')").toString(), "0");
    }

    @Test(expected=ValidationException.class)
    public void testMillenniumWithTime() {
        this.testExtractFromTimeZeroResult(TimeUnit.MILLENNIUM);
    }

    @Test(expected=ValidationException.class)
    public void testCenturyWithTime() {
        this.testExtractFromTimeZeroResult(TimeUnit.CENTURY);
    }

    @Test(expected=ValidationException.class)
    public void testYearWithTime() {
        this.testExtractFromTimeZeroResult(TimeUnit.YEAR);
    }

    @Test(expected=ValidationException.class)
    public void testMonthWithTime() {
        this.testExtractFromTimeZeroResult(TimeUnit.MONTH);
    }

    @Test(expected=ValidationException.class)
    public void testDayWithTime() {
        this.testExtractFromTimeZeroResult(TimeUnit.DAY);
    }

    @Test(expected=ValidationException.class)
    public void testInValidationExceptionMoreThanOneTypes() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.int2Literal(4)})), "f2.in(f3, f4, 4)", "true");
    }

    @Test(expected=ValidationException.class)
    public void scalaInValidationExceptionDifferentOperandsTest() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")})), "true", "true");
    }

    @Test(expected=ValidationException.class)
    public void javaInValidationExceptionDifferentOperandsTest() {
        this.testTableApi(package$.MODULE$.boolean2Literal(true), "f1.in('Hi','Hello world','Comment#1')", "true");
    }
}

