/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.map$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.MapTypeTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u001f\t)R*\u00199UsB,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0003vi&d7/\u0003\u0002\u0016%\tyQ*\u00199UsB,G+Z:u\u0005\u0006\u001cX\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005\u0001B/Z:u/J|gnZ&fsRK\b/\u001a\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!QK\\5uQ\u0011YRe\u000b\u0017\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!b\u0011!\u00026v]&$\u0018B\u0001\u0016(\u0005\u0011!Vm\u001d;\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\t1!\u00199j\u0013\t\u0011tFA\nWC2LG-\u0019;j_:,\u0005pY3qi&|g\u000eC\u00035\u0001\u0011\u0005Q$\u0001\u0010uKN$\u0018J\\2peJ,7\r^'baRK\b/Z\"p[B\f'/[:p]\"\"1'J\u0016-\u0011\u00159\u0004\u0001\"\u0001\u001e\u0003u!Xm\u001d;V]N,\b\u000f]8si\u0016$7i\\7qCJL7o\u001c8UsB,\u0007\u0006\u0002\u001c&W1BQA\u000f\u0001\u0005\u0002u\tA\u0002^3ti\u0016k\u0007\u000f^=NCBDC!O\u0013,Y!)Q\b\u0001C\u0001;\u0005QC/Z:u+:\u001cX\u000f\u001d9peR,G-T1q\u00136\u0004H.[2jiRK\b/Z\"bgR$\u0016M\u00197f\u0003BL\u0007\u0006\u0002\u001f&W1BQ\u0001\u0011\u0001\u0005\u0002u\tQ\u0005^3tiVs7/\u001e9q_J$X\rZ'ba&k\u0007\u000f\\5dSR$\u0016\u0010]3DCN$8+\u001d7)\t}*3\u0006\f")
public class MapTypeValidationTest
extends MapTypeTestBase {
    @Test(expected=ValidationException.class)
    public void testWrongKeyType() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.int2Literal(12)), "f2.at(12)", "f2[12]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testIncorrectMapTypeComparison() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3"))), "f1 === f3", "f1 = f3", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedComparisonType() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f6 !== f2", "f6 != f2", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testEmptyMap() {
        this.testAllApis(package$.MODULE$.string2Literal("FAIL"), "map()", "MAP[]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedMapImplicitTypeCastTableApi() {
        this.testTableApi(map$.MODULE$.apply(package$.MODULE$.string2Literal("k1"), package$.MODULE$.double2Literal(1.0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("k2"), package$.MODULE$.float2Literal(2.0f)})), "map('k1', 1.0, 'k2', 2.0f)", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedMapImplicitTypeCastSql() {
        this.testSqlApi("MAP['k1', 'string', 'k2', 12]", "FAIL");
    }
}

