/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.array$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.ArrayTypeTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001f\t9\u0012I\u001d:bsRK\b/\u001a,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t!B^1mS\u0012\fG/[8o\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"!E!se\u0006LH+\u001f9f)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u001di\u0016\u001cH/S7qY&\u001c\u0017\u000e\u001e+za\u0016\u001c\u0015m\u001d;UC\ndW-\u00119j)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDCaG\u0013,YA\u0011a%K\u0007\u0002O)\u0011\u0001\u0006D\u0001\u0006UVt\u0017\u000e^\u0005\u0003U\u001d\u0012A\u0001V3ti\u0006AQ\r\u001f9fGR,GmI\u0001.!\tq\u0013'D\u00010\u0015\t\u0001d!A\u0002ba&L!AM\u0018\u0003'Y\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\t\u000bQ\u0002A\u0011A\u000f\u00029Q,7\u000f^%na2L7-\u001b;UsB,7)Y:u\u0003J\u0014\u0018-_*rY\"\"1'J\u0016-\u0011\u00159\u0004\u0001\"\u0001\u001e\u0003}!Xm\u001d;PEZLw.^:J]Z\fG.\u001b3J]\u0012,\u0007\u0010V1cY\u0016\f\u0005/\u001b\u0015\u0005m\u0015ZC\u0006C\u0003;\u0001\u0011\u0005Q$A\tuKN$X)\u001c9us\u0006\u0013(/Y=Tc2DC!O\u0013,Y!)Q\b\u0001C\u0001;\u00051B/Z:u\u000b6\u0004H/_!se\u0006LH+\u00192mK\u0006\u0003\u0018\u000e\u000b\u0003=K-b\u0003\"\u0002!\u0001\t\u0003i\u0012\u0001\u0005;fgRtU\u000f\u001c7BeJ\f\u0017pU9mQ\u0011yTe\u000b\u0017\t\u000b\r\u0003A\u0011A\u000f\u00025Q,7\u000f\u001e#jM\u001a,'/\u001a8u)f\u0004Xm]!se\u0006L8+\u001d7)\t\t+3\u0006\f\u0005\u0006\r\u0002!\t!H\u0001 i\u0016\u001cH\u000fR5gM\u0016\u0014XM\u001c;UsB,7/\u0011:sCf$\u0016M\u00197f\u0003BL\u0007\u0006B#&W1BQ!\u0013\u0001\u0005\u0002u\t\u0011\u0004^3tiVs7/\u001e9q_J$X\rZ\"p[B\f'/[:p]\"\"\u0001*J\u0016-\u0011\u0015a\u0005\u0001\"\u0001\u001e\u0003M!Xm\u001d;FY\u0016lWM\u001c;O_:\f%O]1zQ\u0011YUe\u000b\u0017\t\u000b=\u0003A\u0011A\u000f\u0002-Q,7\u000f^#mK6,g\u000e\u001e(p]\u0006\u0013(/Y=Tc2DCAT\u0013,Y!)!\u000b\u0001C\u0001;\u0005IB/Z:u\u0007\u0006\u0014H-\u001b8bY&$\u0018p\u00148O_:\f%O]1zQ\u0011\tVe\u000b\u0017\t\u000bU\u0003A\u0011A\u000f\u00029Q,7\u000f^\"be\u0012Lg.\u00197jif|eNT8o\u0003J\u0014\u0018-_*rY\"\"A+J\u0016-\u0001")
public class ArrayTypeValidationTest
extends ArrayTypeTestBase {
    @Test(expected=ValidationException.class)
    public void testImplicitTypeCastTableApi() {
        this.testTableApi(array$.MODULE$.apply(package$.MODULE$.double2Literal(1.0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.float2Literal(2.0f)})), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testImplicitTypeCastArraySql() {
        this.testSqlApi("ARRAY['string', 12]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testObviousInvalidIndexTableApi() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.int2Literal(0)), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testEmptyArraySql() {
        this.testSqlApi("ARRAY[]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testEmptyArrayTableApi() {
        this.testTableApi(package$.MODULE$.string2Literal("FAIL"), "array()", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testNullArraySql() {
        this.testSqlApi("ARRAY[NULL]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testDifferentTypesArraySql() {
        this.testSqlApi("ARRAY[1, TRUE]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testDifferentTypesArrayTableApi() {
        this.testTableApi(package$.MODULE$.string2Literal("FAIL"), "array(1, true)", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedComparison() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$less$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at(package$.MODULE$.int2Literal(1))), "f2 <= f5.at(1)", "f2 <= f5[1]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testElementNonArray() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).element(), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testElementNonArraySql() {
        this.testSqlApi("ELEMENT(f0)", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testCardinalityOnNonArray() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cardinality(), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testCardinalityOnNonArraySql() {
        this.testSqlApi("CARDINALITY(f0)", "FAIL");
    }
}

