/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\t\tB+Z7q_J\fG\u000eV=qKN$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\u0011\u0011CA\u0001\u0006kRLGn]\u0005\u0003'A\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\u0016i\u0016\u001cH\u000fV5nKB{\u0017N\u001c;MSR,'/\u00197t)\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"\u0001B+oSRD#!G\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019R\u0011!\u00026v]&$\u0018B\u0001\u0015&\u0005\u0011!Vm\u001d;\t\u000b)\u0002A\u0011A\u000e\u00021Q,7\u000f\u001e+j[\u0016Le\u000e^3sm\u0006dG*\u001b;fe\u0006d7\u000f\u000b\u0002*G!)Q\u0006\u0001C\u00017\u0005\u0011B/Z:u)&lW\rU8j]RLe\u000e];uQ\ta3\u0005C\u00031\u0001\u0011\u00051$A\u000buKN$H+[7f\u0013:$XM\u001d<bY&s\u0007/\u001e;)\u0005=\u001a\u0003\"B\u001a\u0001\t\u0003Y\u0012\u0001\u0006;fgR$\u0016.\\3Q_&tGoQ1ti&tw\r\u000b\u00023G!)a\u0007\u0001C\u00017\u00059B/Z:u)&lW-\u00138uKJ4\u0018\r\\\"bgRLgn\u001a\u0015\u0003k\rBQ!\u000f\u0001\u0005\u0002m\tq\u0003^3tiRKW.\u001a)pS:$8i\\7qCJL7o\u001c8)\u0005a\u001a\u0003\"\u0002\u001f\u0001\t\u0003Y\u0012A\u0007;fgR$\u0016.\\3J]R,'O^1m\u0003JLG\u000f[7fi&\u001c\u0007FA\u001e$\u0011\u0015y\u0004\u0001\"\u0001\u001c\u0003Q!Xm\u001d;TK2,7\r\u001e(vY24\u0016\r\\;fg\"\u0012ah\t\u0005\u0006\u0005\u0002!\taQ\u0001\ti\u0016\u001cH\u000fR1uCV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002H\r\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\u0004%><\b\"B&\u0001\t\u0003a\u0015\u0001\u0003;za\u0016LeNZ8\u0016\u00035\u00032AT+X\u001b\u0005y%B\u0001)R\u0003!!\u0018\u0010]3j]\u001a|'B\u0001*T\u0003\u0019\u0019w.\\7p]*\u0011AKB\u0001\u0004CBL\u0017B\u0001,P\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007CA\u000fY\u0013\tIfDA\u0002B]f\u0004")
public class TemporalTypesTest
extends ExpressionTestBase {
    @Test
    public void testTimePointLiterals() {
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14").toDate(), "'1990-10-14'.toDate", "DATE '1990-10-14'", "1990-10-14");
        this.testTableApi(package$.MODULE$.sqlDate2Literal(Date.valueOf("2040-09-11")), "'2040-09-11'.toDate", "2040-09-11");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30").cast(Types$.MODULE$.SQL_DATE()), "'1500-04-30'.cast(SQL_DATE)", "CAST('1500-04-30' AS DATE)", "1500-04-30");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("15:45:59").toTime(), "'15:45:59'.toTime", "TIME '15:45:59'", "15:45:59");
        this.testTableApi(package$.MODULE$.sqlTime2Literal(Time.valueOf("00:00:00")), "'00:00:00'.toTime", "00:00:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1:30:00").cast(Types$.MODULE$.SQL_TIME()), "'1:30:00'.cast(SQL_TIME)", "CAST('1:30:00' AS TIME)", "01:30:00");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1990-10-14 23:00:00.123").toTimestamp(), "'1990-10-14 23:00:00.123'.toTimestamp", "TIMESTAMP '1990-10-14 23:00:00.123'", "1990-10-14 23:00:00.123");
        this.testTableApi(package$.MODULE$.sqlTimestamp2Literal(Timestamp.valueOf("2040-09-11 00:00:00.000")), "'2040-09-11 00:00:00.000'.toTimestamp", "2040-09-11 00:00:00.0");
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("1500-04-30 12:00:00").cast(Types$.MODULE$.SQL_TIMESTAMP()), "'1500-04-30 12:00:00'.cast(SQL_TIMESTAMP)", "CAST('1500-04-30 12:00:00' AS TIMESTAMP)", "1500-04-30 12:00:00.0");
    }

    @Test
    public void testTimeIntervalLiterals() {
        this.testAllApis(package$.MODULE$.LiteralIntExpression(1).year(), "1.year", "INTERVAL '1' YEAR", "+1-00");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(1).month(), "1.month", "INTERVAL '1' MONTH", "+0-01");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(12).days(), "12.days", "INTERVAL '12' DAY", "+12 00:00:00.000");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(1).hour(), "1.hour", "INTERVAL '1' HOUR", "+0 01:00:00.000");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(3).minutes(), "3.minutes", "INTERVAL '3' MINUTE", "+0 00:03:00.000");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(3).seconds(), "3.seconds", "INTERVAL '3' SECOND", "+0 00:00:03.000");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(3).millis(), "3.millis", "INTERVAL '0.003' SECOND", "+0 00:00:00.003");
    }

    @Test
    public void testTimePointInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), "f0", "f0", "1990-10-14");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), "f1", "f1", "10:20:45");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "1990-10-14 10:20:45.123");
    }

    @Test
    public void testTimeIntervalInput() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")), "f9", "f9", "+2-00");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")), "f10", "f10", "+0 00:00:12.000");
    }

    @Test
    public void testTimePointCasting() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(Types$.MODULE$.SQL_TIMESTAMP()), "f0.cast(SQL_TIMESTAMP)", "CAST(f0 AS TIMESTAMP)", "1990-10-14 00:00:00.0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).cast(Types$.MODULE$.SQL_TIMESTAMP()), "f1.cast(SQL_TIMESTAMP)", "CAST(f1 AS TIMESTAMP)", "1970-01-01 10:20:45.0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(Types$.MODULE$.SQL_DATE()), "f2.cast(SQL_DATE)", "CAST(f2 AS DATE)", "1990-10-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(Types$.MODULE$.SQL_TIME()), "f2.cast(SQL_TIME)", "CAST(f2 AS TIME)", "10:20:45");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(Types$.MODULE$.SQL_TIME()), "f2.cast(SQL_TIME)", "CAST(f2 AS TIME)", "10:20:45");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(Types$.MODULE$.SQL_DATE()), "f7.cast(SQL_DATE)", "2002-11-09");
        this.testTableApi((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(Types$.MODULE$.SQL_DATE())).cast(Types$.MODULE$.INT()), "f7.cast(SQL_DATE).cast(INT)", "12000");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(Types$.MODULE$.SQL_TIME()), "f7.cast(SQL_TIME)", "00:00:12");
        this.testTableApi((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(Types$.MODULE$.SQL_TIME())).cast(Types$.MODULE$.INT()), "f7.cast(SQL_TIME).cast(INT)", "12000");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).cast(Types$.MODULE$.SQL_TIMESTAMP()), "f8.cast(SQL_TIMESTAMP)", "2016-06-27 07:23:33.0");
        this.testTableApi((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).cast(Types$.MODULE$.SQL_TIMESTAMP())).cast(Types$.MODULE$.LONG()), "f8.cast(SQL_TIMESTAMP).cast(LONG)", "1467012213000");
    }

    @Test
    public void testTimeIntervalCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cast(Types$.MODULE$.INTERVAL_MONTHS()), "f7.cast(INTERVAL_MONTHS)", "+1000-00");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).cast(Types$.MODULE$.INTERVAL_MILLIS()), "f8.cast(INTERVAL_MILLIS)", "+16979 07:23:33.000");
    }

    @Test
    public void testTimePointComparison() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3"))), "f0 < f3", "f0 < f3", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "f0 < f4", "f0 < f4", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f1 < f5", "f1 < f5", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(Types$.MODULE$.SQL_TIMESTAMP())).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f0.cast(SQL_TIMESTAMP) !== f2", "CAST(f0 AS TIMESTAMP) <> f2", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(Types$.MODULE$.SQL_TIMESTAMP())).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "f0.cast(SQL_TIMESTAMP) === f6", "CAST(f0 AS TIMESTAMP) = f6", "true");
    }

    @Test
    public void testTimeIntervalArithmetic() {
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).months()).$less(package$.MODULE$.LiteralIntExpression(24).months()), "12.months < 24.months", "INTERVAL '12' MONTH < INTERVAL '24' MONTH", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(8).years()).$eq$eq$eq(package$.MODULE$.LiteralIntExpression(8).years()), "8.years === 8.years", "INTERVAL '8' YEAR = INTERVAL '8' YEAR", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(8).millis()).$greater(package$.MODULE$.LiteralIntExpression(10).millis()), "8.millis > 10.millis", "INTERVAL '0.008' SECOND > INTERVAL '0.010' SECOND", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(8).millis()).$eq$eq$eq(package$.MODULE$.LiteralIntExpression(8).millis()), "8.millis === 8.millis", "INTERVAL '0.008' SECOND = INTERVAL '0.008' SECOND", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(8).years()).$plus(package$.MODULE$.LiteralIntExpression(10).months()), "8.years + 10.months", "INTERVAL '8' YEAR + INTERVAL '10' MONTH", "+8-10");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(2).years()).$minus(package$.MODULE$.LiteralIntExpression(12).months()), "2.years - 12.months", "INTERVAL '2' YEAR - INTERVAL '12' MONTH", "+1-00");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(-2).years(), "-2.years", "-INTERVAL '2' YEAR", "-2-00");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(8).hours()).$plus(package$.MODULE$.LiteralIntExpression(10).minutes())).$plus(package$.MODULE$.LiteralIntExpression(12).seconds())).$plus(package$.MODULE$.LiteralIntExpression(5).millis()), "8.hours + 10.minutes + 12.seconds + 5.millis", "INTERVAL '8' HOUR + INTERVAL '10' MINUTE + INTERVAL '12.005' SECOND", "+0 08:10:12.005");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(1).minute()).$minus(package$.MODULE$.LiteralIntExpression(10).seconds()), "1.minute - 10.seconds", "INTERVAL '1' MINUTE - INTERVAL '10' SECOND", "+0 00:00:50.000");
        this.testAllApis(package$.MODULE$.LiteralIntExpression(-10).seconds(), "-10.seconds", "-INTERVAL '10' SECOND", "-0 00:00:10.000");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus(package$.MODULE$.LiteralIntExpression(2).days()), "f0 + 2.days", "f0 + INTERVAL '2' DAY", "1990-10-16");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(30).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "30.days + f0", "INTERVAL '30' DAY + f0", "1990-11-13");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus(package$.MODULE$.LiteralIntExpression(2).months()), "f0 + 2.months", "f0 + INTERVAL '2' MONTH", "1990-12-14");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(2).months()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "2.months + f0", "INTERVAL '2' MONTH + f0", "1990-12-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.LiteralIntExpression(12).hours()), "f1 + 12.hours", "f1 + INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(12).hours()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12.hours + f1", "INTERVAL '12' HOUR + f1", "22:20:45");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus(package$.MODULE$.LiteralIntExpression(10).days())).$plus(package$.MODULE$.LiteralIntExpression(4).millis()), "f2 + 10.days + 4.millis", "f2 + INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-24 10:20:45.127");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(10).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")))).$plus(package$.MODULE$.LiteralIntExpression(4).millis()), "10.days + f2 + 4.millis", "INTERVAL '10 00:00:00.004' DAY TO SECOND + f2", "1990-10-24 10:20:45.127");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus(package$.MODULE$.LiteralIntExpression(10).years()), "f2 + 10.years", "f2 + INTERVAL '10' YEAR", "2000-10-14 10:20:45.123");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(10).years()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "10.years + f2", "INTERVAL '10' YEAR + f2", "2000-10-14 10:20:45.123");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus(package$.MODULE$.LiteralIntExpression(2).days()), "f0 - 2.days", "f0 - INTERVAL '2' DAY", "1990-10-12");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(-30).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "-30.days + f0", "INTERVAL '-30' DAY + f0", "1990-09-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus(package$.MODULE$.LiteralIntExpression(2).months()), "f0 - 2.months", "f0 - INTERVAL '2' MONTH", "1990-08-14");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(-2).months()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "-2.months + f0", "-INTERVAL '2' MONTH + f0", "1990-08-14");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$minus(package$.MODULE$.LiteralIntExpression(12).hours()), "f1 - 12.hours", "f1 - INTERVAL '12' HOUR", "22:20:45");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(-12).hours()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "-12.hours + f1", "INTERVAL '-12' HOUR + f1", "22:20:45");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus(package$.MODULE$.LiteralIntExpression(10).days())).$minus(package$.MODULE$.LiteralIntExpression(4).millis()), "f2 - 10.days - 4.millis", "f2 - INTERVAL '10 00:00:00.004' DAY TO SECOND", "1990-10-04 10:20:45.119");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(-10).days()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")))).$minus(package$.MODULE$.LiteralIntExpression(4).millis()), "-10.days + f2 - 4.millis", "INTERVAL '-10 00:00:00.004' DAY TO SECOND + f2", "1990-10-04 10:20:45.119");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus(package$.MODULE$.LiteralIntExpression(10).years()), "f2 - 10.years", "f2 - INTERVAL '10' YEAR", "1980-10-14 10:20:45.123");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralIntExpression(-10).years()).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "-10.years + f2", "INTERVAL '-10' YEAR + f2", "1980-10-14 10:20:45.123");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).cast(Types$.MODULE$.INTERVAL_MONTHS())).unary_$minus(), "-f9.cast(INTERVAL_MONTHS)", "-CAST(f9 AS INTERVAL YEAR)", "-2-00");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).cast(Types$.MODULE$.INTERVAL_MILLIS())).unary_$minus(), "-f10.cast(INTERVAL_MILLIS)", "-CAST(f10 AS INTERVAL SECOND)", "-0 00:00:12.000");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus(package$.MODULE$.LiteralIntExpression(2).days())).$plus(package$.MODULE$.LiteralIntExpression(1).month()), "f0 + 2.days + 1.month", "f0 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$minus(package$.MODULE$.LiteralIntExpression(2).days())).$minus(package$.MODULE$.LiteralIntExpression(1).month()), "f0 - 2.days - 1.month", "f0 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$plus(package$.MODULE$.LiteralIntExpression(2).days())).$plus(package$.MODULE$.LiteralIntExpression(1).month()), "f2 + 2.days + 1.month", "f2 + INTERVAL '2' DAY + INTERVAL '1' MONTH", "1990-11-16 10:20:45.123");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$minus(package$.MODULE$.LiteralIntExpression(2).days())).$minus(package$.MODULE$.LiteralIntExpression(1).month()), "f2 - 2.days - 1.month", "f2 - INTERVAL '2' DAY - INTERVAL '1' MONTH", "1990-09-12 10:20:45.123");
    }

    @Test
    public void testSelectNullValues() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")), "f11", "f11", "null");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f12")), "f12", "f12", "null");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")), "f13", "f13", "null");
    }

    /*
     * WARNING - void declaration
     */
    public Row testData() {
        void var1_1;
        Row testData = new Row(14);
        testData.setField(0, (Object)Date.valueOf("1990-10-14"));
        testData.setField(1, (Object)Time.valueOf("10:20:45"));
        testData.setField(2, (Object)Timestamp.valueOf("1990-10-14 10:20:45.123"));
        testData.setField(3, (Object)Date.valueOf("1990-10-13"));
        testData.setField(4, (Object)Date.valueOf("1990-10-15"));
        testData.setField(5, (Object)Time.valueOf("00:00:00"));
        testData.setField(6, (Object)Timestamp.valueOf("1990-10-14 00:00:00.0"));
        testData.setField(7, (Object)BoxesRunTime.boxToInteger((int)12000));
        testData.setField(8, (Object)BoxesRunTime.boxToLong((long)1467012213000L));
        testData.setField(9, (Object)BoxesRunTime.boxToInteger((int)24));
        testData.setField(10, (Object)BoxesRunTime.boxToLong((long)12000L));
        testData.setField(11, null);
        testData.setField(12, null);
        testData.setField(13, null);
        return var1_1;
    }

    @Override
    public TypeInformation<Object> typeInfo() {
        return new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.SQL_DATE(), Types$.MODULE$.SQL_TIME(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.SQL_DATE(), Types$.MODULE$.SQL_DATE(), Types$.MODULE$.SQL_TIME(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.INTERVAL_MONTHS(), Types$.MODULE$.INTERVAL_MILLIS(), Types$.MODULE$.SQL_DATE(), Types$.MODULE$.SQL_TIME(), Types$.MODULE$.SQL_TIMESTAMP()});
    }
}

