/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001b\t\t2+\u001d7FqB\u0014Xm]:j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\u0011\u0011CA\u0001\u0006kRLGn]\u0005\u0003'A\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\u0018i\u0016\u001cHoQ8na\u0006\u0014\u0018n]8o\rVt7\r^5p]N$\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG\u000f\u000b\u0002\u001aGA\u0011AeJ\u0007\u0002K)\u0011aEC\u0001\u0006UVt\u0017\u000e^\u0005\u0003Q\u0015\u0012A\u0001V3ti\")!\u0006\u0001C\u00017\u0005!B/Z:u\u0019><\u0017nY1m\rVt7\r^5p]ND#!K\u0012\t\u000b5\u0002A\u0011A\u000e\u0002/Q,7\u000f^!sSRDW.\u001a;jG\u001a+hn\u0019;j_:\u001c\bF\u0001\u0017$\u0011\u0015\u0001\u0004\u0001\"\u0001\u001c\u0003M!Xm\u001d;TiJLgn\u001a$v]\u000e$\u0018n\u001c8tQ\ty3\u0005C\u00034\u0001\u0011\u00051$A\u000buKN$H+Z7q_J\fGNR;oGRLwN\\:)\u0005I\u001a\u0003\"\u0002\u001c\u0001\t\u0003Y\u0012\u0001\u0007;fgR\u001cuN\u001c3ji&|g.\u00197Gk:\u001cG/[8og\"\u0012Qg\t\u0005\u0006s\u0001!\taG\u0001\u001ci\u0016\u001cH\u000fV=qK\u000e{gN^3sg&|gNR;oGRLwN\\:)\u0005a\u001a\u0003\"\u0002\u001f\u0001\t\u0003Y\u0012a\u0006;fgR\u001cu\u000e\u001c7fGRLwN\u001c$v]\u000e$\u0018n\u001c8tQ\tY4\u0005C\u0003@\u0001\u0011\u00051$A\u000fuKN$h+\u00197vK\u000e{gn\u001d;sk\u000e$xN\u001d$v]\u000e$\u0018n\u001c8tQ\tq4\u0005C\u0003C\u0001\u0011\u00051$A\tuKN$\b*Y:i\rVt7\r^5p]ND#!Q\u0012\t\u000b\u0015\u0003A\u0011A\u000e\u0002EQ,7\u000f\u001e%bg\"4UO\\2uS>t7/\u00168tkB\u0004xN\u001d;fI2+gn\u001a;iQ\u0011!5e\u0012%\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u0013\t\u0003\u0015Js!a\u0013)\u000f\u00051{U\"A'\u000b\u00059c\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\t\tf$A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0015\t\tf\u0004C\u0003W\u0001\u0011\u00051$A\u000euKN$\b*Y:i\rVt7\r^5p]NC\u0017M\r(p!\u0006\u0014\u0018-\u001c\u0015\u0005+\u000e:\u0005lI\u0001Z!\tQV,D\u0001\\\u0015\taF!A\u0002ba&L!AX.\u0003'Y\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\t\u000b\u0001\u0004A\u0011I1\u0002\u0011Q,7\u000f\u001e#bi\u0006,\u0012A\u0019\t\u0003;\rL!\u0001\u001a\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003g\u0001\u0011\u0005s-\u0001\u0005usB,\u0017J\u001c4p+\u0005A\u0007cA5pE6\t!N\u0003\u0002lY\u0006AA/\u001f9fS:4wN\u0003\u0002n]\u000611m\\7n_:T!\u0001\u0018\u0004\n\u0005AT'a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8")
public class SqlExpressionTest
extends ExpressionTestBase {
    @Test
    public void testComparisonFunctions() {
        this.testSqlApi("1 = 1", "true");
        this.testSqlApi("1 <> 1", "false");
        this.testSqlApi("5 > 2", "true");
        this.testSqlApi("2 >= 2", "true");
        this.testSqlApi("5 < 2", "false");
        this.testSqlApi("2 <= 2", "true");
        this.testSqlApi("1 IS NULL", "false");
        this.testSqlApi("1 IS NOT NULL", "true");
        this.testSqlApi("NULLIF(1,1) IS DISTINCT FROM NULLIF(1,1)", "false");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "true");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "true");
        this.testSqlApi("12 BETWEEN NULL AND 13", "null");
        this.testSqlApi("12 BETWEEN 11 AND 13", "true");
        this.testSqlApi("12 BETWEEN ASYMMETRIC 13 AND 11", "false");
        this.testSqlApi("12 BETWEEN SYMMETRIC 13 AND 11", "true");
        this.testSqlApi("12 NOT BETWEEN 11 AND 13", "false");
        this.testSqlApi("12 NOT BETWEEN ASYMMETRIC 13 AND 11", "true");
        this.testSqlApi("12 NOT BETWEEN SYMMETRIC 13 AND 11", "false");
        this.testSqlApi("'TEST' LIKE '%EST'", "true");
        this.testSqlApi("'TEST' NOT LIKE '%EST'", "false");
        this.testSqlApi("'TEST' SIMILAR TO '.EST'", "true");
        this.testSqlApi("'TEST' NOT SIMILAR TO '.EST'", "false");
        this.testSqlApi("'TEST' IN ('west', 'TEST', 'rest')", "true");
        this.testSqlApi("'TEST' IN ('west', 'rest')", "false");
        this.testSqlApi("'TEST' NOT IN ('west', 'TEST', 'rest')", "false");
        this.testSqlApi("'TEST' NOT IN ('west', 'rest')", "true");
    }

    @Test
    public void testLogicalFunctions() {
        this.testSqlApi("TRUE OR FALSE", "true");
        this.testSqlApi("TRUE AND FALSE", "false");
        this.testSqlApi("NOT TRUE", "false");
        this.testSqlApi("TRUE IS FALSE", "false");
        this.testSqlApi("TRUE IS NOT FALSE", "true");
        this.testSqlApi("TRUE IS TRUE", "true");
        this.testSqlApi("TRUE IS NOT TRUE", "false");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS UNKNOWN", "true");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS NOT UNKNOWN", "false");
    }

    @Test
    public void testArithmeticFunctions() {
        this.testSqlApi("+5", "5");
        this.testSqlApi("-5", "-5");
        this.testSqlApi("5+5", "10");
        this.testSqlApi("5-5", "0");
        this.testSqlApi("5*5", "25");
        this.testSqlApi("5/5", "1");
        this.testSqlApi("POWER(5, 5)", "3125.0");
        this.testSqlApi("ABS(-5)", "5");
        this.testSqlApi("MOD(-26, 5)", "-1");
        this.testSqlApi("SQRT(4)", "2.0");
        this.testSqlApi("LN(2)", "0.6931471805599453");
        this.testSqlApi("LOG10(10)", "1.0");
        this.testSqlApi("LOG2(8)", "3.0");
        this.testSqlApi("LOG(E())", "1.0");
        this.testSqlApi("LOG(3,27)", "3.0");
        this.testSqlApi("EXP(1)", "2.718281828459045");
        this.testSqlApi("CEIL(2.5)", "3");
        this.testSqlApi("CEILING(2.5)", "3");
        this.testSqlApi("FLOOR(2.5)", "2");
        this.testSqlApi("SIN(2.5)", "0.5984721441039564");
        this.testSqlApi("SINH(2.5)", "6.0502044810397875");
        this.testSqlApi("COS(2.5)", "-0.8011436155469337");
        this.testSqlApi("TAN(2.5)", "-0.7470222972386603");
        this.testSqlApi("TANH(2.5)", "0.9866142981514303");
        this.testSqlApi("COT(2.5)", "-1.3386481283041514");
        this.testSqlApi("ASIN(0.5)", "0.5235987755982989");
        this.testSqlApi("ACOS(0.5)", "1.0471975511965979");
        this.testSqlApi("ATAN(0.5)", "0.4636476090008061");
        this.testSqlApi("ATAN2(0.5, 0.5)", "0.7853981633974483");
        this.testSqlApi("COSH(2.5)", "6.132289479663686");
        this.testSqlApi("DEGREES(0.5)", "28.64788975654116");
        this.testSqlApi("RADIANS(0.5)", "0.008726646259971648");
        this.testSqlApi("SIGN(-1.1)", "-1");
        this.testSqlApi("ROUND(-12.345, 2)", "-12.35");
        this.testSqlApi("PI", "3.141592653589793");
        this.testSqlApi("E()", "2.718281828459045");
        this.testSqlApi("BIN(12)", "1100");
    }

    @Test
    public void testStringFunctions() {
        this.testSqlApi("'test' || 'string'", "teststring");
        this.testSqlApi("CHAR_LENGTH('string')", "6");
        this.testSqlApi("CHARACTER_LENGTH('string')", "6");
        this.testSqlApi("UPPER('string')", "STRING");
        this.testSqlApi("LOWER('STRING')", "string");
        this.testSqlApi("POSITION('STR' IN 'STRING')", "1");
        this.testSqlApi("TRIM(BOTH ' STRING ')", "STRING");
        this.testSqlApi("TRIM(LEADING 'x' FROM 'xxxxSTRINGxxxx')", "STRINGxxxx");
        this.testSqlApi("TRIM(TRAILING 'x' FROM 'xxxxSTRINGxxxx')", "xxxxSTRING");
        this.testSqlApi("LTRIM(' This is a test String.')", "This is a test String.");
        this.testSqlApi("RTRIM('This is a test String. ')", "This is a test String.");
        this.testSqlApi("OVERLAY('This is an old string' PLACING ' new' FROM 10 FOR 5)", "This is a new string");
        this.testSqlApi("SUBSTRING('hello world', 2)", "ello world");
        this.testSqlApi("SUBSTRING('hello world', 2, 3)", "ell");
        this.testSqlApi("INITCAP('hello WORLD')", "Hello World");
        this.testSqlApi("CONCAT('a', 'b')", "ab");
        this.testSqlApi("CONCAT('a', NULLIF('a', 'a'), 'b')", "null");
        this.testSqlApi("CONCAT_WS('~', 'a', NULLIF('a', 'a'), 'b')", "a~b");
        this.testSqlApi("LPAD('hi',4,'??')", "??hi");
        this.testSqlApi("RPAD('hi',4,'??')", "hi??");
        this.testSqlApi("FROM_BASE64('aGVsbG8gd29ybGQ=')", "hello world");
        this.testSqlApi("TO_BASE64('hello world')", "aGVsbG8gd29ybGQ=");
        this.testSqlApi("REPEAT('This is a test String.', 2)", "This is a test String.This is a test String.");
        this.testSqlApi("REGEXP_REPLACE('foobar', 'oo|ar', '')", "fb");
        this.testSqlApi("REPLACE('hello world', 'world', 'flink')", "hello flink");
        this.testSqlApi("REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
    }

    @Test
    public void testTemporalFunctions() {
        this.testSqlApi("DATE '1990-10-14'", "1990-10-14");
        this.testSqlApi("TIME '12:12:12'", "12:12:12");
        this.testSqlApi("TIMESTAMP '1990-10-14 12:12:12.123'", "1990-10-14 12:12:12.123");
        this.testSqlApi("INTERVAL '10 00:00:00.004' DAY TO SECOND", "+10 00:00:00.004");
        this.testSqlApi("INTERVAL '10 00:12' DAY TO MINUTE", "+10 00:12:00.000");
        this.testSqlApi("INTERVAL '2-10' YEAR TO MONTH", "+2-10");
        this.testSqlApi("EXTRACT(DAY FROM DATE '1990-12-01')", "1");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("YEAR(DATE '1994-09-27')", "1994");
        this.testSqlApi("QUARTER(DATE '2016-04-12')", "2");
        this.testSqlApi("MONTH(DATE '1994-09-27')", "9");
        this.testSqlApi("WEEK(DATE '1994-09-27')", "39");
        this.testSqlApi("DAYOFYEAR(DATE '1994-09-27')", "270");
        this.testSqlApi("DAYOFMONTH(DATE '1994-09-27')", "27");
        this.testSqlApi("DAYOFWEEK(DATE '1994-09-27')", "3");
        this.testSqlApi("HOUR(TIMESTAMP '1994-09-27 13:14:15')", "13");
        this.testSqlApi("MINUTE(TIMESTAMP '1994-09-27 13:14:15')", "14");
        this.testSqlApi("SECOND(TIMESTAMP '1994-09-27 13:14:15')", "15");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO MINUTE)", "12:44:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO MINUTE)", "12:45:00");
        this.testSqlApi("(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "true");
        this.testSqlApi("(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:55:01', INTERVAL '1' HOUR)", "false");
        this.testSqlApi("TIMESTAMPADD(WEEK, 1, DATE '2003-01-02')", "2003-01-09");
    }

    @Test
    public void testConditionalFunctions() {
        this.testSqlApi("CASE 2 WHEN 1, 2 THEN 2 ELSE 3 END", "2");
        this.testSqlApi("CASE WHEN 1 = 2 THEN 2 WHEN 1 = 1 THEN 3 ELSE 4 END", "3");
        this.testSqlApi("NULLIF(1, 1)", "null");
        this.testSqlApi("COALESCE(NULL, 5)", "5");
    }

    @Test
    public void testTypeConversionFunctions() {
        this.testSqlApi("CAST(2 AS DOUBLE)", "2.0");
    }

    @Test
    public void testCollectionFunctions() {
        this.testSqlApi("CARDINALITY(ARRAY[TRUE, TRUE, FALSE])", "3");
        this.testSqlApi("ARRAY[TRUE, FALSE][2]", "false");
        this.testSqlApi("ELEMENT(ARRAY['HELLO WORLD'])", "HELLO WORLD");
        this.testSqlApi("CARDINALITY(MAP['k1', 'v1', 'k2', 'v2'])", "2");
        this.testSqlApi("MAP['k1', 'v1', 'k2', 'v2']['k2']", "v2");
    }

    @Test
    public void testValueConstructorFunctions() {
        this.testSqlApi("ROW('hello world', 12)", "hello world,12");
        this.testSqlApi("('hello world', 12)", "hello world,12");
        this.testSqlApi("('foo', ('bar', 12))", "foo,bar,12");
        this.testSqlApi("ARRAY[TRUE, TRUE]", "[true, true]");
        this.testSqlApi("MAP['k1', CAST(true AS VARCHAR(256)), 'k2', 'foo']", "{k1=true, k2=foo}");
    }

    @Test
    public void testHashFunctions() {
        this.testSqlApi("MD5('')", "d41d8cd98f00b204e9800998ecf8427e");
        this.testSqlApi("MD5('test')", "098f6bcd4621d373cade4e832627b4f6");
        this.testSqlApi("SHA1('')", "da39a3ee5e6b4b0d3255bfef95601890afd80709");
        this.testSqlApi("SHA1('test')", "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3");
        this.testSqlApi("SHA224('')", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA2('', 224)", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA224('test')", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA2('test', 224)", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA256('')", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA2('', 256)", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA256('test')", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA2('test', 256)", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA384('')", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA2('', 384)", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA384('test')", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA2('test', 384)", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA512('')", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA2('',512)", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA512('test')", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("SHA2('test',512)", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("MD5(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA1(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA224(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA256(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA384(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA512(CAST(NULL AS VARCHAR))", "null");
        this.testSqlApi("SHA2(CAST(NULL AS VARCHAR), 256)", "null");
    }

    @Test(expected=RuntimeException.class)
    public void testHashFunctionsUnsupportedLength() {
        this.testSqlApi("SHA2('', 333)", "");
    }

    @Test(expected=ValidationException.class)
    public void testHashFunctionSha2NoParam() {
        this.testSqlApi("SHA2('')", "");
    }

    @Override
    public Object testData() {
        return new Row(0);
    }

    @Override
    public TypeInformation<Object> typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }
}

