/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.ImplicitExpressionConversions;
import org.apache.flink.table.api.scala.atan2$;
import org.apache.flink.table.api.scala.concat$;
import org.apache.flink.table.api.scala.concat_ws$;
import org.apache.flink.table.api.scala.currentDate$;
import org.apache.flink.table.api.scala.currentTime$;
import org.apache.flink.table.api.scala.currentTimestamp$;
import org.apache.flink.table.api.scala.e$;
import org.apache.flink.table.api.scala.localTime$;
import org.apache.flink.table.api.scala.localTimestamp$;
import org.apache.flink.table.api.scala.pi$;
import org.apache.flink.table.api.scala.rand$;
import org.apache.flink.table.api.scala.randInteger$;
import org.apache.flink.table.api.scala.temporalOverlaps$;
import org.apache.flink.table.api.scala.timestampDiff$;
import org.apache.flink.table.api.scala.uuid$;
import org.apache.flink.table.expressions.Atan2;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Log;
import org.apache.flink.table.expressions.Log$;
import org.apache.flink.table.expressions.Null;
import org.apache.flink.table.expressions.TableSymbols;
import org.apache.flink.table.expressions.TimeIntervalUnit$;
import org.apache.flink.table.expressions.TimePointUnit$;
import org.apache.flink.table.expressions.utils.ScalarTypesTestBase;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u00015\u00111cU2bY\u0006\u0014h)\u001e8di&|gn\u001d+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\u0005\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\u0014'\u000e\fG.\u0019:UsB,7\u000fV3ti\n\u000b7/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t1\u0002^3ti>3XM\u001d7bsR\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\bFA\r$!\t!s%D\u0001&\u0015\t1#\"A\u0003kk:LG/\u0003\u0002)K\t!A+Z:u\u0011\u0015Q\u0003\u0001\"\u0001\u001c\u00031!Xm\u001d;Q_NLG/[8oQ\tI3\u0005C\u0003.\u0001\u0011\u00051$A\u0007uKN$8+\u001e2tiJLgn\u001a\u0015\u0003Y\rBQ\u0001\r\u0001\u0005\u0002m\t1\u0002^3tiJ+\u0007\u000f\\1dK\"\u0012qf\t\u0005\u0006g\u0001!\taG\u0001\ti\u0016\u001cH\u000f\u0016:j[\"\u0012!g\t\u0005\u0006m\u0001!\taG\u0001\u000fi\u0016\u001cHo\u00115be2+gn\u001a;iQ\t)4\u0005C\u0003:\u0001\u0011\u00051$A\u0007uKN$X\u000b\u001d9fe\u000e\u000b7/\u001a\u0015\u0003q\rBQ\u0001\u0010\u0001\u0005\u0002m\tQ\u0002^3ti2{w/\u001a:DCN,\u0007FA\u001e$\u0011\u0015y\u0004\u0001\"\u0001\u001c\u0003-!Xm\u001d;J]&$8)\u00199)\u0005y\u001a\u0003\"\u0002\"\u0001\t\u0003Y\u0012A\u0003;fgR\u001cuN\\2bi\"\u0012\u0011i\t\u0005\u0006\u000b\u0002!\taG\u0001\ti\u0016\u001cH\u000fT5lK\"\u0012Ai\t\u0005\u0006\u0011\u0002!\taG\u0001\fi\u0016\u001cHOT8u\u0019&\\W\r\u000b\u0002HG!)1\n\u0001C\u00017\u0005\u0011B/Z:u\u0019&\\WmV5uQ\u0016\u001b8-\u00199fQ\tQ5\u0005C\u0003O\u0001\u0011\u00051$A\u000buKN$hj\u001c;MS.,w+\u001b;i\u000bN\u001c\u0017\r]3)\u00055\u001b\u0003\"B)\u0001\t\u0003Y\u0012a\u0003;fgR\u001c\u0016.\\5mCJD#\u0001U\u0012\t\u000bQ\u0003A\u0011A\u000e\u0002\u001dQ,7\u000f\u001e(piNKW.\u001b7be\"\u00121k\t\u0005\u0006/\u0002!\taG\u0001\u0016i\u0016\u001cHoU5nS2\f'oV5uQ\u0016\u001b8-\u00199fQ\t16\u0005C\u0003[\u0001\u0011\u00051$\u0001\ruKN$hj\u001c;TS6LG.\u0019:XSRDWi]2ba\u0016D#!W\u0012\t\u000bu\u0003A\u0011A\u000e\u0002\u001fQ,7\u000f^'vYRL7i\u001c8dCRD#\u0001X\u0012\t\u000b\u0001\u0004A\u0011A\u000e\u0002\u0019Q,7\u000f^\"p]\u000e\fGoV:)\u0005}\u001b\u0003\"B2\u0001\t\u0003Y\u0012\u0001\u0003;fgRd\u0005+\u00193)\u0005\t\u001c\u0003\"\u00024\u0001\t\u0003Y\u0012\u0001\u0003;fgR\u0014\u0006+\u00193)\u0005\u0015\u001c\u0003\"B5\u0001\t\u0003Y\u0012a\u0002;fgRDU\r\u001f\u0015\u0003Q\u000eBQ\u0001\u001c\u0001\u0005\u0002m\tq\u0001^3ti\nKg\u000e\u000b\u0002lG!)q\u000e\u0001C\u00017\u0005\tB/Z:u%\u0016<W\r\u001f9SKBd\u0017mY3)\u00059\u001c\u0003\"\u0002:\u0001\t\u0003Y\u0012!\u0005;fgR\u0014VmZ3ya\u0016CHO]1di\"\u0012\u0011o\t\u0005\u0006k\u0002!\taG\u0001\u000fi\u0016\u001cHO\u0012:p[\n\u000b7/\u001a\u001c5Q\t!8\u0005C\u0003y\u0001\u0011\u00051$\u0001\u0007uKN$Hk\u001c\"bg\u00164D\u0007\u000b\u0002xG!)1\u0010\u0001C\u00017\u0005AA/Z:u+VKE\t\u000b\u0002{G!)a\u0010\u0001C\u00017\u0005IA/Z:u\u0019R\u0013\u0018.\u001c\u0015\u0003{\u000eBa!a\u0001\u0001\t\u0003Y\u0012!\u0003;fgR\u0014FK]5nQ\r\t\ta\t\u0005\u0007\u0003\u0013\u0001A\u0011A\u000e\u0002\u0015Q,7\u000f\u001e*fa\u0016\fG\u000fK\u0002\u0002\b\rBa!a\u0004\u0001\t\u0003Y\u0012a\u0002;fgRlu\u000e\u001a\u0015\u0004\u0003\u001b\u0019\u0003BBA\u000b\u0001\u0011\u00051$A\u0004uKN$X\t\u001f9)\u0007\u0005M1\u0005\u0003\u0004\u0002\u001c\u0001!\taG\u0001\ni\u0016\u001cH\u000fT8hcAB3!!\u0007$\u0011\u0019\t\t\u0003\u0001C\u00017\u0005AA/Z:u\u0019><'\u0007K\u0002\u0002 \rBa!a\n\u0001\t\u0003Y\u0012!\u0003;fgR\u0004vn^3sQ\r\t)c\t\u0005\u0007\u0003[\u0001A\u0011A\u000e\u0002\u0011Q,7\u000f^*reRD3!a\u000b$\u0011\u0019\t\u0019\u0004\u0001C\u00017\u0005AA/Z:u\u0007>\u001c\b\u000eK\u0002\u00022\rBa!!\u000f\u0001\t\u0003Y\u0012A\u0002;fgRde\u000eK\u0002\u00028\rBa!a\u0010\u0001\t\u0003Y\u0012a\u0002;fgR\f%m\u001d\u0015\u0004\u0003{\u0019\u0003BBA#\u0001\u0011\u00051$A\fuKN$\u0018I]5uQ6,G/[2GY>|'oQ3jY\"\u001a\u00111I\u0012\t\r\u0005-\u0003\u0001\"\u0001\u001c\u0003\u001d!Xm\u001d;TS:D3!!\u0013$\u0011\u0019\t\t\u0006\u0001C\u00017\u00059A/Z:u\u0007>\u001c\bfAA(G!1\u0011q\u000b\u0001\u0005\u0002m\t\u0001\u0002^3tiNKg\u000e\u001b\u0015\u0004\u0003+\u001a\u0003BBA/\u0001\u0011\u00051$A\u0004uKN$H+\u00198)\u0007\u0005m3\u0005\u0003\u0004\u0002d\u0001!\taG\u0001\ti\u0016\u001cH\u000fV1oQ\"\u001a\u0011\u0011M\u0012\t\r\u0005%\u0004\u0001\"\u0001\u001c\u0003\u001d!Xm\u001d;D_RD3!a\u001a$\u0011\u0019\ty\u0007\u0001C\u00017\u0005AA/Z:u\u0003NLg\u000eK\u0002\u0002n\rBa!!\u001e\u0001\t\u0003Y\u0012\u0001\u0003;fgR\f5m\\:)\u0007\u0005M4\u0005\u0003\u0004\u0002|\u0001!\taG\u0001\ti\u0016\u001cH/\u0011;b]\"\u001a\u0011\u0011P\u0012\t\r\u0005\u0005\u0005\u0001\"\u0001\u001c\u0003%!Xm\u001d;Bi\u0006t'\u0007K\u0002\u0002\u0000\rBa!a\"\u0001\t\u0003Y\u0012a\u0003;fgR$Um\u001a:fKND3!!\"$\u0011\u0019\ti\t\u0001C\u00017\u0005YA/Z:u%\u0006$\u0017.\u00198tQ\r\tYi\t\u0005\u0007\u0003'\u0003A\u0011A\u000e\u0002\u0011Q,7\u000f^*jO:D3!!%$\u0011\u0019\tI\n\u0001C\u00017\u0005IA/Z:u%>,h\u000e\u001a\u0015\u0004\u0003/\u001b\u0003BBAP\u0001\u0011\u00051$\u0001\u0004uKN$\b+\u001b\u0015\u0004\u0003;\u001b\u0003BBAS\u0001\u0011\u00051$\u0001\fuKN$(+\u00198e\u0003:$'+\u00198e\u0013:$XmZ3sQ\r\t\u0019k\t\u0005\u0007\u0003W\u0003A\u0011A\u000e\u0002\u000bQ,7\u000f^#)\u0007\u0005%6\u0005\u0003\u0004\u00022\u0002!\taG\u0001\bi\u0016\u001cH\u000fT8hQ\r\tyk\t\u0005\u0007\u0003o\u0003A\u0011A\u000e\u0002\u0017Q,7\u000f^#yiJ\f7\r\u001e\u0015\u0004\u0003k\u001b\u0003BBA_\u0001\u0011\u00051$A\tuKN$H+Z7q_J\fGN\u00127p_JD3!a/$\u0011\u0019\t\u0019\r\u0001C\u00017\u0005!B/Z:u\u0007V\u0014(/\u001a8u)&lW\rU8j]RD3!!1$\u0011\u0019\tI\r\u0001C\u00017\u0005aA/Z:u\u001fZ,'\u000f\\1qg\"\u001a\u0011qY\u0012\t\r\u0005=\u0007\u0001\"\u0001\u001c\u0003E!Xm\u001d;US6,7\u000f^1na\u0012KgM\u001a\u0015\u0004\u0003\u001b\u001c\u0003BBAk\u0001\u0011\u00051$\u0001\tuKN$H+[7fgR\fW\u000e]!eI\"\u001a\u00111[\u0012\t\r\u0005m\u0007\u0001\"\u0001\u001c\u0003E!Xm\u001d;ICNDg)\u001e8di&|gn\u001d\u0015\u0004\u00033\u001c\u0003BBAq\u0001\u0011\u00051$A\tuKN$\u0018j\u001d+sk\u0016L5OR1mg\u0016D3!a8$\u0001")
public class ScalarFunctionsTest
extends ScalarTypesTestBase {
    @Test
    public void testOverlay() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("xxxxxtest").overlay(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xxxx"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(6)), "'xxxxxtest'.overlay('xxxx', 6)", "OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6)", "xxxxxxxxx");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("xxxxxtest").overlay(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xxxx"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(6), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "'xxxxxtest'.overlay('xxxx', 6, 2)", "OVERLAY('xxxxxtest' PLACING 'xxxx' FROM 6 FOR 2)", "xxxxxxxxxst");
    }

    @Test
    public void testPosition() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").position(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xxxtest")), "'test'.position('xxxtest')", "POSITION('test' IN 'xxxtest')", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("testx").position(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xxxtest")), "'testx'.position('xxxtest')", "POSITION('testx' IN 'xxxtest')", "0");
    }

    @Test
    public void testSubstring() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "f0.substring(2)", "SUBSTRING(f0, 2)", "his is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(5)), "f0.substring(2, 5)", "SUBSTRING(f0, 2, 5)", "his i");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f0.substring(1, f7)", "SUBSTRING(f0, 1, f7)", "Thi");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).substring((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).cast(Types$.MODULE$.BYTE()), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f0.substring(1.cast(BYTE), f7)", "SUBSTRING(f0, CAST(1 AS TINYINT), f7)", "Thi");
        this.testSqlApi("SUBSTRING(f0 FROM 2 FOR 1)", "h");
        this.testSqlApi("SUBSTRING(f0 FROM 2)", "his is a test String.");
    }

    @Test
    public void testReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(" "), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("_")), "f0.replace(' ', '_')", "REPLACE(f0, ' ', '_')", "This_is_a_test_String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("i"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "f0.replace('i', '')", "REPLACE(f0, 'i', '')", "Ths s a test Strng.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).replace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("i"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "f33.replace('i', '')", "REPLACE(f33, 'i', '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace((Expression)new Null(Types$.MODULE$.STRING()), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "f0.replace(Null(STRING), '')", "REPLACE(f0, NULLIF('', ''), '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).replace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(" "), (Expression)new Null(Types$.MODULE$.STRING())), "f0.replace(' ', Null(STRING))", "REPLACE(f0, ' ', NULLIF('', ''))", "null");
    }

    @Test
    public void testTrim() {
        ImplicitExpressionConversions.UnresolvedFieldExpression qual$1 = org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8"));
        boolean x$5 = qual$1.trim$default$1();
        boolean x$6 = qual$1.trim$default$2();
        Expression x$7 = qual$1.trim$default$3();
        this.testAllApis(qual$1.trim(x$5, x$6, x$7), "f8.trim()", "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).trim(true, true, org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(" ")), "trim(f8)", "TRIM(f8)", "This is a test String.");
        this.testAllApis(org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).trim(false, true, org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(" ")), "f8.trim(TRAILING, ' ')", "TRIM(TRAILING FROM f8)", " This is a test String.");
        this.testAllApis(org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).trim(true, true, org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(".")), "trim(BOTH, '.', f0)", "TRIM(BOTH '.' FROM f0)", "This is a test String");
    }

    @Test
    public void testCharLength() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).charLength(), "f0.charLength()", "CHAR_LENGTH(f0)", "22");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).charLength(), "charLength(f0)", "CHARACTER_LENGTH(f0)", "22");
    }

    @Test
    public void testUpperCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).upperCase(), "f0.upperCase()", "UPPER(f0)", "THIS IS A TEST STRING.");
    }

    @Test
    public void testLowerCase() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).lowerCase(), "f0.lowerCase()", "LOWER(f0)", "this is a test string.");
    }

    @Test
    public void testInitCap() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).initCap(), "f0.initCap()", "INITCAP(f0)", "This Is A Test String.");
    }

    @Test
    public void testConcat() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).$plus(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "f0 + f0", "f0||f0", "This is a test String.This is a test String.");
    }

    @Test
    public void testLike() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("Th_s%")), "f0.like('Th_s%')", "f0 LIKE 'Th_s%'", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("%is a%")), "f0.like('%is a%')", "f0 LIKE '%is a%'", "true");
    }

    @Test
    public void testNotLike() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("Th_s%"))).unary_$bang(), "!f0.like('Th_s%')", "f0 NOT LIKE 'Th_s%'", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).like(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("%is a%"))).unary_$bang(), "!f0.like('%is a%')", "f0 NOT LIKE '%is a%'", "false");
    }

    @Test
    public void testLikeWithEscape() {
        this.testSqlApi("f23 LIKE '&%Th_s%' ESCAPE '&'", "true");
        this.testSqlApi("f23 LIKE '&%%is a%' ESCAPE '&'", "true");
        this.testSqlApi("f0 LIKE 'Th_s%' ESCAPE '&'", "true");
        this.testSqlApi("f0 LIKE '%is a%' ESCAPE '&'", "true");
    }

    @Test
    public void testNotLikeWithEscape() {
        this.testSqlApi("f23 NOT LIKE '&%Th_s%' ESCAPE '&'", "false");
        this.testSqlApi("f23 NOT LIKE '&%%is a%' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT LIKE 'Th_s%' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT LIKE '%is a%' ESCAPE '&'", "false");
    }

    @Test
    public void testSimilar() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("_*")), "f0.similar('_*')", "f0 SIMILAR TO '_*'", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*")), "f0.similar('This (is)? a (test)+ Strin_*')", "f0 SIMILAR TO 'This (is)? a (test)+ Strin_*'", "true");
    }

    @Test
    public void testNotSimilar() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("_*"))).unary_$bang(), "!f0.similar('_*')", "f0 NOT SIMILAR TO '_*'", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).similar(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("This (is)? a (test)+ Strin_*"))).unary_$bang(), "!f0.similar('This (is)? a (test)+ Strin_*')", "f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*'", "false");
    }

    @Test
    public void testSimilarWithEscape() {
        this.testSqlApi("f24 SIMILAR TO '&*&__*' ESCAPE '&'", "true");
        this.testSqlApi("f0 SIMILAR TO '_*' ESCAPE '&'", "true");
        this.testSqlApi("f24 SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "true");
        this.testSqlApi("f0 SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "true");
    }

    @Test
    public void testNotSimilarWithEscape() {
        this.testSqlApi("f24 NOT SIMILAR TO '&*&__*' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT SIMILAR TO '_*' ESCAPE '&'", "false");
        this.testSqlApi("f24 NOT SIMILAR TO '&*&_This (is)? a (test)+ Strin_*' ESCAPE '&'", "false");
        this.testSqlApi("f0 NOT SIMILAR TO 'This (is)? a (test)+ Strin_*' ESCAPE '&'", "false");
    }

    @Test
    public void testMultiConcat() {
        this.testAllApis(concat$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xx"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))})), "concat('xx', f33)", "CONCAT('xx', f33)", "null");
        this.testAllApis(concat$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("CC"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("---")})), "concat('AA','BB','CC','---')", "CONCAT('AA','BB','CC','---')", "AABBCC---");
        this.testAllApis(concat$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("x~x"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("b~b"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("c~~~~c"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("---")})), "concat('x~x','b~b','c~~~~c','---')", "CONCAT('x~x','b~b','c~~~~c','---')", "x~xb~bc~~~~c---");
    }

    @Test
    public void testConcatWs() {
        this.testAllApis(concat_ws$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "concat_ws(f33, 'AA')", "CONCAT_WS(f33, 'AA')", "null");
        this.testAllApis(concat_ws$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "concat_ws('~~~~','AA')", "concat_ws('~~~~','AA')", "AA");
        this.testAllApis(concat_ws$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("AA"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("BB")})), "concat_ws('~','AA','BB')", "concat_ws('~','AA','BB')", "AA~BB");
        this.testAllApis(concat_ws$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("~"), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("AA"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("BB"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal(""), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("CC")})), "concat_ws('~',f33, 'AA','BB','',f33, 'CC')", "concat_ws('~',f33, 'AA','BB','',f33, 'CC')", "AA~BB~~CC");
        this.testAllApis(concat_ws$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("~~~~"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("Flink"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("xx"), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))})), "concat_ws('~~~~','Flink', f33, 'xx', f33, f33)", "CONCAT_WS('~~~~','Flink', f33, 'xx', f33, f33)", "Flink~~~~xx");
    }

    @Test
    public void testLPad() {
        this.testSqlApi("LPAD('hi',4,'??')", "??hi");
        this.testSqlApi("LPAD('hi',1,'??')", "h");
        this.testSqlApi("LPAD('',1,'??')", "?");
        this.testSqlApi("LPAD('',30,'??')", "??????????????????????????????");
        this.testSqlApi("LPAD('111',-2,'??')", "null");
        this.testSqlApi("LPAD(f33,1,'??')", "null");
        this.testSqlApi("LPAD('ab',1,'??')", "a");
        this.testSqlApi("LPAD('\u23a8\u23a8',1,'??')", "\u23a8");
        this.testSqlApi("LPAD('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',2,'??')", "\u00e4\u00e4");
        this.testSqlApi("LPAD('\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4',10,'??')", "?\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4");
        this.testSqlApi("LPAD('Hello', -1, 'x') IS NULL", "true");
        this.testSqlApi("LPAD('Hello', -1, 'x') IS NOT NULL", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").lpad(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(13), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("12345")), "'\u00e4\u00e4\u00e4'.lpad(13, '12345')", "LPAD('\u00e4\u00e4\u00e4',13,'12345')", "1234512345\u00e4\u00e4\u00e4");
    }

    @Test
    public void testRPad() {
        this.testSqlApi("RPAD('hi',4,'??')", "hi??");
        this.testSqlApi("RPAD('hi',1,'??')", "h");
        this.testSqlApi("RPAD('',1,'??')", "?");
        this.testSqlApi("RPAD('1',30,'??')", "1?????????????????????????????");
        this.testSqlApi("RPAD('111',-2,'??')", "null");
        this.testSqlApi("RPAD(f33,1,'??')", "null");
        this.testSqlApi("RPAD('ab',1,'??')", "a");
        this.testSqlApi("RPAD('\u00fc\u00f6',1,'??')", "\u00fc");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("\u00e4\u00e4\u00e4").rpad(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(13), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("12345")), "'\u00e4\u00e4\u00e4'.rpad(13, '12345')", "RPAD('\u00e4\u00e4\u00e4',13,'12345')", "\u00e4\u00e4\u00e41234512345");
    }

    @Test
    public void testHex() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(100).hex(), "100.hex()", "HEX(100)", "64");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).hex(), "f2.hex()", "HEX(f2)", "2A");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.BYTE())).hex(), "hex(Null(BYTE))", "HEX(CAST(NULL AS TINYINT))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).hex(), "f3.hex()", "HEX(f3)", "2B");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).hex(), "f4.hex()", "HEX(f4)", "2C");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).hex(), "f7.hex()", "HEX(f7)", "3");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(12).hex(), "12.hex()", "HEX(12)", "C");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).hex(), "10.hex()", "HEX(10)", "A");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).hex(), "0.hex()", "HEX(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("\u00f6").hex(), "'\u00f6'.hex()", "HEX('\u00f6')", "C3B6");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32")).hex(), "f32.hex()", "HEX(f32)", "FFFFFFFFFFFFFFFF");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).hex(), "f0.hex()", "HEX(f0)", "546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).hex(), "f8.hex()", "HEX(f8)", "20546869732069732061207465737420537472696E672E20");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f23")).hex(), "f23.hex()", "HEX(f23)", "25546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f24")).hex(), "f24.hex()", "HEX(f24)", "2A5F546869732069732061207465737420537472696E672E");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("\u4f60\u597d").hex(), "'\u4f60\u597d'.hex()", "HEX('\u4f60\u597d')", "E4BDA0E5A5BD");
    }

    @Test
    public void testBin() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.BYTE())).bin(), "bin(Null(BYTE))", "BIN((CAST(NULL AS TINYINT)))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).bin(), "f2.bin()", "BIN(f2)", "101010");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).bin(), "f3.bin()", "BIN(f3)", "101011");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).bin(), "f4.bin()", "BIN(f4)", "101100");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).bin(), "f7.bin()", "BIN(f7)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(12).bin(), "12.bin()", "BIN(12)", "1100");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).bin(), "10.bin()", "BIN(10)", "1010");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).bin(), "0.bin()", "BIN(0)", "0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32")).bin(), "f32.bin()", "BIN(f32)", "1111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testRegexpReplace() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo|ar"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("abc")), "'foobar'.regexpReplace('oo|ar', 'abc')", "regexp_replace('foobar', 'oo|ar', 'abc')", "fabcbabc");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foofar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("^f"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "'foofar'.regexpReplace('^f', '')", "regexp_replace('foofar', '^f', '')", "oofar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("^f*.*r$"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace('^f*.*r$', '')", "regexp_replace('foobar', '^f*.*r$', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foo1bar2").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("\\d"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "'foo1bar2'.regexpReplace('\\d', '')", "regexp_replace('foobar', '\\d', '')", "foobar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("\\w"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace('\\w', '')", "regexp_replace('foobar', '\\w', '')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("fooobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("$")), "'fooobar'.regexpReplace('oo', '$')", "regexp_replace('fooobar', 'oo', '$')", "f$obar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("\\")), "'foobar'.regexpReplace('oo', '\\')", "regexp_replace('foobar', 'oo', '\\')", "f\\bar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo|ar"), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "f33.regexpReplace('oo|ar', '')", "REGEXP_REPLACE(f33, 'oo|ar', '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("")), "'foobar'.regexpReplace(f33, '')", "REGEXP_REPLACE('foobar', f33, '')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foobar").regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo|ar"), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "'foobar'.regexpReplace('oo|ar', f33)", "REGEXP_REPLACE('foobar', 'oo|ar', f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.STRING())).regexpReplace(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("oo|ar"), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33"))), "Null(STRING).regexpReplace('oo|ar', f33)", "REGEXP_REPLACE(CAST(NULL AS VARCHAR), 'oo|ar', f33)", "null");
    }

    @Test
    public void testRegexpExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo(.*?)(bar)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 2)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo(.*?)(bar)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(0)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 0)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 0)", "foothebar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo(.*?)(bar)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo(.*?)(bar)', 1)", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 1)", "the");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo([\\w]+)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo([\\w]+)', 1)", "REGEXP_EXTRACT('foothebar', 'foo([\\w]+)', 1)", "thebar");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo([\\d]+)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "'foothebar'.regexpExtract('foo([\\d]+)', 1)", "REGEXP_EXTRACT('foothebar', 'foo([\\d]+)', 1)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo(.*?)(bar)"), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "f33.regexpExtract('foo(.*?)(bar)', 2)", "REGEXP_EXTRACT(f33, 'foo(.*?)(bar)', 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "'foothebar'.regexpExtract(f33, 2)", "REGEXP_EXTRACT('foothebar', f33, 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("foothebar").regexpExtract(org.apache.flink.table.api.scala.package$.MODULE$.string2Literal("foo(.*?)(bar)")), "'foothebar'.regexpExtract('foo(.*?)(bar)')", "REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)')", "foothebar");
    }

    @Test
    public void testFromBase64() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f35")).fromBase64(), "f35.fromBase64()", "from_base64(f35)", "hello world");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f35")).fromBase64(), "f35.fromBase64()", "FROM_BASE64(f35)", "hello world");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).fromBase64(), "f33.fromBase64()", "FROM_BASE64(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("5L2g5aW9").fromBase64(), "'5L2g5aW9'.fromBase64()", "FROM_BASE64('5L2g5aW9')", "\u4f60\u597d");
    }

    @Test
    public void testToBase64() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).toBase64(), "f0.toBase64()", "TO_BASE64(f0)", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).toBase64(), "f8.toBase64()", "TO_BASE64(f8)", "IFRoaXMgaXMgYSB0ZXN0IFN0cmluZy4g");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("").toBase64(), "''.toBase64()", "TO_BASE64('')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).toBase64(), "f33.toBase64()", "TO_BASE64(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("\u4f60\u597d").toBase64(), "'\u4f60\u597d'.toBase64()", "TO_BASE64('\u4f60\u597d')", "5L2g5aW9");
    }

    @Test
    public void testUUID() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(uuid$.MODULE$.apply()).charLength(), "uuid().charLength", "CHARACTER_LENGTH(UUID())", "36");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(uuid$.MODULE$.apply()).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(9), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "uuid().substring(9, 1)", "SUBSTRING(UUID(), 9, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(uuid$.MODULE$.apply()).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(14), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "uuid().substring(14, 1)", "SUBSTRING(UUID(), 14, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(uuid$.MODULE$.apply()).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(19), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "uuid().substring(19, 1)", "SUBSTRING(UUID(), 19, 1)", "-");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(uuid$.MODULE$.apply()).substring(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(24), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "uuid().substring(24, 1)", "SUBSTRING(UUID(), 24, 1)", "-");
    }

    @Test
    public void testLTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).ltrim(), "f8.ltrim", "LTRIM(f8)", "This is a test String. ");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).ltrim(), "f0.ltrim", "LTRIM(f0)", "This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("").ltrim(), "''.ltrim()", "LTRIM('')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).ltrim(), "f33.ltrim", "LTRIM(f33)", "null");
    }

    @Test
    public void testRTrim() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).rtrim(), "f8.rtrim", "RTRIM(f8)", " This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).rtrim(), "f0.rtrim", "RTRIM(f0)", "This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("").rtrim(), "''.rtrim()", "RTRIM('')", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).rtrim(), "f33.rtrim", "RTRIM(f33)", "null");
    }

    @Test
    public void testRepeat() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "f0.repeat(1)", "REPEAT(f0, 1)", "This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "f0.repeat(2)", "REPEAT(f0, 2)", "This is a test String.This is a test String.");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(0)), "f0.repeat(0)", "REPEAT(f0, 0)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(-1)), "f0.repeat(-1)", "REPEAT(f0, -1)", "");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(2)), "f33.repeat(2)", "REPEAT(f33, 2)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("").repeat(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "''.repeat(1)", "REPEAT('', 2)", "");
    }

    @Test
    public void testMod() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).mod(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f4.mod(f7)", "MOD(f4, f7)", "2");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).mod(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(3)), "mod(f4, 3)", "MOD(f4, 3)", "2");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).$percent(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(3)), "mod(44, 3)", "MOD(44, 3)", "2");
    }

    @Test
    public void testExp() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).exp(), "f2.exp()", "EXP(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).exp(), "f3.exp()", "EXP(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).exp(), "f4.exp()", "EXP(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).exp(), "f5.exp()", "EXP(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).exp(), "f6.exp()", "EXP(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).exp(), "exp(f7)", "EXP(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(3).exp(), "exp(3)", "EXP(3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(3.0))).toString());
    }

    @Test
    public void testLog10() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).log10(), "f2.log10()", "LOG10(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).log10(), "f3.log10()", "LOG10(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).log10(), "f4.log10()", "LOG10(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).log10(), "f5.log10()", "LOG10(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log10(), "f6.log10()", "LOG10(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log10(4.6))).toString());
    }

    @Test
    public void testLog2() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log2(), "f6.log2", "LOG2(f6)", "2.2016338611696504");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(100))).log2(), "(f6 - f6 + 100).log2()", "LOG2(f6 - f6 + 100)", "6.643856189774725");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$plus(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(20))).log2(), "(f6+20).log2", "LOG2(f6+20)", "4.620586410451877");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).log2(), "10.log2", "LOG2(10)", "3.3219280948873626");
    }

    @Test
    public void testPower() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2.power(f7)", "POWER(f2, f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)((byte)42), 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "f3.power(f6)", "POWER(f3, f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)((short)43), 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f4.power(f5)", "POWER(f4, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)44, (double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f4.power(f5)", "POWER(f4, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow((double)44, (double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f5.power(f5)", "power(f5, f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 4.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "f5.power(f6)", "power(f5, f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f5.power(f7)", "power(f5, f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "f5.power(f4)", "power(f5, f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5"))), "f22.cast(DOUBLE).power(f5)", "power(CAST(f22 AS DOUBLE), f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 4.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "f22.cast(DOUBLE).power(f6)", "power(CAST(f22 AS DOUBLE), f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f22.cast(DOUBLE).power(f7)", "power(CAST(f22 AS DOUBLE), f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())).power(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4"))), "f22.cast(DOUBLE).power(f4)", "power(CAST(f22 AS DOUBLE), f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(2.0, 44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).power((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())), "f6.power(f22.cast(DOUBLE))", "power(f6, f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.6, 2.0))).toString());
    }

    @Test
    public void testSqrt() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sqrt(), "f6.sqrt", "SQRT(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).sqrt(), "f7.sqrt", "SQRT(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sqrt(), "f4.sqrt", "SQRT(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cast(Types$.MODULE$.DOUBLE())).sqrt(), "f22.cast(DOUBLE).sqrt", "SQRT(CAST(f22 AS DOUBLE))", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(2.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).sqrt(), "f5.sqrt", "SQRT(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.pow(4.5, 0.5))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(25).sqrt(), "25.sqrt()", "SQRT(25)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralDoubleExpression(2.2).sqrt(), "2.2.sqrt()", "POWER(CAST(2.2 AS DOUBLE), CAST(0.5 AS DOUBLE))", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sqrt(2.2))).toString());
    }

    @Test
    public void testCosh() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).cosh(), "0.cosh()", "COSH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(-1).cosh(), "-1.cosh()", "COSH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cosh(), "f4.cosh", "COSH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cosh(), "f6.cosh", "COSH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).cosh(), "f7.cosh", "COSH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).cosh(), "f22.cosh", "COSH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cosh(2.0))).toString());
    }

    @Test
    public void testLn() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).ln(), "f2.ln()", "LN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).ln(), "f3.ln()", "LN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).ln(), "f4.ln()", "LN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).ln(), "f5.ln()", "LN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).ln(), "f6.ln()", "LN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.log(4.6))).toString());
    }

    @Test
    public void testAbs() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).abs(), "f2.abs()", "ABS(f2)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).abs(), "f3.abs()", "ABS(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).abs(), "f4.abs()", "ABS(f4)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).abs(), "f5.abs()", "ABS(f5)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).abs(), "f6.abs()", "ABS(f6)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).abs(), "f9.abs()", "ABS(f9)", "42");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).abs(), "f10.abs()", "ABS(f10)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).abs(), "f11.abs()", "ABS(f11)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f12")).abs(), "f12.abs()", "ABS(f12)", "4.5");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f13")).abs(), "f13.abs()", "ABS(f13)", "4.6");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).abs(), "f15.abs()", "ABS(f15)", "1231.1231231321321321111");
    }

    @Test
    public void testArithmeticFloorCeil() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).floor(), "f5.floor()", "FLOOR(f5)", "4.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).ceil(), "f5.ceil()", "CEIL(f5)", "5.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).floor(), "f3.floor()", "FLOOR(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).ceil(), "f3.ceil()", "CEIL(f3)", "43");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).floor(), "f15.floor()", "FLOOR(f15)", "-1232");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).ceil(), "f15.ceil()", "CEIL(f15)", "-1231");
    }

    @Test
    public void testSin() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).sin(), "f2.sin()", "SIN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).sin(), "f3.sin()", "SIN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sin(), "f4.sin()", "SIN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).sin(), "f5.sin()", "SIN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sin(), "f6.sin()", "SIN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).sin(), "sin(f15)", "SIN(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin(-1231.1231231321322))).toString());
    }

    @Test
    public void testCos() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cos(), "f2.cos()", "COS(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cos(), "f3.cos()", "COS(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cos(), "f4.cos()", "COS(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cos(), "f5.cos()", "COS(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cos(), "f6.cos()", "COS(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).cos(), "cos(f15)", "COS(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos(-1231.1231231321322))).toString());
    }

    @Test
    public void testSinh() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).sinh(), "0.sinh()", "SINH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(-1).sinh(), "-1.sinh()", "SINH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sinh(), "f4.sinh", "SINH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sinh(), "f6.sinh", "SINH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).sinh(), "f7.sinh", "SINH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).sinh(), "f22.sinh", "SINH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sinh(2.0))).toString());
    }

    @Test
    public void testTan() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).tan(), "f2.tan()", "TAN(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).tan(), "f3.tan()", "TAN(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).tan(), "f4.tan()", "TAN(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).tan(), "f5.tan()", "TAN(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).tan(), "f6.tan()", "TAN(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).tan(), "tan(f15)", "TAN(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tan(-1231.1231231321322))).toString());
    }

    @Test
    public void testTanh() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).tanh(), "0.tanh()", "TANH(0)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(0.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(-1).tanh(), "-1.tanh()", "TANH(-1)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(-1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).tanh(), "f4.tanh", "TANH(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(44.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).tanh(), "f6.tanh", "TANH(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")).tanh(), "f7.tanh", "TANH(f7)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(3.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f22")).tanh(), "f22.tanh", "TANH(f22)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.tanh(2.0))).toString());
    }

    @Test
    public void testCot() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cot(), "f2.cot()", "COT(f2)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((byte)42))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cot(), "f3.cot()", "COT(f3)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((short)43))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cot(), "f4.cot()", "COT(f4)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)44)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cot(), "f5.cot()", "COT(f5)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan((double)((float)4.5))))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).cot(), "f6.cot()", "COT(f6)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan(4.6)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).cot(), "cot(f15)", "COT(f15)", ((Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.tan(-1231.1231231321322)))).toString());
    }

    @Test
    public void testAsin() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).asin(), "f25.asin()", "ASIN(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).asin(), "f26.asin()", "ASIN(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).asin(), "f27.asin()", "ASIN(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).asin(), "f28.asin()", "ASIN(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).asin(), "f29.asin()", "ASIN(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).asin(), "f30.asin()", "ASIN(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).asin(), "f31.asin()", "ASIN(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.asin(-0.12312313213213211))).toString());
    }

    @Test
    public void testAcos() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).acos(), "f25.acos()", "ACOS(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).acos(), "f26.acos()", "ACOS(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).acos(), "f27.acos()", "ACOS(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).acos(), "f28.acos()", "ACOS(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).acos(), "f29.acos()", "ACOS(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).acos(), "f30.acos()", "ACOS(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).acos(), "f31.acos()", "ACOS(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.acos(-0.12312313213213211))).toString());
    }

    @Test
    public void testAtan() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")).atan(), "f25.atan()", "ATAN(f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((byte)0.42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")).atan(), "f26.atan()", "ATAN(f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((short)0)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")).atan(), "f27.atan()", "ATAN(f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")).atan(), "f28.atan()", "ATAN(f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan((double)((float)0.45)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).atan(), "f29.atan()", "ATAN(f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(0.46))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")).atan(), "f30.atan()", "ATAN(f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(1.0))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).atan(), "f31.atan()", "ATAN(f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan(-0.12312313213213211))).toString());
    }

    @Test
    public void testAtan2() {
        this.testAllApis(atan2$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26"))), "atan2(f25, f26)", "ATAN2(f25, f26)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((byte)0.42), (double)((byte)0)))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f26")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f25"))), "atan2(f26, f25)", "ATAN2(f26, f25)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((short)0), (double)((short)0)))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f27"))), "atan2(f27, f27)", "ATAN2(f27, f27)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)0, (double)0))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f28"))), "atan2(f28, f28)", "ATAN2(f28, f28)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2((double)((float)0.45), (double)((float)0.45)))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29"))), "atan2(f29, f29)", "ATAN2(f29, f29)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(0.46, 0.46))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "atan2(f30, f30)", "ATAN2(f30, f30)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(1.0, 1.0))).toString());
        this.testAllApis((Expression)new Atan2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")), org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31"))), "atan2(f31, f31)", "ATAN2(f31, f31)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(-0.12312313213213211, -0.12312313213213211))).toString());
    }

    @Test
    public void testDegrees() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).degrees(), "f2.degrees()", "DEGREES(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).degrees(), "f3.degrees()", "DEGREES(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).degrees(), "f4.degrees()", "DEGREES(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).degrees(), "f5.degrees()", "DEGREES(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).degrees(), "f6.degrees()", "DEGREES(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).degrees(), "degrees(f15)", "DEGREES(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toDegrees(-1231.1231231321322))).toString());
    }

    @Test
    public void testRadians() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).radians(), "f2.radians()", "RADIANS(f2)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((byte)42)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).radians(), "f3.radians()", "RADIANS(f3)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((short)43)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).radians(), "f4.radians()", "RADIANS(f4)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)44))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).radians(), "f5.radians()", "RADIANS(f5)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians((double)((float)4.5)))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).radians(), "f6.radians()", "RADIANS(f6)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians(4.6))).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).radians(), "radians(f15)", "RADIANS(f15)", ((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.toRadians(-1231.1231231321322))).toString());
    }

    @Test
    public void testSign() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).sign(), "f4.sign()", "SIGN(f4)", ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).sign(), "f6.sign()", "SIGN(f6)", ((Object)BoxesRunTime.boxToDouble((double)1.0)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f15")).sign(), "sign(f15)", "SIGN(f15)", ((Object)BoxesRunTime.boxToInteger((int)-1)).toString());
    }

    @Test
    public void testRound() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f29")).round(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f30"))), "f29.round(f30)", "ROUND(f29, f30)", ((Object)BoxesRunTime.boxToDouble((double)0.5)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f31")).round(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f31.round(f7)", "ROUND(f31, f7)", ((Object)BoxesRunTime.boxToDouble((double)-0.123)).toString());
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).round(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f32"))), "f4.round(f32)", "ROUND(f4, f32)", ((Object)BoxesRunTime.boxToInteger((int)40)).toString());
    }

    @Test
    public void testPi() {
        this.testAllApis(pi$.MODULE$.apply(), "pi()", "PI", ((Object)BoxesRunTime.boxToDouble((double)Math.PI)).toString());
    }

    @Test
    public void testRandAndRandInteger() {
        Random random1 = new Random(1L);
        this.testAllApis(rand$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1)), "rand(1)", "RAND(1)", ((Object)BoxesRunTime.boxToDouble((double)random1.nextDouble())).toString());
        Random random2 = new Random(3L);
        this.testAllApis(rand$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "rand(f7)", "RAND(f7)", ((Object)BoxesRunTime.boxToDouble((double)random2.nextDouble())).toString());
        Random random3 = new Random(1L);
        this.testAllApis(randInteger$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(1), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(10)), "randInteger(1, 10)", "RAND_INTEGER(1, 10)", ((Object)BoxesRunTime.boxToInteger((int)random3.nextInt(10))).toString());
        Random random4 = new Random(3L);
        this.testAllApis(randInteger$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7")), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cast(Types$.MODULE$.INT())), "randInteger(f7, f4.cast(INT))", "RAND_INTEGER(f7, CAST(f4 AS INT))", ((Object)BoxesRunTime.boxToInteger((int)random4.nextInt(44))).toString());
    }

    @Test
    public void testE() {
        this.testAllApis(e$.MODULE$.apply(), "E()", "E()", ((Object)BoxesRunTime.boxToDouble((double)Math.E)).toString());
        this.testAllApis(e$.MODULE$.apply(), "e()", "e()", ((Object)BoxesRunTime.boxToDouble((double)Math.E)).toString());
    }

    @Test
    public void testLog() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).log(), "f6.log", "LOG(f6)", "1.5260563034950492");
        this.testTableApi((Expression)Log$.MODULE$.apply(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6"))), "Log(f6)", "1.5260563034950492");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(100))).log((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$minus(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")))).$plus(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(10))), "(f6 - f6 + 100).log(f6 - f6 + 10)", "LOG(f6 - f6 + 10, f6 - f6 + 100)", "2.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$plus(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(20))).log(), "(f6+20).log", "LOG(f6+20)", "3.202746442938317");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).log(), "10.log", "LOG(10)", "2.302585092994046");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(100).log(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(10)), "100.log(10)", "LOG(10, 100)", "2.0");
        this.testTableApi((Expression)new Log(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(10), org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(100)), "Log(10, 100)", "2.0");
    }

    @Test
    public void testExtract() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.YEAR()), "f16.extract(YEAR)", "EXTRACT(YEAR FROM f16)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.QUARTER()), "f16.extract(QUARTER)", "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.MONTH()), "extract(f16, MONTH)", "EXTRACT(MONTH FROM f16)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.WEEK()), "extract(f16, WEEK)", "EXTRACT(WEEK FROM f16)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.DAY()), "f16.extract(DAY)", "EXTRACT(DAY FROM f16)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.YEAR()), "f18.extract(YEAR)", "EXTRACT(YEAR FROM f18)", "1996");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.QUARTER()), "f18.extract(QUARTER)", "EXTRACT(QUARTER FROM f18)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).extract(TimeIntervalUnit$.MODULE$.QUARTER()), "f16.extract(QUARTER)", "EXTRACT(QUARTER FROM f16)", "4");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.MONTH()), "f18.extract(MONTH)", "EXTRACT(MONTH FROM f18)", "11");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.WEEK()), "f18.extract(WEEK)", "EXTRACT(WEEK FROM f18)", "45");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.DAY()), "f18.extract(DAY)", "EXTRACT(DAY FROM f18)", "10");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.HOUR()), "f18.extract(HOUR)", "EXTRACT(HOUR FROM f18)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit$.MODULE$.HOUR()), "f17.extract(HOUR)", "EXTRACT(HOUR FROM f17)", "6");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.MINUTE()), "f18.extract(MINUTE)", "EXTRACT(MINUTE FROM f18)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit$.MODULE$.MINUTE()), "f17.extract(MINUTE)", "EXTRACT(MINUTE FROM f17)", "55");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).extract(TimeIntervalUnit$.MODULE$.SECOND()), "f18.extract(SECOND)", "EXTRACT(SECOND FROM f18)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).extract(TimeIntervalUnit$.MODULE$.SECOND()), "f17.extract(SECOND)", "EXTRACT(SECOND FROM f17)", "44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit$.MODULE$.DAY()), "f19.extract(DAY)", "EXTRACT(DAY FROM f19)", "16979");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit$.MODULE$.HOUR()), "f19.extract(HOUR)", "EXTRACT(HOUR FROM f19)", "7");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit$.MODULE$.MINUTE()), "f19.extract(MINUTE)", "EXTRACT(MINUTE FROM f19)", "23");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f19")).extract(TimeIntervalUnit$.MODULE$.SECOND()), "f19.extract(SECOND)", "EXTRACT(SECOND FROM f19)", "33");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit$.MODULE$.MONTH()), "f20.extract(MONTH)", "EXTRACT(MONTH FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit$.MODULE$.QUARTER()), "f20.extract(QUARTER)", "EXTRACT(QUARTER FROM f20)", "1");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f20")).extract(TimeIntervalUnit$.MODULE$.YEAR()), "f20.extract(YEAR)", "EXTRACT(YEAR FROM f20)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f18)", "2");
        this.testSqlApi("EXTRACT(MILLENNIUM FROM f16)", "2");
        this.testSqlApi("EXTRACT(CENTURY FROM f18)", "20");
        this.testSqlApi("EXTRACT(CENTURY FROM f16)", "20");
        this.testSqlApi("EXTRACT(DOY FROM f18)", "315");
        this.testSqlApi("EXTRACT(DOY FROM f16)", "315");
        this.testSqlApi("EXTRACT(DOW FROM f18)", "1");
        this.testSqlApi("EXTRACT(DOW FROM f16)", "1");
        this.testSqlApi("EXTRACT(WEEK FROM f18)", "45");
        this.testSqlApi("EXTRACT(WEEK FROM f16)", "45");
        this.testSqlApi("YEAR(f18)", "1996");
        this.testSqlApi("YEAR(f16)", "1996");
        this.testSqlApi("QUARTER(f18)", "4");
        this.testSqlApi("QUARTER(f16)", "4");
        this.testSqlApi("MONTH(f18)", "11");
        this.testSqlApi("MONTH(f16)", "11");
        this.testSqlApi("WEEK(f18)", "45");
        this.testSqlApi("WEEK(f16)", "45");
        this.testSqlApi("DAYOFYEAR(f18)", "315");
        this.testSqlApi("DAYOFYEAR(f16)", "315");
        this.testSqlApi("DAYOFMONTH(f18)", "10");
        this.testSqlApi("DAYOFMONTH(f16)", "10");
        this.testSqlApi("DAYOFWEEK(f18)", "1");
        this.testSqlApi("DAYOFWEEK(f16)", "1");
        this.testSqlApi("HOUR(f17)", "6");
        this.testSqlApi("HOUR(f19)", "7");
        this.testSqlApi("MINUTE(f17)", "55");
        this.testSqlApi("MINUTE(f19)", "23");
        this.testSqlApi("SECOND(f17)", "44");
        this.testSqlApi("SECOND(f19)", "33");
    }

    @Test
    public void testTemporalFloor() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit$.MODULE$.YEAR()), "f18.floor(YEAR)", "FLOOR(f18 TO YEAR)", "1996-01-01 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit$.MODULE$.MONTH()), "f18.floor(MONTH)", "FLOOR(f18 TO MONTH)", "1996-11-01 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit$.MODULE$.DAY()), "f18.floor(DAY)", "FLOOR(f18 TO DAY)", "1996-11-10 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit$.MODULE$.MINUTE()), "f18.floor(MINUTE)", "FLOOR(f18 TO MINUTE)", "1996-11-10 06:55:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).floor(TimeIntervalUnit$.MODULE$.SECOND()), "f18.floor(SECOND)", "FLOOR(f18 TO SECOND)", "1996-11-10 06:55:44.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit$.MODULE$.HOUR()), "f17.floor(HOUR)", "FLOOR(f17 TO HOUR)", "06:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit$.MODULE$.MINUTE()), "f17.floor(MINUTE)", "FLOOR(f17 TO MINUTE)", "06:55:00");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).floor(TimeIntervalUnit$.MODULE$.SECOND()), "f17.floor(SECOND)", "FLOOR(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).floor(TimeIntervalUnit$.MODULE$.YEAR()), "f16.floor(YEAR)", "FLOOR(f16 TO YEAR)", "1996-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).floor(TimeIntervalUnit$.MODULE$.MONTH()), "f16.floor(MONTH)", "FLOOR(f16 TO MONTH)", "1996-11-01");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit$.MODULE$.YEAR()), "f18.ceil(YEAR)", "CEIL(f18 TO YEAR)", "1997-01-01 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit$.MODULE$.MONTH()), "f18.ceil(MONTH)", "CEIL(f18 TO MONTH)", "1996-12-01 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit$.MODULE$.DAY()), "f18.ceil(DAY)", "CEIL(f18 TO DAY)", "1996-11-11 00:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit$.MODULE$.MINUTE()), "f18.ceil(MINUTE)", "CEIL(f18 TO MINUTE)", "1996-11-10 06:56:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f18")).ceil(TimeIntervalUnit$.MODULE$.SECOND()), "f18.ceil(SECOND)", "CEIL(f18 TO SECOND)", "1996-11-10 06:55:45.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit$.MODULE$.HOUR()), "f17.ceil(HOUR)", "CEIL(f17 TO HOUR)", "07:00:00");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit$.MODULE$.MINUTE()), "f17.ceil(MINUTE)", "CEIL(f17 TO MINUTE)", "06:56:00");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f17")).ceil(TimeIntervalUnit$.MODULE$.SECOND()), "f17.ceil(SECOND)", "CEIL(f17 TO SECOND)", "06:55:44");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).ceil(TimeIntervalUnit$.MODULE$.YEAR()), "f16.ceil(YEAR)", "CEIL(f16 TO YEAR)", "1996-01-01");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f16")).ceil(TimeIntervalUnit$.MODULE$.MONTH()), "f16.ceil(MONTH)", "CEIL(f16 TO MONTH)", "1996-11-01");
    }

    @Test
    public void testCurrentTimePoint() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(currentDate$.MODULE$.apply()).cast(Types$.MODULE$.STRING())).charLength()).$greater$eq(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(5)), "currentDate().cast(STRING).charLength() >= 5", "CHAR_LENGTH(CAST(CURRENT_DATE AS VARCHAR)) >= 5", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(currentTime$.MODULE$.apply()).cast(Types$.MODULE$.STRING())).charLength()).$greater$eq(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(5)), "currentTime().cast(STRING).charLength() >= 5", "CHAR_LENGTH(CAST(CURRENT_TIME AS VARCHAR)) >= 5", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(currentTimestamp$.MODULE$.apply()).cast(Types$.MODULE$.STRING())).charLength()).$greater$eq(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(12)), "currentTimestamp().cast(STRING).charLength() >= 12", "CHAR_LENGTH(CAST(CURRENT_TIMESTAMP AS VARCHAR)) >= 12", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(localTimestamp$.MODULE$.apply()).cast(Types$.MODULE$.STRING())).charLength()).$greater$eq(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(12)), "localTimestamp().cast(STRING).charLength() >= 12", "CHAR_LENGTH(CAST(LOCALTIMESTAMP AS VARCHAR)) >= 12", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(localTime$.MODULE$.apply()).cast(Types$.MODULE$.STRING())).charLength()).$greater$eq(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(5)), "localTime().cast(STRING).charLength() >= 5", "CHAR_LENGTH(CAST(LOCALTIME AS VARCHAR)) >= 5", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations(localTimestamp$.MODULE$.apply()).$eq$eq$eq(localTimestamp$.MODULE$.apply()), "localTimestamp() === localTimestamp()", "LOCALTIMESTAMP = LOCALTIMESTAMP", "true");
    }

    @Test
    public void testOverlaps() {
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2:55:00").toTime(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).hour(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("3:30:00").toTime(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(2).hours()), "temporalOverlaps('2:55:00'.toTime, 1.hour, '3:30:00'.toTime, 2.hours)", "(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "true");
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("9:30:00").toTime(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("9:29:00").toTime(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("9:31:00").toTime()), "temporalOverlaps(toTime('9:00:00'), '9:30:00'.toTime, '9:29:00'.toTime, '9:31:00'.toTime)", "(TIME '9:00:00', TIME '9:30:00') OVERLAPS (TIME '9:29:00', TIME '9:31:00')", "true");
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("9:00:00").toTime(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("10:00:00").toTime(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("10:15:00").toTime(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(3).hours()), "temporalOverlaps('9:00:00'.toTime, '10:00:00'.toTime, '10:15:00'.toTime, 3.hours)", "(TIME '9:00:00', TIME '10:00:00') OVERLAPS (TIME '10:15:00', INTERVAL '3' HOUR)", "false");
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10").toDate(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).days(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-19").toDate(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(10).days()), "temporalOverlaps(toDate('2011-03-10'), 10.days, '2011-03-19'.toDate, 10.days)", "(DATE '2011-03-10', INTERVAL '10' DAY) OVERLAPS (DATE '2011-03-19', INTERVAL '10' DAY)", "true");
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:02").toTimestamp(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 05:02:01").toTimestamp()), "temporalOverlaps(toTimestamp('2011-03-10 05:02:02'), 0.milli, '2011-03-10 05:02:02'.toTimestamp, '2011-03-10 05:02:01'.toTimestamp)", "(TIMESTAMP '2011-03-10 05:02:02', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 05:02:02', TIMESTAMP '2011-03-10 05:02:01')", "true");
        this.testAllApis(temporalOverlaps$.MODULE$.apply((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.001").toTimestamp(), org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(0).milli(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2011-03-10 02:02:02.002").toTimestamp()), "temporalOverlaps('2011-03-10 02:02:02.001'.toTimestamp, 0.milli, '2011-03-10 02:02:02.002'.toTimestamp, '2011-03-10 02:02:02.002'.toTimestamp)", "(TIMESTAMP '2011-03-10 02:02:02.001', INTERVAL '0' SECOND) OVERLAPS (TIMESTAMP '2011-03-10 02:02:02.002', TIMESTAMP '2011-03-10 02:02:02.002')", "false");
    }

    @Test
    public void testTimestampDiff() {
        Map dataMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"DAY", (Object)TimePointUnit$.MODULE$.DAY(), (Object)"SQL_TSI_DAY")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"1"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"3"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"3")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"HOUR", (Object)TimePointUnit$.MODULE$.HOUR(), (Object)"SQL_TSI_HOUR")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-04 12:12:11", (Object)"25"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"35"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"85"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-12", (Object)"-72")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MINUTE", (Object)TimePointUnit$.MODULE$.MINUTE(), (Object)"SQL_TSI_MINUTE")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 12:10:11", (Object)"59"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"2111"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"5100"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"4320")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"SECOND", (Object)TimePointUnit$.MODULE$.SECOND(), (Object)"SQL_TSI_SECOND")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"61"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-16 11:11:11", (Object)"126671"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2016-06-19", (Object)"306000"), new Tuple3((Object)"2016-06-15", (Object)"2016-06-18", (Object)"259200")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"WEEK", (Object)TimePointUnit$.MODULE$.WEEK(), (Object)"SQL_TSI_WEEK")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-05-03 11:11:11", (Object)"2018-07-03 11:12:12", (Object)"8"), new Tuple3((Object)"2016-04-15", (Object)"2016-07-16 11:11:11", (Object)"13"), new Tuple3((Object)"2016-04-15 11:00:00", (Object)"2016-09-19", (Object)"22"), new Tuple3((Object)"2016-08-15", (Object)"2016-06-18", (Object)"-8")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"MONTH", (Object)TimePointUnit$.MODULE$.MONTH(), (Object)"SQL_TSI_MONTH")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-07-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"24"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"23"), new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"21")}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"QUARTER", (Object)TimePointUnit$.MODULE$.QUARTER(), (Object)"SQL_TSI_QUARTER")), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"2018-01-03 11:11:11", (Object)"2018-09-05 11:11:11", (Object)"2"), new Tuple3((Object)"2016-06-15", (Object)"2018-06-16 11:11:11", (Object)"8"), new Tuple3((Object)"2016-06-15 11:00:00", (Object)"2018-05-19", (Object)"7"), new Tuple3((Object)"2016-06-15", (Object)"2018-03-18", (Object)"7")})))}));
        dataMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampDiff$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ScalarFunctionsTest.$anonfun$testTimestampDiff$2(this, x$2);
            return BoxedUnit.UNIT;
        });
        this.testAllApis(timestampDiff$.MODULE$.apply(TimePointUnit$.MODULE$.DAY(), (Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP()), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()), "timestampDiff(DAY, Null(SQL_TIMESTAMP), '2016-02-24 12:42:25'.toTimestamp)", "TIMESTAMPDIFF(DAY, CAST(NULL AS TIMESTAMP), TIMESTAMP '2016-02-24 12:42:25')", "null");
        this.testAllApis(timestampDiff$.MODULE$.apply(TimePointUnit$.MODULE$.DAY(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp(), (Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP())), "timestampDiff(DAY, '2016-02-24 12:42:25'.toTimestamp,  Null(SQL_TIMESTAMP))", "TIMESTAMPDIFF(DAY, TIMESTAMP '2016-02-24 12:42:25',  CAST(NULL AS TIMESTAMP))", "null");
    }

    @Test
    public void testTimestampAdd() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-61), (Object)"2017-11-29 22:58:58.998"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1000), (Object)"2017-11-29 22:58:58.998")}));
        Seq YEAR = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-11-29 22:58:58.998", "2020-11-29 22:58:58.998", "2016-11-29 22:58:58.998", "1956-11-29 22:58:58.998", "1017-11-29 22:58:58.998"}));
        Seq QUARTER = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2018-03-01 22:58:58.998", "2018-08-31 22:58:58.998", "2017-08-29 22:58:58.998", "2002-08-29 22:58:58.998", "1767-11-29 22:58:58.998"}));
        Seq MONTH = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-12-29 22:58:58.998", "2018-03-01 22:58:58.998", "2017-10-29 22:58:58.998", "2012-10-29 22:58:58.998", "1934-07-29 22:58:58.998"}));
        Seq WEEK = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-12-06 22:58:58.998", "2017-12-20 22:58:58.998", "2017-11-22 22:58:58.998", "2016-09-28 22:58:58.998", "1998-09-30 22:58:58.998"}));
        Seq DAY = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-30 22:58:58.998", "2017-12-02 22:58:58.998", "2017-11-28 22:58:58.998", "2017-09-29 22:58:58.998", "2015-03-05 22:58:58.998"}));
        Seq HOUR = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 23:58:58.998", "2017-11-30 01:58:58.998", "2017-11-29 21:58:58.998", "2017-11-27 09:58:58.998", "2017-10-19 06:58:58.998"}));
        Seq MINUTE = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 22:59:58.998", "2017-11-29 23:01:58.998", "2017-11-29 22:57:58.998", "2017-11-29 21:57:58.998", "2017-11-29 06:18:58.998"}));
        Seq SECOND = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2017-11-29 22:58:59.998", "2017-11-29 22:59:01.998", "2017-11-29 22:58:57.998", "2017-11-29 22:57:57.998", "2017-11-29 22:42:18.998"}));
        Map intervalMapResults = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_YEAR"), (Object)YEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_QUARTER"), (Object)QUARTER), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MONTH"), (Object)MONTH), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_WEEK"), (Object)WEEK), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_DAY"), (Object)DAY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_HOUR"), (Object)HOUR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_MINUTE"), (Object)MINUTE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SECOND"), (Object)SECOND), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SQL_TSI_SECOND"), (Object)SECOND)}));
        intervalMapResults.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampAdd$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ScalarFunctionsTest.$anonfun$testTimestampAdd$2(this, data, x$4);
            return BoxedUnit.UNIT;
        });
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-02-24 12:42:25").toTimestamp()).$plus((Expression)new Null(Types$.MODULE$.INTERVAL_MILLIS())), "'2016-02-24 12:42:25'.toTimestamp + Null(INTERVAL_MILLIS)", "TIMESTAMPADD(HOUR, CAST(NULL AS INTEGER), TIMESTAMP '2016-02-24 12:42:25')", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP())).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(-200).hours()), "Null(SQL_TIMESTAMP) + -200.hours", "TIMESTAMPADD(HOUR, -200, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP())).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(3).months()), "Null(SQL_TIMESTAMP) + 3.months", "TIMESTAMPADD(MONTH, 3, CAST(NULL AS TIMESTAMP))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-06-15'.toDate + 1.month", "timestampadd(MONTH, 1, date '2016-06-15')", "2016-07-15");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toDate()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).day()), "'2016-06-15'.toDate + 1.day", "timestampadd(DAY, 1, date '2016-06-15')", "2016-06-16");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).hour()), "'2016-06-15'.toTimestamp - 1.hour", "timestampadd(HOUR, -1, date '2016-06-15')", "2016-06-14 23:00:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).minute()), "'2016-06-15'.toTimestamp + 1.minute", "timestampadd(MINUTE, 1, date '2016-06-15')", "2016-06-15 00:01:00.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$minus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()), "'2016-06-15'.toTimestamp - 1.second", "timestampadd(SQL_TSI_SECOND, -1, date '2016-06-15')", "2016-06-14 23:59:59.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-06-15").toTimestamp()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()), "'2016-06-15'.toTimestamp + 1.second", "timestampadd(SECOND, 1, date '2016-06-15')", "2016-06-15 00:00:01.0");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP())).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).second()), "Null(SQL_TIMESTAMP) + 1.second", "timestampadd(SECOND, 1, cast(null as date))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.SQL_TIMESTAMP())).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).day()), "Null(SQL_TIMESTAMP) + 1.day", "timestampadd(DAY, 1, cast(null as date))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-05-31").toDate()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-05-31'.toDate + 1.month", "timestampadd(MONTH, 1, date '2016-05-31')", "2016-06-30");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-01-31").toDate()).$plus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(5).month()), "'2016-01-31'.toDate + 5.month", "timestampadd(MONTH, 5, date '2016-01-31')", "2016-06-30");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("2016-03-31").toDate()).$minus(org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(1).month()), "'2016-03-31'.toDate - 1.month", "timestampadd(MONTH, -1, date '2016-03-31')", "2016-02-29");
    }

    @Test
    public void testHashFunctions() {
        String expectedMd5 = "098f6bcd4621d373cade4e832627b4f6";
        String expectedSha1 = "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3";
        String expectedSha224 = "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809";
        String expectedSha256 = "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08";
        String expectedSha384 = "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9";
        String expectedSha512 = "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff";
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").md5(), "md5('test')", "MD5('test')", expectedMd5);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha1(), "sha1('test')", "SHA1('test')", expectedSha1);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha224(), "sha224('test')", "SHA224('test')", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(224)), "sha2('test', 224)", "SHA2('test', 224)", expectedSha224);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha256(), "sha256('test')", "SHA256('test')", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(256)), "sha2('test', 256)", "SHA2('test', 256)", expectedSha256);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha384(), "sha384('test')", "SHA384('test')", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(384)), "sha2('test', 384)", "SHA2('test', 384)", expectedSha384);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha512(), "sha512('test')", "SHA512('test')", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(512)), "sha2('test', 512)", "SHA2('test', 512)", expectedSha512);
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).md5(), "md5(f33)", "MD5(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha1(), "sha1(f33)", "SHA1(f33)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha224(), "sha224(f33)", "SHA2(f33, 224)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha2(org.apache.flink.table.api.scala.package$.MODULE$.int2Literal(224)), "sha2(f33, 224)", "SHA2(f33, 224)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha256(), "sha256(f33)", "SHA2(f33, 256)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha384(), "sha384(f33)", "SHA2(f33, 384)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f33")).sha512(), "sha512(f33)", "SHA2(f33, 512)", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2((Expression)new Null(Types$.MODULE$.INT())), "sha2('test', Null(INT))", "SHA2('test', CAST(NULL AS INT))", "null");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression("test").sha2(org.apache.flink.table.api.scala.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f34"))), "sha2('test', f34)", "SHA2('test', f34)", expectedSha256);
    }

    @Test
    public void testIsTrueIsFalse() {
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).isTrue(), "f1.isTrue", "f1 IS TRUE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isTrue(), "f21.isTrue", "f21 IS TRUE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralBooleanExpression(false).isFalse(), "false.isFalse", "FALSE IS FALSE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isFalse(), "f21.isFalse", "f21 IS FALSE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).isNotTrue(), "f1.isNotTrue", "f1 IS NOT TRUE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isNotTrue(), "f21.isNotTrue", "f21 IS NOT TRUE", "true");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralBooleanExpression(false).isNotFalse(), "false.isNotFalse", "FALSE IS NOT FALSE", "false");
        this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f21")).isNotFalse(), "f21.isNotFalse", "f21 IS NOT FALSE", "true");
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampDiff$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampDiff$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testTimestampDiff$4(ScalarFunctionsTest $this, Tuple3 unitParts$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int index;
            Tuple3 data = (Tuple3)tuple2._1();
            int n = index = tuple2._2$mcI$sp();
            switch (n) {
                case 0: {
                    $this.testAllApis(timestampDiff$.MODULE$.apply((TableSymbols.TableSymbolValue)unitParts$1._2(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringBuilder(47).append("timestampDiff(").append(unitParts$1._1()).append(", '").append(data._1()).append("'.toTimestamp, '").append(data._2()).append("'.toTimestamp)").toString(), new StringBuilder(43).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", TIMESTAMP '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(43).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", TIMESTAMP '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    $this.testAllApis(timestampDiff$.MODULE$.apply((TableSymbols.TableSymbolValue)unitParts$1._2(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._2()).toTimestamp()), new StringBuilder(42).append("timestampDiff(").append(unitParts$1._1()).append(", '").append(data._1()).append("'.toDate, '").append(data._2()).append("'.toTimestamp)").toString(), new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", DATE '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", DATE '").append(data._1()).append("', TIMESTAMP '").append(data._2()).append("')").toString(), (String)data._3());
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 2: {
                    $this.testAllApis(timestampDiff$.MODULE$.apply((TableSymbols.TableSymbolValue)unitParts$1._2(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._1()).toTimestamp(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringBuilder(42).append("timestampDiff(").append(unitParts$1._1()).append(", '").append(data._1()).append("'.toTimestamp, '").append(data._2()).append("'.toDate)").toString(), new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", TIMESTAMP '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(38).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", TIMESTAMP '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 3: {
                    $this.testAllApis(timestampDiff$.MODULE$.apply((TableSymbols.TableSymbolValue)unitParts$1._2(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._1()).toDate(), (Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression((String)data._2()).toDate()), new StringBuilder(37).append("timestampDiff(").append(unitParts$1._1()).append(", '").append(data._1()).append("'.toDate, '").append(data._2()).append("'.toDate)").toString(), new StringBuilder(33).append("TIMESTAMPDIFF(").append(unitParts$1._1()).append(", DATE '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    $this.testSqlApi(new StringBuilder(33).append("TIMESTAMPDIFF(").append(unitParts$1._3()).append(", DATE '").append(data._1()).append("', DATE '").append(data._2()).append("')").toString(), (String)data._3());
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$testTimestampDiff$2(ScalarFunctionsTest $this, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple3 unitParts = (Tuple3)tuple2._1();
        Seq dataParts = (Seq)tuple2._2();
        ((TraversableLike)dataParts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalarFunctionsTest.$anonfun$testTimestampDiff$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ScalarFunctionsTest.$anonfun$testTimestampDiff$4($this, unitParts, x$1);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Tuple2 intervalCount$1(String interval, int count) {
        Tuple2 tuple2;
        String string = interval;
        if ("YEAR".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringBuilder(6).append(count).append(".years").toString());
        } else if ("SQL_TSI_YEAR".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).years(), (Object)new StringBuilder(6).append(count).append(".years").toString());
        } else if ("QUARTER".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringBuilder(9).append(count).append(".quarters").toString());
        } else if ("SQL_TSI_QUARTER".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).quarters(), (Object)new StringBuilder(9).append(count).append(".quarters").toString());
        } else if ("MONTH".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringBuilder(7).append(count).append(".months").toString());
        } else if ("SQL_TSI_MONTH".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).months(), (Object)new StringBuilder(7).append(count).append(".months").toString());
        } else if ("WEEK".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringBuilder(6).append(count).append(".weeks").toString());
        } else if ("SQL_TSI_WEEK".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).weeks(), (Object)new StringBuilder(6).append(count).append(".weeks").toString());
        } else if ("DAY".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringBuilder(5).append(count).append(".days").toString());
        } else if ("SQL_TSI_DAY".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).days(), (Object)new StringBuilder(5).append(count).append(".days").toString());
        } else if ("HOUR".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringBuilder(6).append(count).append(".hours").toString());
        } else if ("SQL_TSI_HOUR".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).hours(), (Object)new StringBuilder(6).append(count).append(".hours").toString());
        } else if ("MINUTE".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringBuilder(8).append(count).append(".minutes").toString());
        } else if ("SQL_TSI_MINUTE".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).minutes(), (Object)new StringBuilder(8).append(count).append(".minutes").toString());
        } else if ("SECOND".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringBuilder(8).append(count).append(".seconds").toString());
        } else if ("SQL_TSI_SECOND".equals(string)) {
            tuple2 = new Tuple2((Object)org.apache.flink.table.api.scala.package$.MODULE$.LiteralIntExpression(count).seconds(), (Object)new StringBuilder(8).append(count).append(".seconds").toString());
        } else {
            throw new MatchError((Object)string);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$testTimestampAdd$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testTimestampAdd$2(ScalarFunctionsTest $this, Seq data$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String interval = (String)tuple2._1();
        Seq result = (Seq)tuple2._2();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Tuple2 tuple2 = (Tuple2)data$1.apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int offset = tuple2._1$mcI$sp();
            String ts = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)offset), (Object)ts);
            Tuple2 tuple23 = tuple22;
            int offset2 = tuple23._1$mcI$sp();
            String ts2 = (String)tuple23._2();
            Tuple2 timeInterval = ScalarFunctionsTest.intervalCount$1(interval, offset2);
            $this.testAllApis((Expression)org.apache.flink.table.api.scala.package$.MODULE$.WithOperations((Expression)timeInterval._1()).$plus((Expression)org.apache.flink.table.api.scala.package$.MODULE$.LiteralStringExpression(ts2).toTimestamp()), new StringBuilder(17).append(timeInterval._2()).append(" + '").append(ts2).append("'.toTimestamp").toString(), new StringBuilder(30).append("TIMESTAMPADD(").append(interval).append(", ").append(offset2).append(", TIMESTAMP '").append(ts2).append("')").toString(), (String)result.apply(i));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

