/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.sql.Date;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.map$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Null;
import org.apache.flink.table.expressions.utils.MapTypeTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u001b\tYQ*\u00199UsB,G+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0002\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"aD'baRK\b/\u001a+fgR\u0014\u0015m]3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0004;fgRl\u0015\r\u001d'ji\u0016\u0014\u0018\r\u001c\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5uQ\tI2\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u0015\u0005)!.\u001e8ji&\u0011\u0001&\n\u0002\u0005)\u0016\u001cH\u000fC\u0003+\u0001\u0011\u00051$\u0001\u0007uKN$X*\u00199GS\u0016dG\r\u000b\u0002*G!)Q\u0006\u0001C\u00017\u0005\tB/Z:u\u001b\u0006\u0004x\n]3sCRLwN\\:)\u00051\u001a\u0003\"\u0002\u0019\u0001\t\u0003Y\u0012A\u0005;fgRl\u0015\r\u001d+za\u0016\u001c\u0015m\u001d;j]\u001eD#aL\u0012")
public class MapTypeTest
extends MapTypeTestBase {
    @Test
    public void testMapLiteral() {
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1, 1)", "MAP[1, 1]", "{1=1}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.boolean2Literal(true), package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(true, true)", "map[TRUE, TRUE]", "{true=true}");
        this.testTableApi(map$.MODULE$.apply(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1p, 1p)", "{1=1}");
        this.testAllApis(map$.MODULE$.apply(map$.MODULE$.apply(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), map$.MODULE$.apply(package$.MODULE$.int2Literal(3), package$.MODULE$.int2Literal(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(map(1, 2), map(3, 4))", "MAP[MAP[1, 2], MAP[3, 4]]", "{{1=2}={3=4}}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.int2Literal(3), package$.MODULE$.int2Literal(9), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(2)})), "map(1 + 2, 3 * 3, 6 / 3, 4 - 2)", "map[1 + 2, 3 * 3, 6 / 3, 4 - 2]", "{2=2, 3=9}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.int2Literal(1), (Expression)new Null(Types$.MODULE$.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1, Null(INT))", "map[1, NULLIF(1,1)]", "{1=null}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.int2Literal(1), package$.MODULE$.long2Literal(2L), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(3), package$.MODULE$.long2Literal(4L)})), "map(1, 2L, 3, 4L)", "MAP[1, CAST(2 AS BIGINT), 3, CAST(4 AS BIGINT)]", "{1=2, 3=4}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.sqlDate2Literal(Date.valueOf("1985-04-11")), package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map('1985-04-11'.toDate, 1)", "MAP[DATE '1985-04-11', 1]", "{1985-04-11=1}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0002)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0003)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(2.0002p, 2.0003p)", "MAP[CAST(2.0002 AS DECIMAL), CAST(2.0003 AS DECIMAL)]", "{2.0002=2.0003}");
        this.testSqlApi("MAP['k1', CAST(1 AS DOUBLE), 'k2', CAST(2 AS FLOAT)]", "{k1=1.0, k2=2.0}");
    }

    @Test
    public void testMapField() {
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f4, f5)", "MAP[f4, f5]", "{foo=12}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f4, f1)", "MAP[f4, f1]", "{foo={}}");
        this.testAllApis(map$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f2, f3)", "MAP[f2, f3]", "{{a=12, b=13}={12=a, 13=b}}");
        this.testAllApis(map$.MODULE$.apply((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).at(package$.MODULE$.string2Literal("a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f1.at('a'), f5)", "MAP[f1['a'], f5]", "{null=12}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")), "f1", "f1", "{}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "{a=12, b=13}");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("a")), "f2.at('a')", "f2['a']", "12");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at(package$.MODULE$.int2Literal(12)), "f3.at(12)", "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(map$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))).at(package$.MODULE$.string2Literal("foo"))).at(package$.MODULE$.int2Literal(13)), "map(f4, f3).at('foo').at(13)", "MAP[f4, f3]['foo'][13]", "b");
    }

    @Test
    public void testMapOperations() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))), "f1 === f2", "f1 = f2", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f3 === f7", "f3 = f7", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).$eq$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("a"))), "f5 === f2.at('a')", "f5 = f2['a']", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).at(package$.MODULE$.string2Literal("map is null")), "f0.at('map is null')", "f0['map is null']", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).at(package$.MODULE$.string2Literal("map is empty")), "f1.at('map is empty')", "f1['map is empty']", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("b")), "f2.at('b')", "f2['b']", "13");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at(package$.MODULE$.int2Literal(1)), "f3.at(1)", "f3[1]", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at(package$.MODULE$.int2Literal(12)), "f3.at(12)", "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cardinality(), "f3.cardinality()", "CARDINALITY(f3)", "2");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("a"))).isNotNull(), "f2.at('a').isNotNull", "f2['a'] IS NOT NULL", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("a"))).isNull(), "f2.at('a').isNull", "f2['a'] IS NULL", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("c"))).isNotNull(), "f2.at('c').isNotNull", "f2['c'] IS NOT NULL", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.string2Literal("c"))).isNull(), "f2.at('c').isNull", "f2['c'] IS NULL", "true");
    }

    @Test
    public void testMapTypeCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cast(Types$.MODULE$.MAP(Types$.MODULE$.STRING(), Types$.MODULE$.INT())), "f2.cast(MAP(STRING, INT))", "{a=12, b=13}");
    }
}

