/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.expressions.utils.Func3$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u001b\tYA*\u001b;fe\u0006dG+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0002\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"AE#yaJ,7o]5p]R+7\u000f\u001e\"bg\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u00025Q,7\u000f\u001e$jK2$w+\u001b;i\u0005>|G.Z1o!J,g-\u001b=\u0015\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\"\u0012\u0011d\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M)\tQA[;oSRL!\u0001K\u0013\u0003\tQ+7\u000f\u001e\u0005\u0006U\u0001!\taG\u0001\u0014i\u0016\u001cHOT8o\u0003N\u001c\u0017.\u001b'ji\u0016\u0014\u0018\r\u001c\u0015\u0003S\rBQ!\f\u0001\u0005\u0002m\tq\u0002^3ti\u0012{WO\u00197f#V|G/\u001a\u0015\u0003Y\rBQ\u0001\r\u0001\u0005\u0002m\t!\u0003^3tiN#(/\u001b8h\u0019&$XM]1mg\"\u0012qf\t\u0005\u0006g\u0001!\t\u0001N\u0001\ti\u0016\u001cH\u000fR1uCV\tQ\u0007\u0005\u0002\u001em%\u0011qG\b\u0002\u0004\u0003:L\b\"B\u001d\u0001\t\u0003Q\u0014\u0001\u0003;za\u0016LeNZ8\u0016\u0003m\u00022\u0001P\"6\u001b\u0005i$B\u0001 @\u0003!!\u0018\u0010]3j]\u001a|'B\u0001!B\u0003\u0019\u0019w.\\7p]*\u0011!IB\u0001\u0004CBL\u0017B\u0001#>\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\"\u0002$\u0001\t\u0003:\u0015!\u00034v]\u000e$\u0018n\u001c8t+\u0005A\u0005\u0003B%Q'Zs!A\u0013(\u0011\u0005-sR\"\u0001'\u000b\u00055c\u0011A\u0002\u001fs_>$h(\u0003\u0002P=\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\u00075\u000b\u0007O\u0003\u0002P=A\u0011\u0011\nV\u0005\u0003+J\u0013aa\u0015;sS:<\u0007CA,Z\u001b\u0005A&B\u0001$\u0005\u0013\tQ\u0006L\u0001\bTG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8")
public class LiteralTest
extends ExpressionTestBase {
    @Test
    public void testFieldWithBooleanPrefix() {
        this.testTableApi(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "trUeX")), "trUeX", "trUeX_value");
        this.testTableApi(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_A")), "FALSE_A", "FALSE_A_value");
        this.testTableApi(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "FALSE_AB")), "FALSE_AB", "FALSE_AB_value");
        this.testTableApi(package$.MODULE$.boolean2Literal(true), "trUe", "true");
        this.testTableApi(package$.MODULE$.boolean2Literal(false), "FALSE", "false");
    }

    @Test
    public void testNonAsciiLiteral() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).like(package$.MODULE$.string2Literal("%\u6d4b\u8bd5%")), "f4.like('%\u6d4b\u8bd5%')", "f4 LIKE '%\u6d4b\u8bd5%'", "true");
        this.testAllApis(package$.MODULE$.string2Literal("\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22"), "'\u0410\u0431\u0432\u0433\u0434\u0435' + '\u8c22\u8c22'", "'\u0410\u0431\u0432\u0433\u0434\u0435' || '\u8c22\u8c22'", "\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22");
    }

    @Test
    public void testDoubleQuote() {
        String hello = "\"<hello>\"";
        this.testAllApis(Func3$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(42), package$.MODULE$.string2Literal(hello)})), new StringBuilder(13).append("Func3(42, '").append(hello).append("')").toString(), new StringBuilder(13).append("Func3(42, '").append(hello).append("')").toString(), new StringBuilder(7).append("42 and ").append(hello).toString());
    }

    @Test
    public void testStringLiterals() {
        this.testAllApis(package$.MODULE$.string2Literal(">\n<"), "'>\n<'", "'>\n<'", ">\n<");
        this.testAllApis(package$.MODULE$.string2Literal(">\u263a<"), "'>\u263a<'", "'>\u263a<'", ">\u263a<");
        this.testAllApis(package$.MODULE$.string2Literal(">\u263a<"), "'>\u263a<'", "'>\u263a<'", ">\u263a<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\<"), "'>\\<'", "'>\\<'", ">\\<");
        this.testAllApis(package$.MODULE$.string2Literal(">'<"), "'>''<'", "'>''<'", ">'<");
        this.testAllApis(package$.MODULE$.string2Literal(" "), "' '", "' '", " ");
        this.testAllApis(package$.MODULE$.string2Literal(""), "''", "''", "");
        this.testAllApis(package$.MODULE$.string2Literal(">foo([\\w]+)<"), "'>foo([\\w]+)<'", "'>foo([\\w]+)<'", ">foo([\\w]+)<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\'\n<"), "\">\\'\n<\"", "'>\\''\n<'", ">\\'\n<");
        this.testAllApis(package$.MODULE$.string2Literal("It's me."), "'It''s me.'", "'It''s me.'", "It's me.");
        this.testTableApi(package$.MODULE$.string2Literal("I \"like\" dogs."), "\"I \"\"like\"\" dogs.\"", "I \"like\" dogs.");
        this.testSqlApi("U&'>\\263A<'", ">\u263a<");
        this.testSqlApi("U&'>#263A<' UESCAPE '#'", ">\u263a<");
        this.testSqlApi("'>\\\\<'", ">\\\\<");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object testData() {
        void var1_1;
        Row testData = new Row(4);
        testData.setField(0, (Object)"trUeX_value");
        testData.setField(1, (Object)"FALSE_A_value");
        testData.setField(2, (Object)"FALSE_AB_value");
        testData.setField(3, (Object)"\u8fd9\u662f\u4e2a\u6d4b\u8bd5\u5b57\u7b26\u4e32");
        return var1_1;
    }

    @Override
    public TypeInformation<Object> typeInfo() {
        return new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"trUeX", "FALSE_A", "FALSE_AB", "f4"}));
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Func3"), (Object)Func3$.MODULE$)}));
    }
}

