/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Double$;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\tyA)Z2j[\u0006dG+\u001f9f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E\u0011\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005I)\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012a\u0005;fgR$UmY5nC2d\u0015\u000e^3sC2\u001cH#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u00033\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0006\u0002\u000b),h.\u001b;\n\u0005!*#\u0001\u0002+fgRDQA\u000b\u0001\u0005\u0002m\t!\u0003^3ti\u0012+7-[7bY\n{'\u000fZ3sg\"\u0012\u0011f\t\u0005\u0006[\u0001!\taG\u0001\u0013i\u0016\u001cH\u000fR3dS6\fGnQ1ti&tw\r\u000b\u0002-G!)\u0001\u0007\u0001C\u00017\u0005)B/Z:u\t\u0016\u001c\u0017.\\1m\u0003JLG\u000f[7fi&\u001c\u0007FA\u0018$\u0011\u0015\u0019\u0004\u0001\"\u0001\u001c\u0003U!Xm\u001d;EK\u000eLW.\u00197D_6\u0004\u0018M]5t_:D#AM\u0012\t\u000bY\u0002A\u0011A\u001c\u0002\u0011Q,7\u000f\u001e#bi\u0006,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\tQ\u0001^=qKNL!!\u0010\u001e\u0003\u0007I{w\u000fC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0005usB,\u0017J\u001c4p+\u0005\t\u0005c\u0001\"J\u00176\t1I\u0003\u0002E\u000b\u0006AA/\u001f9fS:4wN\u0003\u0002G\u000f\u000611m\\7n_:T!\u0001\u0013\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002K\u0007\nyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0005\u0002\u001e\u0019&\u0011QJ\b\u0002\u0004\u0003:L\b")
public class DecimalTypeTest
extends ExpressionTestBase {
    @Test
    public void testDecimalLiterals() {
        this.testAllApis(package$.MODULE$.double2Literal(11.2), "11.2", "11.2", "11.2");
        this.testAllApis(package$.MODULE$.double2Literal(0.7623533651719233), "0.7623533651719233", "0.7623533651719233", "0.7623533651719233");
        this.testAllApis(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("1234567891234567891")), "1234567891234567891p", "1234567891234567891", "1234567891234567891");
        this.testTableApi(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789")), "123456789123456789123456789p", "123456789123456789123456789");
        this.testTableApi(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("12.3456789123456789123456789")), "12.3456789123456789123456789p", "12.3456789123456789123456789");
    }

    @Test
    public void testDecimalBorders() {
        this.testAllApis(package$.MODULE$.double2Literal(Double.MAX_VALUE), ((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE)).toString());
        this.testAllApis(package$.MODULE$.double2Literal(Double$.MODULE$.MinValue()), ((Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())).toString(), ((Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue())).toString());
        this.testAllApis((Expression)package$.MODULE$.LiteralDoubleExpression(Double$.MODULE$.MinValue()).cast(Types$.MODULE$.FLOAT()), new StringBuilder(12).append(Double$.MODULE$.MinValue()).append(".cast(FLOAT)").toString(), new StringBuilder(15).append("CAST(").append(Double$.MODULE$.MinValue()).append(" AS FLOAT)").toString(), ((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)).toString());
        this.testAllApis((Expression)package$.MODULE$.LiteralByteExpression((byte)-128).cast(Types$.MODULE$.BYTE()), new StringBuilder(13).append("(").append(-128).append(").cast(BYTE)").toString(), new StringBuilder(17).append("CAST(").append(-128).append(" AS TINYINT)").toString(), ((Object)BoxesRunTime.boxToByte((byte)-128)).toString());
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralByteExpression((byte)-128).cast(Types$.MODULE$.BYTE())).$minus((Expression)package$.MODULE$.LiteralIntExpression(1).cast(Types$.MODULE$.BYTE())), new StringBuilder(30).append("(").append(-128).append(").cast(BYTE) - (1).cast(BYTE)").toString(), new StringBuilder(38).append("CAST(").append(-128).append(" AS TINYINT) - CAST(1 AS TINYINT)").toString(), ((Object)BoxesRunTime.boxToByte((byte)127)).toString());
        this.testAllApis((Expression)package$.MODULE$.LiteralShortExpression((short)Short.MIN_VALUE).cast(Types$.MODULE$.SHORT()), new StringBuilder(14).append("(").append(Short.MIN_VALUE).append(").cast(SHORT)").toString(), new StringBuilder(18).append("CAST(").append(Short.MIN_VALUE).append(" AS SMALLINT)").toString(), ((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE)).toString());
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.LiteralIntExpression(Integer.MIN_VALUE).cast(Types$.MODULE$.INT())).$minus(package$.MODULE$.int2Literal(1)), new StringBuilder(16).append("(").append(Integer.MIN_VALUE).append(").cast(INT) - 1").toString(), new StringBuilder(17).append("CAST(").append(Integer.MIN_VALUE).append(" AS INT) - 1").toString(), ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        this.testAllApis((Expression)package$.MODULE$.LiteralLongExpression(Long.MIN_VALUE).cast(Types$.MODULE$.LONG()), new StringBuilder(14).append("(").append(Long.MIN_VALUE).append("L).cast(LONG)").toString(), new StringBuilder(16).append("CAST(").append(Long.MIN_VALUE).append(" AS BIGINT)").toString(), ((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)).toString());
    }

    @Test
    public void testDecimalCasting() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("123456789123456789123456789").cast(Types$.MODULE$.DECIMAL()), "'123456789123456789123456789'.cast(DECIMAL)", "123456789123456789123456789");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cast(Types$.MODULE$.DECIMAL()), "f3.cast(DECIMAL)", "CAST(f3 AS DECIMAL)", "4.2");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cast(Types$.MODULE$.DOUBLE()), "f0.cast(DOUBLE)", "CAST(f0 AS DOUBLE)", "1.2345678912345679E8");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cast(Types$.MODULE$.INT()), "f4.cast(INT)", "CAST(f4 AS INT)", "123456789");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cast(Types$.MODULE$.LONG()), "f4.cast(LONG)", "CAST(f4 AS BIGINT)", "123456789");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).cast(Types$.MODULE$.BOOLEAN()), "f1.cast(BOOLEAN)", "true");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).cast(Types$.MODULE$.BOOLEAN()), "f5.cast(BOOLEAN)", "false");
        this.testTableApi((Expression)package$.MODULE$.LiteralScalaDecimalExpression(scala.package$.MODULE$.BigDecimal().apply("123456789.123456789123456789")).cast(Types$.MODULE$.DOUBLE()), "(123456789.123456789123456789p).cast(DOUBLE)", "1.2345678912345679E8");
    }

    @Test
    public void testDecimalArithmetic() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.int2Literal(12)), "f1 + 12", "f1 + 12", "123456789123456789123456801");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)12))).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12 + f1", "12 + f1", "123456789123456789123456801");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.double2Literal(12.3)), "f1 + 12.3", "f1 + 12.3", "123456789123456789123456801.3");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)12.3))).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "12.3 + f1", "12.3 + f1", "123456789123456789123456801.3");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 + f1", "f1 + f1", "246913578246913578246913578");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$minus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 - f1", "f1 - f1", "0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$times(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 * f1", "f1 * f1", "15241578780673678546105778281054720515622620750190521");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$div(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 / f1", "f1 / f1", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$percent(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "f1 % f1", "MOD(f1, f1)", "0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).unary_$minus(), "-f0", "-f0", "-123456789.123456789123456789");
        this.testAllApis((Expression)package$.MODULE$.WithOperations(package$.MODULE$.LiteralScalaDecimalExpression(scala.package$.MODULE$.BigDecimal().apply("1")).toExpr()).$div(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("3"))), "1p / 3p", "CAST('1' AS DECIMAL) / CAST('3' AS DECIMAL)", "0.3333333333333333333333333333333333");
    }

    @Test
    public void testDecimalComparison() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$less(package$.MODULE$.int2Literal(12)), "f1 < 12", "f1 < 12", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$greater(package$.MODULE$.int2Literal(12)), "f1 > 12", "f1 > 12", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.int2Literal(12)), "f1 === 12", "f1 = 12", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).$eq$eq$eq(package$.MODULE$.int2Literal(0)), "f5 === 0", "f5 = 0", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$eq$eq$eq(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 === 123456789123456789123456789p", "f1 = CAST('123456789123456789123456789' AS DECIMAL)", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).$bang$eq$eq(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789"))), "f1 !== 123456789123456789123456789p", "f1 <> CAST('123456789123456789123456789' AS DECIMAL)", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0"))), "f4 < f0", "f4 < f0", "true");
        this.testSqlApi("12 < f1", "true");
    }

    /*
     * WARNING - void declaration
     */
    public Row testData() {
        void var1_1;
        Row testData = new Row(6);
        testData.setField(0, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789.123456789123456789").bigDecimal());
        testData.setField(1, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789123456789123456789").bigDecimal());
        testData.setField(2, (Object)BoxesRunTime.boxToInteger((int)42));
        testData.setField(3, (Object)BoxesRunTime.boxToDouble((double)4.2));
        testData.setField(4, (Object)scala.package$.MODULE$.BigDecimal().apply("123456789").bigDecimal());
        testData.setField(5, (Object)scala.package$.MODULE$.BigDecimal().apply("0.000").bigDecimal());
        return var1_1;
    }

    @Override
    public TypeInformation<Object> typeInfo() {
        return new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.DECIMAL(), Types$.MODULE$.DECIMAL(), Types$.MODULE$.INT(), Types$.MODULE$.DOUBLE(), Types$.MODULE$.DECIMAL(), Types$.MODULE$.DECIMAL()});
    }
}

