/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.scala.dateFormat$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.shaded.org.joda.time.DateTime;
import org.apache.flink.table.shaded.org.joda.time.DateTimeZone;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001b\t!B)\u0019;f)&lWMR;oGRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\u0005\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\u0013\u000bb\u0004(/Z:tS>tG+Z:u\u0005\u0006\u001cX\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001b\u0001\n\u0013Y\u0012aB%O'R\u000be\nV\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005i&lWM\u0003\u0002\"\u0015\u0005!!n\u001c3b\u0013\t\u0019cD\u0001\u0005ECR,G+[7f\u0011\u0019)\u0003\u0001)A\u00059\u0005A\u0011JT*U\u0003:#\u0006\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u00151{5)\u0011'`5>sU)F\u0001*!\ti\"&\u0003\u0002,=\taA)\u0019;f)&lWMW8oK\"1Q\u0006\u0001Q\u0001\n%\n1\u0002T(D\u00032{&l\u0014(FA!9q\u0006\u0001b\u0001\n\u0013Y\u0012A\u0003'P\u0007\u0006cu\fV%N\u000b\"1\u0011\u0007\u0001Q\u0001\nq\t1\u0002T(D\u00032{F+S'FA!)1\u0007\u0001C\u0001i\u0005qA/Z:u\t\u0006$XMR8s[\u0006$H#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003eq\u0002\"!\u0010!\u000e\u0003yR!a\u0010\u0006\u0002\u000b),h.\u001b;\n\u0005\u0005s$\u0001\u0002+fgRDQa\u0011\u0001\u0005\u0002Q\n!\u0005^3ti\u0012\u000bG/\u001a$pe6\fGOT8o\u0007>t7\u000f^1oi\u001a{'/\\1ui\u0016\u0014\bF\u0001\"=\u0011\u00151\u0005\u0001\"\u0011H\u0003!!Xm\u001d;ECR\fW#\u0001%\u0011\u0005YJ\u0015B\u0001&8\u0005\r\te.\u001f\u0005\u0006\u0019\u0002!\t%T\u0001\tif\u0004X-\u00138g_V\ta\nE\u0002P-\"k\u0011\u0001\u0015\u0006\u0003#J\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u0003'R\u000baaY8n[>t'BA+\u0007\u0003\r\t\u0007/[\u0005\u0003/B\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c")
public class DateTimeFunctionTest
extends ExpressionTestBase {
    private final DateTime INSTANT = DateTime.parse((String)"1990-01-02T03:04:05.678Z");
    private final DateTimeZone LOCAL_ZONE = DateTimeZone.getDefault();
    private final DateTime LOCAL_TIME = this.INSTANT().toDateTime(this.LOCAL_ZONE());

    private DateTime INSTANT() {
        return this.INSTANT;
    }

    private DateTimeZone LOCAL_ZONE() {
        return this.LOCAL_ZONE;
    }

    private DateTime LOCAL_TIME() {
        return this.LOCAL_TIME;
    }

    @Test
    public void testDateFormat() {
        String expected = this.LOCAL_TIME().toString("MM/dd/yyyy HH:mm:ss.SSSSSS");
        this.testAllApis(dateFormat$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.string2Literal("%m/%d/%Y %H:%i:%s.%f")), "dateFormat(f0, \"%m/%d/%Y %H:%i:%s.%f\")", "DATE_FORMAT(f0, '%m/%d/%Y %H:%i:%s.%f')", expected);
    }

    @Test
    public void testDateFormatNonConstantFormatter() {
        String expected = this.LOCAL_TIME().toString("MM/dd/yyyy");
        this.testAllApis(dateFormat$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))), "dateFormat(f0, f1)", "DATE_FORMAT(f0, f1)", expected);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object testData() {
        void var1_1;
        Row testData = new Row(2);
        testData.setField(0, (Object)new Timestamp(this.LOCAL_ZONE().convertLocalToUTC(this.INSTANT().getMillis(), true)));
        testData.setField(1, (Object)"%m/%d/%Y");
        return var1_1;
    }

    @Override
    public TypeInformation<Object> typeInfo() {
        return new RowTypeInfo(new TypeInformation[]{Types.SQL_TIMESTAMP, Types.STRING});
    }
}

