/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.sql.Date;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.array$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Null;
import org.apache.flink.table.expressions.utils.ArrayTypeTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001I2A!\u0001\u0002\u0001\u001b\ti\u0011I\u001d:bsRK\b/\u001a+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\u0005\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\u0012\u0003J\u0014\u0018-\u001f+za\u0016$Vm\u001d;CCN,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003E!Xm\u001d;BeJ\f\u0017\u0010T5uKJ\fGn\u001d\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5uQ\tI2\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u0015\u0005)!.\u001e8ji&\u0011\u0001&\n\u0002\u0005)\u0016\u001cH\u000fC\u0003+\u0001\u0011\u00051$\u0001\buKN$\u0018I\u001d:bs\u001aKW\r\u001c3)\u0005%\u001a\u0003\"B\u0017\u0001\t\u0003Y\u0012a\u0005;fgR\f%O]1z\u001fB,'/\u0019;j_:\u001c\bF\u0001\u0017$\u0011\u0015\u0001\u0004\u0001\"\u0001\u001c\u0003Q!Xm\u001d;BeJ\f\u0017\u0010V=qK\u000e\u000b7\u000f^5oO\"\u0012qf\t")
public class ArrayTypeTest
extends ArrayTypeTestBase {
    @Test
    public void testArrayLiterals() {
        this.testAllApis(array$.MODULE$.apply(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)})), "array(1, 2, 3)", "ARRAY[1, 2, 3]", "[1, 2, 3]");
        this.testAllApis(array$.MODULE$.apply(package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.boolean2Literal(true), package$.MODULE$.boolean2Literal(true)})), "array(true, true, true)", "ARRAY[TRUE, TRUE, TRUE]", "[true, true, true]");
        this.testTableApi(array$.MODULE$.apply(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1))})), "array(1p, 1p)", "[1, 1]");
        this.testAllApis(array$.MODULE$.apply(array$.MODULE$.apply(array$.MODULE$.apply(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{array$.MODULE$.apply(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "array(array(array(1), array(1)))", "ARRAY[ARRAY[ARRAY[1], ARRAY[1]]]", "[[[1], [1]]]");
        this.testAllApis(array$.MODULE$.apply(package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(9)})), "array(1 + 1, 3 * 3)", "ARRAY[1 + 1, 3 * 3]", "[2, 9]");
        this.testAllApis(array$.MODULE$.apply((Expression)new Null(Types$.MODULE$.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(1)})), "array(Null(INT), 1)", "ARRAY[NULLIF(1,1), 1]", "[null, 1]");
        this.testAllApis(array$.MODULE$.apply(array$.MODULE$.apply((Expression)new Null(Types$.MODULE$.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(1)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "array(array(Null(INT), 1))", "ARRAY[ARRAY[NULLIF(1,1), 1]]", "[[null, 1]]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new int[]{1, 2, 3}), "array(1, 2, 3)", "[1, 2, 3]");
        this.testTableApi(package$.MODULE$.array2ArrayConstructor((Object)new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}), "array(1, 2, 3)", "[1, 2, 3]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)new Date[]{Date.valueOf("1985-04-11")}), "array('1985-04-11'.toDate)", "ARRAY[DATE '1985-04-11']", "[1985-04-11]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)new BigDecimal[]{scala.package$.MODULE$.BigDecimal().apply(2.0002), scala.package$.MODULE$.BigDecimal().apply(2.0003)}), "Array(2.0002p, 2.0003p)", "ARRAY[CAST(2.0002 AS DECIMAL), CAST(2.0003 AS DECIMAL)]", "[2.0002, 2.0003]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)((Object[])new boolean[][]{{true}})), "Array(Array(true))", "ARRAY[ARRAY[TRUE]]", "[[true]]");
        this.testAllApis(package$.MODULE$.array2ArrayConstructor((Object)((Object[])new int[][]{{1, 2, 3}, {3, 2, 1}})), "Array(Array(1, 2, 3), Array(3, 2, 1))", "ARRAY[ARRAY[1, 2, 3], ARRAY[3, 2, 1]]", "[[1, 2, 3], [3, 2, 1]]");
        this.testSqlApi("ARRAY[CAST(1 AS DOUBLE), CAST(2 AS FLOAT)]", "[1.0, 2.0]");
    }

    @Test
    public void testArrayField() {
        this.testAllApis(array$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "array(f0, f1)", "ARRAY[f0, f1]", "[null, 42]");
        this.testAllApis(array$.MODULE$.apply(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))})), "array(f0, f1)", "ARRAY[f0, f1]", "[null, 42]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "[1, 2, 3]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), "f3", "f3", "[1984-03-12, 1984-02-10]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")), "f5", "f5", "[[1, 2, 3], null]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")), "f6", "f6", "[1, null, null, 4]");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")), "f2", "f2", "[1, 2, 3]");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at(package$.MODULE$.int2Literal(1)), "f2.at(1)", "f2[1]", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at(package$.MODULE$.int2Literal(1)), "f3.at(1)", "f3[1]", "1984-03-12");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).at(package$.MODULE$.int2Literal(2)), "f3.at(2)", "f3[2]", "1984-02-10");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at(package$.MODULE$.int2Literal(1))).at(package$.MODULE$.int2Literal(2)), "f5.at(1).at(2)", "f5[1][2]", "2");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at(package$.MODULE$.int2Literal(2))).at(package$.MODULE$.int2Literal(2)), "f5.at(2).at(2)", "f5[2][2]", "null");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).at(package$.MODULE$.int2Literal(2))).at(package$.MODULE$.int2Literal(2)), "f4.at(2).at(2)", "f4[2][2]", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).at(package$.MODULE$.int2Literal(1)), "f11.at(1)", "f11[1]", "1");
    }

    @Test
    public void testArrayOperations() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).cardinality(), "f2.cardinality()", "CARDINALITY(f2)", "3");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).cardinality(), "f4.cardinality()", "CARDINALITY(f4)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).cardinality(), "f11.cardinality()", "CARDINALITY(f11)", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9")).element(), "f9.element()", "ELEMENT(f9)", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8")).element(), "f8.element()", "ELEMENT(f8)", "4.0");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).element(), "f10.element()", "ELEMENT(f10)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")).element(), "f4.element()", "ELEMENT(f4)", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).element(), "f11.element()", "ELEMENT(f11)", "1");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at(package$.MODULE$.int2Literal(1))), "f2 === f5.at(1)", "f2 = f5[1]", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$eq$eq$eq(array$.MODULE$.apply(package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(2), package$.MODULE$.int2Literal(3)}))), "f6 === array(1, 2, 3)", "f6 = ARRAY[1, 2, 3]", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f5")).at(package$.MODULE$.int2Literal(1))), "f2 !== f5.at(1)", "f2 <> f5[1]", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 === f7", "f2 = f7", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f7"))), "f2 !== f7", "f2 <> f7", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 === f11", "f11 = f11", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 === f9", "f11 = f9", "true");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11"))), "f11 !== f11", "f11 <> f11", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f11")).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f9"))), "f11 !== f9", "f11 <> f9", "false");
    }

    @Test
    public void testArrayTypeCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")).cast(Types$.MODULE$.OBJECT_ARRAY(Types$.MODULE$.SQL_DATE())), "f3.cast(OBJECT_ARRAY(SQL_DATE))", "[1984-03-12, 1984-02-10]");
    }
}

