/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Optional;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.Rowtime$;
import org.apache.flink.table.descriptors.RowtimeTest;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.descriptors.Schema$;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.tsextractors.ExistingField;
import org.apache.flink.table.sources.tsextractors.StreamRecordTimestamp;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.BoundedOutOfOrderTimestamps;
import org.apache.flink.table.sources.wmstrategies.PreserveWatermarks;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001b\t\u00192k\u00195f[\u00064\u0016\r\\5eCR|'\u000fV3ti*\u00111\u0001B\u0001\fI\u0016\u001c8M]5qi>\u00148O\u0003\u0002\u0006\r\u0005)A/\u00192mK*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\u00017\u0005yB/Z:u'\u000eDW-\\1XSRD'k\\<uS6,gI]8n'>,(oY3\u0015\u0003q\u0001\"aD\u000f\n\u0005y\u0001\"\u0001B+oSRD#!\u0007\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rR\u0011!\u00026v]&$\u0018BA\u0013#\u0005\u0011!Vm\u001d;\t\u000b\u001d\u0002A\u0011A\u000e\u0002]Q,7\u000f\u001e#fe&4X\rV1cY\u0016\u001c\u0016N\\6TG\",W.Y,ji\"\u0014vn\u001e;j[\u00164%o\\7T_V\u00148-\u001a\u0015\u0005M\u0001J#&\u0001\u0005fqB,7\r^3eG\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\r\t\u0007/[\u0005\u0003a5\u0012a\u0002V1cY\u0016,\u0005pY3qi&|g\u000eC\u00033\u0001\u0011\u00051$A\u0017uKN$H)\u001a:jm\u0016$\u0016M\u00197f'&t7nU2iK6\fw+\u001b;i%><H/[7f\rJ|WNR5fY\u0012D#!\r\u0011\t\u000bU\u0002A\u0011A\u000e\u0002=Q,7\u000f^*dQ\u0016l\u0017mV5uQJ{w\u000f^5nK\u001a\u0013x.\u001c$jK2$\u0007F\u0001\u001b!\u0011\u0015A\u0004\u0001\"\u0001\u001c\u00035\"Xm\u001d;TG\",W.Y,ji\"\u0014vn\u001e;j[\u0016\u001cUo\u001d;p[RKW.Z:uC6\u0004X\t\u001f;sC\u000e$xN\u001d\u0015\u0003o\u0001\u0002")
public class SchemaValidatorTest {
    @Test
    public void testSchemaWithRowtimeFromSource() {
        Schema desc1 = Schema$.MODULE$.apply().field("otherField", Types$.MODULE$.STRING()).from("csvField").field("abcField", Types$.MODULE$.STRING()).field("p", Types$.MODULE$.SQL_TIMESTAMP()).proctime().field("r", Types$.MODULE$.SQL_TIMESTAMP()).rowtime(Rowtime$.MODULE$.apply().timestampsFromSource().watermarksFromSource());
        DescriptorProperties props = new DescriptorProperties();
        props.putProperties(desc1.toProperties());
        TableSchema inputSchema = TableSchema.builder().field("csvField", Types$.MODULE$.STRING()).field("abcField", Types$.MODULE$.STRING()).field("myField", Types$.MODULE$.BOOLEAN()).build();
        Assert.assertEquals(Optional.of("p"), (Object)SchemaValidator$.MODULE$.deriveProctimeAttribute(props));
        RowtimeAttributeDescriptor rowtime = (RowtimeAttributeDescriptor)SchemaValidator$.MODULE$.deriveRowtimeAttributes(props).get(0);
        Assert.assertEquals((Object)"r", (Object)rowtime.getAttributeName());
        Assert.assertTrue((boolean)(rowtime.getTimestampExtractor() instanceof StreamRecordTimestamp));
        Assert.assertTrue((boolean)(rowtime.getWatermarkStrategy() instanceof PreserveWatermarks));
        java.util.Map expectedMapping = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherField"), (Object)"csvField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"csvField"), (Object)"csvField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"abcField"), (Object)"abcField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"myField"), (Object)"myField")}))).asJava();
        Assert.assertEquals((Object)expectedMapping, (Object)SchemaValidator$.MODULE$.deriveFieldMapping(props, Optional.of(inputSchema.toRowType())));
    }

    @Test(expected=TableException.class)
    public void testDeriveTableSinkSchemaWithRowtimeFromSource() {
        Schema desc1 = Schema$.MODULE$.apply().field("otherField", Types$.MODULE$.STRING()).from("csvField").field("abcField", Types$.MODULE$.STRING()).field("p", Types$.MODULE$.SQL_TIMESTAMP()).proctime().field("r", Types$.MODULE$.SQL_TIMESTAMP()).rowtime(Rowtime$.MODULE$.apply().timestampsFromSource().watermarksFromSource());
        DescriptorProperties props = new DescriptorProperties();
        props.putProperties(desc1.toProperties());
        SchemaValidator$.MODULE$.deriveTableSinkSchema(props);
    }

    @Test
    public void testDeriveTableSinkSchemaWithRowtimeFromField() {
        Schema desc1 = Schema$.MODULE$.apply().field("otherField", Types$.MODULE$.STRING()).from("csvField").field("abcField", Types$.MODULE$.STRING()).field("p", Types$.MODULE$.SQL_TIMESTAMP()).proctime().field("r", Types$.MODULE$.SQL_TIMESTAMP()).rowtime(Rowtime$.MODULE$.apply().timestampsFromField("myTime").watermarksFromSource());
        DescriptorProperties props = new DescriptorProperties();
        props.putProperties(desc1.toProperties());
        TableSchema expectedTableSinkSchema = TableSchema.builder().field("csvField", Types$.MODULE$.STRING()).field("abcField", Types$.MODULE$.STRING()).field("myTime", Types$.MODULE$.SQL_TIMESTAMP()).build();
        Assert.assertEquals((Object)expectedTableSinkSchema, (Object)SchemaValidator$.MODULE$.deriveTableSinkSchema(props));
    }

    @Test
    public void testSchemaWithRowtimeFromField() {
        Schema desc1 = Schema$.MODULE$.apply().field("otherField", Types$.MODULE$.STRING()).from("csvField").field("abcField", Types$.MODULE$.STRING()).field("p", Types$.MODULE$.SQL_TIMESTAMP()).proctime().field("r", Types$.MODULE$.SQL_TIMESTAMP()).rowtime(Rowtime$.MODULE$.apply().timestampsFromField("myTime").watermarksFromSource());
        DescriptorProperties props = new DescriptorProperties();
        props.putProperties(desc1.toProperties());
        TableSchema inputSchema = TableSchema.builder().field("csvField", Types$.MODULE$.STRING()).field("abcField", Types$.MODULE$.STRING()).field("myField", Types$.MODULE$.BOOLEAN()).field("myTime", Types$.MODULE$.SQL_TIMESTAMP()).build();
        Assert.assertEquals(Optional.of("p"), (Object)SchemaValidator$.MODULE$.deriveProctimeAttribute(props));
        RowtimeAttributeDescriptor rowtime = (RowtimeAttributeDescriptor)SchemaValidator$.MODULE$.deriveRowtimeAttributes(props).get(0);
        Assert.assertEquals((Object)"r", (Object)rowtime.getAttributeName());
        Assert.assertTrue((boolean)(rowtime.getTimestampExtractor() instanceof ExistingField));
        Assert.assertTrue((boolean)(rowtime.getWatermarkStrategy() instanceof PreserveWatermarks));
        java.util.Map expectedMapping = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherField"), (Object)"csvField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"csvField"), (Object)"csvField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"abcField"), (Object)"abcField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"myField"), (Object)"myField"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"myTime"), (Object)"myTime")}))).asJava();
        Assert.assertEquals((Object)expectedMapping, (Object)SchemaValidator$.MODULE$.deriveFieldMapping(props, Optional.of(inputSchema.toRowType())));
    }

    @Test
    public void testSchemaWithRowtimeCustomTimestampExtractor() {
        Schema descriptor = Schema$.MODULE$.apply().field("f1", Types$.MODULE$.STRING()).field("f2", Types$.MODULE$.STRING()).field("f3", Types$.MODULE$.SQL_TIMESTAMP()).field("rt", Types$.MODULE$.SQL_TIMESTAMP()).rowtime(Rowtime$.MODULE$.apply().timestampsFromExtractor((TimestampExtractor)new RowtimeTest.CustomExtractor("f3")).watermarksPeriodicBounded(1000L));
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(descriptor.toProperties());
        RowtimeAttributeDescriptor rowtime = (RowtimeAttributeDescriptor)SchemaValidator$.MODULE$.deriveRowtimeAttributes(properties).get(0);
        Assert.assertEquals((Object)"rt", (Object)rowtime.getAttributeName());
        TimestampExtractor extractor = rowtime.getTimestampExtractor();
        Assert.assertTrue((boolean)extractor.equals((Object)new RowtimeTest.CustomExtractor("f3")));
        Assert.assertTrue((boolean)(rowtime.getWatermarkStrategy() instanceof BoundedOutOfOrderTimestamps));
    }
}

