/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.HierarchyDescriptorValidator$;
import org.apache.flink.table.descriptors.LiteralValue;
import org.apache.flink.table.descriptors.LiteralValue$;
import org.apache.flink.table.descriptors.LiteralValueValidator;
import org.apache.flink.table.descriptors.LiteralValueValidator$;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001b\t\u0001B*\u001b;fe\u0006dg+\u00197vKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0002Z3tGJL\u0007\u000f^8sg*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\nEKN\u001c'/\u001b9u_J$Vm\u001d;CCN,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\ty\u0001\u0001C\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\tuKN$X*[:tS:<g+\u00197vKR\t\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0003V]&$\b\u0006\u0002\f!M\u001d\u0002\"!\t\u0013\u000e\u0003\tR!a\t\u0006\u0002\u000b),h.\u001b;\n\u0005\u0015\u0012#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\u0004CBL\u0017BA\u0017+\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015y\u0003\u0001\"\u0001\u0019\u00039!Xm\u001d;Xe>twMV1mk\u0016DCA\f\u0011'O!)1\u0001\u0001C!eQ\t1\u0007E\u00025smj\u0011!\u000e\u0006\u0003m]\nA!\u001e;jY*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u0011a\u0015n\u001d;\u0011\u0005=a\u0014BA\u001f\u0003\u0005)!Um]2sSB$xN\u001d\u0005\u0006\u007f\u0001!\t\u0005Q\u0001\nm\u0006d\u0017\u000eZ1u_J$\u0012!\u0011\t\u0003\u001f\tK!a\u0011\u0002\u0003'\u0011+7o\u0019:jaR|'OV1mS\u0012\fGo\u001c:\t\u000b\u0015\u0003A\u0011\t$\u0002\u0015A\u0014x\u000e]3si&,7\u000fF\u0001H!\r!\u0014\b\u0013\t\u0005i%[5*\u0003\u0002Kk\t\u0019Q*\u00199\u0011\u00051\u001bfBA'R!\tq5$D\u0001P\u0015\t\u0001F\"\u0001\u0004=e>|GOP\u0005\u0003%n\ta\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!k\u0007")
public class LiteralValueTest
extends DescriptorTestBase {
    @Test(expected=ValidationException.class)
    public void testMissingValue() {
        this.removePropertyAndVerify(this.descriptors().get(0), LiteralValueValidator$.MODULE$.VALUE());
    }

    @Test(expected=ValidationException.class)
    public void testWrongValue() {
        this.addPropertyAndVerify(this.descriptors().get(2), LiteralValueValidator$.MODULE$.VALUE(), "12.222");
    }

    public List<Descriptor> descriptors() {
        LiteralValue bigDecimalDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.DECIMAL()).value(new BigDecimal(1));
        LiteralValue booleanDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.BOOLEAN()).value(false);
        LiteralValue byteDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.BYTE()).value((byte)4);
        LiteralValue doubleDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.DOUBLE()).value(7.0);
        LiteralValue floatDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.FLOAT()).value(8.0f);
        LiteralValue intDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.INT()).value(9);
        LiteralValue longDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.LONG()).value(10L);
        LiteralValue shortDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.SHORT()).value((short)11);
        LiteralValue stringDesc = LiteralValue$.MODULE$.apply().of(Types$.MODULE$.STRING()).value("12");
        return Arrays.asList((Object[])new Descriptor[]{bigDecimalDesc, booleanDesc, byteDesc, doubleDesc, floatDesc, intDesc, longDesc, shortDesc, stringDesc});
    }

    public DescriptorValidator validator() {
        return new LiteralValueValidator(HierarchyDescriptorValidator$.MODULE$.EMPTY_PREFIX());
    }

    public List<java.util.Map<String, String>> properties() {
        scala.collection.immutable.Map bigDecimalProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"DECIMAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"1")}));
        scala.collection.immutable.Map booleanDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"BOOLEAN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"false")}));
        scala.collection.immutable.Map byteDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"TINYINT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"4")}));
        scala.collection.immutable.Map doubleDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"DOUBLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"7.0")}));
        scala.collection.immutable.Map floatDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"FLOAT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"8.0")}));
        scala.collection.immutable.Map intProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"INT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"9")}));
        scala.collection.immutable.Map longDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"BIGINT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"10")}));
        scala.collection.immutable.Map shortDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"SMALLINT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"11")}));
        scala.collection.immutable.Map stringDesc = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"VARCHAR"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"12")}));
        return Arrays.asList((Object[])new java.util.Map[]{(java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)bigDecimalProps).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)booleanDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)byteDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)doubleDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)floatDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)intProps).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)longDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)shortDesc).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)stringDesc).asJava()});
    }
}

