/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\tAB)Z:de&\u0004Ho\u001c:Qe>\u0004XM\u001d;jKN$Vm\u001d;\u000b\u0005\r!\u0011a\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00057\u0005I\u0011I\u0015*B3~[U)W\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB*ue&tw\r\u0003\u0004&\u0001\u0001\u0006I\u0001H\u0001\u000b\u0003J\u0013\u0016)W0L\u000bf\u0003\u0003\"B\u0014\u0001\t\u0003A\u0013A\u0003;fgR,\u0015/^1mgR\t\u0011\u0006\u0005\u0002\u0010U%\u00111\u0006\u0005\u0002\u0005+:LG\u000f\u000b\u0002'[A\u0011a&M\u0007\u0002_)\u0011\u0001GC\u0001\u0006UVt\u0017\u000e^\u0005\u0003e=\u0012A\u0001V3ti\")A\u0007\u0001C\u0001Q\u0005\u0001B/Z:u\u001b&\u001c8/\u001b8h\u0003J\u0014\u0018-\u001f\u0015\u0003g5BQa\u000e\u0001\u0005\u0002!\nq\u0002^3ti\u0006\u0013(/Y=WC2,Xm\u001d\u0015\u0003m5BQA\u000f\u0001\u0005\u0002!\nA\u0003^3ti\u0006\u0013(/Y=TS:<G.\u001a,bYV,\u0007FA\u001d.\u0011\u0015i\u0004\u0001\"\u0001)\u0003Y!Xm\u001d;BeJ\f\u00170\u00138wC2LGMV1mk\u0016\u001c\b\u0006\u0002\u001f.\u007f\u0001\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A\tB\u0001\u0004CBL\u0017B\u0001$D\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015A\u0005\u0001\"\u0001)\u0003m!Xm\u001d;BeJ\f\u00170\u00138wC2LGmU5oO2,g+\u00197vK\"\"q)L A\u0011\u0015Y\u0005\u0001\"\u0001)\u0003]!Xm\u001d;J]Z\fG.\u001b3NSN\u001c\u0018N\\4BeJ\f\u0017\u0010\u000b\u0003K[}\u0002\u0005\"\u0002(\u0001\t\u0003A\u0013A\u0004;fgR\u0014V-\\8wK.+\u0017p\u001d\u0015\u0003\u001b6BQ!\u0015\u0001\u0005\u0002!\nq\u0002^3tiB\u0013XMZ5yK\u0012l\u0015\r\u001d\u0015\u0003!6BQ\u0001\u0016\u0001\u0005\nU\u000b1\u0003^3ti\u0006\u0013(/Y=WC2LG-\u0019;j_:$B!\u000b,\\A\")qk\u0015a\u00011\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005aI\u0016B\u0001.\u0003\u0005Q!Um]2sSB$xN\u001d)s_B,'\u000f^5fg\")Al\u0015a\u0001;\u0006IQ.\u001b8MK:<G\u000f\u001b\t\u0003\u001fyK!a\u0018\t\u0003\u0007%sG\u000fC\u0003b'\u0002\u0007Q,A\u0005nCbdUM\\4uQ\u0002")
public class DescriptorPropertiesTest {
    private final String ARRAY_KEY;

    private String ARRAY_KEY() {
        return this.ARRAY_KEY;
    }

    @Test
    public void testEquals() {
        DescriptorProperties properties1 = new DescriptorProperties();
        properties1.putString("hello1", "12");
        properties1.putString("hello2", "13");
        properties1.putString("hello3", "14");
        DescriptorProperties properties2 = new DescriptorProperties();
        properties2.putString("hello1", "12");
        properties2.putString("hello2", "13");
        properties2.putString("hello3", "14");
        DescriptorProperties properties3 = new DescriptorProperties();
        properties3.putString("hello1", "12");
        properties3.putString("hello3", "14");
        properties3.putString("hello2", "13");
        Assert.assertEquals((Object)properties1, (Object)properties2);
        Assert.assertEquals((Object)properties1, (Object)properties3);
    }

    @Test
    public void testMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        this.testArrayValidation(properties, 0, Integer.MAX_VALUE);
    }

    @Test
    public void testArrayValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".0").toString(), "12");
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".1").toString(), "42");
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".2").toString(), "66");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assert.assertEquals(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{12, 42, 66})), (Object)properties.getArray(this.ARRAY_KEY(), JavaScalaConversionUtil$.MODULE$.toJava((Function1 & java.io.Serializable & Serializable)key -> BoxesRunTime.boxToInteger((int)properties.getInt(key)))));
    }

    @Test
    public void testArraySingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(this.ARRAY_KEY(), "12");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
        Assert.assertEquals(Collections.singletonList(BoxesRunTime.boxToInteger((int)12)), (Object)properties.getArray(this.ARRAY_KEY(), JavaScalaConversionUtil$.MODULE$.toJava((Function1 & java.io.Serializable & Serializable)key -> BoxesRunTime.boxToInteger((int)properties.getInt(key)))));
    }

    @Test(expected=ValidationException.class)
    public void testArrayInvalidValues() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".0").toString(), "12");
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".1").toString(), "INVALID");
        properties.putString(new StringBuilder(2).append(this.ARRAY_KEY()).append(".2").toString(), "66");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test(expected=ValidationException.class)
    public void testArrayInvalidSingleValue() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString(this.ARRAY_KEY(), "INVALID");
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test(expected=ValidationException.class)
    public void testInvalidMissingArray() {
        DescriptorProperties properties = new DescriptorProperties();
        this.testArrayValidation(properties, 1, Integer.MAX_VALUE);
    }

    @Test
    public void testRemoveKeys() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        DescriptorProperties actual = properties.withoutKeys(Arrays.asList((Object[])new String[]{"hello1", "hello3"}));
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("hello2", "13");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testPrefixedMap() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("hello1", "12");
        properties.putString("hello2", "13");
        properties.putString("hello3", "14");
        Map actual = properties.asPrefixedMap("prefix.");
        DescriptorProperties expected = new DescriptorProperties();
        expected.putString("prefix.hello1", "12");
        expected.putString("prefix.hello2", "13");
        expected.putString("prefix.hello3", "14");
        Assert.assertEquals((Object)expected.asMap(), (Object)actual);
    }

    private void testArrayValidation(DescriptorProperties properties, int minLength, int maxLength) {
        Function1 & java.io.Serializable & Serializable validator = (Function1 & java.io.Serializable & Serializable)key -> {
            properties.validateInt(key, false);
            return BoxedUnit.UNIT;
        };
        properties.validateArray(this.ARRAY_KEY(), JavaScalaConversionUtil$.MODULE$.toJava((Function1)validator), minLength, maxLength);
    }

    public DescriptorPropertiesTest() {
        this.ARRAY_KEY = "my-array";
    }
}

