/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.TableAlreadyExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ExternalCatalogTable$;
import org.apache.flink.table.catalog.InMemoryExternalCatalog;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u00111$\u00138NK6|'/_#yi\u0016\u0014h.\u00197DCR\fGn\\4UKN$(BA\u0002\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00057\u0005aA-\u0019;bE\u0006\u001cXMT1nKV\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\rM#(/\u001b8h\u0011\u0019)\u0003\u0001)A\u00059\u0005iA-\u0019;bE\u0006\u001cXMT1nK\u0002B\u0011b\u0001\u0001A\u0002\u0003\u0007I\u0011B\u0014\u0016\u0003!\u0002\"\u0001G\u0015\n\u0005)\u0012!aF%o\u001b\u0016lwN]=FqR,'O\\1m\u0007\u0006$\u0018\r\\8h\u0011%a\u0003\u00011AA\u0002\u0013%Q&A\u0006dCR\fGn\\4`I\u0015\fHC\u0001\u00182!\tyq&\u0003\u00021!\t!QK\\5u\u0011\u001d\u00114&!AA\u0002!\n1\u0001\u001f\u00132\u0011%!\u0004\u00011A\u0001B\u0003&\u0001&\u0001\u0005dCR\fGn\\4!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0015\u0019X\r^+q)\u0005q\u0003FA\u001b:!\tQT(D\u0001<\u0015\ta$\"A\u0003kk:LG/\u0003\u0002?w\t1!)\u001a4pe\u0016DQ\u0001\u0011\u0001\u0005\u0002]\nq\u0002^3ti\u000e\u0013X-\u0019;f)\u0006\u0014G.\u001a\u0015\u0003\u007f\t\u0003\"AO\"\n\u0005\u0011[$\u0001\u0002+fgRDQA\u0012\u0001\u0005\u0002]\na\u0003^3ti\u000e\u0013X-\u0019;f\u000bbL7\u000f^3e)\u0006\u0014G.\u001a\u0015\u0005\u000b\nC\u0015*\u0001\u0005fqB,7\r^3eG\u0005Q\u0005CA&O\u001b\u0005a%BA'\u0005\u0003\r\t\u0007/[\u0005\u0003\u001f2\u0013!\u0004V1cY\u0016\fEN]3bIf,\u00050[:u\u000bb\u001cW\r\u001d;j_:DQ!\u0015\u0001\u0005\u0002]\nA\u0002^3ti\u001e+G\u000fV1cY\u0016D#\u0001\u0015\"\t\u000bQ\u0003A\u0011A\u001c\u0002)Q,7\u000f^$fi:{G/\u0012=jgR$\u0016M\u00197fQ\u0011\u0019&\t\u0013,$\u0003]\u0003\"a\u0013-\n\u0005ec%A\u0006+bE2,gj\u001c;Fq&\u001cH/\u0012=dKB$\u0018n\u001c8\t\u000bm\u0003A\u0011A\u001c\u0002\u001dQ,7\u000f^!mi\u0016\u0014H+\u00192mK\"\u0012!L\u0011\u0005\u0006=\u0002!\taN\u0001\u0017i\u0016\u001cH/\u00117uKJtu\u000e^#ySN$H+\u00192mK\"\"QL\u0011%W\u0011\u0015\t\u0007\u0001\"\u00018\u00035!Xm\u001d;Ee>\u0004H+\u00192mK\"\u0012\u0001M\u0011\u0005\u0006I\u0002!\taN\u0001\u0016i\u0016\u001cH\u000f\u0012:pa:{G/\u0012=jgR$\u0016M\u00197fQ\u0011\u0019'\t\u0013,\t\u000b\u001d\u0004A\u0011A\u001c\u0002/Q,7\u000f^$fi:{G/\u0012=jgR$\u0015\r^1cCN,\u0007\u0006\u00024C\u0011&\u001c\u0013A\u001b\t\u0003\u0017.L!\u0001\u001c'\u00031\r\u000bG/\u00197pO:{G/\u0012=jgR,\u0005pY3qi&|g\u000eC\u0003o\u0001\u0011\u0005q'\u0001\nuKN$8I]3bi\u0016$\u0015\r^1cCN,\u0007FA7C\u0011\u0015\t\b\u0001\"\u00018\u0003e!Xm\u001d;De\u0016\fG/Z#ySN$X\r\u001a#bi\u0006\u0014\u0017m]3)\tA\u0014\u0005j]\u0012\u0002iB\u00111*^\u0005\u0003m2\u0013AdQ1uC2|w-\u00117sK\u0006$\u00170\u0012=jgR,\u0005pY3qi&|g\u000eC\u0003y\u0001\u0011\u0005q'A\tuKN$h*Z:uK\u0012\u001c\u0015\r^1m_\u001eD#a\u001e\"\t\u000bm\u0004A\u0011\u0002?\u0002'\r\u0014X-\u0019;f)\u0006\u0014G.Z%ogR\fgnY3\u0015\u0003u\u0004\"\u0001\u0007@\n\u0005}\u0014!\u0001F#yi\u0016\u0014h.\u00197DCR\fGn\\4UC\ndW\r\u0003\u0004|\u0001\u0011%\u00111\u0001\u000b\u0006{\u0006\u0015\u00111\u0005\u0005\t\u0003\u000f\t\t\u00011\u0001\u0002\n\u0005Qa-[3mI:\u000bW.Z:\u0011\u000b=\tY!a\u0004\n\u0007\u00055\u0001CA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0012\u0005}a\u0002BA\n\u00037\u00012!!\u0006\u0011\u001b\t\t9BC\u0002\u0002\u001a1\ta\u0001\u0010:p_Rt\u0014bAA\u000f!\u00051\u0001K]3eK\u001aL1aIA\u0011\u0015\r\ti\u0002\u0005\u0005\t\u0003K\t\t\u00011\u0001\u0002(\u0005Qa-[3mIRK\b/Z:\u0011\u000b=\tY!!\u000b1\t\u0005-\u0012\u0011\t\t\u0007\u0003[\tI$!\u0010\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t\u0001\u0002^=qK&tgm\u001c\u0006\u0005\u0003k\t9$\u0001\u0004d_6lwN\u001c\u0006\u0003\u001b\u001aIA!a\u000f\u00020\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0005\u0003\u0002@\u0005\u0005C\u0002\u0001\u0003\r\u0003\u0007\n\u0019#!A\u0001\u0002\u000b\u0005\u0011Q\t\u0002\u0004?\u0012\n\u0014\u0003BA$\u0003\u001b\u00022aDA%\u0013\r\tY\u0005\u0005\u0002\b\u001d>$\b.\u001b8h!\ry\u0011qJ\u0005\u0004\u0003#\u0002\"aA!os\u001a1\u0011Q\u000b\u0001\u0001\u0003/\u0012\u0011\u0003V3ti\u000e{gN\\3di>\u0014H)Z:d'\u0011\t\u0019&!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018\u0005\u0003-!Wm]2sSB$xN]:\n\t\u0005\r\u0014Q\f\u0002\u0014\u0007>tg.Z2u_J$Um]2sSB$xN\u001d\u0005\b+\u0005MC\u0011AA4)\t\tI\u0007\u0005\u0003\u0002l\u0005MS\"\u0001\u0001\t\u0011\u0005=\u00141\u000bC)\u0003c\nQ\u0003^8D_:tWm\u0019;peB\u0013x\u000e]3si&,7\u000f\u0006\u0002\u0002tAA\u0011QOA>\u0003\u001f\ty!\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u0011\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003{\n9HA\u0002NCB\u0004")
public class InMemoryExternalCatalogTest {
    private final String databaseName;
    private InMemoryExternalCatalog catalog;

    private String databaseName() {
        return this.databaseName;
    }

    private InMemoryExternalCatalog catalog() {
        return this.catalog;
    }

    private void catalog_$eq(InMemoryExternalCatalog x$1) {
        this.catalog = x$1;
    }

    @Before
    public void setUp() {
        this.catalog_$eq(new InMemoryExternalCatalog(this.databaseName()));
    }

    @Test
    public void testCreateTable() {
        Assert.assertTrue((boolean)this.catalog().listTables().isEmpty());
        this.catalog().createTable("t1", this.createTableInstance(), false);
        List tables = this.catalog().listTables();
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)"t1", tables.get(0));
    }

    @Test(expected=TableAlreadyExistException.class)
    public void testCreateExistedTable() {
        String tableName = "t1";
        this.catalog().createTable(tableName, this.createTableInstance(), false);
        this.catalog().createTable(tableName, this.createTableInstance(), false);
    }

    @Test
    public void testGetTable() {
        ExternalCatalogTable originTable = this.createTableInstance();
        this.catalog().createTable("t1", originTable, false);
        Assert.assertEquals((Object)this.catalog().getTable("t1"), (Object)originTable);
    }

    @Test(expected=TableNotExistException.class)
    public void testGetNotExistTable() {
        this.catalog().getTable("nonexisted");
    }

    @Test
    public void testAlterTable() {
        String tableName = "t1";
        ExternalCatalogTable table = this.createTableInstance();
        this.catalog().createTable(tableName, table, false);
        Assert.assertEquals((Object)this.catalog().getTable(tableName), (Object)table);
        ExternalCatalogTable newTable = this.createTableInstance((String[])((Object[])new String[]{"number"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT()}));
        this.catalog().alterTable(tableName, newTable, false);
        ExternalCatalogTable currentTable = this.catalog().getTable(tableName);
        Assert.assertNotEquals((Object)table, (Object)currentTable);
        Assert.assertEquals((Object)newTable, (Object)currentTable);
    }

    @Test(expected=TableNotExistException.class)
    public void testAlterNotExistTable() {
        this.catalog().alterTable("nonexisted", this.createTableInstance(), false);
    }

    @Test
    public void testDropTable() {
        String tableName = "t1";
        this.catalog().createTable(tableName, this.createTableInstance(), false);
        Assert.assertTrue((boolean)this.catalog().listTables().contains(tableName));
        this.catalog().dropTable(tableName, false);
        Assert.assertFalse((boolean)this.catalog().listTables().contains(tableName));
    }

    @Test(expected=TableNotExistException.class)
    public void testDropNotExistTable() {
        this.catalog().dropTable("nonexisted", false);
    }

    @Test(expected=CatalogNotExistException.class)
    public void testGetNotExistDatabase() {
        this.catalog().getSubCatalog("notexistedDb");
    }

    @Test
    public void testCreateDatabase() {
        this.catalog().createSubCatalog("db2", (ExternalCatalog)new InMemoryExternalCatalog("db2"), false);
        Assert.assertEquals((long)1L, (long)this.catalog().listSubCatalogs().size());
    }

    @Test(expected=CatalogAlreadyExistException.class)
    public void testCreateExistedDatabase() {
        this.catalog().createSubCatalog("existed", (ExternalCatalog)new InMemoryExternalCatalog("existed"), false);
        Assert.assertNotNull((Object)this.catalog().getSubCatalog("existed"));
        List databases = this.catalog().listSubCatalogs();
        Assert.assertEquals((long)1L, (long)databases.size());
        Assert.assertEquals((Object)"existed", databases.get(0));
        this.catalog().createSubCatalog("existed", (ExternalCatalog)new InMemoryExternalCatalog("existed"), false);
    }

    @Test
    public void testNestedCatalog() {
        InMemoryExternalCatalog sub = new InMemoryExternalCatalog("sub");
        InMemoryExternalCatalog sub1 = new InMemoryExternalCatalog("sub1");
        this.catalog().createSubCatalog("sub", (ExternalCatalog)sub, false);
        sub.createSubCatalog("sub1", (ExternalCatalog)sub1, false);
        sub1.createTable("table", this.createTableInstance(), false);
        List tables = this.catalog().getSubCatalog("sub").getSubCatalog("sub1").listTables();
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)"table", tables.get(0));
    }

    private ExternalCatalogTable createTableInstance() {
        TestConnectorDesc connDesc = new TestConnectorDesc();
        Schema schemaDesc = new Schema().field("first", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO).field("second", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        return ExternalCatalogTable$.MODULE$.builder((ConnectorDescriptor)connDesc).withSchema(schemaDesc).asTableSource();
    }

    private ExternalCatalogTable createTableInstance(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        TestConnectorDesc connDesc = new TestConnectorDesc();
        Schema schemaDesc = new Schema();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fieldName = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Schema schema = schemaDesc.field(fieldName, fieldTypes[index]);
            return schema;
        });
        return ExternalCatalogTable$.MODULE$.builder((ConnectorDescriptor)connDesc).withSchema(schemaDesc).asTableSource();
    }

    public InMemoryExternalCatalogTest() {
        this.databaseName = "db1";
    }

    public class TestConnectorDesc
    extends ConnectorDescriptor {
        public Map<String, String> toConnectorProperties() {
            return Collections.emptyMap();
        }

        public /* synthetic */ InMemoryExternalCatalogTest org$apache$flink$table$catalog$InMemoryExternalCatalogTest$TestConnectorDesc$$$outer() {
            return InMemoryExternalCatalogTest.this;
        }

        public TestConnectorDesc() {
            if (InMemoryExternalCatalogTest.this == null) {
                throw null;
            }
            super("test", 1, false);
        }
    }
}

