/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.calcite.FlinkTypeSystem;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogSchema$;
import org.apache.flink.table.plan.schema.TableSourceSinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\tIR\t\u001f;fe:\fGnQ1uC2|wmU2iK6\fG+Z:u\u0015\t\u0019A!A\u0004dCR\fGn\\4\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011B\u000e\u0002\u0015M\u001c\u0007.Z7b\u001d\u0006lW-F\u0001\u001d!\tibE\u0004\u0002\u001fIA\u0011qDI\u0007\u0002A)\u0011\u0011\u0005D\u0001\u0007yI|w\u000e\u001e \u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\tBaA\u000b\u0001!\u0002\u0013a\u0012aC:dQ\u0016l\u0017MT1nK\u0002B\u0011\u0002\f\u0001A\u0002\u0003\u0007I\u0011B\u0017\u0002+\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e\u001c6\r[3nCV\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u000511o\u00195f[\u0006T!a\r\u0005\u0002\u000f\r\fGnY5uK&\u0011Q\u0007\r\u0002\u000b'\u000eDW-\\1QYV\u001c\b\"C\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u00039\u0003e)\u0007\u0010^3s]\u0006d7)\u0019;bY><7k\u00195f[\u0006|F%Z9\u0015\u0005ej\u0004C\u0001\u001e<\u001b\u0005\u0011\u0013B\u0001\u001f#\u0005\u0011)f.\u001b;\t\u000fy2\u0014\u0011!a\u0001]\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0001\u0003\u0001\u0019!A!B\u0013q\u0013AF3yi\u0016\u0014h.\u00197DCR\fGn\\4TG\",W.\u0019\u0011\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0015\u0001F2bY\u000eLG/Z\"bi\u0006dwn\u001a*fC\u0012,'/F\u0001E!\t)\u0005*D\u0001G\u0015\t9%'A\u0004qe\u0016\u0004\u0018M]3\n\u0005%3%\u0001F\"bY\u000eLG/Z\"bi\u0006dwn\u001a*fC\u0012,'\u000fC\u0005L\u0001\u0001\u0007\t\u0019!C\u0005\u0019\u0006A2-\u00197dSR,7)\u0019;bY><'+Z1eKJ|F%Z9\u0015\u0005ej\u0005b\u0002 K\u0003\u0003\u0005\r\u0001\u0012\u0005\n\u001f\u0002\u0001\r\u0011!Q!\n\u0011\u000bQcY1mG&$XmQ1uC2|wMU3bI\u0016\u0014\b\u0005C\u0004R\u0001\t\u0007I\u0011\u0002*\u0002\u0005\u0011\u0014W#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001\u00027b]\u001eT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002(+\"11\f\u0001Q\u0001\nM\u000b1\u0001\u001a2!\u0011\u001di\u0006A1A\u0005\nI\u000b!\u0001\u001e2\t\r}\u0003\u0001\u0015!\u0003T\u0003\r!(\r\t\u0005\u0006C\u0002!\tAY\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u0012\u0001\r\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O*\tQA[;oSRL!!\u001b4\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0001c\u0003A!Xm\u001d;HKR\u001cVOY*dQ\u0016l\u0017\r\u000b\u0002k[B\u0011QM\\\u0005\u0003_\u001a\u0014A\u0001V3ti\")\u0011\u000f\u0001C\u0001E\u0006aA/Z:u\u000f\u0016$H+\u00192mK\"\u0012\u0001/\u001c\u0005\u0006i\u0002!\tAY\u0001\u0015i\u0016\u001cHoR3u\u001d>$X\t_5tiR\u000b'\r\\3)\u0005Ml\u0007")
public class ExternalCatalogSchemaTest
extends TableTestBase {
    private final String schemaName;
    private SchemaPlus externalCatalogSchema;
    private CalciteCatalogReader calciteCatalogReader;
    private final String db;
    private final String tb;

    private String schemaName() {
        return this.schemaName;
    }

    private SchemaPlus externalCatalogSchema() {
        return this.externalCatalogSchema;
    }

    private void externalCatalogSchema_$eq(SchemaPlus x$1) {
        this.externalCatalogSchema = x$1;
    }

    private CalciteCatalogReader calciteCatalogReader() {
        return this.calciteCatalogReader;
    }

    private void calciteCatalogReader_$eq(CalciteCatalogReader x$1) {
        this.calciteCatalogReader = x$1;
    }

    private String db() {
        return this.db;
    }

    private String tb() {
        return this.tb;
    }

    @Before
    public void setUp() {
        SchemaPlus rootSchemaPlus = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        ExternalCatalog catalog = CommonTestData$.MODULE$.getInMemoryTestCatalog(true);
        ExternalCatalogSchema$.MODULE$.registerCatalog((TableEnvironment)this.streamTestUtil().tableEnv(), rootSchemaPlus, this.schemaName(), catalog);
        this.externalCatalogSchema_$eq(rootSchemaPlus.getSubSchema("schemaName"));
        FlinkTypeFactory typeFactory = new FlinkTypeFactory((RelDataTypeSystem)new FlinkTypeSystem());
        Properties prop = new Properties();
        prop.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), "false");
        CalciteConnectionConfigImpl calciteConnConfig = new CalciteConnectionConfigImpl(prop);
        this.calciteCatalogReader_$eq(new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchemaPlus), Collections.emptyList(), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)calciteConnConfig));
    }

    @Test
    public void testGetSubSchema() {
        java.util.List allSchemaObjectNames = this.calciteCatalogReader().getAllSchemaObjectNames((java.util.List)Lists.newArrayList((Object[])new String[]{this.schemaName()}));
        Set subSchemas = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allSchemaObjectNames).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogSchemaTest.$anonfun$testGetSubSchema$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.getFullyQualifiedNames()).asScala()).toList(), Buffer$.MODULE$.canBuildFrom())).toSet();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{new .colon.colon((Object)this.schemaName(), (List)Nil$.MODULE$), new .colon.colon((Object)this.schemaName(), (List)new .colon.colon((Object)"db1", (List)Nil$.MODULE$)), new .colon.colon((Object)this.schemaName(), (List)new .colon.colon((Object)"db2", (List)Nil$.MODULE$)), new .colon.colon((Object)this.schemaName(), (List)new .colon.colon((Object)"db3", (List)Nil$.MODULE$))}));
        Set set = subSchemas;
        Assert.assertTrue((!(genTraversable != null ? !genTraversable.equals(set) : set != null) ? 1 : 0) != 0);
    }

    @Test
    public void testGetTable() {
        Some some;
        TableSourceTable tst;
        Prepare.PreparingTable relOptTable = this.calciteCatalogReader().getTable((java.util.List)Lists.newArrayList((Object[])new String[]{this.schemaName(), this.db(), this.tb()}));
        Assert.assertNotNull((Object)relOptTable);
        TableSourceSinkTable tableSourceSinkTable = (TableSourceSinkTable)relOptTable.unwrap(TableSourceSinkTable.class);
        Option option = tableSourceSinkTable.tableSourceTable();
        if (option instanceof Some && (tst = (TableSourceTable)(some = (Some)option).value()) != null) {
            TableSourceTable tableSourceTable = tst;
            Assert.assertTrue((boolean)(tableSourceTable.tableSource() instanceof CsvTableSource));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Assert.fail((String)"unexpected table type!");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Test
    public void testGetNotExistTable() {
        Prepare.PreparingTable relOptTable = this.calciteCatalogReader().getTable((java.util.List)Lists.newArrayList((Object[])new String[]{this.schemaName(), this.db(), "nonexist-tb"}));
        Assert.assertNull((Object)relOptTable);
    }

    public static final /* synthetic */ boolean $anonfun$testGetSubSchema$1(SqlMoniker x$1) {
        return x$1.getType().equals((Object)SqlMonikerType.SCHEMA);
    }

    public ExternalCatalogSchemaTest() {
        this.schemaName = "test";
        this.db = "db1";
        this.tb = "tb1";
    }
}

