/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.rules.CalcMergeRule;
import org.apache.calcite.rel.rules.CalcSplitRule;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfigBuilder;
import org.apache.flink.table.plan.rules.datastream.DataStreamRetractionRules$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\tA2)\u00197dSR,7i\u001c8gS\u001e\u0014U/\u001b7eKJ$Vm\u001d;\u000b\u0005\r!\u0011aB2bY\u000eLG/\u001a\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t\u0001\u0003^3ti\u0012+g-Y;miJ+H.Z:\u0015\u0003q\u0001\"aD\u000f\n\u0005y\u0001\"\u0001B+oSRD#!\u0007\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rR\u0011!\u00026v]&$\u0018BA\u0013#\u0005\u0011!Vm\u001d;\t\u000b\u001d\u0002A\u0011A\u000e\u0002\u0013Q,7\u000f\u001e*vY\u0016\u001c\bF\u0001\u0014!\u0011\u0015Q\u0003\u0001\"\u0001\u001c\u0003u!Xm\u001d;SKBd\u0017mY3O_Jl\u0017\r\\5{CRLwN\u001c*vY\u0016\u001c\bFA\u0015!\u0011\u0015i\u0003\u0001\"\u0001\u001c\u0003\u0001\"Xm\u001d;SKBd\u0017mY3O_Jl\u0017\r\\5{CRLwN\\!eIJ+H.Z:)\u00051\u0002\u0003\"\u0002\u0019\u0001\t\u0003Y\u0012!\u0007;fgR\fE\r\u001a(pe6\fG.\u001b>bi&|gNU;mKND#a\f\u0011\t\u000bM\u0002A\u0011A\u000e\u00029Q,7\u000f^!eI\u0006#GMT8s[\u0006d\u0017N_1uS>t'+\u001e7fg\"\u0012!\u0007\t\u0005\u0006m\u0001!\taG\u0001$i\u0016\u001cHOU3qY\u0006\u001cW\rT8hS\u000e\fGn\u00149uS6L'0\u0019;j_:\u0014V\u000f\\3tQ\t)\u0004\u0005C\u0003:\u0001\u0011\u00051$\u0001\u0014uKN$(+\u001a9mC\u000e,Gj\\4jG\u0006dw\n\u001d;j[&T\u0018\r^5p]\u0006#GMU;mKND#\u0001\u000f\u0011\t\u000bq\u0002A\u0011A\u000e\u0002?Q,7\u000f^!eI2{w-[2bY>\u0003H/[7ju\u0006$\u0018n\u001c8Sk2,7\u000f\u000b\u0002<A!)q\b\u0001C\u00017\u0005!C/Z:u%\u0016\u0004H.Y2f!\"L8/[2bY>\u0003H/[7ju\u0006$\u0018n\u001c8Sk2,7\u000f\u000b\u0002?A!)!\t\u0001C\u00017\u00059C/Z:u%\u0016\u0004H.Y2f!\"L8/[2bY>\u0003H/[7ju\u0006$\u0018n\u001c8BI\u0012\u0014V\u000f\\3tQ\t\t\u0005\u0005C\u0003F\u0001\u0011\u00051$\u0001\u0011uKN$\u0018\t\u001a3QQf\u001c\u0018nY1m\u001fB$\u0018.\\5{CRLwN\u001c*vY\u0016\u001c\bF\u0001#!\u0011\u0015A\u0005\u0001\"\u0001\u001c\u0003i!Xm\u001d;SKBd\u0017mY3EK\u000e|'/\u0019;j_:\u0014V\u000f\\3tQ\t9\u0005\u0005C\u0003L\u0001\u0011\u00051$A\u000fuKN$(+\u001a9mC\u000e,G)Z2pe\u0006$\u0018n\u001c8BI\u0012\u0014V\u000f\\3tQ\tQ\u0005\u0005C\u0003O\u0001\u0011\u00051$\u0001\fuKN$\u0018\t\u001a3EK\u000e|'/\u0019;j_:\u0014V\u000f\\3tQ\ti\u0005\u0005C\u0003R\u0001\u0011\u00051$A\ruKN$\u0018\t\u001a3BI\u0012$UmY8sCRLwN\u001c*vY\u0016\u001c\bF\u0001)!\u0011\u0015!\u0006\u0001\"\u0001\u001c\u0003a!Xm\u001d;EK\u001a\fW\u000f\u001c;Pa\u0016\u0014\u0018\r^8s)\u0006\u0014G.\u001a\u0015\u0003'\u0002BQa\u0016\u0001\u0005\u0002m\t\u0001\u0004^3tiJ+\u0007\u000f\\1dK>\u0003XM]1u_J$\u0016M\u00197fQ\t1\u0006\u0005C\u0003[\u0001\u0011\u00051$A\u000euKN$(+\u001a9mC\u000e,\u0017\t\u001a3Pa\u0016\u0014\u0018\r^8s)\u0006\u0014G.\u001a\u0015\u00033\u0002BQ!\u0018\u0001\u0005\u0002m\tA\u0003^3ti\u0006#Gm\u00149fe\u0006$xN\u001d+bE2,\u0007F\u0001/!\u0011\u0015\u0001\u0007\u0001\"\u0001\u001c\u0003]!Xm\u001d;BI\u0012\fE\rZ(qKJ\fGo\u001c:UC\ndW\r\u000b\u0002`A!)1\r\u0001C\u00017\u0005\u0011C/Z:u%\u0016\u0004H.Y2f'FdGk\u001c*fY\u000e{gN^3si\u0016\u00148i\u001c8gS\u001eD#A\u0019\u0011")
public class CalciteConfigBuilderTest {
    @Test
    public void testDefaultRules() {
        CalciteConfig cc = new CalciteConfigBuilder().build();
        Assert.assertFalse((boolean)cc.replacesNormRuleSet());
        Assert.assertFalse((boolean)cc.getNormRuleSet().isDefined());
        Assert.assertFalse((boolean)cc.replacesLogicalOptRuleSet());
        Assert.assertFalse((boolean)cc.getLogicalOptRuleSet().isDefined());
        Assert.assertFalse((boolean)cc.replacesPhysicalOptRuleSet());
        Assert.assertFalse((boolean)cc.getPhysicalOptRuleSet().isDefined());
        Assert.assertFalse((boolean)cc.replacesDecoRuleSet());
        Assert.assertFalse((boolean)cc.getDecoRuleSet().isDefined());
    }

    @Test
    public void testRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE})).replaceLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).replacePhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).replaceDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()})).build();
        Assert.assertFalse((boolean)cc.replacesNormRuleSet());
        Assert.assertTrue((boolean)cc.getNormRuleSet().isDefined());
        Assert.assertTrue((boolean)cc.replacesLogicalOptRuleSet());
        Assert.assertTrue((boolean)cc.getLogicalOptRuleSet().isDefined());
        Assert.assertTrue((boolean)cc.replacesPhysicalOptRuleSet());
        Assert.assertTrue((boolean)cc.getPhysicalOptRuleSet().isDefined());
        Assert.assertTrue((boolean)cc.replacesDecoRuleSet());
        Assert.assertTrue((boolean)cc.getDecoRuleSet().isDefined());
    }

    @Test
    public void testReplaceNormalizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesNormRuleSet()));
        Assert.assertTrue((boolean)cc.getNormRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getNormRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)ReduceExpressionsRule.FILTER_INSTANCE));
    }

    @Test
    public void testReplaceNormalizationAddRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE})).addNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.PROJECT_INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesNormRuleSet()));
        Assert.assertTrue((boolean)cc.getNormRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getNormRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)2L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)ReduceExpressionsRule.FILTER_INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)ReduceExpressionsRule.PROJECT_INSTANCE));
    }

    @Test
    public void testAddNormalizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesNormRuleSet()));
        Assert.assertTrue((boolean)cc.getNormRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getNormRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)ReduceExpressionsRule.FILTER_INSTANCE));
    }

    @Test
    public void testAddAddNormalizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE})).addNormRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{ReduceExpressionsRule.PROJECT_INSTANCE, ReduceExpressionsRule.CALC_INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesNormRuleSet()));
        Assert.assertTrue((boolean)cc.getNormRuleSet().isDefined());
        List cList = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getNormRuleSet().get()).iterator()).asScala()).toList();
        Assert.assertEquals((long)3L, (long)cList.size());
        Assert.assertEquals((Object)cList.head(), (Object)ReduceExpressionsRule.FILTER_INSTANCE);
        Assert.assertEquals((Object)cList.apply(1), (Object)ReduceExpressionsRule.PROJECT_INSTANCE);
        Assert.assertEquals((Object)cList.apply(2), (Object)ReduceExpressionsRule.CALC_INSTANCE);
    }

    @Test
    public void testReplaceLogicalOptimizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesLogicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getLogicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getLogicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
    }

    @Test
    public void testReplaceLogicalOptimizationAddRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).addLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CalcMergeRule.INSTANCE, CalcSplitRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesLogicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getLogicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getLogicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)3L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcSplitRule.INSTANCE));
    }

    @Test
    public void testAddLogicalOptimizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).addLogicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CalcMergeRule.INSTANCE, CalcSplitRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesLogicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getLogicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getLogicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)3L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcSplitRule.INSTANCE));
    }

    @Test
    public void testReplacePhysicalOptimizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replacePhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesPhysicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getPhysicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getPhysicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
    }

    @Test
    public void testReplacePhysicalOptimizationAddRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replacePhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).addPhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CalcMergeRule.INSTANCE, CalcSplitRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesPhysicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getPhysicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getPhysicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)3L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcSplitRule.INSTANCE));
    }

    @Test
    public void testAddPhysicalOptimizationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addPhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE})).addPhysicalOptRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CalcMergeRule.INSTANCE, CalcSplitRule.INSTANCE})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesPhysicalOptRuleSet()));
        Assert.assertTrue((boolean)cc.getPhysicalOptRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getPhysicalOptRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)3L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)FilterMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcMergeRule.INSTANCE));
        Assert.assertTrue((boolean)cSet.contains((Object)CalcSplitRule.INSTANCE));
    }

    @Test
    public void testReplaceDecorationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesDecoRuleSet()));
        Assert.assertTrue((boolean)cc.getDecoRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getDecoRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()));
    }

    @Test
    public void testReplaceDecorationAddRules() {
        CalciteConfig cc = new CalciteConfigBuilder().replaceDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()})).addDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.UPDATES_AS_RETRACTION_INSTANCE()})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesDecoRuleSet()));
        Assert.assertTrue((boolean)cc.getDecoRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getDecoRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)2L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()));
        Assert.assertTrue((boolean)cSet.contains((Object)DataStreamRetractionRules$.MODULE$.UPDATES_AS_RETRACTION_INSTANCE()));
    }

    @Test
    public void testAddDecorationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesDecoRuleSet()));
        Assert.assertTrue((boolean)cc.getDecoRuleSet().isDefined());
        Set cSet = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getDecoRuleSet().get()).iterator()).asScala()).toSet();
        Assert.assertEquals((long)1L, (long)cSet.size());
        Assert.assertTrue((boolean)cSet.contains((Object)DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()));
    }

    @Test
    public void testAddAddDecorationRules() {
        CalciteConfig cc = new CalciteConfigBuilder().addDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE()})).addDecoRuleSet(RuleSets.ofList((RelOptRule[])new RelOptRule[]{DataStreamRetractionRules$.MODULE$.UPDATES_AS_RETRACTION_INSTANCE(), DataStreamRetractionRules$.MODULE$.ACCMODE_INSTANCE()})).build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesDecoRuleSet()));
        Assert.assertTrue((boolean)cc.getDecoRuleSet().isDefined());
        List cList = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((Iterable)cc.getDecoRuleSet().get()).iterator()).asScala()).toList();
        Assert.assertEquals((long)3L, (long)cList.size());
        Assert.assertEquals((Object)cList.head(), (Object)DataStreamRetractionRules$.MODULE$.DEFAULT_RETRACTION_INSTANCE());
        Assert.assertEquals((Object)cList.apply(1), (Object)DataStreamRetractionRules$.MODULE$.UPDATES_AS_RETRACTION_INSTANCE());
        Assert.assertEquals((Object)cList.apply(2), (Object)DataStreamRetractionRules$.MODULE$.ACCMODE_INSTANCE());
    }

    @Test
    public void testDefaultOperatorTable() {
        CalciteConfig cc = new CalciteConfigBuilder().build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertFalse((boolean)cc.getSqlOperatorTable().isDefined());
    }

    @Test
    public void testReplaceOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlOperatorTable((SqlOperatorTable)oracleTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)oracleOps.size(), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplaceAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        SqlStdOperatorTable stdTable = new SqlStdOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlOperatorTable((SqlOperatorTable)oracleTable).addSqlOperatorTable((SqlOperatorTable)stdTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Buffer stdOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(stdTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)(oracleOps.size() + stdOps.size()), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
        stdOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceAddOperatorTable$2(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().addSqlOperatorTable((SqlOperatorTable)oracleTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)oracleOps.size(), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        SqlStdOperatorTable stdTable = new SqlStdOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().addSqlOperatorTable((SqlOperatorTable)oracleTable).addSqlOperatorTable((SqlOperatorTable)stdTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Buffer stdOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(stdTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)(oracleOps.size() + stdOps.size()), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
        stdOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddAddOperatorTable$2(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplaceSqlToRelConverterConfig() {
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).withInSubQueryThreshold(Integer.MAX_VALUE).build();
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlToRelConverterConfig(config).build();
        Assert.assertTrue((boolean)cc.getSqlToRelConverterConfig().isDefined());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((SqlToRelConverter.Config)cc.getSqlToRelConverterConfig().get()).getInSubQueryThreshold());
    }

    public static final /* synthetic */ void $anonfun$testReplaceOperatorTable$1(Set ops$1, SqlOperator o) {
        Assert.assertTrue((boolean)ops$1.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testReplaceAddOperatorTable$1(Set ops$2, SqlOperator o) {
        Assert.assertTrue((boolean)ops$2.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testReplaceAddOperatorTable$2(Set ops$2, SqlOperator o) {
        Assert.assertTrue((boolean)ops$2.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddOperatorTable$1(Set ops$3, SqlOperator o) {
        Assert.assertTrue((boolean)ops$3.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddAddOperatorTable$1(Set ops$4, SqlOperator o) {
        Assert.assertTrue((boolean)ops$4.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddAddOperatorTable$2(Set ops$4, SqlOperator o) {
        Assert.assertTrue((boolean)ops$4.contains((Object)o));
    }
}

