/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.validation;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.sources.CsvTableSource$;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.ExistingField;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.AscendingTimestamps;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;
import org.apache.flink.table.utils.TestTableSourceWithTime;
import org.apache.flink.table.utils.TestTableSourceWithTime$;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u001f\tIB+\u00192mKN{WO]2f-\u0006d\u0017\u000eZ1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0006wC2LG-\u0019;j_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005IB/Z:u+:\u0014Xm]8mm\u0016$7k\u00195f[\u00064\u0015.\u001a7e)\u0005q\u0002CA\t \u0013\t\u0001#C\u0001\u0003V]&$\b\u0006B\u000e#Q%\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\u000b),h.\u001b;\n\u0005\u001d\"#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002UA\u00111\u0006L\u0007\u0002\t%\u0011Q\u0006\u0002\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0006_\u0001!\t!H\u0001\u001ai\u0016\u001cHOT8o\u001b\u0006$8\r[5oO\u001aKW\r\u001c3UsB,7\u000f\u000b\u0003/E!J\u0003\"\u0002\u001a\u0001\t\u0003i\u0012!\u0007;fgRl\u0015\r\u001d9j]\u001e$v.\u00168l]><hNR5fY\u0012DC!\r\u0012)S!)Q\u0007\u0001C\u0001;\u0005yB/Z:u\u001b\u0006\u0004\b/\u001b8h/&$\b.\u00138wC2LGMR5fY\u0012$\u0016\u0010]3)\tQ\u0012\u0003&\u000b\u0005\u0006q\u0001!\t!H\u0001\u001ei\u0016\u001cHOT8o)&lWm\u001d;b[B\u0004&o\\2uS6,g)[3mI\"\"qG\t\u0015*\u0011\u0015Y\u0004\u0001\"\u0001\u001e\u0003q!Xm\u001d;O_:$\u0016.\\3ti\u0006l\u0007OU8xi&lWMR5fY\u0012DCA\u000f\u0012)S!)a\b\u0001C\u0001;\u0005YB/Z:u\r&,G\u000e\u001a*poRLW.Z!oIB\u0013xn\u0019;j[\u0016DC!\u0010\u0012)S!)\u0011\t\u0001C\u0001;\u0005)C/Z:u+:\\gn\\<o)&lWm\u001d;b[B,\u0005\u0010\u001e:bGR|'/\u0011:h\r&,G\u000e\u001a\u0015\u0005\u0001\nB\u0013\u0006C\u0003E\u0001\u0011\u0005Q$A\u0014uKN$h)Y5mS:<G+[7fgR\fW\u000e]#yiJ\f7\r^8s-\u0006d\u0017\u000eZ1uS>t\u0007\u0006B\"#Q%BQa\u0012\u0001\u0005\u0002u\tQ\u0005^3ti\u000e\u001bh\u000fV1cY\u0016\u001cv.\u001e:dK\n+\u0018\u000e\u001c3fe^KG\u000f\u001b(vY2\u0004\u0016\r\u001e5)\t\u0019\u0013\u0003&S\u0012\u0002\u0015B\u00111j\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012B\u0001*\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002S%!)q\u000b\u0001C\u0001;\u0005yC/Z:u\u0007N4H+\u00192mKN{WO]2f\u0005VLG\u000eZ3s/&$\b\u000eR;qY&\u001c\u0017\r^3GS\u0016dGMT1nK\"\"aK\t\u0015J\u0011\u0015Q\u0006\u0001\"\u0001\u001e\u0003\u001d\"Xm\u001d;DgZ$\u0016M\u00197f'>,(oY3Ck&dG-\u001a:XSRDW)\u001c9us\u001aKW\r\u001c3)\te\u0013\u0003&\u0013")
public class TableSourceValidationTest {
    @Test(expected=ValidationException.class)
    public void testUnresolvedSchemaField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount", "value"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.DOUBLE()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "amount"}));
        TestTableSourceWithTime ts = new TestTableSourceWithTime(schema, rowType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testNonMatchingFieldTypes() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "amount"}));
        TestTableSourceWithTime ts = new TestTableSourceWithTime(schema, rowType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testMappingToUnknownField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.DOUBLE()}));
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.DOUBLE()});
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"f3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"f1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"f2")}));
        TableSchema x$1 = schema;
        RowTypeInfo x$2 = rowType;
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map x$4 = mapping;
        String x$5 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4();
        String x$6 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        TestTableSourceWithTime ts = new TestTableSourceWithTime(x$1, x$2, x$3, x$5, x$6, (Map<String, String>)x$4);
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testMappingWithInvalidFieldType() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.DOUBLE()}));
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"f0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"f1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)"f2")}));
        TableSchema x$7 = schema;
        RowTypeInfo x$8 = rowType;
        Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map x$10 = mapping;
        String x$11 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4();
        String x$12 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5();
        TestTableSourceWithTime ts = new TestTableSourceWithTime(x$7, x$8, x$9, x$11, x$12, (Map<String, String>)x$10);
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testNonTimestampProctimeField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.LONG()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "amount"}));
        TableSchema x$13 = schema;
        RowTypeInfo x$14 = rowType;
        Seq x$15 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$16 = "ptime";
        String x$17 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4();
        Map<String, String> x$18 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6();
        TestTableSourceWithTime ts = new TestTableSourceWithTime(x$13, x$14, x$15, x$17, x$16, x$18);
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testNonTimestampRowtimeField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount", "rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.LONG()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "rtime", "amount"}));
        TestTableSourceWithTime ts = new TestTableSourceWithTime(schema, rowType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testFieldRowtimeAndProctime() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount", "time"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "time", "amount"}));
        TestTableSourceWithTime ts = new TestTableSourceWithTime(schema, rowType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "time", "time", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=ValidationException.class)
    public void testUnknownTimestampExtractorArgField() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"id", "name", "amount", "rtime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"id", "name", "rtime", "amount"}));
        TestTableSourceWithTime<Row> ts = new TestTableSourceWithTime<Row>(null, schema, rowType){

            public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
                return Collections.singletonList(new RowtimeAttributeDescriptor("rtime", (TimestampExtractor)new ExistingField("doesNotExist"), (WatermarkStrategy)new AscendingTimestamps()));
            }
        };
        tEnv.registerTableSource("testTable", (TableSource)ts);
    }

    @Test(expected=ValidationException.class)
    public void testFailingTimestampExtractorValidation() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        String[] fieldNames = (String[])((Object[])new String[]{"id", "name", "amount"});
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), fieldNames);
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.INT()}));
        TestTableSourceWithTime ts = new TestTableSourceWithTime(schema, rowType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "amount", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6());
        tEnv.registerTableSource("testTable", ts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCsvTableSourceBuilderWithNullPath() {
        CsvTableSource$.MODULE$.builder().field("myfield", Types$.MODULE$.STRING()).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCsvTableSourceBuilderWithDuplicateFieldName() {
        CsvTableSource$.MODULE$.builder().path("/path/to/csv").field("myfield", Types$.MODULE$.STRING()).field("myfield", Types$.MODULE$.INT());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCsvTableSourceBuilderWithEmptyField() {
        CsvTableSource$.MODULE$.builder().path("/path/to/csv").build();
    }
}

