/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.validation;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001\u001f\tIB+\u00192mKN\u001b\u0007.Z7b-\u0006d\u0017\u000eZ1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0006wC2LG-\u0019;j_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\t1\u0005^3ti\u000e{G.^7o\u001d\u0006lW-\u00118e\u0007>dW/\u001c8UsB,gj\u001c;FcV\fG\u000eF\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0011)f.\u001b;)\u0005m)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\r\u0003\u0015QWO\\5u\u0013\tQsE\u0001\u0003UKN$\b\"\u0002\u0017\u0001\t\u0003i\u0012\u0001\u0007;fgR\u001cu\u000e\\;n]:\u000bW.Z:EkBd\u0017nY1uK\"\u00121&\n")
public class TableSchemaValidationTest
extends TableTestBase {
    @Test
    public void testColumnNameAndColumnTypeNotEqual() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Number of field names and field types must be equal.\nNumber of names is 3, number of types is 2.\nList of field names: [a, b, c]\nList of field types: [Integer, String]");
        String[] fieldNames = (String[])((Object[])new String[]{"a", "b", "c"});
        TypeInformation[] typeInfos = (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        new TableSchema(fieldNames, typeInfos);
    }

    @Test
    public void testColumnNamesDuplicate() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Field names must be unique.\nList of duplicate fields: [a]\nList of all fields: [a, a, c]");
        String[] fieldNames = (String[])((Object[])new String[]{"a", "a", "c"});
        TypeInformation[] typeInfos = (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        new TableSchema(fieldNames, typeInfos);
    }
}

