/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.table;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.scala.Over$;
import org.apache.flink.table.api.scala.Tumble$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.apache.flink.table.utils.TestNestedProjectableTableSource;
import org.apache.flink.table.utils.TestNestedProjectableTableSource$;
import org.apache.flink.table.utils.TestProjectableTableSource;
import org.apache.flink.table.utils.TestProjectableTableSource$;
import org.apache.flink.table.utils.TestTableSourceWithTime;
import org.apache.flink.table.utils.TestTableSourceWithTime$;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001!\tyA+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)A/\u00192mK*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011aA1qS*\u00111!\u0003\u0006\u0003\u0015-\tQA\u001a7j].T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\t!\u0002\"A\u0003vi&d7/\u0003\u0002\u0017'\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQ\u0001\u0007\u0001\u0005\u0002e\ta\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0002\t\u000bu\u0001A\u0011\u0001\u0010\u0002GQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5M_:<'k\\<US6,g)[3mIR\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\bF\u0001\u000f'!\t9#&D\u0001)\u0015\tIS\"A\u0003kk:LG/\u0003\u0002,Q\t!A+Z:u\u0011\u0015i\u0003\u0001\"\u0001\u001f\u0003!\"Xm\u001d;UC\ndWmU8ve\u000e,w+\u001b;i)&lWm\u001d;b[B\u0014vn\u001e+j[\u00164\u0015.\u001a7eQ\tac\u0005C\u00031\u0001\u0011\u0005a$A\u0011uKN$(k\\<US6,G+\u00192mKN{WO]2f\u000fJ|W\u000f],j]\u0012|w\u000f\u000b\u00020M!)1\u0007\u0001C\u0001=\u0005iB/Z:u!J|7\rV5nKR\u000b'\r\\3T_V\u00148-Z*j[BdW\r\u000b\u00023M!)a\u0007\u0001C\u0001=\u0005\tC/Z:u!J|7\rV5nKR\u000b'\r\\3T_V\u00148-Z(wKJ<\u0016N\u001c3po\"\u0012QG\n\u0005\u0006s\u0001!\tAH\u0001\u001fi\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQJ{w\u000f^5nKB\u0013xn\u0019;j[\u0016D#\u0001\u000f\u0014\t\u000bq\u0002A\u0011\u0001\u0010\u00023Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f\u001e*poRLW.\u001a\u0015\u0003w\u0019BQa\u0010\u0001\u0005\u0002y\t!\u0004^3tiB\u0013xN[3di^KG\u000f[8viB\u0013xn\u0019;j[\u0016DQ!\u0011\u0001\u0005\u0002y\tq\u0003^3tiB\u0013xN[3di>sG.\u001f)s_\u000e$\u0018.\\3\t\u000b\r\u0003A\u0011\u0001\u0010\u0002-Q,7\u000f\u001e)s_*,7\r^(oYf\u0014vn\u001e;j[\u0016DQ!\u0012\u0001\u0005\u0002y\ta\u0003^3tiB\u0013xN[3di^KG\u000f['baBLgn\u001a\u0015\u0003\t\u001aBQ\u0001\u0013\u0001\u0005\u0002y\t\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t9e\u0005")
public class TableSourceTest
extends TableTestBase {
    @Test
    public void testTableSourceWithLongRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("rowTimeT", new TestTableSourceWithTime(tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowTimeT"})).select("rowtime, id, name, val");
        String expected = "StreamTableSourceScan(table=[[rowTimeT]], fields=[rowtime, id, name, val], source=[TestTableSourceWithTime(id, rowtime, val, name)])";
        util.verifyTable(t, expected);
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("rowTimeT", new TestTableSourceWithTime(tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowTimeT"})).select("rowtime, id, name, val");
        String expected = "StreamTableSourceScan(table=[[rowTimeT]], fields=[rowtime, id, name, val], source=[TestTableSourceWithTime(id, rowtime, val, name)])";
        util.verifyTable(t, expected);
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rowtime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rowtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("rowTimeT", new TestTableSourceWithTime(tableSchema, returnType, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "rowtime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$5(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowTimeT"})).filter("val > 100").window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(10).minutes()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")).end(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).avg()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", "StreamTableSourceScan(table=[[rowTimeT]], fields=[rowtime, val, name], source=[TestTableSourceWithTime(id, rowtime, val, name)])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime", "val", "name"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{">(val, 100)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"name"})), TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"TumblingGroupWindow('w, 'rowtime, 600000.millis)"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"name", "AVG(val) AS TMP_1", "end('w) AS TMP_0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"name", "TMP_0", "TMP_1"}))}));
        util.verifyTable(t, expected);
    }

    @Test
    public void testProcTimeTableSourceSimple() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        TableSchema x$1 = tableSchema;
        RowTypeInfo x$2 = returnType;
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$4 = "proctime";
        String x$5 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4();
        Map<String, String> x$6 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6();
        util.tableEnv().registerTableSource("procTimeT", new TestTableSourceWithTime(x$1, x$2, x$3, x$5, x$4, x$6));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"procTimeT"})).select("proctime, id, name, val");
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", "StreamTableSourceScan(table=[[procTimeT]], fields=[id, proctime, val, name], source=[TestTableSourceWithTime(id, proctime, val, name)])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"PROCTIME(proctime) AS proctime", "id", "name", "val"}))}));
        util.verifyTable(t, expected);
    }

    @Test
    public void testProcTimeTableSourceOverWindow() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "proctime", "val", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        TableSchema x$7 = tableSchema;
        RowTypeInfo x$8 = returnType;
        Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        String x$10 = "proctime";
        String x$11 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$4();
        Map<String, String> x$12 = TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$6();
        util.tableEnv().registerTableSource("procTimeT", new TestTableSourceWithTime(x$7, x$8, x$9, x$11, x$10, x$12));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"procTimeT"})).window((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OverWindow[]{Over$.MODULE$.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))})).orderBy(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime"))).preceding(package$.MODULE$.LiteralIntExpression(2).hours()).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")).sum()).over(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).as((Symbol)SymbolLiteral.bootstrap("apply", "valSum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "valSum")).$greater(package$.MODULE$.int2Literal(100)));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", "StreamTableSourceScan(table=[[procTimeT]], fields=[id, proctime, val, name], source=[TestTableSourceWithTime(id, proctime, val, name)])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"id"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 7200000 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"id", "proctime", "val", "name", "SUM(val) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"id", "name", "w0$o0 AS valSum"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{">(w0$o0, 100)"}))}));
        util.verifyTable(t, expected);
    }

    @Test
    public void testProjectWithRowtimeProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
        String expected = "StreamTableSourceScan(table=[[T]], fields=[name, val, id], source=[TestSource(physical fields: name, val, id)])";
        util.verifyTable(t, expected);
    }

    @Test
    public void testProjectWithoutRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"id", "name", "val", "rtime"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", "StreamTableSourceScan(table=[[T]], fields=[ptime, name, val, id], source=[TestSource(physical fields: name, val, id)])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"PROCTIME(ptime) AS ptime", "name", "val", "id"}))}));
        util.verifyTable(t, expected);
    }

    public void testProjectWithoutProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id"))}));
        String expected = "StreamTableSourceScan(table=[[T]], fields=[name, val, rtime, id], source=[TestSource(physical fields: name, val, rtime, id)])";
        util.verifyTable(t, expected);
    }

    public void testProjectOnlyProctime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ptime"))}));
        String expected = "StreamTableSourceScan(table=[[T]], fields=[ptime], source=[TestSource(physical fields: )])";
        util.verifyTable(t, expected);
    }

    public void testProjectOnlyRowtime() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG(), Types$.MODULE$.LONG(), Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "rtime", "val", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", TestProjectableTableSource$.MODULE$.$lessinit$greater$default$6()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime"))}));
        String expected = "StreamTableSourceScan(table=[[T]], fields=[rtime], source=[TestSource(physical fields: rtime)])";
        util.verifyTable(t, expected);
    }

    @Test
    public void testProjectWithMapping() {
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "rtime", "val", "ptime", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.LONG(), Types$.MODULE$.SQL_TIMESTAMP(), Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.INT(), Types$.MODULE$.STRING(), Types$.MODULE$.LONG()}), (String[])((Object[])new String[]{"p-rtime", "p-id", "p-name", "p-val"}));
        Map mapping = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rtime"), (Object)"p-rtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"p-id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)"p-val"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"p-name")}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), "rtime", "ptime", (Map<String, String>)mapping));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "val"))}));
        String expected = "StreamTableSourceScan(table=[[T]], fields=[name, rtime, val], source=[TestSource(physical fields: remapped-p-name, remapped-p-rtime, remapped-p-val)])";
        util.verifyTable(t, expected);
    }

    @Test
    public void testNestedProject() {
        RowTypeInfo nested1 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), (String[])((Object[])new String[]{"name", "value"}));
        RowTypeInfo nested2 = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.BOOLEAN()}), (String[])((Object[])new String[]{"num", "flag"}));
        RowTypeInfo deepNested = new RowTypeInfo((TypeInformation[])new RowTypeInfo[]{nested1, nested2}, (String[])((Object[])new String[]{"nested1", "nested2"}));
        TableSchema tableSchema = new TableSchema((String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), deepNested, nested1, Types$.MODULE$.STRING()}));
        RowTypeInfo returnType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), deepNested, nested1, Types$.MODULE$.STRING()}), (String[])((Object[])new String[]{"id", "deepNested", "nested", "name"}));
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource("T", (TableSource)new TestNestedProjectableTableSource(tableSchema, (TypeInformation<Row>)returnType, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$4(), TestNestedProjectableTableSource$.MODULE$.$lessinit$greater$default$5()));
        Table t = util.tableEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested1")).get("name")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedName"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nested")).get("value")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedValue"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("flag")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedFlag"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deepNested")).get("nested2")).get("num")).as((Symbol)SymbolLiteral.bootstrap("apply", "nestedNum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", "StreamTableSourceScan(table=[[T]], fields=[id, deepNested, nested], source=[TestSource(read nested fields: id.*, deepNested.nested2.num, deepNested.nested2.flag, deepNested.nested1.name, nested.value)])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"id", "deepNested.nested1.name AS nestedName", "nested.value AS nestedValue", "deepNested.nested2.flag AS nestedFlag", "deepNested.nested2.num AS nestedNum"}))}));
        util.verifyTable(t, expected);
    }
}

