/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.scala.Session$;
import org.apache.flink.table.api.scala.Slide$;
import org.apache.flink.table.api.scala.Tumble$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.table.AggregateTest$;
import org.apache.flink.table.expressions.Aggregation;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001!\ti\u0011iZ4sK\u001e\fG/\u001a+fgRT!a\u0001\u0003\u0002\u000bQ\f'\r\\3\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005\rI!B\u0001\u0006\f\u0003\u00151G.\u001b8l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!\u001e;jYNL!AF\n\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t!\u0001C\u0003\u001e\u0001\u0011\u0005a$\u0001\u000euKN$xI]8va\u0012K7\u000f^5oGR\fum\u001a:fO\u0006$X\rF\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0011)f.\u001b;)\u0005q1\u0003CA\u0014+\u001b\u0005A#BA\u0015\u000e\u0003\u0015QWO\\5u\u0013\tY\u0003F\u0001\u0003UKN$\b\"B\u0017\u0001\t\u0003q\u0012a\t;fgR<%o\\;q\t&\u001cH/\u001b8di\u0006;wM]3hCR,w+\u001b;i+\u0012\u000bui\u0012\u0015\u0003Y\u0019BQ\u0001\r\u0001\u0005\u0002y\t!\u0003^3ti\u001e\u0013x.\u001e9BO\u001e\u0014XmZ1uK\"\u0012qF\n\u0005\u0006g\u0001!\tAH\u0001 i\u0016\u001cHo\u0012:pkB\fum\u001a:fO\u0006$XmV5uQ\u000e{gn\u001d;b]R\f\u0004F\u0001\u001a'\u0011\u00151\u0004\u0001\"\u0001\u001f\u0003}!Xm\u001d;He>,\b/Q4he\u0016<\u0017\r^3XSRD7i\u001c8ti\u0006tGO\r\u0015\u0003k\u0019BQ!\u000f\u0001\u0005\u0002y\t\u0001\u0006^3ti\u001e\u0013x.\u001e9BO\u001e\u0014XmZ1uK^KG\u000f[#yaJ,7o]5p]&s7+\u001a7fGRD#\u0001\u000f\u0014\t\u000bq\u0002A\u0011\u0001\u0010\u00029Q,7\u000f^$s_V\u0004\u0018iZ4sK\u001e\fG/Z,ji\"4\u0015\u000e\u001c;fe\"\u00121H\n\u0005\u0006\u007f\u0001!\tAH\u0001\u001ei\u0016\u001cHo\u0012:pkB\fum\u001a:fO\u0006$XmV5uQ\u00063XM]1hK\"\u0012aH\n\u0005\u0006\u0005\u0002!\tAH\u0001$i\u0016\u001cH\u000fR5ti&t7\r^!hOJ,w-\u0019;f\u001f:$V/\u001c2mK^Kg\u000eZ8xQ\t\te\u0005C\u0003F\u0001\u0011\u0005a$\u0001\u0018uKN$X*\u001e7uS\u0012K7\u000f^5oGR\fum\u001a:fO\u0006$XmU1nK\u001aKW\r\u001c3P]\"{\u0007oV5oI><\bF\u0001#'\u0011\u0015A\u0005\u0001\"\u0001\u001f\u0003A\"Xm\u001d;ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5He>,\b/\u001b8h\u001f:\u001cVm]:j_:<\u0016N\u001c3po\"\u0012qI\n")
public class AggregateTest
extends TableTestBase {
    @Test
    public void testGroupDistinctAggregate() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.table.AggregateTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).distinct(), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).count()).distinct()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "SUM(DISTINCT a) AS TMP_0", "COUNT(DISTINCT c) AS TMP_1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"TMP_0", "TMP_1"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupDistinctAggregateWithUDAGG() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.table.AggregateTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        JavaUserDefinedAggFunctions.WeightedAvg weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvg();
        Table resultTable = table.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.toDistinct((AggregateFunction)weightedAvg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).distinct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), package$.MODULE$.userDefinedAggFunctionConstructor((AggregateFunction)weightedAvg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "WeightedAvg(DISTINCT a, b) AS TMP_0", "WeightedAvg(a, b) AS TMP_1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"TMP_0", "TMP_1"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregate() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.table.AggregateTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "COUNT(a) AS TMP_0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"TMP_0"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregateWithConstant1() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.table.AggregateTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"4 AS four", "b", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"four", "a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"four", "a", "SUM(b) AS TMP_0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"4 AS four", "TMP_0"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregateWithConstant2() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.table.AggregateTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"4 AS four", "a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"four", "b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"four", "b", "SUM(a) AS TMP_0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"4 AS four", "TMP_0"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregateWithExpressionInSelect() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.api.stream.table.AggregateTest$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).as((Symbol)SymbolLiteral.bootstrap("apply", "a"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$percent(package$.MODULE$.int2Literal(3))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).min(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).avg()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "MOD(b, 3) AS d", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"d"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"d", "MIN(c) AS TMP_0", "AVG(a) AS TMP_1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"TMP_0", "TMP_1"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregateWithFilter() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.api.stream.table.AggregateTest$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()})).where((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "a"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(b, 2)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "SUM(a) AS TMP_0"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testGroupAggregateWithAverage() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.api.stream.table.AggregateTest$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table resultTable = table.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast((TypeInformation)BasicTypeInfo.DOUBLE_TYPE_INFO)).avg()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "a", "CAST(a) AS a0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "AVG(a0) AS TMP_0"}))}));
        util.verifyTable(resultTable, expected);
    }

    @Test
    public void testDistinctAggregateOnTumbleWindow() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.api.stream.table.AggregateTest$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table result = table.window((Window)Tumble$.MODULE$.over(package$.MODULE$.LiteralIntExpression(15).minute()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()).distinct(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(DISTINCT a) AS TMP_0", "SUM(a) AS TMP_1"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testMultiDistinctAggregateSameFieldOnHopWindow() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.api.stream.table.AggregateTest$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table result = table.window((Window)Slide$.MODULE$.over(package$.MODULE$.LiteralIntExpression(1).hour()).every(package$.MODULE$.LiteralIntExpression(15).minute()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()).distinct(), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).distinct(), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).max()).distinct()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SlidingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(3600000).millis(), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(DISTINCT a) AS TMP_0", "SUM(DISTINCT a) AS TMP_1", "MAX(DISTINCT a) AS TMP_2"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testDistinctAggregateWithGroupingOnSessionWindow() {
        StreamTableTestUtil util = this.streamTestUtil();
        Table table = util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.api.stream.table.AggregateTest$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table result = table.window((Window)Session$.MODULE$.withGap(package$.MODULE$.LiteralIntExpression(15).minute()).on(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))).as(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w"))})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count(), package$.MODULE$.toDistinct((Aggregation)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).count()).distinct()}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SessionGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "COUNT(a) AS TMP_0", "COUNT(DISTINCT c) AS TMP_1"}))}));
        util.verifyTable(result, expected);
    }
}

