/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.validation.WindowAggregateValidationTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001'\tir+\u001b8e_^\fum\u001a:fO\u0006$XMV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0007gR\u0014X-Y7\u000b\u0005%Q\u0011aA1qS*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\"\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005Q1\u000f\u001e:fC6,F/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0006tiJ,\u0017-\\+uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013\u0001\u0007;fgR$V/\u001c2mK^Kg\u000eZ8x\u001d>|eMZ:fiR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0003kk:LG/\u0003\u00027g\t!A+Z:u\u0011\u0015A\u0004\u0001\"\u0001*\u0003U!Xm\u001d;I_B<\u0016N\u001c3po:{wJ\u001a4tKRD#aN\u0019\t\u000bm\u0002A\u0011A\u0015\u00023Q,7\u000f^*fgNLwN\\,j]\u0012|wOT8PM\u001a\u001cX\r\u001e\u0015\u0003uEBQA\u0010\u0001\u0005\u0002%\na\u0003^3tiZ\u000b'/[1cY\u0016<\u0016N\u001c3poNK'0\u001a\u0015\u0003{EBQ!\u0011\u0001\u0005\u0002%\n!\u0004^3ti^Kg\u000eZ8x+\u0012\fumZ%om\u0006d\u0017\u000eZ!sOND#\u0001Q\u0019\t\u000b\u0011\u0003A\u0011A\u0015\u0002=Q,7\u000f^,j]\u0012|wo\u0016:p]\u001e<\u0016N\u001c3poB\u000b'/Y7fi\u0016\u0014\bFA\"2\u0001")
public class WindowAggregateValidationTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testTumbleWindowNoOffset() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("TUMBLE window with alignment is not supported yet");
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.streamUtil().verifySql(sqlQuery, "n/a");
    }

    @Test
    public void testHopWindowNoOffset() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("HOP window with alignment is not supported yet");
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY HOP(proctime, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.streamUtil().verifySql(sqlQuery, "n/a");
    }

    @Test
    public void testSessionWindowNoOffset() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("SESSION window with alignment is not supported yet");
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable GROUP BY SESSION(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.streamUtil().verifySql(sqlQuery, "n/a");
    }

    @Test
    public void testVariableWindowSize() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Only constant window intervals with millisecond resolution are supported");
        String sql = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, c * INTERVAL '1' MINUTE)";
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test
    public void testWindowUdAggInvalidArgs() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Given parameters of function do not match any signature");
        this.streamUtil().tableEnv().registerFunction("weightedAvg", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sqlQuery = "SELECT SUM(a) AS sumA, weightedAvg(a, b) AS wAvg FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.streamUtil().verifySql(sqlQuery, "n/a");
    }

    @Test
    public void testWindowWrongWindowParameter() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Only constant window intervals with millisecond resolution are supported");
        String sqlQuery = "SELECT COUNT(*) FROM MyTable GROUP BY TUMBLE(proctime, INTERVAL '2-10' YEAR TO MONTH)";
        this.streamUtil().verifySql(sqlQuery, "n/a");
    }

    public WindowAggregateValidationTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.validation.WindowAggregateValidationTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

