/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.validation.JoinValidationTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001'\t\u0011\"j\\5o-\u0006d\u0017\u000eZ1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0006wC2LG-\u0019;j_:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T!!\u0003\u0006\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u000b\u0003\u0015)H/\u001b7t\u0013\tIbCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013%\u0011%\u0001\u0006tiJ,\u0017-\\+uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r\u0019\u0002\u0001\u0015!\u0003#\u0003-\u0019HO]3b[V#\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002?Q,7\u000f^,j]\u0012|wOS8j]\u0012KgM\u001a+j[\u0016Le\u000eZ5dCR|'\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\t\u001d\nt\u0007\u000f\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\n\u0011\b\u0005\u0002;w5\t\u0001\"\u0003\u0002=\u0011\tqA+\u00192mK\u0016C8-\u001a9uS>t\u0007\"\u0002 \u0001\t\u0003I\u0013!\b;fgR<\u0016N\u001c3po*{\u0017N\u001c(pi\u000esgmQ8oI&$\u0018n\u001c8)\tu\nt\u0007\u000f\u0005\u0006\u0003\u0002!\t!K\u0001\u001fi\u0016\u001cHOT8S_^$\u0018.\\3BiR\u0014\u0018NY;uK&s'+Z:vYRDC\u0001Q\u00198q!)A\t\u0001C\u0001S\u0005qB/Z:u%\u0006tw-Z!oI\u0016\u000bX/\u00197jif\u0004&/\u001a3jG\u0006$Xm\u001d\u0015\u0005\u0007F:\u0004\bC\u0003H\u0001\u0011\u0005\u0011&A\u0010uKN$X)];bY&$\u0018\u0010\u0015:fI&\u001c\u0017\r^3XSRDwJ\u001a4tKRDCAR\u00198q!)!\n\u0001C\u0001S\u0005\u0019D/Z:u\u001d>\u0014vn\u001e;j[\u0016\fE\u000f\u001e:jEV$X-\u00138SKN,H\u000e\u001e$pe:{gnV5oI><\u0018J\u001c8fe*{\u0017N\u001c\u0015\u0005\u0013F:\u0004\bC\u0003N\u0001\u0011\u0005\u0011&\u0001\u001buKN$hj\u001c)s_\u000e$\u0018.\\3BiR\u0014\u0018NY;uK&s'+Z:vYR4uN\u001d(p]^Kg\u000eZ8x\u0013:tWM\u001d&pS:DC\u0001T\u00198q!)\u0001\u000b\u0001C\u0001S\u0005aB/Z:u\u0015>LgnV5uQJ{w\u000f^5nK\u000e{g\u000eZ5uS>t\u0007FA(2\u0011\u0015\u0019\u0006\u0001\"\u0001*\u00031\"Xm\u001d;K_&tw+\u001b;i%><H/[7f\u0007>tG-\u001b;j_:4%o\\7D_6\u0004H.\u001a=Rk\u0016\u0014\u0018\u0010\u000b\u0002Sc!)a\u000b\u0001C\u0001S\u0005iB/Z:u\u0015>LgnV5uQJ{w\u000f^5nKB\u0013xN[3di&|g\u000e\u000b\u0002Vc\u0001")
public class JoinValidationTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test(expected=TableException.class)
    public void testWindowJoinDiffTimeIndicator() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a FROM\n        |MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime > t2.proctime - INTERVAL '5' SECOND AND\n        |  t1.proctime < t2.c + INTERVAL '5' SECOND")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testWindowJoinNotCnfCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a\n        |FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  (t1.proctime > t2.proctime - INTERVAL '5' SECOND OR\n        |   t1.proctime < t2.c + INTERVAL '5' SECOND)")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testNoRowtimeAttributeInResult() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND t2.proctime\n        | ")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testRangeAndEqualityPredicates() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.proctime > t2.proctime - INTERVAL '5' SECOND AND\n        |  t1.proctime = t2.proctime\n        | ")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testEqualityPredicateWithOffset() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.proctime = t2.proctime - INTERVAL '5' SECOND\n        | ")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testNoRowtimeAttributeInResultForNonWindowInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a\n        | ")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test(expected=TableException.class)
    public void testNoProctimeAttributeInResultForNonWindowInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND t1.proctime > t2.proctime\n        | ")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test
    public void testJoinWithRowtimeCondition() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Rowtime attributes must not be in the input rows of a regular join.");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a\n        |FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c > t2.c - INTERVAL '5' SECOND\n        |")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    @Test
    public void testJoinWithRowtimeConditionFromComplexQuery() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Rowtime attributes must not be in the input rows of a regular join.");
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "eventTs")).rowtime()}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, Object>> createSerializerInstance(Class<Tuple2<Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.sql.validation.JoinValidationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "eventTs")).rowtime()}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }

                    public CaseClassSerializer<Tuple2<Object, Object>> createSerializerInstance(Class<Tuple2<Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.sql.validation.JoinValidationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql1 = new StringOps(Predef$.MODULE$.augmentString("SELECT\n        |  id,\n        |  eventTs AS t1,\n        |  COUNT(*) OVER (\n        |    PARTITION BY id ORDER BY eventTs ROWS BETWEEN 100 PRECEDING AND CURRENT ROW\n        |  ) AS cnt1\n        |FROM MyTable1\n        |")).stripMargin();
        String sql2 = new StringOps(Predef$.MODULE$.augmentString("SELECT DISTINCT\n        |  id AS r_id,\n        |  eventTs AS t2,\n        |  COUNT(*) OVER (\n        |    PARTITION BY id ORDER BY eventTs ROWS BETWEEN 50 PRECEDING AND CURRENT ROW\n        |  ) AS cnt2\n        |FROM MyTable2\n        |")).stripMargin();
        Table left = util.tableEnv().sqlQuery(sql1);
        Table right = util.tableEnv().sqlQuery(sql2);
        Table result = left.join(right).where("id === r_id && t1 === t2").select("id, t1");
        util.verifyTable(result, "n/a");
    }

    @Test
    public void testJoinWithRowtimeProjection() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Rowtime attributes must not be in the input rows of a regular join.");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c\n        |FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a\n        |")).stripMargin();
        this.streamUtil().verifySql(sql, "n/a");
    }

    public JoinValidationTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).rowtime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.validation.JoinValidationTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addTable("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).rowtime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.sql.validation.JoinValidationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

