/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql.validation;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.utils.StreamTestData$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.MemoryTableSourceSinkUtil;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001'\tA\u0012J\\:feRLe\u000e^8WC2LG-\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u0003<bY&$\u0017\r^5p]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0004CBL'BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003q!Xm\u001d;J]\u000e|gn]5ti\u0016tG\u000fT3oORD\u0017J\\:feR$\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003\tUs\u0017\u000e\u001e\u0015\u0005?\u0019bS\u0006\u0005\u0002(U5\t\u0001F\u0003\u0002*!\u0005)!.\u001e8ji&\u00111\u0006\u000b\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\u0005q\u0003CA\u00181\u001b\u0005A\u0011BA\u0019\t\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015\u0019\u0004\u0001\"\u0001\"\u0003a!Xm\u001d;V]6\fGo\u00195fIRK\b/Z:J]N,'\u000f\u001e\u0015\u0005e\u0019bS\u0006C\u00037\u0001\u0011\u0005\u0011%\u0001\u000fuKN$XK\\:vaB|'\u000f^3e!\u0006\u0014H/[1m\u0013:\u001cXM\u001d;)\tU2C&\f")
public class InsertIntoValidationTest {
    @Test(expected=ValidationException.class)
    public void testInconsistentLengthInsert() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("sourceTable", t);
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e"});
        TypeInformation[] fieldTypes = (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.LONG()});
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        String sql = "INSERT INTO targetTable SELECT a, b, c FROM sourceTable";
        tEnv.sqlUpdate(sql);
    }

    @Test(expected=ValidationException.class)
    public void testUnmatchedTypesInsert() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("sourceTable", t);
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e", "f"});
        TypeInformation[] fieldTypes = (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.INT(), Types$.MODULE$.LONG()});
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        String sql = "INSERT INTO targetTable SELECT a, b, c FROM sourceTable";
        tEnv.sqlUpdate(sql);
    }

    @Test(expected=ValidationException.class)
    public void testUnsupportedPartialInsert() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        StreamTableEnvironment tEnv = TableEnvironment$.MODULE$.getTableEnvironment(env);
        Table t = package$.MODULE$.dataStream2DataStreamConversions(StreamTestData$.MODULE$.getSmall3TupleDataStream(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])).as((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tEnv.registerTable("sourceTable", t);
        String[] fieldNames = (String[])((Object[])new String[]{"d", "e", "f"});
        TypeInformation[] fieldTypes = tEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourceTable"})).getSchema().getFieldTypes();
        MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink sink = new MemoryTableSourceSinkUtil.UnsafeMemoryAppendTableSink();
        tEnv.registerTableSink("targetTable", fieldNames, fieldTypes, (TableSink)sink);
        String sql = "INSERT INTO targetTable (d, f) SELECT a, c FROM sourceTable";
        tEnv.sqlUpdate(sql);
    }
}

