/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$;
import org.apache.flink.table.api.stream.table.TemporalTableJoinTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil;
import org.apache.flink.types.Row;
import org.hamcrest.Matchers;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\t)B+Z7q_J\fG\u000eV1cY\u0016Tu.\u001b8UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0005kRLG.F\u0001!!\t\u0019\u0012%\u0003\u0002#)\tiA+\u00192mKR+7\u000f^+uS2Da\u0001\n\u0001!\u0002\u0013\u0001\u0013!B;uS2\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0007_J$WM]:\u0016\u0003!\u0002\"!\u000b\u0016\u000e\u0003\u0019I!a\u000b\u0004\u0003\u000bQ\u000b'\r\\3\t\r5\u0002\u0001\u0015!\u0003)\u0003\u001dy'\u000fZ3sg\u0002Bqa\f\u0001C\u0002\u0013\u0005q%\u0001\u0007sCR,7\u000fS5ti>\u0014\u0018\u0010\u0003\u00042\u0001\u0001\u0006I\u0001K\u0001\u000ee\u0006$Xm\u001d%jgR|'/\u001f\u0011\t\u000fM\u0002!\u0019!C\u0001i\u0005)!/\u0019;fgV\tQ\u0007E\u00027smj\u0011a\u000e\u0006\u0003q!\t\u0011BZ;oGRLwN\\:\n\u0005i:$!\u0004+bE2,g)\u001e8di&|g\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?\u0015\u0005)A/\u001f9fg&\u0011\u0001)\u0010\u0002\u0004%><\bB\u0002\"\u0001A\u0003%Q'\u0001\u0004sCR,7\u000f\t\u0005\b\t\u0002\u0011\r\u0011\"\u0001(\u00039\u0001(o\\2uS6,wJ\u001d3feNDaA\u0012\u0001!\u0002\u0013A\u0013a\u00049s_\u000e$\u0018.\\3Pe\u0012,'o\u001d\u0011\t\u000f!\u0003!\u0019!C\u0001O\u0005!\u0002O]8di&lWMU1uKND\u0015n\u001d;pefDaA\u0013\u0001!\u0002\u0013A\u0013!\u00069s_\u000e$\u0018.\\3SCR,7\u000fS5ti>\u0014\u0018\u0010\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u00015\u00035\u0001(o\\2uS6,'+\u0019;fg\"1a\n\u0001Q\u0001\nU\na\u0002\u001d:pGRLW.\u001a*bi\u0016\u001c\b\u0005C\u0003Q\u0001\u0011\u0005\u0011+\u0001\buKN$8+[7qY\u0016Tu.\u001b8\u0015\u0003I\u0003\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013A!\u00168ji\"\u0012q*\u0017\t\u00035vk\u0011a\u0017\u0006\u00039:\tQA[;oSRL!AX.\u0003\tQ+7\u000f\u001e\u0005\u0006A\u0002!\t!U\u0001\u0017i\u0016\u001cHoU5na2,\u0007K]8di&lWMS8j]\"\u0012q,\u0017\u0005\u0006G\u0002!\t!U\u0001\u0010i\u0016\u001cHoQ8na2,\u0007PS8j]\"\u0012!-\u0017\u0005\u0006M\u0002!\t!U\u0001\u0015i\u0016\u001cH/\u00168d_J\u0014X\r\\1uK\u0012Tu.\u001b8)\u0005\u0015L\u0006\"B5\u0001\t\u0003\t\u0016!\b;fgR$V-\u001c9pe\u0006dG+\u00192mK\u001a+hn\u0019;j_:\u001c6-\u00198)\u0005!L\u0006")
public class TemporalTableJoinTest
extends TableTestBase {
    private final TableTestUtil util = this.streamTestUtil();
    private final Table orders = this.util().addTable("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }

                public CaseClassSerializer<Tuple3<Object, String, Timestamp>> createSerializerInstance(Class<Tuple3<Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ratesHistory = this.util().addTable("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }

                public CaseClassSerializer<Tuple3<String, Object, Timestamp>> createSerializerInstance(Class<Tuple3<String, Object, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final TableFunction<Row> rates = this.util().addFunction("Rates", this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency"))), TypeExtractor.createTypeInfo(Row.class));
    private final Table proctimeOrders = this.util().addTable("ProctimeOrders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_proctime")).proctime()}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                public Tuple2<Object, String> createInstance(Object[] fields) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                }

                public CaseClassSerializer<Tuple2<Object, String>> createSerializerInstance(Class<Tuple2<Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table proctimeRatesHistory = this.util().addTable("ProctimeRatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                public Tuple2<String, Object> createInstance(Object[] fields) {
                    return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                }

                public CaseClassSerializer<Tuple2<String, Object>> createSerializerInstance(Class<Tuple2<String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final TableFunction<Row> proctimeRates = this.util().addFunction("ProctimeRates", this.proctimeRatesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency"))), TypeExtractor.createTypeInfo(Row.class));

    public TableTestUtil util() {
        return this.util;
    }

    public Table orders() {
        return this.orders;
    }

    public Table ratesHistory() {
        return this.ratesHistory;
    }

    public TableFunction<Row> rates() {
        return this.rates;
    }

    public Table proctimeOrders() {
        return this.proctimeOrders;
    }

    public Table proctimeRatesHistory() {
        return this.proctimeRatesHistory;
    }

    public TableFunction<Row> proctimeRates() {
        return this.proctimeRates;
    }

    @Test
    public void testSimpleJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(o.o_rowtime)) AS r WHERE currency = o_currency";
        this.util().verifySql(sqlQuery, TemporalTableJoinTest$.MODULE$.getExpectedSimpleJoinPlan());
    }

    @Test
    public void testSimpleProctimeJoin() {
        String sqlQuery = "SELECT o_amount * rate as rate FROM ProctimeOrders AS o, LATERAL TABLE (ProctimeRates(o.o_proctime)) AS r WHERE currency = o_currency";
        this.util().verifySql(sqlQuery, TemporalTableJoinTest$.MODULE$.getExpectedSimpleProctimeJoinPlan());
    }

    @Test
    public void testComplexJoin() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("Table3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3_comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t3_secondary_key"))}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }

                    public CaseClassSerializer<Tuple2<String, Object>> createSerializerInstance(Class<Tuple2<String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_secondary_key"))}), new CaseClassTypeInfo<Tuple5<Timestamp, String, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])), (Object)((String)fields[3]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }

                    public CaseClassSerializer<Tuple5<Timestamp, String, Object, String, Object>> createSerializerInstance(Class<Tuple5<Timestamp, String, Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table ratesHistory = util.addTable("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comment")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "secondary_key"))}), new CaseClassTypeInfo<Tuple5<Timestamp, String, String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Timestamp, String, String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>>(this, fieldSerializers){

                    public Tuple5<Timestamp, String, String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple5((Object)((Timestamp)fields[0]), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[4])));
                    }

                    public CaseClassSerializer<Tuple5<Timestamp, String, String, Object, Object>> createSerializerInstance(Class<Tuple5<Timestamp, String, String, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.api.stream.sql.TemporalTableJoinTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        TemporalTableFunction rates = ratesHistory.filter((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")).$greater(package$.MODULE$.long2Literal(110L))).createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")));
        util.addFunction("Rates", rates, TypeExtractor.createTypeInfo(Row.class));
        String sqlQuery = "SELECT * FROM (SELECT o_amount * rate as rate, secondary_key as secondary_key FROM Orders AS o, LATERAL TABLE (Rates(o_rowtime)) AS r WHERE currency = o_currency OR secondary_key = o_secondary_key), Table3 WHERE t3_secondary_key = secondary_key";
        util.verifySql(sqlQuery, TemporalTableJoinTest$.MODULE$.getExpectedComplexJoinPlan());
    }

    @Test
    public void testUncorrelatedJoin() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage(Matchers.startsWith((String)"Cannot generate a valid execution plan"));
        String sqlQuery = "SELECT o_amount * rate as rate FROM Orders AS o, LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123')) AS r WHERE currency = o_currency";
        this.util().printSql(sqlQuery);
    }

    @Test
    public void testTemporalTableFunctionScan() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage(Matchers.startsWith((String)"Cannot generate a valid execution plan"));
        String sqlQuery = "SELECT * FROM LATERAL TABLE (Rates(TIMESTAMP '2016-06-27 10:10:42.123'))";
        this.util().printSql(sqlQuery);
    }
}

