/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.OverWindowTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\tqqJ^3s/&tGm\\<UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\u000bgR\u0014X-Y7Vi&dW#\u0001\u0011\u0011\u0005M\t\u0013B\u0001\u0012\u0015\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019!\u0003\u0001)A\u0005A\u0005Y1\u000f\u001e:fC6,F/\u001b7!\u0011\u00151\u0003\u0001\"\u0001(\u0003q\"Xm\u001d;Qe>\u001cG/[7f\u0005>,h\u000eZ3e\t&\u001cH/\u001b8di^KG\u000f\u001b(p]\u0012K7\u000f^5oGR\u0004\u0016M\u001d;ji&|g.\u001a3S_^|e/\u001a:\u0015\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012A!\u00168ji\"\u0012Qe\f\t\u0003aMj\u0011!\r\u0006\u0003e9\tQA[;oSRL!\u0001N\u0019\u0003\tQ+7\u000f\u001e\u0005\u0006m\u0001!\taJ\u0001.i\u0016\u001cH\u000f\u0015:pGRLW.\u001a\"pk:$W\r\u001a#jgRLgn\u0019;QCJ$\u0018\u000e^5p]\u0016$'k\\<Pm\u0016\u0014\bFA\u001b0\u0011\u0015I\u0004\u0001\"\u0001(\u0003\u0019\"Xm\u001d;Qe>\u001cG+[7f\u0005>,h\u000eZ3e!\u0006\u0014H/\u001b;j_:,GMU8xg>3XM\u001d\u0015\u0003q=BQ\u0001\u0010\u0001\u0005\u0002\u001d\nq\u0005^3tiB\u0013xn\u0019+j[\u0016\u0014u.\u001e8eK\u0012\u0004\u0016M\u001d;ji&|g.\u001a3SC:<Wm\u0014<fe\"\u00121h\f\u0005\u0006\u007f\u0001!\taJ\u0001+i\u0016\u001cH\u000f\u0015:pGRKW.\u001a\"pk:$W\r\u001a(p]B\u000b'\u000f^5uS>tW\r\u001a*b]\u001e,wJ^3sQ\tqt\u0006C\u0003C\u0001\u0011\u0005q%A\u0015uKN$\bK]8d)&lWMQ8v]\u0012,GMT8o!\u0006\u0014H/\u001b;j_:,GMU8xg>3XM\u001d\u0015\u0003\u0003>BQ!\u0012\u0001\u0005\u0002\u001d\n\u0011\u0006^3tiB\u0013xn\u0019+j[\u0016,fNY8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ\u000bgnZ3Pm\u0016\u0014\bF\u0001#0\u0011\u0015A\u0005\u0001\"\u0001(\u0003!\"Xm\u001d;Qe>\u001cG+[7f+:\u0014w.\u001e8eK\u0012\u0004\u0016M\u001d;ji&|g.\u001a3S_^\u001cxJ^3sQ\t9u\u0006C\u0003L\u0001\u0011\u0005q%\u0001\u0017uKN$\bK]8d)&lW-\u00168c_VtG-\u001a3O_:\u0004\u0016M\u001d;ji&|g.\u001a3SC:<Wm\u0014<fe\"\u0012!j\f\u0005\u0006\u001d\u0002!\taJ\u0001,i\u0016\u001cH\u000f\u0015:pGRKW.Z+oE>,h\u000eZ3e\u001d>t\u0007+\u0019:uSRLwN\\3e%><8o\u0014<fe\"\u0012Qj\f\u0005\u0006#\u0002!\taJ\u0001&i\u0016\u001cHOU8x)&lWMQ8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ{wo](wKJD#\u0001U\u0018\t\u000bQ\u0003A\u0011A\u0014\u0002MQ,7\u000f\u001e*poRKW.\u001a\"pk:$W\r\u001a)beRLG/[8oK\u0012\u0014\u0016M\\4f\u001fZ,'\u000f\u000b\u0002T_!)q\u000b\u0001C\u0001O\u0005AC/Z:u%><H+[7f\u0005>,h\u000eZ3e\u001d>t\u0007+\u0019:uSRLwN\\3e%><8o\u0014<fe\"\u0012ak\f\u0005\u00065\u0002!\taJ\u0001*i\u0016\u001cHOU8x)&lWMQ8v]\u0012,GMT8o!\u0006\u0014H/\u001b;j_:,GMU1oO\u0016|e/\u001a:)\u0005e{\u0003\"B/\u0001\t\u00039\u0013\u0001\u000b;fgR\u0014vn\u001e+j[\u0016,fNY8v]\u0012,G\rU1si&$\u0018n\u001c8fIJ\u000bgnZ3Pm\u0016\u0014\bF\u0001/0\u0011\u0015\u0001\u0007\u0001\"\u0001(\u0003\u001d\"Xm\u001d;S_^$\u0016.\\3V]\n|WO\u001c3fIB\u000b'\u000f^5uS>tW\r\u001a*poN|e/\u001a:)\u0005}{\u0003\"B2\u0001\t\u00039\u0013a\u000b;fgR\u0014vn\u001e+j[\u0016,fNY8v]\u0012,GMT8o!\u0006\u0014H/\u001b;j_:,GMU1oO\u0016|e/\u001a:)\u0005\t|\u0003\"\u00024\u0001\t\u00039\u0013A\u000b;fgR\u0014vn\u001e+j[\u0016,fNY8v]\u0012,GMT8o!\u0006\u0014H/\u001b;j_:,GMU8xg>3XM\u001d\u0015\u0003K>BQ!\u001b\u0001\u0005\u0002\u001d\na\u0007^3tiB\u0013xn\u0019+j[\u0016\u0014u.\u001e8eK\u0012\u0004\u0016M\u001d;ji&|g.\u001a3S_^\u001cxJ^3s\t&4g-\u001a:f]R<\u0016N\u001c3poND#\u0001[\u0018")
public class OverWindowTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testProctimeBoundedDistinctWithNonDistinctPartitionedRowOver() {
        String sql = "SELECT b, count(a) OVER (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as cnt1, sum(a) OVER (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as sum1, count(DISTINCT a) OVER (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as cnt2, sum(DISTINCT c) OVER (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as sum2 from MyTable";
        String sql2 = "SELECT b, count(a) OVER w as cnt1, sum(a) OVER w as sum1, count(DISTINCT a) OVER w as cnt2, sum(DISTINCT c) OVER w as sum2 from MyTable WINDOW w AS (PARTITION BY b ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 2 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "proctime", "COUNT(a) AS w0$o0, $SUM0(a) AS w0$o1, COUNT(DISTINCT a) AS w0$o2, COUNT(DISTINCT c) AS w0$o3, $SUM0(DISTINCT c) AS w0$o4"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "w0$o0 AS cnt1, CASE(>(w0$o0, 0), CAST(w0$o1), null) AS sum1, w0$o2 AS cnt2, CASE(>(w0$o3, 0), CAST(w0$o4), null) AS sum2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProctimeBoundedDistinctPartitionedRowOver() {
        String sql = "SELECT c, count(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as cnt1, sum(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as sum1 from MyTable";
        String sql2 = "SELECT c, count(DISTINCT a) OVER w as cnt1, sum(DISTINCT a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as sum1 FROM MyTable WINDOW w AS (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 2 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(DISTINCT a) AS w0$o0, $SUM0(DISTINCT a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1, CASE(>(w0$o0, 0), CAST(w0$o1), null) AS sum1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeBoundedPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as cnt1, sum(a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as sum1 from MyTable";
        String sql2 = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW) as cnt1, sum(a) OVER w as sum1 from MyTable WINDOW w AS (PARTITION BY c ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 2 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(a) AS w0$o0, $SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1, CASE(>(w0$o0, 0), CAST(w0$o1), null) AS sum1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeBoundedPartitionedRangeOver() {
        String sqlQuery = "SELECT a,   AVG(c) OVER (PARTITION BY a ORDER BY proctime     RANGE BETWEEN INTERVAL '2' HOUR PRECEDING AND CURRENT ROW) AS avgA FROM MyTable";
        String sqlQuery2 = "SELECT a,   AVG(c) OVER w AS avgA FROM MyTable WINDOW w AS (PARTITION BY a ORDER BY proctime   RANGE BETWEEN INTERVAL '2' HOUR PRECEDING AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sqlQuery2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 7200000 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(c) AS w0$o0", "$SUM0(c) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "/(CASE(>(w0$o0, 0)", "CAST(w0$o1), null), w0$o0) AS avgA"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcTimeBoundedNonPartitionedRangeOver() {
        String sqlQuery = "SELECT a,   COUNT(c) OVER (ORDER BY proctime     RANGE BETWEEN INTERVAL '10' SECOND PRECEDING AND CURRENT ROW) FROM MyTable";
        String sqlQuery2 = "SELECT a,   COUNT(c) OVER w FROM MyTable WINDOW w AS (ORDER BY proctime   RANGE BETWEEN INTERVAL '10' SECOND PRECEDING AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sqlQuery2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 10000 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(c) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcTimeBoundedNonPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW)from MyTable";
        String sql2 = "SELECT c, count(a) OVER w FROM MyTable WINDOW w AS (ORDER BY proctime ROWS BETWEEN 2 preceding AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 2 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeUnboundedPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED preceding) as cnt1, sum(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED preceding) as cnt2 from MyTable";
        String sql2 = "SELECT c, count(a) OVER w as cnt1, sum(a) OVER (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED preceding) as cnt2 FROM MyTable WINDOW w AS (PARTITION BY c ORDER BY proctime RANGE UNBOUNDED preceding)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeUnboundedPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) from MyTable";
        String sql2 = "SELECT c, count(a) OVER w FROM MyTable WINDOW w AS (PARTITION BY c ORDER BY proctime ROWS UNBOUNDED preceding)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "proctime", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeUnboundedNonPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY proctime RANGE UNBOUNDED preceding) as cnt1, sum(a) OVER (ORDER BY proctime RANGE UNBOUNDED preceding) as cnt2 from MyTable";
        String sql2 = "SELECT c, count(a) OVER (ORDER BY proctime RANGE UNBOUNDED preceding) as cnt1, sum(a) OVER w as cnt2 FROM MyTable WINDOW w AS(ORDER BY proctime RANGE UNBOUNDED preceding)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeUnboundedNonPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW) from MyTable";
        String sql2 = "SELECT c, count(a) OVER w FROM MyTable WINDOW w AS (ORDER BY proctime ROWS BETWEEN UNBOUNDED preceding AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "proctime", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeBoundedPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY rowtime ROWS BETWEEN 5 preceding AND CURRENT ROW) from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 5 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeBoundedPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY rowtime RANGE BETWEEN INTERVAL '1' SECOND  preceding AND CURRENT ROW) from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 1000 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeBoundedNonPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY rowtime ROWS BETWEEN 5 preceding AND CURRENT ROW) from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 5 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeBoundedNonPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY rowtime RANGE BETWEEN INTERVAL '1' SECOND  preceding AND CURRENT ROW) as cnt1 from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 1000 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS $1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeUnboundedPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY rowtime RANGE UNBOUNDED preceding) as cnt1, sum(a) OVER (PARTITION BY c ORDER BY rowtime RANGE UNBOUNDED preceding) as cnt2 from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeUnboundedPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (PARTITION BY c ORDER BY rowtime ROWS UNBOUNDED preceding) as cnt1, sum(a) OVER (PARTITION BY c ORDER BY rowtime ROWS UNBOUNDED preceding) as cnt2 from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeUnboundedNonPartitionedRangeOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY rowtime RANGE UNBOUNDED preceding) as cnt1, sum(a) OVER (ORDER BY rowtime RANGE UNBOUNDED preceding) as cnt2 from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("range", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testRowTimeUnboundedNonPartitionedRowsOver() {
        String sql = "SELECT c, count(a) OVER (ORDER BY rowtime ROWS UNBOUNDED preceding) as cnt1, sum(a) OVER (ORDER BY rowtime ROWS UNBOUNDED preceding) as cnt2 from MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "rowtime", "COUNT(a) AS w0$o0", "$SUM0(a) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "w0$o0 AS cnt1", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS cnt2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testProcTimeBoundedPartitionedRowsOverDifferentWindows() {
        String sql = "SELECT a, SUM(c) OVER (PARTITION BY a ORDER BY proctime ROWS BETWEEN 3 PRECEDING AND CURRENT ROW), MIN(c) OVER (PARTITION BY a ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW) FROM MyTable";
        String sql2 = "SELECT a, SUM(c) OVER w1, MIN(c) OVER w2 FROM MyTable WINDOW w1 AS (PARTITION BY a ORDER BY proctime ROWS BETWEEN 3 PRECEDING AND CURRENT ROW),w2 AS (PARTITION BY a ORDER BY proctime ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)";
        this.streamUtil().verifySqlPlansIdentical(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sql2}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamOverAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("partitionBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("orderBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime"})), TableTestUtil$.MODULE$.term("rows", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"BETWEEN 3 PRECEDING AND CURRENT ROW"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "COUNT(c) AS w0$o0", "$SUM0(c) AS w0$o1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "CASE(>(w0$o0, 0)", "CAST(w0$o1), null) AS EXPR$1", "w1$o0 AS EXPR$2"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    public OverWindowTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.OverWindowTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

