/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.JoinTest$;
import org.apache.flink.table.calcite.RelTimeIndicatorConverter$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Null;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.runtime.join.WindowJoinUtil;
import org.apache.flink.table.runtime.join.WindowJoinUtil$;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001E\u0011\u0001BS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\t1!\u00199j\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011!B;uS2\u001c\u0018BA\f\u0015\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0003 \u0003)\u0019HO]3b[V#\u0018\u000e\\\u000b\u0002AA\u00111#I\u0005\u0003EQ\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2Da\u0001\n\u0001!\u0002\u0013\u0001\u0013aC:ue\u0016\fW.\u0016;jY\u0002BQA\n\u0001\u0005\u0002\u001d\nq\u0005^3tiB\u0013xnY3tg&tw\rV5nK&sg.\u001a:K_&tw+\u001b;i\u001f:\u001cE.Y;tKR\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0003V]&$\bFA\u00130!\t\u00014'D\u00012\u0015\t\u0011d\"A\u0003kk:LG/\u0003\u00025c\t!A+Z:u\u0011\u00151\u0004\u0001\"\u0001(\u0003\u0001\"Xm\u001d;S_^$\u0016.\\3J]:,'OS8j]^KG\u000f[(o\u00072\fWo]3)\u0005Uz\u0003\"B\u001d\u0001\t\u00039\u0013A\u000b;fgR\u0004&o\\2fgNLgn\u001a+j[\u0016LeN\\3s\u0015>LgnV5uQ^CWM]3DY\u0006,8/\u001a\u0015\u0003q=BQ\u0001\u0010\u0001\u0005\u0002\u001d\n1\u0005^3tiJ{w\u000fV5nK&sg.\u001a:K_&tw+\u001b;i/\",'/Z\"mCV\u001cX\r\u000b\u0002<_!)q\b\u0001C\u0001O\u0005AB/Z:u\u0015>LgnV5uQ\u0016\u000bX/\u001b)s_\u000e$\u0016.\\3)\u0005yz\u0003\"\u0002\"\u0001\t\u00039\u0013a\u0006;fgRTu.\u001b8XSRDW)];j%><H+[7fQ\t\tu\u0006C\u0003F\u0001\u0011\u0005q%A\fuKN$(j\\5o/&$\bNT;mY2KG/\u001a:bY\"\u0012Ai\f\u0005\u0006\u0011\u0002!\taJ\u00010i\u0016\u001cHOU8x)&lW-\u00138oKJTu.\u001b8B]\u0012<\u0016N\u001c3po\u0006;wM]3hCRLwN\\(o\r&\u00148\u000f\u001e\u0015\u0003\u000f>BQa\u0013\u0001\u0005\u0002\u001d\n\u0001\u0007^3tiJ{w\u000fV5nK&sg.\u001a:K_&t\u0017I\u001c3XS:$wn^!hOJ,w-\u0019;j_:|enU3d_:$\u0007F\u0001&0\u0011\u0015q\u0005\u0001\"\u0001(\u0003e!Xm\u001d;Qe>\u001cG+[7f\u0019\u00164GoT;uKJTu.\u001b8)\u00055{\u0003\"B)\u0001\t\u00039\u0013\u0001\u0007;fgR\u0014vn\u001e+j[\u0016dUM\u001a;PkR,'OS8j]\"\u0012\u0001k\f\u0005\u0006)\u0002!\taJ\u0001\u001bi\u0016\u001cH\u000f\u0015:pGRKW.\u001a*jO\"$x*\u001e;fe*{\u0017N\u001c\u0015\u0003'>BQa\u0016\u0001\u0005\u0002\u001d\n\u0011\u0004^3tiJ{w\u000fV5nKJKw\r\u001b;PkR,'OS8j]\"\u0012ak\f\u0005\u00065\u0002!\taJ\u0001\u001ai\u0016\u001cH\u000f\u0015:pGRKW.\u001a$vY2|U\u000f^3s\u0015>Lg\u000e\u000b\u0002Z_!)Q\f\u0001C\u0001O\u0005AB/Z:u%><H+[7f\rVdGnT;uKJTu.\u001b8)\u0005q{\u0003\"\u00021\u0001\t\u00039\u0013\u0001\u0005;fgR|U\u000f^3s\u0015>Lgn\u00149uQ\tyv\u0006C\u0003d\u0001\u0011\u0005q%\u0001\u000buKN$(j\\5o)&lWMQ8v]\u0012\f'/\u001f\u0015\u0003E>BQA\u001a\u0001\u0005\u0002\u001d\na\u0004^3ti*{\u0017N\u001c*f[\u0006LgnQ8oI&$\u0018n\u001c8D_:4XM\u001d;)\u0005\u0015|\u0003\"B5\u0001\t\u00039\u0013!\u0007;fgRdUM\u001a;PkR,'OS8j]\u0016\u000bX/\u001b)sK\u0012D#\u0001[\u0018\t\u000b1\u0004A\u0011A\u0014\u0002CQ,7\u000f\u001e'fMR|U\u000f^3s\u0015>Lg.R9vS\u0006sG\rT8dC2\u0004&/\u001a3)\u0005-|\u0003\"B8\u0001\t\u00039\u0013a\t;fgRdUM\u001a;PkR,'OS8j]\u0016\u000bX/[!oI:{g.R9vSB\u0013X\r\u001a\u0015\u0003]>BQA\u001d\u0001\u0005\u0002\u001d\n!\u0004^3tiJKw\r\u001b;PkR,'OS8j]\u0016\u000bX/\u001b)sK\u0012D#!]\u0018\t\u000bU\u0004A\u0011A\u0014\u0002EQ,7\u000f\u001e*jO\"$x*\u001e;fe*{\u0017N\\#rk&\fe\u000e\u001a'pG\u0006d\u0007K]3eQ\t!x\u0006C\u0003y\u0001\u0011\u0005q%\u0001\u0013uKN$(+[4ii>+H/\u001a:K_&tW)];j\u0003:$gj\u001c8FcVL\u0007K]3eQ\t9x\u0006C\u0003|\u0001\u0011%A0\u0001\nwKJLg-\u001f+j[\u0016\u0014u.\u001e8eCJLH\u0003\u0003\u0015~\u0003+\ty\"a\t\t\u000byT\b\u0019A@\u0002\u000fQLW.Z*rYB!\u0011\u0011AA\b\u001d\u0011\t\u0019!a\u0003\u0011\u0007\u0005\u0015!&\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\t\u0002\rq\u0012xn\u001c;?\u0013\r\tiAK\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055!\u0006C\u0004\u0002\u0018i\u0004\r!!\u0007\u0002\u0017\u0015D\b\u000fT3giNK'0\u001a\t\u0004S\u0005m\u0011bAA\u000fU\t!Aj\u001c8h\u0011\u001d\t\tC\u001fa\u0001\u00033\tA\"\u001a=q%&<\u0007\u000e^*ju\u0016Da!!\n{\u0001\u0004y\u0018aC3yaRKW.\u001a+za\u0016Dq!!\u000b\u0001\t\u0013\tY#\u0001\u000fwKJLg-\u001f*f[\u0006LgnQ8oI&$\u0018n\u001c8D_:4XM\u001d;\u0015\u000b!\ni#!\r\t\u000f\u0005=\u0012q\u0005a\u0001\u007f\u0006)\u0011/^3ss\"9\u00111GA\u0014\u0001\u0004y\u0018!D3ya\u0016\u001cGoQ8oIN#(\u000f")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testProcessingTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 3600000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, proctime, a0, b, proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeInnerJoinWithOnClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' SECOND AND t2.c + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 10000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c, a0, b, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcessingTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 3600000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, proctime, a0, b, proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b0 AS b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeInnerJoinWithWhereClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' MINUTE AND t2.c + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 600000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c, a0, b, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b0 AS b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testJoinWithEquiProcTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.proctime = t2.proctime\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), =(PROCTIME(proctime), PROCTIME(proctime0)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime", "a0", "b", "proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b0 AS b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testJoinWithEquiRowTime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.c = t2.c\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), =(CAST(c), CAST(c0)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "a0", "b", "c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b0 AS b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testJoinWithNullLiteral() {
        StreamTableTestUtil streamUtil = this.streamTestUtil();
        Table t1 = streamUtil.addTable("Table1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.sql.JoinTest$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.WithOperations((Expression)new Null(Types$.MODULE$.LONG())).as((Symbol)SymbolLiteral.bootstrap("apply", "nullField"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        Table t2 = streamUtil.addTable("Table2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.sql.JoinTest$$anon$24 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.LiteralLongExpression(12L).as((Symbol)SymbolLiteral.bootstrap("apply", "nullField"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}));
        streamUtil.tableEnv().registerTable("T1", t1);
        streamUtil.tableEnv().registerTable("T2", t2);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.a, t2.c, t1.c\n        |FROM T1 AS t1\n        |JOIN T2 AS t2 ON t1.a = t2.a AND t1.nullField = t2.nullField AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '5' SECOND AND\n        |  t2.proctime + INTERVAL '5' SECOND\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "null AS nullField"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "12 AS nullField"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), =(nullField, nullField0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 5000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 5000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c", "proctime", "nullField", "a0", "c0", "proctime0", "nullField0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a0 AS a", "c0 AS c", "c AS c0"}))}));
        streamUtil.verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnFirst() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.b, SUM(t2.a) AS aSum, COUNT(t2.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' MINUTE AND t2.c + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t1.c, INTERVAL '6' HOUR), t1.b\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 600000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c, a0, b0, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "b", "a0", "b0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.LiteralIntExpression(21600000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "SUM(a0) AS aSum", "COUNT(b0) AS bCnt"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeInnerJoinAndWindowAggregationOnSecond() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t2.b, SUM(t1.a) AS aSum, COUNT(t1.b) AS bCnt\n        |FROM MyTable t1, MyTable2 t2\n        |WHERE t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' MINUTE AND t2.c + INTERVAL '1' HOUR\n        |GROUP BY TUMBLE(t2.c, INTERVAL '6' HOUR), t2.b\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 600000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c, a0, b0, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c0", "b0", "a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b0"})), TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c0")), package$.MODULE$.LiteralIntExpression(21600000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b0", "SUM(a) AS aSum", "COUNT(b) AS bCnt"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 3600000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, proctime, a0, b, proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeLeftOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 LEFT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' SECOND AND t2.c + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 10000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c, a0, b, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 3600000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, proctime, a0, b, proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RightOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeRightOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 RIGHT OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' SECOND AND t2.c + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 10000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c, a0, b, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RightOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testProcTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 Full OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.proctime BETWEEN t2.proctime - INTERVAL '1' HOUR AND t2.proctime + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "proctime"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(PROCTIME(proctime), -(PROCTIME(proctime0), 3600000)), <=(PROCTIME(proctime), +(PROCTIME(proctime0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, proctime, a0, b, proctime0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"FullOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowTimeFullOuterJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' SECOND AND t2.c + INTERVAL '1' HOUR\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 10000)), <=(CAST(c), +(CAST(c0), 3600000)))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c, a0, b, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"FullOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testOuterJoinOpt() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.a, t2.b\n        |FROM MyTable t1 FULL OUTER JOIN MyTable2 t2 ON\n        |  t1.a = t2.a AND\n        |  t1.c BETWEEN t2.c - INTERVAL '10' SECOND AND t2.c + INTERVAL '1' HOUR\n        |  WHERE t1.b LIKE t2.b\n        |")).stripMargin();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamWindowJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, a0), >=(CAST(c), -(CAST(c0), 10000)), <=(CAST(c), +(CAST(c0), 3600000)), LIKE(b, b0))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c, a0, b0, c0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b0 AS b"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testJoinTimeBoundary() {
        this.verifyTimeBoundary("t1.proctime between t2.proctime - interval '1' hour and t2.proctime + interval '1' hour", -3600000L, 3600000L, "proctime");
        this.verifyTimeBoundary("t1.proctime > t2.proctime - interval '1' second and t1.proctime < t2.proctime + interval '1' second", -999L, 999L, "proctime");
        this.verifyTimeBoundary("t1.c >= t2.c - interval '1' second and t1.c <= t2.c + interval '1' second", -1000L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.c >= t2.c and t1.c <= t2.c + interval '1' second", 0L, 1000L, "rowtime");
        this.verifyTimeBoundary("t1.c >= t2.c + interval '1' second and t1.c <= t2.c + interval '10' second", 1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t2.c - interval '1' second <= t1.c and t2.c + interval '10' second >= t1.c", -1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.c >= t2.c - interval '1' second and t1.c <= t2.c + interval '10' second", -1000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.c - interval '2' second >= t2.c + interval '1' second - interval '10' second and t1.c <= t2.c + interval '10' second", -7000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t2.c + interval '1' second - interval '10' second <= t1.c - interval '2' second and t2.c + interval '10' second >= t1.c", -7000L, 10000L, "rowtime");
        this.verifyTimeBoundary("t1.c >= t2.c - interval '10' second and t1.c <= t2.c - interval '5' second", -10000L, -5000L, "rowtime");
        this.verifyTimeBoundary("t2.c - interval '10' second <= t1.c and t2.c - interval '5' second >= t1.c", -10000L, -5000L, "rowtime");
        this.verifyTimeBoundary("t1.c > t2.c - interval '2' second and t1.c < t2.c + interval '2' second", -1999L, 1999L, "rowtime");
        this.verifyTimeBoundary("t2.c > t1.c - interval '2' second and t2.c < t1.c + interval '2' second", -1999L, 1999L, "rowtime");
        this.verifyTimeBoundary("t1.c = t2.c", 0L, 0L, "rowtime");
    }

    @Test
    public void testJoinRemainConditionConvert() {
        this.streamUtil().addTable("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.sql.JoinTest$$anon$25 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addTable("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).rowtime(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.api.stream.sql.JoinTest$$anon$26 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT t1.a, t2.c FROM MyTable3 as t1 join MyTable4 as t2 on t1.a = t2.a and t1.b >= t2.b - interval '10' second and t1.b <= t2.b - interval '5' second and t1.c > t2.c";
        this.verifyRemainConditionConvert(query, "AND(=($0, $4), >($2, $6))");
        String query1 = "SELECT t1.a, t2.c FROM MyTable3 as t1 join MyTable4 as t2 on t1.a = t2.a and t1.b >= t2.b - interval '10' second and t1.b <= t2.b - interval '5' second ";
        this.verifyRemainConditionConvert(query1, "=($0, $4)");
        this.streamUtil().addTable("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$27 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.api.stream.sql.JoinTest$$anon$27 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addTable("MyTable6", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$28 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.api.stream.sql.JoinTest$$anon$28 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query2 = "SELECT t1.a, t2.c FROM MyTable5 as t1 join MyTable6 as t2 on t1.a = t2.a and t1.proctime >= t2.proctime - interval '10' second and t1.proctime <= t2.proctime - interval '5' second and t1.c > t2.c";
        this.verifyRemainConditionConvert(query2, "AND(=($0, $4), >($2, $6))");
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$29 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.api.stream.sql.JoinTest$$anon$29 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$30 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.api.stream.sql.JoinTest$$anon$30 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, y FROM t LEFT OUTER JOIN s ON a = z";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"y", "z"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(a, z)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "y", "z"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "y"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$31 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.api.stream.sql.JoinTest$$anon$31 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$32 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.api.stream.sql.JoinTest$$anon$32 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "<(b, 2) AS $f3"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"y", "z"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, z), $f3)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "$f3", "y", "z"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "y"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$33 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.api.stream.sql.JoinTest$$anon$33 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$34 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$14[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$14(org.apache.flink.table.api.stream.sql.JoinTest$$anon$34 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, z), <(b, x))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "x", "y", "z"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "y"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$35 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$15[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$15(org.apache.flink.table.api.stream.sql.JoinTest$$anon$35 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$36 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$16[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$16(org.apache.flink.table.api.stream.sql.JoinTest$$anon$36 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"y", "z"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(a, z)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "y", "z"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RightOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "y"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$37 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$17[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$17(org.apache.flink.table.api.stream.sql.JoinTest$$anon$37 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$38 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$18[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$18(org.apache.flink.table.api.stream.sql.JoinTest$$anon$38 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"x", "z", "<(x, 2) AS $f3"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, z), $f3)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "x", "z", "$f3"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RightOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "x"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$39 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$19[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$19(org.apache.flink.table.api.stream.sql.JoinTest$$anon$39 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$40 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$20[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$20(org.apache.flink.table.api.stream.sql.JoinTest$$anon$40 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String query = "SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x";
        Table result = util.tableEnv().sqlQuery(query);
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), TableTestUtil$.MODULE$.streamTableNode(1), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(=(a, z), <(b, x))"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "x", "y", "z"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RightOuterJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "y"}))}));
        util.verifyTable(result, expected);
    }

    private void verifyTimeBoundary(String timeSql, long expLeftSize, long expRightSize, String expTimeType) {
        Option windowBounds;
        String query = new StringBuilder(76).append("SELECT t1.a, t2.b FROM MyTable as t1 join MyTable2 as t2 on t1.a = t2.a and ").append(timeSql).toString();
        Table resultTable = this.streamUtil().tableEnv().sqlQuery(query);
        RelNode relNode = RelTimeIndicatorConverter$.MODULE$.convert(resultTable.getRelNode(), this.streamUtil().tableEnv().getRelBuilder().getRexBuilder());
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        Tuple2 tuple2 = WindowJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(joinNode.getCondition(), 4, joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.streamUtil().tableEnv().getConfig());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = windowBounds = (Option)tuple2._1();
        Option windowBounds2 = option;
        String timeTypeStr = ((WindowJoinUtil.WindowBounds)windowBounds2.get()).isEventTime() ? "rowtime" : "proctime";
        Assert.assertEquals((long)expLeftSize, (long)((WindowJoinUtil.WindowBounds)windowBounds2.get()).leftLowerBound());
        Assert.assertEquals((long)expRightSize, (long)((WindowJoinUtil.WindowBounds)windowBounds2.get()).leftUpperBound());
        Assert.assertEquals((Object)expTimeType, (Object)timeTypeStr);
    }

    private void verifyRemainConditionConvert(String query, String expectCondStr) {
        Option remainCondition;
        Table resultTable = this.streamUtil().tableEnv().sqlQuery(query);
        RelNode relNode = RelTimeIndicatorConverter$.MODULE$.convert(resultTable.getRelNode(), this.streamUtil().tableEnv().getRelBuilder().getRexBuilder());
        LogicalJoin joinNode = (LogicalJoin)relNode.getInput(0);
        Tuple2 tuple2 = WindowJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(joinNode.getCondition(), 4, joinNode.getRowType(), joinNode.getCluster().getRexBuilder(), this.streamUtil().tableEnv().getConfig());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = remainCondition = (Option)tuple2._2();
        Option remainCondition2 = option;
        String actual = remainCondition2.getOrElse((Function0 & Serializable & scala.Serializable)() -> "").toString();
        Assert.assertEquals((Object)expectCondStr, (Object)actual);
    }

    public JoinTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).rowtime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.JoinTest$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addTable("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).rowtime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.sql.JoinTest$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

