/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.GroupWindowTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001#\tyqI]8va^Kg\u000eZ8x)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tQ!\u001e;jYNL!a\u0006\u000b\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015M$(/Z1n+RLG.F\u0001!!\t\u0019\u0012%\u0003\u0002#)\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1A\u0005\u0001Q\u0001\n\u0001\n1b\u001d;sK\u0006lW\u000b^5mA!)a\u0005\u0001C\u0001O\u0005\u0011B/Z:u)Vl'\r\\3Gk:\u001cG/[8o)\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B+oSRD#!J\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Ir\u0011!\u00026v]&$\u0018B\u0001\u001b2\u0005\u0011!Vm\u001d;\t\u000bY\u0002A\u0011A\u0014\u0002'Q,7\u000f\u001e%paBLgn\u001a$v]\u000e$\u0018n\u001c8)\u0005Uz\u0003\"B\u001d\u0001\t\u00039\u0013a\u0005;fgR\u001cVm]:j_:4UO\\2uS>t\u0007F\u0001\u001d0\u0011\u0015a\u0004\u0001\"\u0001(\u0003\u0005\"Xm\u001d;FqB\u0014Xm]:j_:|enV5oI><\u0018)\u001e=Gk:\u001cG/[8oQ\tYt\u0006C\u0003@\u0001\u0011\u0005q%\u0001\u0013uKN$X\t\u001f9sKN\u001c\u0018n\u001c8P]^Kg\u000eZ8x\u0011\u00064\u0018N\\4Gk:\u001cG/[8oQ\tqt\u0006C\u0003C\u0001\u0011\u0005q%A\u0011uKN$X*\u001e7uS^Kg\u000eZ8x'Fdw+\u001b;i\u0003\u001e<'/Z4bi&|g\u000e\u000b\u0002B_!)Q\t\u0001C\u0001O\u0005aB/Z:u\t\u0016\u001cw.\u001c9pg\u0006\u0014G.Z!hO\u001a+hn\u0019;j_:\u001c\bF\u0001#0\u0001")
public class GroupWindowTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testTumbleFunction() {
        this.streamUtil().tableEnv().registerFunction("weightedAvg", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT   COUNT(*), weightedAvg(c, a) AS wAvg,   TUMBLE_START(rowtime, INTERVAL '15' MINUTE),   TUMBLE_END(rowtime, INTERVAL '15' MINUTE)FROM MyTable GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime", "c", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS EXPR$0", "weightedAvg(c, a) AS wAvg", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "wAvg", "w$start AS EXPR$2", "w$end AS EXPR$3"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testHoppingFunction() {
        this.streamUtil().tableEnv().registerFunction("weightedAvg", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT COUNT(*), weightedAvg(c, a) AS wAvg,   HOP_START(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR),   HOP_END(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR) FROM MyTable GROUP BY HOP(proctime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime", "c", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SlidingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.LiteralIntExpression(3600000).millis(), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS EXPR$0", "weightedAvg(c, a) AS wAvg", "start('w$) AS w$start", "end('w$) AS w$end", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "wAvg", "w$start AS EXPR$2", "w$end AS EXPR$3"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testSessionFunction() {
        this.streamUtil().tableEnv().registerFunction("weightedAvg", (AggregateFunction)new JavaUserDefinedAggFunctions.WeightedAvgWithMerge(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT   COUNT(*), weightedAvg(c, a) AS wAvg,   SESSION_START(proctime, INTERVAL '15' MINUTE),   SESSION_END(proctime, INTERVAL '15' MINUTE) FROM MyTable GROUP BY SESSION(proctime, INTERVAL '15' MINUTE)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"proctime", "c", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SessionGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS EXPR$0", "weightedAvg(c, a) AS wAvg", "start('w$) AS w$start", "end('w$) AS w$end", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "wAvg", "w$start AS EXPR$2", "w$end AS EXPR$3"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testExpressionOnWindowAuxFunction() {
        String sql = "SELECT   COUNT(*),   TUMBLE_END(rowtime, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE FROM MyTable GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS EXPR$0", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "+(w$end, 60000) AS EXPR$1"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testExpressionOnWindowHavingFunction() {
        String sql = "SELECT   COUNT(*),   HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE) FROM MyTable GROUP BY HOP(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE) HAVING   SUM(a) > 0 AND   QUARTER(HOP_START(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime, a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SlidingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(60000).millis(), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS EXPR$0", "SUM(a) AS $f1", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "w$start AS EXPR$1"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(>($f1, 0), =(EXTRACT(FLAG(QUARTER), w$start), 1))"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testMultiWindowSqlWithAggregation() {
        String sql = "SELECT\n          TUMBLE_ROWTIME(zzzzz, INTERVAL '0.004' SECOND),\n          TUMBLE_END(zzzzz, INTERVAL '0.004' SECOND),\n          COUNT(`a`) AS `a`\n        FROM (\n          SELECT\n            COUNT(`a`) AS `a`,\n            TUMBLE_ROWTIME(rowtime, INTERVAL '0.002' SECOND) AS `zzzzz`\n          FROM MyTable\n          GROUP BY TUMBLE(rowtime, INTERVAL '0.002' SECOND)\n        )\n        GROUP BY TUMBLE(zzzzz, INTERVAL '0.004' SECOND)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime, a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(2).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS a", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "w$rowtime AS zzzzz"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "zzzzz")), package$.MODULE$.LiteralIntExpression(4).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(*) AS a", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"w$rowtime AS EXPR$0", "w$end AS EXPR$1", "a"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testDecomposableAggFunctions() {
        String sql = "SELECT   VAR_POP(c), VAR_SAMP(c), STDDEV_POP(c), STDDEV_SAMP(c),   TUMBLE_START(rowtime, INTERVAL '15' MINUTE),   TUMBLE_END(rowtime, INTERVAL '15' MINUTE)FROM MyTable GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime", "c", "*(c, c) AS $f2", "*(c, c) AS $f3", "*(c, c) AS $f4", "*(c, c) AS $f5"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"SUM($f2) AS $f0", "SUM(c) AS $f1", "COUNT(c) AS $f2", "SUM($f3) AS $f3", "SUM($f4) AS $f4", "SUM($f5) AS $f5", "start('w$) AS w$start", "end('w$) AS w$end", "rowtime('w$) AS w$rowtime", "proctime('w$) AS w$proctime"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"CAST(/(-($f0, /(*($f1, $f1), $f2)), $f2)) AS EXPR$0", "CAST(/(-($f3, /(*($f1, $f1), $f2)), CASE(=($f2, 1), null, -($f2, 1)))) AS EXPR$1", "CAST(POWER(/(-($f4, /(*($f1, $f1), $f2)), $f2), 0.5)) AS EXPR$2", "CAST(POWER(/(-($f5, /(*($f1, $f1), $f2)), CASE(=($f2, 1), null, -($f2, 1))), 0.5)) AS EXPR$3", "w$start AS EXPR$4", "w$end AS EXPR$5"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    public GroupWindowTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.GroupWindowTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

