/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.DistinctAggregateTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001#\t)B)[:uS:\u001cG/Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\u000bgR\u0014X-Y7Vi&dW#\u0001\u0011\u0011\u0005M\t\u0013B\u0001\u0012\u0015\u0005M\u0019FO]3b[R\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019!\u0003\u0001)A\u0005A\u0005Y1\u000f\u001e:fC6,F/\u001b7!\u0011\u00151\u0003\u0001\"\u0001(\u00031!Xm\u001d;ESN$\u0018N\\2u)\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B+oSRD#!J\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Ir\u0011!\u00026v]&$\u0018B\u0001\u001b2\u0005\u0011!Vm\u001d;\t\u000bY\u0002A\u0011A\u0014\u00025Q,7\u000f\u001e#jgRLgn\u0019;BMR,'/Q4he\u0016<\u0017\r^3)\u0005Uz\u0003FA\u001b:!\t\u0001$(\u0003\u0002<c\t1\u0011j\u001a8pe\u0016DQ!\u0010\u0001\u0005\u0002\u001d\nQ\u0003^3ti\u0012K7\u000f^5oGR\fum\u001a:fO\u0006$X\r\u000b\u0002=_!)\u0001\t\u0001C\u0001O\u0005\u0019C/Z:u\t&\u001cH/\u001b8di\u0006;wM]3hCR,wJ\u001c+v[\ndWmV5oI><\bFA 0\u0011\u0015\u0019\u0005\u0001\"\u0001(\u00039\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hOJ,w-\u0019;f'\u0006lWMR5fY\u0012|e\u000eS8q/&tGm\\<)\u0005\t{\u0003\"\u0002$\u0001\t\u00039\u0013\u0001\r;fgR$\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/Z,ji\"<%o\\;qS:<wJ\\*fgNLwN\\,j]\u0012|w\u000f\u000b\u0002F_\u0001")
public class DistinctAggregateTest
extends TableTestBase {
    private final StreamTableTestUtil streamUtil = this.streamTestUtil();

    private StreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test
    public void testDistinct() {
        String sql = "SELECT DISTINCT a, b, c FROM MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b, c"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Ignore
    @Test
    public void testDistinctAfterAggregate() {
        String sql = "SELECT DISTINCT a FROM MyTable GROUP BY a, b, c";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))}));
        this.streamUtil().verifySql(sql, expected);
    }

    @Test
    public void testDistinctAggregate() {
        String sqlQuery = "SELECT   c, SUM(DISTINCT a), SUM(a), COUNT(DISTINCT b) FROM MyTable GROUP BY c ";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "SUM(DISTINCT a) AS EXPR$1", "SUM(a) AS EXPR$2", "COUNT(DISTINCT b) AS EXPR$3"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testDistinctAggregateOnTumbleWindow() {
        String sqlQuery = "SELECT COUNT(DISTINCT a),   SUM(a) FROM MyTable GROUP BY TUMBLE(rowtime, INTERVAL '15' MINUTE) ";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new TumblingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(DISTINCT a) AS EXPR$0", "SUM(a) AS EXPR$1"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testMultiDistinctAggregateSameFieldOnHopWindow() {
        String sqlQuery = "SELECT COUNT(DISTINCT a),   SUM(DISTINCT a),   MAX(DISTINCT a) FROM MyTable GROUP BY HOP(rowtime, INTERVAL '15' MINUTE, INTERVAL '1' HOUR) ";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"rowtime", "a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SlidingGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(3600000).millis(), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(DISTINCT a) AS EXPR$0", "SUM(DISTINCT a) AS EXPR$1", "MAX(DISTINCT a) AS EXPR$2"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    @Test
    public void testDistinctAggregateWithGroupingOnSessionWindow() {
        String sqlQuery = "SELECT a,   COUNT(a),   SUM(DISTINCT c) FROM MyTable GROUP BY a, SESSION(rowtime, INTERVAL '15' MINUTE) ";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamGroupWindowAggregate", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "rowtime", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("window", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new SessionGroupWindow(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "w$")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.LiteralIntExpression(900000).millis())})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "COUNT(a) AS EXPR$1", "SUM(DISTINCT c) AS EXPR$2"}))}));
        this.streamUtil().verifySql(sqlQuery, expected);
    }

    public DistinctAggregateTest() {
        this.streamUtil().addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, String, Object>> createSerializerInstance(Class<Tuple3<Object, String, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.DistinctAggregateTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

