/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.api.stream.sql.CorrelateTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.utils.HierarchyTableFunction;
import org.apache.flink.table.utils.PojoTableFunc;
import org.apache.flink.table.utils.PojoUser;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableFunc1;
import org.apache.flink.table.utils.TableFunc2;
import org.apache.flink.table.utils.TableFunc5;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.apache.flink.table.utils.VarArgsFunc0;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001#\ti1i\u001c:sK2\fG/\u001a+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\tQ\u0002^3ti\u000e\u0013xn]:K_&tG#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003;\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\b\u0002\u000b),h.\u001b;\n\u00051J#\u0001\u0002+fgRDQA\f\u0001\u0005\u0002}\t\u0001\u0005^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\b\u000eT5uKJ\fG\u000e\u0016:vK\"\u0012Qf\n\u0005\u0006c\u0001!\taH\u0001\u001ci\u0016\u001cH\u000fT3gi>+H/\u001a:K_&t\u0017i]*vEF+XM]=)\u0005A:\u0003\"\u0002\u001b\u0001\t\u0003y\u0012A\u0004;fgR\u001cUo\u001d;p[RK\b/\u001a\u0015\u0003g\u001dBQa\u000e\u0001\u0005\u0002}\t\u0011\u0003^3ti\"KWM]1sG\"LH+\u001f9fQ\t1t\u0005C\u0003;\u0001\u0011\u0005q$\u0001\u0007uKN$\bk\u001c6p)f\u0004X\r\u000b\u0002:O!)Q\b\u0001C\u0001?\u0005YA/Z:u%><H+\u001f9fQ\tat\u0005C\u0003A\u0001\u0011\u0005q$\u0001\u0006uKN$h)\u001b7uKJD#aP\u0014\t\u000b\r\u0003A\u0011A\u0010\u0002%Q,7\u000f^*dC2\f'OR;oGRLwN\u001c\u0015\u0003\u0005\u001eBQA\u0012\u0001\u0005\u0002}\ta\u0005^3tiR\u000b'\r\\3Gk:\u001cG/[8o/&$\bNV1sS\u0006\u0014G.Z!sOVlWM\u001c;tQ\t)u\u0005")
public class CorrelateTest
extends TableTestBase {
    @Test
    public void testCrossJoin() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc1 func1 = new TableFunc1();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func1", func1, BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = "SELECT c, s FROM MyTable, LATERAL TABLE(func1(c)) AS T(s)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery, expected);
        String sqlQuery2 = "SELECT c, s FROM MyTable, LATERAL TABLE(func1(c, '$')) AS T(s)";
        String expected2 = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1($cor0.c, '$')"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1($cor0.c, '$'))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery2, expected2);
    }

    @Test
    public void testLeftOuterJoinWithLiteralTrue() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc1 func1 = new TableFunc1();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func1", func1, BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = "SELECT c, s FROM MyTable LEFT JOIN LATERAL TABLE(func1(c)) AS T(s) ON TRUE";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LEFT"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testLeftOuterJoinAsSubQuery() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc1 func1 = new TableFunc1();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addTable("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c2"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func1", func1, BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT *\n        | FROM MyTable2 LEFT OUTER JOIN\n        |  (SELECT c, s\n        |   FROM MyTable LEFT OUTER JOIN LATERAL TABLE(func1(c)) AS T(s) on true)\n        | ON c2 = s ")).stripMargin();
        String expected = TableTestUtil$.MODULE$.binaryNode("DataStreamJoin", TableTestUtil$.MODULE$.streamTableNode(1), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LEFT"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"=(c2, s)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a2", "b2", "c2", "c", "s"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"LeftOuterJoin"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testCustomType() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc2 func2 = new TableFunc2();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func2", func2, TypeExtractor.createTypeInfo(Row.class));
        String sqlQuery = "SELECT c, name, len FROM MyTable, LATERAL TABLE(func2(c)) AS T(name, len)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func2($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func2($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0", "f1"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0, INTEGER f1)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS name", "f1 AS len"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testHierarchyType() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        HierarchyTableFunction function = new HierarchyTableFunction();
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(String.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Boolean.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)Nil$.MODULE$)));
        Class<Tuple3> clazz = Tuple3.class;
        util.addFunction("hierarchy", function, new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))));
        String sqlQuery = "SELECT c, T.* FROM MyTable, LATERAL TABLE(hierarchy(c)) AS T(name, adult, len)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"hierarchy($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(hierarchy($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0", "f1", "f2"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0, BOOLEAN f1, INTEGER f2)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS name", "f1 AS adult", "f2 AS len"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testPojoType() {
        GenericTypeInfo genericTypeInfo;
        Class<PojoUser> clazz;
        StreamTableTestUtil util = this.streamTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        PojoTableFunc function = new PojoTableFunc();
        .colon.colon fields = new .colon.colon((Object)new Tuple2((Object)"age", (Object)BasicTypeInfo.getInfoFor(Integer.TYPE)), (List)new .colon.colon((Object)new Tuple2((Object)"name", (Object)BasicTypeInfo.getInfoFor(String.class)), (List)Nil$.MODULE$));
        Map clazzFields = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef error = BooleanRef.create((boolean)false);
        for (Class traversalClazz = clazz = PojoUser.class; traversalClazz != null; traversalClazz = traversalClazz.getSuperclass()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])traversalClazz.getDeclaredFields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
                block0: {
                    if (!clazzFields.contains((Object)field.getName()) || Modifier.isStatic(field.getModifiers())) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(59).append("The field ").append(field).append(" is already contained in the ").append(new StringBuilder(66).append("hierarchy of the class ").append(clazz).append(". Please use unique field names throughout ").toString()).append("your class hierarchy").toString());
                    error$1.elem = true;
                }
                return (Map)clazzFields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field));
            });
        }
        if (error.elem) {
            genericTypeInfo = new GenericTypeInfo(clazz);
        } else {
            List pojoFields = (List)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fName = (String)tuple2._1();
                BasicTypeInfo fTpe = (BasicTypeInfo)tuple2._2();
                Field field = (Field)clazzFields.apply((Object)fName);
                Iterable iterable = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)new PojoField((Field)clazzFields.apply((Object)fName), (TypeInformation)fTpe)));
                return iterable;
            }, List$.MODULE$.canBuildFrom());
            genericTypeInfo = new PojoTypeInfo(clazz, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pojoFields).asJava());
        }
        util.addFunction("pojo", function, genericTypeInfo);
        String sqlQuery = "SELECT c, name, age FROM MyTable, LATERAL TABLE(pojo(c))";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"pojo($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(pojo($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "age", "name"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, INTEGER age, VARCHAR(65536) name)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "name", "age"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testRowType() {
        StreamTableTestUtil util = this.streamTestUtil();
        TypeInformation rowType = Types$.MODULE$.ROW((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.BOOLEAN(), Types$.MODULE$.ROW((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeInformation[]{Types$.MODULE$.INT(), Types$.MODULE$.INT(), Types$.MODULE$.INT()}))}));
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), rowType);
        TableFunc5 function = new TableFunc5();
        util.addFunction("tableFunc5", function, TypeExtractor.createTypeInfo(Row.class));
        String sqlQuery = "SELECT c, tf.f2 FROM MyTable, LATERAL TABLE(tableFunc5(c)) AS tf";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"tableFunc5($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(tableFunc5($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0", "f1", "f2"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BOOLEAN b, COMPOSITE(Row(f0: Integer, f1: Integer, f2: Integer)) c, INTEGER f0, INTEGER f1, INTEGER f2)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testFilter() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc2 func2 = new TableFunc2();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func2", func2, TypeExtractor.createTypeInfo(Row.class));
        String sqlQuery = "SELECT c, name, len FROM MyTable, LATERAL TABLE(func2(c)) AS T(name, len) WHERE len > 2";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func2($cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func2($cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0", "f1"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0, INTEGER f1)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"})), TableTestUtil$.MODULE$.term("condition", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{">($1, 2)"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS name", "f1 AS len"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testScalarFunction() {
        StreamTableTestUtil util = this.streamTestUtil();
        TableFunc1 func1 = new TableFunc1();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func1", func1, BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = "SELECT c, s FROM MyTable, LATERAL TABLE(func1(SUBSTRING(c, 2))) AS T(s)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1(SUBSTRING($cor0.c, 2))"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1(SUBSTRING($cor0.c, 2)))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        StreamTableTestUtil util = this.streamTestUtil();
        JavaUserDefinedTableFunctions.JavaVarsArgTableFunc0 func1 = new JavaUserDefinedTableFunctions.JavaVarsArgTableFunc0();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<scala.Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<scala.Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public scala.Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<scala.Tuple3<Object, Object, String>> createSerializerInstance(Class<scala.Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.api.stream.sql.CorrelateTest$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        util.addFunction("func1", func1, BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = "SELECT c, s FROM MyTable, LATERAL TABLE(func1('hello', 'world', c)) AS T(s)";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func1('hello', 'world', $cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func1('hello', 'world', $cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery, expected);
        VarArgsFunc0 func2 = new VarArgsFunc0();
        util.addFunction("func2", func2, BasicTypeInfo.getInfoFor(String.class));
        sqlQuery = "SELECT c, s FROM MyTable, LATERAL TABLE(func2('hello', 'world', c)) AS T(s)";
        expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", TableTestUtil$.MODULE$.unaryNode("DataStreamCorrelate", TableTestUtil$.MODULE$.streamTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("invocation", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"func2('hello', 'world', $cor0.c)"})), TableTestUtil$.MODULE$.term("correlate", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"table(func2('hello', 'world', $cor0.c))"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "c", "f0"})), TableTestUtil$.MODULE$.term("rowType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"RecordType(INTEGER a, BIGINT b, VARCHAR(65536) c, VARCHAR(65536) f0)"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"INNER"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "f0 AS s"}))}));
        util.verifySql(sqlQuery, expected);
    }
}

