/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.batch.table.TemporalTableJoinTest$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil;
import org.apache.flink.types.Row;
import org.hamcrest.Matchers;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001!\t)B+Z7q_J\fG\u000eV1cY\u0016Tu.\u001b8UKN$(BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005\rI!B\u0001\u0006\f\u0003\u00151G.\u001b8l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!\u001e;jYNL!AF\n\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t!\u0001C\u0004\u001e\u0001\t\u0007I\u0011\u0001\u0010\u0002\tU$\u0018\u000e\\\u000b\u0002?A\u0011!\u0003I\u0005\u0003CM\u0011Q\u0002V1cY\u0016$Vm\u001d;Vi&d\u0007BB\u0012\u0001A\u0003%q$A\u0003vi&d\u0007\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002\r=\u0014H-\u001a:t+\u00059\u0003C\u0001\u0015*\u001b\u00051\u0011B\u0001\u0016\u0007\u0005\u0015!\u0016M\u00197f\u0011\u0019a\u0003\u0001)A\u0005O\u00059qN\u001d3feN\u0004\u0003b\u0002\u0018\u0001\u0005\u0004%\tAJ\u0001\re\u0006$Xm\u001d%jgR|'/\u001f\u0005\u0007a\u0001\u0001\u000b\u0011B\u0014\u0002\u001bI\fG/Z:ISN$xN]=!\u0011\u001d\u0011\u0004A1A\u0005\u0002M\nQA]1uKN,\u0012\u0001\u000e\t\u0004kaRT\"\u0001\u001c\u000b\u0005]B\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\tIdGA\u0007UC\ndWMR;oGRLwN\u001c\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{%\tQ\u0001^=qKNL!a\u0010\u001f\u0003\u0007I{w\u000f\u0003\u0004B\u0001\u0001\u0006I\u0001N\u0001\u0007e\u0006$Xm\u001d\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\u001dQ,7\u000f^*j[BdWMS8j]R\tQ\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003V]&$\bF\u0001\"M!\ti\u0005+D\u0001O\u0015\tyU\"A\u0003kk:LG/\u0003\u0002R\u001d\n!A+Z:u\u0011\u0015\u0019\u0006\u0001\"\u0001E\u0003Q!Xm\u001d;V]\u000e|'O]3mCR,GMS8j]\"\u0012!\u000b\u0014\u0005\u0006-\u0002!\t\u0001R\u0001\u001ei\u0016\u001cH\u000fV3na>\u0014\u0018\r\u001c+bE2,g)\u001e8di&|gnU2b]\"\u0012Q\u000b\u0014")
public class TemporalTableJoinTest
extends TableTestBase {
    private final TableTestUtil util = this.batchTestUtil();
    private final Table orders = this.util().addTable("Orders", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_amount")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                }

                public CaseClassSerializer<Tuple3<Object, String, Timestamp>> createSerializerInstance(Class<Tuple3<Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.table.TemporalTableJoinTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final Table ratesHistory = this.util().addTable("RatesHistory", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

        public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
            return x$1.types;
        }

        public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
            TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
            });
            return new CaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                    return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                }

                public CaseClassSerializer<Tuple3<String, Object, Timestamp>> createSerializerInstance(Class<Tuple3<String, Object, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                    return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                }
            };
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.table.TemporalTableJoinTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
        }
    });
    private final TableFunction<Row> rates = this.util().addFunction("Rates", this.ratesHistory().createTemporalTableFunction(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "currency"))), TypeExtractor.createTypeInfo(Row.class));

    public TableTestUtil util() {
        return this.util;
    }

    public Table orders() {
        return this.orders;
    }

    public Table ratesHistory() {
        return this.ratesHistory;
    }

    public TableFunction<Row> rates() {
        return this.rates;
    }

    @Test
    public void testSimpleJoin() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Cannot generate a valid execution plan for the given query");
        Table result = this.orders().join(package$.MODULE$.tableFunctionCall2Table(this.rates()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "o_rowtime"))}), TypeExtractor.createTypeInfo(Row.class)), "currency = o_currency").select("o_amount * rate").as("rate");
        this.util().printTable(result);
    }

    @Test
    public void testUncorrelatedJoin() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage(Matchers.startsWith((String)"Unsupported argument"));
        Table result = this.orders().join(package$.MODULE$.tableFunctionCall2Table(this.rates()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.sqlTimestamp2Literal(Timestamp.valueOf("2016-06-27 10:10:42.123"))}), TypeExtractor.createTypeInfo(Row.class)), "o_currency = currency").select("o_amount * rate");
        this.util().printTable(result);
    }

    @Test
    public void testTemporalTableFunctionScan() {
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Cannot translate a query with an unbounded table function call.");
        Table result = package$.MODULE$.tableFunctionCall2Table(this.rates()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.sqlTimestamp2Literal(Timestamp.valueOf("2016-06-27 10:10:42.123"))}), TypeExtractor.createTypeInfo(Row.class));
        this.util().printTable(result);
    }
}

