/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.sql.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001'\tIrI]8va^Kg\u000eZ8x-\u0006d\u0017\u000eZ1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0006wC2LG-\u0019;j_:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\u0004CBL'BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!)\u0001\u0005\u0001C\u0001C\u0005)B/Z:u\u0011>\u0004x+\u001b8e_^tun\u00144gg\u0016$H#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0015\u0005?%z\u0003\u0007\u0005\u0002+[5\t1F\u0003\u0002-!\u0005)!.\u001e8ji&\u0011af\u000b\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\u0005\t\u0004C\u0001\u001a4\u001b\u0005A\u0011B\u0001\u001b\t\u00059!\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:DQA\u000e\u0001\u0005\u0002\u0005\n\u0011\u0004^3tiN+7o]5p]^Kg\u000eZ8x\u001d>|eMZ:fi\"\"Q'K\u00181\u0011\u0015I\u0004\u0001\"\u0001\"\u0003Y!Xm\u001d;WCJL\u0017M\u00197f/&tGm\\<TSj,\u0007\u0006\u0002\u001d*_ABQ\u0001\u0010\u0001\u0005\u0002\u0005\nA\u0005^3tiR+XN\u00197f/&tGm\\<XSRD\u0017J\u001c<bY&$W\u000bZ!hO\u0006\u0013xm\u001d\u0015\u0005w%zchI\u0001@!\t\u0011\u0004)\u0003\u0002B\u0011\t\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")1\t\u0001C\u0001C\u0005\u0011B/Z:u/&tGm\\<Qe>\u001cG/[7fQ\u0011\u0011\u0015f\f ")
public class GroupWindowValidationTest
extends TableTestBase {
    @Test(expected=TableException.class)
    public void testHopWindowNoOffset() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM T GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        util.verifySql(sqlQuery, "n/a");
    }

    @Test(expected=TableException.class)
    public void testSessionWindowNoOffset() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM T GROUP BY SESSION(ts, INTERVAL '2' HOUR, TIME '10:00:00')";
        util.verifySql(sqlQuery, "n/a");
    }

    @Test(expected=TableException.class)
    public void testVariableWindowSize() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = "SELECT COUNT(*) FROM T GROUP BY TUMBLE(ts, b * INTERVAL '1' MINUTE)";
        util.verifySql(sql, "n/a");
    }

    @Test(expected=ValidationException.class)
    public void testTumbleWindowWithInvalidUdAggArgs() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        JavaUserDefinedAggFunctions.WeightedAvgWithMerge weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvgWithMerge();
        util.tableEnv().registerFunction("weightedAvg", (AggregateFunction)weightedAvg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT weightedAvg(c, a) AS wAvg FROM T GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        util.verifySql(sql, "n/a");
    }

    @Test(expected=ValidationException.class)
    public void testWindowProctime() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)((Timestamp)fields[3]));
                    }

                    public CaseClassSerializer<Tuple4<Object, Object, String, Timestamp>> createSerializerInstance(Class<Tuple4<Object, Object, String, Timestamp>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.batch.sql.validation.GroupWindowValidationTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT   TUMBLE_PROCTIME(ts, INTERVAL '4' MINUTE)FROM T GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        util.verifySql(sqlQuery, "FAIL");
    }
}

