/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.batch.sql.GroupingSetsTest$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001#\t\u0001rI]8va&twmU3ugR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tQ!\u001e;jYNL!a\u0006\u000b\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\tuKN$xI]8va&twmU3ugR\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bFA\u000f(!\tA3&D\u0001*\u0015\tQc\"A\u0003kk:LG/\u0003\u0002-S\t!A+Z:u\u0011\u0015q\u0003\u0001\"\u0001 \u0003!!Xm\u001d;Dk\n,\u0007FA\u0017(\u0011\u0015\t\u0004\u0001\"\u0001 \u0003)!Xm\u001d;S_2dW\u000f\u001d\u0015\u0003a\u001d\u0002")
public class GroupingSetsTest
extends TableTestBase {
    @Test
    public void testGroupingSets() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.sql.GroupingSetsTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT b, c, avg(a) as a, GROUP_ID() as g FROM MyTable GROUP BY GROUPING SETS (b, c)";
        String aggregate = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "null AS c", "a", "1 AS g"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"null AS b", "c", "a", "2 AS g"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g"}))}));
        util.verifySql(sqlQuery, aggregate);
    }

    @Test
    public void testCube() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.sql.GroupingSetsTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT b, c, avg(a) as a, GROUP_ID() as g, GROUPING(b) as gb, GROUPING(c) as gc, GROUPING_ID(b) as gib, GROUPING_ID(c) as gic, GROUPING_ID(b, c) as gid FROM MyTable GROUP BY CUBE (b, c)";
        String group1 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "3 AS g", "1 AS gb", "1 AS gc", "1 AS gib", "1 AS gic", "3 AS gid"}))}));
        String group2 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "null AS c", "a", "1 AS g", "1 AS gb", "0 AS gc", "1 AS gib", "0 AS gic", "2 AS gid"}))}));
        String group3 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"c", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"null AS b", "c", "a", "2 AS g", "0 AS gb", "1 AS gc", "0 AS gib", "1 AS gic", "1 AS gid"}))}));
        String group4 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"null AS b", "null AS c", "a", "0 AS g", "0 AS gb", "0 AS gc", "0 AS gib", "0 AS gic", "0 AS gid"}))}));
        String union = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.binaryNode("DataSetUnion", group1, group2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g", "gb", "gc", "gib", "gic", "gid"}))})), group3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g", "gb", "gc", "gib", "gic", "gid"}))})), group4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g", "gb", "gc", "gib", "gic", "gid"}))}));
        util.verifySql(sqlQuery, union);
    }

    @Test
    public void testRollup() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, Object>> createSerializerInstance(Class<Tuple3<Object, Object, Object>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.batch.sql.GroupingSetsTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT b, c, avg(a) as a, GROUP_ID() as g, GROUPING(b) as gb, GROUPING(c) as gc, GROUPING_ID(b) as gib, GROUPING_ID(c) as gic, GROUPING_ID(b, c) as gid  FROM MyTable GROUP BY ROLLUP (b, c)";
        String group1 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "3 AS g", "1 AS gb", "1 AS gc", "1 AS gib", "1 AS gic", "3 AS gid"}))}));
        String group2 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "null AS c", "a", "1 AS g", "1 AS gb", "0 AS gc", "1 AS gib", "0 AS gic", "2 AS gid"}))}));
        String group3 = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AVG(a) AS a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"null AS b", "null AS c", "a", "0 AS g", "0 AS gb", "0 AS gc", "0 AS gib", "0 AS gic", "0 AS gid"}))}));
        String union = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.binaryNode("DataSetUnion", group1, group2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g", "gb", "gc", "gib", "gic", "gid"}))})), group3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "c", "a", "g", "gb", "gc", "gib", "gic", "gid"}))}));
        util.verifySql(sqlQuery, union);
    }
}

