/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.batch.sql.DistinctAggregateTest$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001#\t)B)[:uS:\u001cG/Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)A/\u00192mK*\u00111\u0002D\u0001\u0006M2Lgn\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0007UC\ndW\rV3ti\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\t1\u0004^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wM]3hCR,G#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003;\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!A\u000b\b\u0002\u000b),h.\u001b;\n\u00051J#\u0001\u0002+fgRDQA\f\u0001\u0005\u0002}\ta\u0005^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016|enU1nK\u000e{G.^7oQ\tis\u0005C\u00032\u0001\u0011\u0005q$\u0001\u001fuKN$8+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/Z!oI>sWm\u0014:Nk2$\u0018NT8o\t&\u001cH/\u001b8di\u0006;wM]3hCR,\u0007F\u0001\u0019(\u0011\u0015!\u0004\u0001\"\u0001 \u0003-\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!hOJ,w-\u0019;f\u001f:$\u0015N\u001a4fe\u0016tGoQ8mk6t\u0007FA\u001a(\u0011\u00159\u0004\u0001\"\u0001 \u0003e\"Xm\u001d;Nk2$\u0018\u000eR5ti&t7\r^!oI:{g\u000eR5ti&t7\r^!hOJ,w-\u0019;f\u001f:$\u0015N\u001a4fe\u0016tGoQ8mk6t\u0007F\u0001\u001c(\u0011\u0015Q\u0004\u0001\"\u0001 \u0003\u001d\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e\u0014XmZ1uK^KG\u000f[$s_V\u0004\u0018N\\4)\u0005e:\u0003\"B\u001f\u0001\t\u0003y\u0012a\r;fgR\u001c\u0016N\\4mK\u0012K7\u000f^5oGR\fum\u001a:fO\u0006$XmV5uQ\u001e\u0013x.\u001e9j]\u001e\fe\u000eZ\"pk:$8\u000b^1sQ\tat\u0005C\u0003A\u0001\u0011\u0005q$\u0001\u0019uKN$Hk^8ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5He>,\b/\u001b8h\u0003:$7i\\;oiN#\u0018M\u001d\u0015\u0003\u007f\u001dBQa\u0011\u0001\u0005\u0002}\t\u0011\b^3tiR;x\u000eR5gM\u0016\u0014XM\u001c;ESN$\u0018N\\2u\u0003\u001e<'/Z4bi\u0016<\u0016\u000e\u001e5He>,\b/\u001b8h\u0003:$7i\\;oiN#\u0018M\u001d\u0015\u0003\u0005\u001e\u0002")
public class DistinctAggregateTest
extends TableTestBase {
    @Test
    public void testSingleDistinctAggregate() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT COUNT(DISTINCT a) FROM MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS EXPR$0"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testMultiDistinctAggregateOnSameColumn() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT a), MAX(DISTINCT a) FROM MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS EXPR$0", "SUM(a) AS EXPR$1", "MAX(a) AS EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testSingleDistinctAggregateAndOneOrMultiNonDistinctAggregate() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery0 = "SELECT COUNT(DISTINCT a), SUM(b) FROM MyTable";
        String expected0 = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "SUM(b) AS EXPR$1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS EXPR$0", "SUM(EXPR$1) AS EXPR$1"}))}));
        util.verifySql(sqlQuery0, expected0);
        String sqlQuery1 = "SELECT COUNT(a), SUM(DISTINCT b) FROM MyTable";
        String expected1 = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b", "COUNT(a) AS EXPR$0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"$SUM0(EXPR$0) AS EXPR$0", "SUM(b) AS EXPR$1"}))}));
        util.verifySql(sqlQuery1, expected1);
    }

    @Test
    public void testMultiDistinctAggregateOnDifferentColumn() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable";
        String expected = TableTestUtil$.MODULE$.binaryNode("DataSetSingleRowJoin", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS EXPR$0"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"SUM(b) AS EXPR$1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "EXPR$1"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"NestedLoopInnerJoin"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testMultiDistinctAndNonDistinctAggregateOnDifferentColumn() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT COUNT(DISTINCT a), SUM(DISTINCT b), COUNT(c) FROM MyTable";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetSingleRowJoin", TableTestUtil$.MODULE$.binaryNode("DataSetSingleRowJoin", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(c) AS EXPR$2"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"COUNT(a) AS EXPR$0"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$2, EXPR$0"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"NestedLoopInnerJoin"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"SUM(b) AS EXPR$1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$2", "EXPR$0, EXPR$1"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"NestedLoopInnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0, EXPR$1, EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testSingleDistinctAggregateWithGrouping() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT a, COUNT(a), SUM(DISTINCT b) FROM MyTable GROUP BY a";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "COUNT(a) AS EXPR$1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "$SUM0(EXPR$1) AS EXPR$1", "SUM(b) AS EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testSingleDistinctAggregateWithGroupingAndCountStar() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b) FROM MyTable GROUP BY a";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b", "COUNT(*) AS EXPR$1"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "$SUM0(EXPR$1) AS EXPR$1", "SUM(b) AS EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testTwoDistinctAggregateWithGroupingAndCountStar() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT b) FROM MyTable GROUP BY a";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "COUNT(*) AS EXPR$1"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, SUM(b) AS EXPR$2, COUNT(b) AS EXPR$3"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"IS NOT DISTINCT FROM(a, a0)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, a0, EXPR$2, EXPR$3"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, EXPR$2, EXPR$3"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testTwoDifferentDistinctAggregateWithGroupingAndCountStar() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.addTable("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }

                    public CaseClassSerializer<Tuple3<Object, Object, String>> createSerializerInstance(Class<Tuple3<Object, Object, String>> tupleClass, TypeSerializer<?>[] fieldSerializers) {
                        return (CaseClassSerializer)this.getClass().getConstructors()[0].newInstance(tupleClass, fieldSerializers);
                    }
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.api.batch.sql.DistinctAggregateTest$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = "SELECT a, COUNT(*), SUM(DISTINCT b), COUNT(DISTINCT c) FROM MyTable GROUP BY a";
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.binaryNode("DataSetJoin", TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, COUNT(*) AS EXPR$1"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, b"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, SUM(b) AS EXPR$2"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"IS NOT DISTINCT FROM(a, a0)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, a0, EXPR$2"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, EXPR$2"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetAggregate", TableTestUtil$.MODULE$.unaryNode("DataSetDistinct", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", TableTestUtil$.MODULE$.batchTableNode(0), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("distinct", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("groupBy", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a"})), TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, COUNT(c) AS EXPR$3"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"IS NOT DISTINCT FROM(a, a0)"})), TableTestUtil$.MODULE$.term("join", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, EXPR$2, a0, EXPR$3"})), TableTestUtil$.MODULE$.term("joinType", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"InnerJoin"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"a, EXPR$1, EXPR$2, EXPR$3"}))}));
        util.verifySql(sqlQuery, expected);
    }
}

