/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.utils.Func0$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.CsvTableSource$;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.apache.flink.table.utils.TestFilterableTableSource;
import org.apache.flink.table.utils.TestFilterableTableSource$;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011q\u0002V1cY\u0016\u001cv.\u001e:dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0003\u001c\u0003=\u0001(o\u001c6fGR,GMR5fY\u0012\u001cX#\u0001\u000f\u0011\u0007u\u0001#%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0015\t%O]1z!\t\u0019#F\u0004\u0002%QA\u0011QEH\u0007\u0002M)\u0011q\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0005%r\u0012A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u0010\t\r9\u0002\u0001\u0015!\u0003\u001d\u0003A\u0001(o\u001c6fGR,GMR5fY\u0012\u001c\b\u0005C\u00041\u0001\t\u0007I\u0011B\u000e\u0002\u00199|7)\u00197d\r&,G\u000eZ:\t\rI\u0002\u0001\u0015!\u0003\u001d\u00035qwnQ1mG\u001aKW\r\u001c3tA!)A\u0007\u0001C\u0001k\u0005YB/Z:u)\u0006\u0014G.Z*pkJ\u001cWmU2b]R{7\u000b\u001e:j]\u001e$\u0012A\u000e\t\u0003;]J!\u0001\u000f\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0003gi\u0002\"a\u000f \u000e\u0003qR!!\u0010\u0006\u0002\u000b),h.\u001b;\n\u0005}b$\u0001\u0002+fgRDQ!\u0011\u0001\u0005\u0002U\n!\u0006^3ti\n\u000bGo\u00195Qe>TWm\u0019;bE2,7k\\;sG\u0016\u001c6-\u00198QY\u0006tG+\u00192mK\u0006\u0003\u0018\u000e\u000b\u0002Au!)A\t\u0001C\u0001k\u0005)C/Z:u\u0005\u0006$8\r\u001b)s_*,7\r^1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c)mC:\u001c\u0016\u000b\u0014\u0015\u0003\u0007jBQa\u0012\u0001\u0005\u0002U\nA\u0006^3ti\n\u000bGo\u00195Qe>TWm\u0019;bE2,7k\\;sG\u0016\u001c6-\u00198O_&#WM\u001c;jif\u001c\u0015\r\\2)\u0005\u0019S\u0004\"\u0002&\u0001\t\u0003)\u0014\u0001\u000b;fgR\u0014\u0015\r^2i!J|'.Z2uC\ndWmU8ve\u000e,g)\u001e7m!J|'.Z2uS>t\u0007FA%;\u0011\u0015i\u0005\u0001\"\u00016\u0003\t\"Xm\u001d;CCR\u001c\u0007NR5mi\u0016\u0014\u0018M\u00197f/&$\bn\\;u!V\u001c\b\u000eR8x]\"\u0012AJ\u000f\u0005\u0006!\u0002!\t!N\u0001#i\u0016\u001cHOQ1uG\"4\u0015\u000e\u001c;fe\u0006\u0014G.\u001a)beRL\u0017\r\u001c)vg\"$un\u001e8)\u0005=S\u0004\"B*\u0001\t\u0003)\u0014A\t;fgR\u0014\u0015\r^2i\r&dG/\u001a:bE2,g)\u001e7msB+8\u000f[3e\t><h\u000e\u000b\u0002Su!)a\u000b\u0001C\u0001k\u0005aC/Z:u\u0005\u0006$8\r\u001b$jYR,'/\u00192mK^KG\u000f[+oG>tg/\u001a:uK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003+jBQ!\u0017\u0001\u0005\u0002U\n!\u0004^3ti\n\u000bGo\u00195GS2$XM]1cY\u0016<\u0016\u000e\u001e5V\t\u001aC#\u0001\u0017\u001e\t\u000bq\u0003A\u0011A\u001b\u0002WQ,7\u000f^*ue\u0016\fW\u000e\u0015:pU\u0016\u001cG/\u00192mKN{WO]2f'\u000e\fg\u000e\u00157b]R\u000b'\r\\3Ba&D#a\u0017\u001e\t\u000b}\u0003A\u0011A\u001b\u0002MQ,7\u000f^*ue\u0016\fW\u000e\u0015:pU\u0016\u001cG/\u00192mKN{WO]2f'\u000e\fg\u000e\u00157b]N\u000bF\n\u000b\u0002_u!)!\r\u0001C\u0001k\u0005iC/Z:u'R\u0014X-Y7Qe>TWm\u0019;bE2,7k\\;sG\u0016\u001c6-\u00198O_&#WM\u001c;jif\u001c\u0015\r\\2)\u0005\u0005T\u0004\"B3\u0001\t\u0003)\u0014A\u000b;fgR\u001cFO]3b[\u001aKG\u000e^3sC\ndWmU8ve\u000e,7kY1o!2\fg\u000eV1cY\u0016\f\u0005/\u001b\u0015\u0003IjBQ\u0001\u001b\u0001\u0005\u0002U\n\u0011\u0004^3ti\u000e\u001bh\u000fV1cY\u0016\u001cv.\u001e:dK\n+\u0018\u000e\u001c3fe\"\u0012qM\u000f\u0005\u0006W\u0002!\t!N\u0001\"i\u0016\u001cH\u000fV5nK2KG/\u001a:bY\u0016C\bO]3tg&|g\u000eU;tQ\u0012|wO\u001c\u0015\u0003UjBQA\u001c\u0001\u0005\u0002=\fQCZ5mi\u0016\u0014\u0018M\u00197f)\u0006\u0014G.Z*pkJ\u001cW-F\u0001q!\u0011i\u0012o\u001d\u0012\n\u0005It\"A\u0002+va2,'\u0007\r\u0002uyB\u0019Q\u000f\u001f>\u000e\u0003YT!a\u001e\u0003\u0002\u000fM|WO]2fg&\u0011\u0011P\u001e\u0002\f)\u0006\u0014G.Z*pkJ\u001cW\r\u0005\u0002|y2\u0001A!C?n\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF%M\t\u0004\u007f\u0006\u0015\u0001cA\u000f\u0002\u0002%\u0019\u00111\u0001\u0010\u0003\u000f9{G\u000f[5oOB\u0019Q$a\u0002\n\u0007\u0005%aDA\u0002B]fDq!!\u0004\u0001\t\u0003\ty!\u0001\u0010gS2$XM]1cY\u0016$\u0016M\u00197f'>,(oY3US6,G+\u001f9fgV\u0011\u0011\u0011\u0003\t\u0006;E\f\u0019B\t\u0019\u0005\u0003+\tI\u0002\u0005\u0003vq\u0006]\u0001cA>\u0002\u001a\u0011Y\u00111DA\u0006\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryFE\r\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003!\u00197O\u001e+bE2,WCAA\u0012!\u0015i\u0012/!\n#!\r)\u0018qE\u0005\u0004\u0003S1(AD\"tmR\u000b'\r\\3T_V\u00148-\u001a\u0005\b\u0003[\u0001A\u0011AA\u0018\u0003Q\u0011\u0017\r^2i'>,(oY3UC\ndWMT8eKR)!%!\r\u00026!9\u00111GA\u0016\u0001\u0004\u0011\u0013AC:pkJ\u001cWMT1nK\"9\u0011qGA\u0016\u0001\u0004a\u0012A\u00024jK2$7\u000fC\u0004\u0002<\u0001!\t!!\u0010\u0002+M$(/Z1n'>,(oY3UC\ndWMT8eKR)!%a\u0010\u0002B!9\u00111GA\u001d\u0001\u0004\u0011\u0003bBA\u001c\u0003s\u0001\r\u0001\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0003y\u0011\u0017\r^2i\r&dG/\u001a:bE2,7k\\;sG\u0016$\u0016M\u00197f\u001d>$W\rF\u0004#\u0003\u0013\nY%!\u0014\t\u000f\u0005M\u00121\ta\u0001E!9\u0011qGA\"\u0001\u0004a\u0002bBA(\u0003\u0007\u0002\rAI\u0001\u0004Kb\u0004\bbBA*\u0001\u0011\u0005\u0011QK\u0001 gR\u0014X-Y7GS2$XM]1cY\u0016\u001cv.\u001e:dKR\u000b'\r\\3O_\u0012,Gc\u0002\u0012\u0002X\u0005e\u00131\f\u0005\b\u0003g\t\t\u00061\u0001#\u0011\u001d\t9$!\u0015A\u0002qAq!a\u0014\u0002R\u0001\u0007!\u0005")
public class TableSourceTest
extends TableTestBase {
    private final String[] projectedFields = (String[])((Object[])new String[]{"last", "id", "score"});
    private final String[] noCalcFields = (String[])((Object[])new String[]{"id", "score", "first"});

    private String[] projectedFields() {
        return this.projectedFields;
    }

    private String[] noCalcFields() {
        return this.noCalcFields;
    }

    @Test
    public void testTableSourceScanToString() {
        TableSource tableSource2;
        TableSource tableSource1;
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = tableSource1 = (TableSource)tuple2._1();
        TableSource tableSource12 = tableSource;
        Tuple2<TableSource<?>, String> tuple22 = this.filterableTableSource();
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        TableSource tableSource3 = tableSource2 = (TableSource)tuple22._1();
        TableSource tableSource22 = tableSource3;
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource("table1", tableSource12);
        tableEnv.registerTableSource("table2", tableSource22);
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table1"})).where("amount > 2");
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table2"})).where("amount > 2");
        Table result = table1.unionAll(table2);
        String expected = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", this.batchFilterableSourceTableNode("table1", (String[])((Object[])new String[]{"name", "id", "amount", "price"}), "'amount > 2"), this.batchFilterableSourceTableNode("table2", (String[])((Object[])new String[]{"name", "id", "amount", "price"}), "'amount > 2"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"name, id, amount, price"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchProjectableSourceScanPlanTableApi() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, (TableSource)tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last")).upperCase(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).floor(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")).$times(package$.MODULE$.int2Literal(2))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.batchSourceTableNode(tableName2, this.projectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"UPPER(last) AS _c0", "FLOOR(id) AS _c1", "*(score, 2) AS _c2"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchProjectableSourceScanPlanSQL() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        util.tableEnv().registerTableSource(tableName2, (TableSource)tableSource2);
        String sqlQuery = new StringBuilder(41).append("SELECT `last`, floor(id), score * 2 FROM ").append(tableName2).toString();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.batchSourceTableNode(tableName2, this.projectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"last", "FLOOR(id) AS EXPR$1", "*(score, 2) AS EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testBatchProjectableSourceScanNoIdentityCalc() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, (TableSource)tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first"))}));
        String expected = this.batchSourceTableNode(tableName2, this.noCalcFields());
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchProjectableSourceFullProjection() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, (TableSource)tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(1)}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", new StringBuilder(88).append("BatchTableSourceScan(table=[[").append(tableName2).append("]], ").append("fields=[], ").append("source=[CsvTableSource(read fields: first)])").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"1 AS _c0"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchFilterableWithoutPushDown() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))})).where("price * 2 < 32");
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", "BatchTableSourceScan(table=[[filterableTable]], fields=[price, id, amount])", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"price", "id", "amount"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(*(price, 2), 32)"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchFilterablePartialPushDown() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).where("amount > 2 && price * 2 < 32").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")).lowerCase(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.batchFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"price", "name", "amount"}), "'amount > 2"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"price", "LOWER(name) AS _c1", "amount"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(*(price, 2), 32)"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchFilterableFullyPushedDown() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))})).where("amount > 2 && amount < 32");
        String expected = this.batchFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"price", "id", "amount"}), "'amount > 2 && 'amount < 32");
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchFilterableWithUnconvertedExpression() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))})).where("amount > 2 && id < 1.2 && (amount < 32 || amount.cast(LONG) > 10)");
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.batchFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"price", "id", "amount"}), "'amount > 2"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"price", "id", "amount"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"AND(<(id, 1.2E0), OR(<(amount, 32), >(CAST(amount), 10)))"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchFilterableWithUDF() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Func0$ func = Func0$.MODULE$;
        tableEnv.registerFunction("func0", (ScalarFunction)func);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))})).where("amount > 2 && func0(amount) < 32");
        String expected = TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.batchFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"price", "id", "amount"}), "'amount > 2"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"price", "id", "amount"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new StringBuilder(15).append("<(").append(Func0$.MODULE$.getClass().getSimpleName()).append("(amount), 32)").toString()}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testStreamProjectableSourceScanPlanTableApi() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        StreamTableTestUtil util = this.streamTestUtil();
        StreamTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, (TableSource)tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")).floor(), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")).$times(package$.MODULE$.int2Literal(2))}));
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.streamSourceTableNode(tableName2, this.projectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"last", "FLOOR(id) AS _c1", "*(score, 2) AS _c2"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testStreamProjectableSourceScanPlanSQL() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerTableSource(tableName2, (TableSource)tableSource2);
        String sqlQuery = new StringBuilder(41).append("SELECT `last`, floor(id), score * 2 FROM ").append(tableName2).toString();
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.streamSourceTableNode(tableName2, this.projectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"last", "FLOOR(id) AS EXPR$1", "*(score, 2) AS EXPR$2"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testStreamProjectableSourceScanNoIdentityCalc() {
        Tuple2<CsvTableSource, String> tuple2 = this.csvTable();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CsvTableSource tableSource = (CsvTableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        CsvTableSource tableSource2 = (CsvTableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        StreamTableTestUtil util = this.streamTestUtil();
        StreamTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, (TableSource)tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first"))}));
        String expected = this.streamSourceTableNode(tableName2, this.noCalcFields());
        util.verifyTable(result, expected);
    }

    @Test
    public void testStreamFilterableSourceScanPlanTableApi() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSource();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        StreamTableTestUtil util = this.streamTestUtil();
        StreamTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        Table result = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName2})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "amount"))})).where("amount > 2 && price * 2 < 32");
        String expected = TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.streamFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"price", "id", "amount"}), "'amount > 2"), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"price", "id", "amount"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(*(price, 2), 32)"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testCsvTableSourceBuilder() {
        CsvTableSource source1 = CsvTableSource$.MODULE$.builder().path("/path/to/csv").field("myfield", Types$.MODULE$.STRING()).field("myfield2", Types$.MODULE$.INT()).quoteCharacter(Predef$.MODULE$.char2Character(';')).fieldDelimiter("#").lineDelimiter("\r\n").commentPrefix("%%").ignoreFirstLine().ignoreParseErrors().build();
        CsvTableSource source2 = new CsvTableSource("/path/to/csv", (String[])((Object[])new String[]{"myfield", "myfield2"}), (TypeInformation[])((Object[])new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.INT()}), "#", "\r\n", Predef$.MODULE$.char2Character(';'), true, "%%", true);
        Assert.assertEquals((Object)source1, (Object)source2);
    }

    @Test
    public void testTimeLiteralExpressionPushdown() {
        Tuple2<TableSource<?>, String> tuple2 = this.filterableTableSourceTimeTypes();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TableSource tableSource = (TableSource)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableSource, (Object)tableName);
        Tuple2 tuple23 = tuple22;
        TableSource tableSource2 = (TableSource)tuple23._1();
        String tableName2 = (String)tuple23._2();
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerTableSource(tableName2, tableSource2);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(174).append("\n        |SELECT id from ").append(tableName2).append("\n        |WHERE\n        |  tv > TIME '14:25:02' AND\n        |  dv > DATE '2017-02-03' AND\n        |  tsv > TIMESTAMP '2017-02-03 14:25:02.000'\n      ").toString())).stripMargin();
        Table result = tableEnv.sqlQuery(sqlQuery);
        String expectedFilter = "'tv > 14:25:02.toTime && 'dv > 2017-02-03.toDate && 'tsv > 2017-02-03 14:25:02.0.toTimestamp";
        String expected = this.batchFilterableSourceTableNode(tableName2, (String[])((Object[])new String[]{"id"}), expectedFilter);
        util.verifyTable(result, expected);
    }

    public Tuple2<TableSource<?>, String> filterableTableSource() {
        TestFilterableTableSource tableSource = TestFilterableTableSource$.MODULE$.apply();
        return new Tuple2((Object)tableSource, (Object)"filterableTable");
    }

    public Tuple2<TableSource<?>, String> filterableTableSourceTimeTypes() {
        RowTypeInfo rowTypeInfo = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, SqlTimeTypeInfo.DATE, SqlTimeTypeInfo.TIME, SqlTimeTypeInfo.TIMESTAMP}), (String[])((Object[])new String[]{"id", "dv", "tv", "tsv"}));
        Row row = new Row(4);
        row.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        row.setField(1, (Object)Date.valueOf("2017-01-23"));
        row.setField(2, (Object)Time.valueOf("14:23:02"));
        row.setField(3, (Object)Timestamp.valueOf("2017-01-24 12:45:01.234"));
        TestFilterableTableSource tableSource = TestFilterableTableSource$.MODULE$.apply(rowTypeInfo, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dv", "tv", "tsv"}))));
        return new Tuple2((Object)tableSource, (Object)"filterableTable");
    }

    public Tuple2<CsvTableSource, String> csvTable() {
        CsvTableSource csvTable = CommonTestData$.MODULE$.getCsvTableSource();
        String tableName = "csvTable";
        return new Tuple2((Object)csvTable, (Object)tableName);
    }

    public String batchSourceTableNode(String sourceName, String[] fields) {
        return new StringBuilder(33).append("BatchTableSourceScan(table=[[").append(sourceName).append("]], ").append(new StringBuilder(11).append("fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], ").toString()).append(new StringBuilder(39).append("source=[CsvTableSource(read fields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append(")])").toString()).toString();
    }

    public String streamSourceTableNode(String sourceName, String[] fields) {
        return new StringBuilder(34).append("StreamTableSourceScan(table=[[").append(sourceName).append("]], ").append(new StringBuilder(11).append("fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], ").toString()).append(new StringBuilder(39).append("source=[CsvTableSource(read fields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append(")])").toString()).toString();
    }

    public String batchFilterableSourceTableNode(String sourceName, String[] fields, String exp) {
        return new StringBuilder(21).append("BatchTableSourceScan(").append(new StringBuilder(42).append("table=[[").append(sourceName).append("]], fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], source=[filter=[").append(exp).append("]])").toString()).toString();
    }

    public String streamFilterableSourceTableNode(String sourceName, String[] fields, String exp) {
        return new StringBuilder(22).append("StreamTableSourceScan(").append(new StringBuilder(42).append("table=[[").append(sourceName).append("]], fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], source=[filter=[").append(exp).append("]])").toString()).toString();
    }
}

