/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.StreamTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.utils.BatchTableTestUtil;
import org.apache.flink.table.utils.StreamTableTestUtil;
import org.apache.flink.table.utils.TableTestBase;
import org.apache.flink.table.utils.TableTestUtil$;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001b\t\u0019R\t\u001f;fe:\fGnQ1uC2|w\rV3ti*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001b\u0001\n\u0013Y\u0012A\u0003;bE2,\u0017\u0007U1uQV\tA\u0004E\u0002\u001eA\tj\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015rR\"\u0001\u0014\u000b\u0005\u001db\u0011A\u0002\u001fs_>$h(\u0003\u0002*=\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc\u0004\u0003\u0004/\u0001\u0001\u0006I\u0001H\u0001\fi\u0006\u0014G.Z\u0019QCRD\u0007\u0005C\u00041\u0001\t\u0007I\u0011B\u000e\u0002%Q\f'\r\\32)>\u0004H*\u001a<fYB\u000bG\u000f\u001b\u0005\u0007e\u0001\u0001\u000b\u0011\u0002\u000f\u0002'Q\f'\r\\32)>\u0004H*\u001a<fYB\u000bG\u000f\u001b\u0011\t\u000fQ\u0002!\u0019!C\u00057\u0005)B/\u00192mKF\u0002&o\u001c6fGR,GMR5fY\u0012\u001c\bB\u0002\u001c\u0001A\u0003%A$\u0001\fuC\ndW-\r)s_*,7\r^3e\r&,G\u000eZ:!\u0011\u001dA\u0004A1A\u0005\nm\t!\u0002^1cY\u0016\u0014\u0004+\u0019;i\u0011\u0019Q\u0004\u0001)A\u00059\u0005YA/\u00192mKJ\u0002\u0016\r\u001e5!\u0011\u001da\u0004A1A\u0005\nm\tQ\u0003^1cY\u0016\u0014\u0004K]8kK\u000e$X\r\u001a$jK2$7\u000f\u0003\u0004?\u0001\u0001\u0006I\u0001H\u0001\u0017i\u0006\u0014G.\u001a\u001aQe>TWm\u0019;fI\u001aKW\r\u001c3tA!)\u0001\t\u0001C\u0001\u0003\u0006\tB/Z:u\u0005\u0006$8\r\u001b+bE2,\u0017\t]5\u0015\u0003\t\u0003\"!H\"\n\u0005\u0011s\"\u0001B+oSRD#a\u0010$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%S\u0011!\u00026v]&$\u0018BA&I\u0005\u0011!Vm\u001d;\t\u000b5\u0003A\u0011A!\u0002\u0019Q,7\u000f\u001e\"bi\u000eD7+\u0015')\u000513\u0005\"\u0002)\u0001\t\u0003\t\u0015A\u0005;fgR\u001cFO]3b[R\u000b'\r\\3Ba&D#a\u0014$\t\u000bM\u0003A\u0011A!\u0002\u001bQ,7\u000f^*ue\u0016\fWnU)MQ\t\u0011f\tC\u0003W\u0001\u0011\u0005\u0011)A\tuKN$Hk\u001c9MKZ,G\u000eV1cY\u0016D#!\u0016$\t\u000be\u0003A\u0011\u0001.\u0002)M|WO]2f\u0005\u0006$8\r\u001b+bE2,gj\u001c3f)\r\u00113,\u0018\u0005\u00069b\u0003\r\u0001H\u0001\u0010g>,(oY3UC\ndW\rU1uQ\")a\f\u0017a\u00019\u00051a-[3mINDQ\u0001\u0019\u0001\u0005\u0002\u0005\fQc]8ve\u000e,7\u000b\u001e:fC6$\u0016M\u00197f\u001d>$W\rF\u0002#E\u000eDQ\u0001X0A\u0002qAQAX0A\u0002q\u0001")
public class ExternalCatalogTest
extends TableTestBase {
    private final String[] table1Path = (String[])((Object[])new String[]{"test", "db1", "tb1"});
    private final String[] table1TopLevelPath = (String[])((Object[])new String[]{"test", "tb1"});
    private final String[] table1ProjectedFields = (String[])((Object[])new String[]{"a", "b", "c"});
    private final String[] table2Path = (String[])((Object[])new String[]{"test", "db2", "tb2"});
    private final String[] table2ProjectedFields = (String[])((Object[])new String[]{"d", "e", "g"});

    private String[] table1Path() {
        return this.table1Path;
    }

    private String[] table1TopLevelPath() {
        return this.table1TopLevelPath;
    }

    private String[] table1ProjectedFields() {
        return this.table1ProjectedFields;
    }

    private String[] table2Path() {
        return this.table2Path;
    }

    private String[] table2ProjectedFields() {
        return this.table2ProjectedFields;
    }

    @Test
    public void testBatchTableApi() {
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db1", "tb1"}));
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        Table result = table2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()})));
        String expected = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table2Path(), this.table2ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(d, 2) AS _c0", "e", "UPPER(g) AS _c2"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table1Path(), this.table1ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(a, 2) AS _c0", "b", "UPPER(c) AS _c2"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"_c0", "e", "_c2"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testBatchSQL() {
        BatchTableTestUtil util = this.batchTestUtil();
        util.tableEnv().registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        String sqlQuery = "SELECT d * 2, e, g FROM test.db2.tb2 WHERE d < 3 UNION ALL (SELECT a * 2, b, c FROM test.db1.tb1)";
        String expected = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table2Path(), this.table2ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(d, 2) AS EXPR$0", "e", "g"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(d, 3)"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table1Path(), this.table1ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(a, 2) AS EXPR$0", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "e", "g"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testStreamTableApi() {
        StreamTableTestUtil util = this.streamTestUtil();
        StreamTableEnvironment tableEnv = util.tableEnv();
        util.tableEnv().registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(true));
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db1", "tb1"}));
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        Table result = table2.where("d < 3").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()})));
        String expected = TableTestUtil$.MODULE$.binaryNode("DataStreamUnion", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.sourceStreamTableNode(this.table2Path(), this.table2ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(d, 2) AS _c0", "e", "UPPER(g) AS _c2"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(d, 3)"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.sourceStreamTableNode(this.table1Path(), this.table1ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(a, 2) AS _c0", "b", "UPPER(c) AS _c2"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"_c0", "e", "_c2"}))}));
        util.verifyTable(result, expected);
    }

    @Test
    public void testStreamSQL() {
        StreamTableTestUtil util = this.streamTestUtil();
        util.tableEnv().registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(true));
        String sqlQuery = "SELECT d * 2, e, g FROM test.db2.tb2 WHERE d < 3 UNION ALL (SELECT a * 2, b, c FROM test.db1.tb1)";
        String expected = TableTestUtil$.MODULE$.binaryNode("DataStreamUnion", TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.sourceStreamTableNode(this.table2Path(), this.table2ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(d, 2) AS EXPR$0", "e", "g"})), TableTestUtil$.MODULE$.term("where", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"<(d, 3)"}))})), TableTestUtil$.MODULE$.unaryNode("DataStreamCalc", this.sourceStreamTableNode(this.table1Path(), this.table1ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(a, 2) AS EXPR$0", "b", "c"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"EXPR$0", "e", "g"}))}));
        util.verifySql(sqlQuery, expected);
    }

    @Test
    public void testTopLevelTable() {
        BatchTableTestUtil util = this.batchTestUtil();
        BatchTableEnvironment tableEnv = util.tableEnv();
        tableEnv.registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "tb1"}));
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        Table result = table2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()})));
        String expected = TableTestUtil$.MODULE$.binaryNode("DataSetUnion", TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table2Path(), this.table2ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(d, 2) AS _c0", "e", "UPPER(g) AS _c2"}))})), TableTestUtil$.MODULE$.unaryNode("DataSetCalc", this.sourceBatchTableNode(this.table1TopLevelPath(), this.table1ProjectedFields()), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("select", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"*(a, 2) AS _c0", "b", "UPPER(c) AS _c2"}))})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TableTestUtil$.MODULE$.term("all", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true"})), TableTestUtil$.MODULE$.term("union", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"_c0", "e", "_c2"}))}));
        util.verifyTable(result, expected);
    }

    public String sourceBatchTableNode(String[] sourceTablePath, String[] fields) {
        return new StringBuilder(33).append("BatchTableSourceScan(table=[[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTablePath)).mkString(", ")).append("]], ").append(new StringBuilder(11).append("fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], ").toString()).append(new StringBuilder(39).append("source=[CsvTableSource(read fields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append(")])").toString()).toString();
    }

    public String sourceStreamTableNode(String[] sourceTablePath, String[] fields) {
        return new StringBuilder(34).append("StreamTableSourceScan(table=[[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTablePath)).mkString(", ")).append("]], ").append(new StringBuilder(11).append("fields=[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append("], ").toString()).append(new StringBuilder(39).append("source=[CsvTableSource(read fields: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(", ")).append(")])").toString()).toString();
    }
}

