/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.utils.CommonTestData$;
import org.apache.flink.table.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u001b\tIR\t\u001f;fe:\fGnQ1uC2|w-\u00138tKJ$H+Z:u\u0015\t\u0019A!A\u0002ba&T!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\nm\tQ\u0002^1cY\u0016\u0014\u0015\r^2i\u000b:4X#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}\u0011\u0011!B:dC2\f\u0017BA\u0011\u001f\u0005U\u0011\u0015\r^2i)\u0006\u0014G.Z#om&\u0014xN\\7f]RDaa\t\u0001!\u0002\u0013a\u0012A\u0004;bE2,')\u0019;dQ\u0016sg\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u00039!\u0018M\u00197f'R\u0014X-Y7F]Z,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U\t\tAA[1wC&\u0011A&\u000b\u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"1a\u0006\u0001Q\u0001\n\u001d\nq\u0002^1cY\u0016\u001cFO]3b[\u0016sg\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0012i\u0016\u001cHOQ1uG\"$\u0016M\u00197f\u0003BLG#\u0001\u001a\u0011\u0005M*T\"\u0001\u001b\u000b\u0003}I!A\u000e\u001b\u0003\tUs\u0017\u000e\u001e\u0015\u0003_a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0006\u0002\u000b),h.\u001b;\n\u0005uR$\u0001\u0002+fgRDQa\u0010\u0001\u0005\u0002E\nA\u0002^3ti\n\u000bGo\u00195T#2C#A\u0010\u001d\t\u000b\t\u0003A\u0011A\u0019\u0002%Q,7\u000f^*ue\u0016\fW\u000eV1cY\u0016\f\u0005/\u001b\u0015\u0003\u0003bBQ!\u0012\u0001\u0005\u0002E\nQ\u0002^3tiN#(/Z1n'Fc\u0005F\u0001#9\u0011\u0015A\u0005\u0001\"\u00012\u0003E!Xm\u001d;U_BdUM^3m)\u0006\u0014G.\u001a\u0015\u0003\u000fb\u0002")
public class ExternalCatalogInsertTest
extends TableTestBase {
    private final BatchTableEnvironment tableBatchEnv = TableEnvironment$.MODULE$.getTableEnvironment(ExecutionEnvironment$.MODULE$.getExecutionEnvironment());
    private final StreamTableEnvironment tableStreamEnv = TableEnvironment$.MODULE$.getTableEnvironment(StreamExecutionEnvironment.getExecutionEnvironment());

    private BatchTableEnvironment tableBatchEnv() {
        return this.tableBatchEnv;
    }

    private StreamTableEnvironment tableStreamEnv() {
        return this.tableStreamEnv;
    }

    @Test
    public void testBatchTableApi() {
        this.tableBatchEnv().registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        Table table1 = this.tableBatchEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db1", "tb1"}));
        Table table2 = this.tableBatchEnv().scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        table2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()}))).insertInto("test.db3.tb3");
    }

    @Test
    public void testBatchSQL() {
        this.tableBatchEnv().registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        String sqlInsert = "INSERT INTO `test.db3.tb3` SELECT d * 2, e, g FROM test.db2.tb2 WHERE d < 3 UNION ALL (SELECT a * 2, b, c FROM test.db1.tb1)";
        this.tableBatchEnv().sqlUpdate(sqlInsert);
    }

    @Test
    public void testStreamTableApi() {
        StreamTableEnvironment tableEnv = this.tableStreamEnv();
        tableEnv.registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(true));
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db1", "tb1"}));
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        table2.where("d < 3").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()}))).insertInto("test.db3.tb3");
    }

    @Test
    public void testStreamSQL() {
        StreamTableEnvironment tableEnv = this.tableStreamEnv();
        tableEnv.registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(true));
        String sqlInsert = "INSERT INTO `test.db3.tb3` SELECT d * 2, e, g FROM test.db2.tb2 WHERE d < 3 UNION ALL (SELECT a * 2, b, c FROM test.db1.tb1)";
        tableEnv.sqlUpdate(sqlInsert);
    }

    @Test
    public void testTopLevelTable() {
        BatchTableEnvironment tableEnv = this.tableBatchEnv();
        tableEnv.registerExternalCatalog("test", CommonTestData$.MODULE$.getInMemoryTestCatalog(false));
        Table table1 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "tb1"}));
        Table table2 = tableEnv.scan((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "db2", "tb2"}));
        table2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).upperCase()})).unionAll(table1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$times(package$.MODULE$.int2Literal(2)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).upperCase()}))).insertInto("test.tb3");
    }
}

