/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FieldsDataType
extends DataType {
    private final List<DataType> fieldDataTypes;

    public FieldsDataType(LogicalType logicalType, @Nullable Class<?> conversionClass, List<DataType> fieldDataTypes) {
        super(logicalType, conversionClass);
        Preconditions.checkNotNull(fieldDataTypes, "Field data types must not be null.");
        this.fieldDataTypes = fieldDataTypes.stream().map(this::updateInnerDataType).collect(Collectors.toList());
    }

    public FieldsDataType(LogicalType logicalType, List<DataType> fieldDataTypes) {
        this(logicalType, null, fieldDataTypes);
    }

    @Override
    public DataType notNull() {
        return new FieldsDataType(this.logicalType.copy(false), this.conversionClass, this.fieldDataTypes);
    }

    @Override
    public DataType nullable() {
        return new FieldsDataType(this.logicalType.copy(true), this.conversionClass, this.fieldDataTypes);
    }

    @Override
    public DataType bridgedTo(Class<?> newConversionClass) {
        return new FieldsDataType(this.logicalType, Preconditions.checkNotNull(newConversionClass, "New conversion class must not be null."), this.fieldDataTypes);
    }

    @Override
    public List<DataType> getChildren() {
        return this.fieldDataTypes;
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldsDataType that = (FieldsDataType)o;
        return this.fieldDataTypes.equals(that.fieldDataTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldDataTypes);
    }

    private DataType updateInnerDataType(DataType innerDataType) {
        if (this.conversionClass == RowData.class) {
            return (DataType)innerDataType.bridgedTo(LogicalTypeUtils.toInternalConversionClass(innerDataType.getLogicalType()));
        }
        return innerDataType;
    }
}

