/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory.jobmanager;

import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.FlinkMemory;
import org.apache.flink.util.Preconditions;

public class JobManagerFlinkMemory
implements FlinkMemory {
    private static final long serialVersionUID = 1L;
    private final MemorySize jvmHeap;
    private final MemorySize offHeapMemory;

    @VisibleForTesting
    public JobManagerFlinkMemory(MemorySize jvmHeap, MemorySize offHeapMemory) {
        this.jvmHeap = Preconditions.checkNotNull(jvmHeap);
        this.offHeapMemory = Preconditions.checkNotNull(offHeapMemory);
    }

    @Override
    public MemorySize getJvmHeapMemorySize() {
        return this.jvmHeap;
    }

    @Override
    public MemorySize getJvmDirectMemorySize() {
        return this.offHeapMemory;
    }

    @Override
    public MemorySize getTotalFlinkMemorySize() {
        return this.jvmHeap.add(this.offHeapMemory);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobManagerFlinkMemory) {
            JobManagerFlinkMemory that = (JobManagerFlinkMemory)obj;
            return Objects.equals(this.jvmHeap, that.jvmHeap) && Objects.equals(this.offHeapMemory, that.offHeapMemory);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.jvmHeap, this.offHeapMemory);
    }
}

