/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.util.Preconditions;

public class PendingTaskManager {
    private final PendingTaskManagerId pendingTaskManagerId;
    private final ResourceProfile totalResourceProfile;
    private final ResourceProfile defaultSlotResourceProfile;
    private final int numSlots;

    public PendingTaskManager(ResourceProfile totalResourceProfile, int numSlots) {
        this.numSlots = numSlots;
        this.totalResourceProfile = Preconditions.checkNotNull(totalResourceProfile);
        this.defaultSlotResourceProfile = SlotManagerUtils.generateDefaultSlotResourceProfile(totalResourceProfile, numSlots);
        this.pendingTaskManagerId = PendingTaskManagerId.generate();
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public PendingTaskManagerId getPendingTaskManagerId() {
        return this.pendingTaskManagerId;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public String toString() {
        return String.format("PendingTaskManager{id=%s, totalResourceProfile=%s, defaultSlotResourceProfile=%s}", this.pendingTaskManagerId, this.totalResourceProfile, this.defaultSlotResourceProfile);
    }
}

